/*
 * Decompiled with CFR 0.152.
 */
package projektY.swing;

import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDBORowRequestListener;
import projektY.database.YDatabaseList;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YRowValues;
import projektY.swing.YComboBoxModel;
import projektY.swing.YJTableCellProperties;
import projektY.swing.YTableModel;

public class YJTableManager
implements YDBOChangeEventListener,
YDBORowRequestListener {
    private YDatabaseList databaseList;
    private boolean readOnly;
    private JTable table;
    private YJTableCellProperties properties;
    private YTableModel tableModel;
    private boolean settingSelection;
    Vector<ComboBoxDefinition> comboBoxDefinitions;

    private void createTableModel() throws YException {
        this.tableModel = new YTableModel(this.databaseList, this.readOnly);
        this.table.setModel(this.tableModel);
        if (this.comboBoxDefinitions == null) {
            this.comboBoxDefinitions = new Vector(20);
        } else {
            this.comboBoxDefinitions.clear();
        }
        for (int iCol = 0; iCol < this.databaseList.getDispColCount(); ++iCol) {
            PropertiesCellRenderer propertiesCellRenderer;
            YColumnDefinition columnDefinition = this.databaseList.getDispColumnDefinition(iCol);
            if (columnDefinition.isLookUp()) {
                YComboBoxModel comboBoxModel;
                if (columnDefinition.isDomain()) {
                    YLookUpDomain lookUpDomain = ((YLookUpDomainColumnDefinition)columnDefinition).getLookUpDomain();
                    comboBoxModel = new YComboBoxModel(lookUpDomain, columnDefinition.isNotNull());
                } else {
                    YDatabaseList lookUpList = ((YLookUpDBColumnDefinition)columnDefinition).getLookUpList();
                    comboBoxModel = new YComboBoxModel(lookUpList, columnDefinition.isNotNull());
                }
                JComboBox comboBox = new JComboBox(comboBoxModel);
                this.table.getColumnModel().getColumn(iCol).setCellEditor(new DefaultCellEditor(comboBox));
                this.comboBoxDefinitions.add(new ComboBoxDefinition(comboBox, columnDefinition));
                if (this.properties == null) continue;
                propertiesCellRenderer = new PropertiesCellRenderer(this.properties, this.readOnly || columnDefinition.isReadOnly());
                this.table.getColumnModel().getColumn(iCol).setCellRenderer(propertiesCellRenderer);
                continue;
            }
            if (columnDefinition.isANum()) {
                AlignRightCellRenderer alignRightCellRenderer = this.properties != null ? new AlignRightCellRenderer(this.properties, this.readOnly || columnDefinition.isReadOnly()) : new AlignRightCellRenderer();
                this.table.getColumnModel().getColumn(iCol).setCellRenderer(alignRightCellRenderer);
                continue;
            }
            if (this.properties == null) continue;
            propertiesCellRenderer = new PropertiesCellRenderer(this.properties, this.readOnly || columnDefinition.isReadOnly());
            this.table.getColumnModel().getColumn(iCol).setCellRenderer(propertiesCellRenderer);
        }
    }

    protected YJTableManager(JTable table, YDatabaseList databaseList, YJTableCellProperties properties, boolean readOnly) throws YException {
        this.table = table;
        this.databaseList = databaseList;
        this.properties = properties;
        this.readOnly = readOnly;
        this.comboBoxDefinitions = null;
        this.createTableModel();
        this.settingSelection = false;
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent evt) {
                try {
                    if (YJTableManager.this.settingSelection) {
                        return;
                    }
                    int iRow = YJTableManager.this.table.getSelectedRow();
                    YJTableManager.this.settingSelection = true;
                    YJTableManager.this.databaseList.setActiveRow(iRow);
                    YJTableManager.this.tableModel.setSelectedRow(iRow);
                }
                catch (YException e) {
                    JOptionPane.showMessageDialog(null, e.toString(), "Fehler", 0);
                }
                finally {
                    YJTableManager.this.settingSelection = false;
                }
            }
        });
        databaseList.addChangeEventListener(this);
        databaseList.addRowRequestListener(this);
    }

    protected YJTableManager(JTable table, YDatabaseList databaseList, boolean readOnly) throws YException {
        this(table, databaseList, null, readOnly);
    }

    protected YJTableManager(JTable table, YDatabaseList databaseList, YJTableCellProperties properties) throws YException {
        this(table, databaseList, properties, false);
    }

    protected YJTableManager(JTable table, YDatabaseList databaseList) throws YException {
        this(table, databaseList, false);
    }

    public static YJTableManager createTableManager(JTable table, YDatabaseList databaseList, YJTableCellProperties properties, boolean readOnly) throws YException {
        return new YJTableManager(table, databaseList, properties, readOnly);
    }

    public static YJTableManager createTableManager(JTable table, YDatabaseList databaseList, boolean readOnly) throws YException {
        return new YJTableManager(table, databaseList, readOnly);
    }

    public static YJTableManager createTableManager(JTable table, YDatabaseList databaseList) throws YException {
        return new YJTableManager(table, databaseList);
    }

    public YTableModel getTableModel() {
        return this.tableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void DBObjectChanged(YDBOChangeEvent evt) throws YException {
        try {
            if (evt.getType() == YDBOChangeEvent.ChangeEventType.ROWSELECTED || evt.getType() == YDBOChangeEvent.ChangeEventType.INSERT) {
                for (int iComboBox = 0; iComboBox < this.comboBoxDefinitions.size(); ++iComboBox) {
                    ComboBoxDefinition comboBoxDefinition = this.comboBoxDefinitions.get(iComboBox);
                    JComboBox comboBox = comboBoxDefinition.comboBox;
                    YLookUpColumnDefinition lookUpColumnDefinition = (YLookUpColumnDefinition)comboBoxDefinition.columnDefinition;
                    YRowValues rowValues = evt.getRowValues();
                    if (lookUpColumnDefinition instanceof YLookUpDBColumnDefinition) {
                        YLookUpDBColumnDefinition lookUpDBColumnDefinition = (YLookUpDBColumnDefinition)lookUpColumnDefinition;
                        if (rowValues == null) {
                            comboBox.setSelectedItem(null);
                            continue;
                        }
                        comboBox.setSelectedItem(lookUpDBColumnDefinition.getLookUpList().findRow(rowValues.getAsString(lookUpColumnDefinition.getFieldValueIndex()), lookUpDBColumnDefinition.getValueFieldName()));
                        continue;
                    }
                    if (!(lookUpColumnDefinition instanceof YLookUpDomainColumnDefinition)) continue;
                    YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = (YLookUpDomainColumnDefinition)lookUpColumnDefinition;
                    if (rowValues == null) {
                        comboBox.setSelectedItem(null);
                        continue;
                    }
                    comboBox.setSelectedItem(lookUpDomainColumnDefinition.getLookUpDomain().lookUpObject(rowValues.getAsString(lookUpColumnDefinition.getFieldValueIndex())));
                }
                if (this.settingSelection) {
                    return;
                }
                this.settingSelection = true;
                int iRow = evt.getIRow0();
                this.table.getSelectionModel().setSelectionInterval(iRow, iRow);
            } else if (evt.getType() == YDBOChangeEvent.ChangeEventType.RESTRUCTURE) {
                this.createTableModel();
            }
        }
        finally {
            this.settingSelection = false;
        }
    }

    public void requestValues() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    @Override
    public void requestRowValues(YRowValues rowValues) throws YException {
        this.requestValues();
    }

    public static class AlignRightCellRenderer
    extends DefaultTableCellRenderer {
        public AlignRightCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public AlignRightCellRenderer(YJTableCellProperties properties, boolean readOnly) {
            this.setHorizontalAlignment(4);
            if (readOnly) {
                if (properties.readOnlyBackground != null) {
                    this.setBackground(properties.readOnlyBackground);
                }
                if (properties.readOnlyForeground != null) {
                    this.setForeground(properties.readOnlyForeground);
                }
            } else {
                if (properties.editableBackground != null) {
                    this.setBackground(properties.editableBackground);
                }
                if (properties.editableForeground != null) {
                    this.setForeground(properties.editableForeground);
                }
            }
        }
    }

    public static class PropertiesCellRenderer
    extends DefaultTableCellRenderer {
        public PropertiesCellRenderer(YJTableCellProperties properties, boolean readOnly) {
            if (readOnly) {
                if (properties.readOnlyBackground != null) {
                    this.setBackground(properties.readOnlyBackground);
                }
                if (properties.readOnlyForeground != null) {
                    this.setForeground(properties.readOnlyForeground);
                }
            } else {
                if (properties.editableBackground != null) {
                    this.setBackground(properties.editableBackground);
                }
                if (properties.editableForeground != null) {
                    this.setForeground(properties.editableForeground);
                }
            }
        }
    }

    private class ComboBoxDefinition {
        JComboBox comboBox;
        YColumnDefinition columnDefinition;

        ComboBoxDefinition(JComboBox comboBox, YColumnDefinition columnDefinition) {
            this.comboBox = comboBox;
            this.columnDefinition = columnDefinition;
        }
    }
}

