/*
 * Decompiled with CFR 0.152.
 */
package popometer.graphics;

import java.awt.Point;
import java.util.ArrayList;
import popometer.graphics.Messpunkt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Farbbereich {
    public ArrayList<Point> Pixels = new ArrayList();
    private Point _center;
    private boolean _centerset;

    public Farbbereich(Point center, int radius) {
        this.Pixels.add(center);
        for (int i = 0; i <= radius; ++i) {
            this.Pixels.add(new Point(center.x - i, center.y - i));
            this.Pixels.add(new Point(center.x + i, center.y + i));
            this.Pixels.add(new Point(center.x + i, center.y - i));
            this.Pixels.add(new Point(center.x - i, center.y + i));
        }
        this._centerset = true;
        this._center = center;
    }

    public Farbbereich() {
        this._centerset = false;
    }

    public Point getCenter() {
        if (this._centerset) {
            return this._center;
        }
        int maxy = 0;
        int maxx = 0;
        int miny = 1000;
        int minx = 1000;
        for (Point point : this.Pixels) {
            if (maxy < point.y) {
                maxy = point.y;
            }
            if (maxx < point.x) {
                maxx = point.x;
            }
            if (miny > point.y) {
                miny = point.y;
            }
            if (minx <= point.x) continue;
            minx = point.x;
        }
        int defaulty = 0;
        int defaultx = (maxx + minx) / 2;
        defaulty = (maxy + miny) / 2;
        this._centerset = true;
        this._center = new Point(defaultx, defaulty);
        return this._center;
    }

    public Boolean isNeighbor(Point p) {
        for (Point pix : this.Pixels) {
            if (Math.abs(pix.x - p.x) > 1 || Math.abs(pix.y - p.y) > 1) continue;
            return true;
        }
        return false;
    }

    public int getRoundness() {
        int rad = this.getRadius();
        int pxsin = 0;
        for (Point pix : this.Pixels) {
            if (!this.isInRange(pix.x, pix.y, rad)) continue;
            ++pxsin;
        }
        return 100 * pxsin / this.Pixels.size();
    }

    public boolean isInRange(int x, int y, int radius) {
        int dy;
        int dx = Math.abs(x - this.getCenter().x);
        return (int)Math.sqrt(dx * dx + (dy = Math.abs(y - this.getCenter().y)) * dy) <= radius;
    }

    public int getRadius() {
        double size = this.Pixels.size();
        size /= Math.PI;
        size = Math.sqrt(size);
        return (int)size;
    }

    public void addPoint(Point p) {
        this.Pixels.add(p);
        this._centerset = false;
    }

    public static Farbbereich getAreaMostLikelyBetween(ArrayList<Farbbereich> areas, Messpunkt mp1, Messpunkt mp2) {
        int lastdiff = 1000;
        int diff = 0;
        Farbbereich ret = areas.get(0);
        for (Farbbereich area : areas) {
            int diffxto1 = Math.abs(area.getCenter().x - mp1.getX());
            int diffyto1 = Math.abs(area.getCenter().y - mp1.getY());
            if (diffxto1 == 0 || diffyto1 == 0) continue;
            int diffxto2 = Math.abs(area.getCenter().x - mp2.getX());
            int diffyto2 = Math.abs(area.getCenter().y - mp2.getY());
            if (diffxto2 == 0 || diffyto2 == 0 || (diff = (int)Math.sqrt(diffxto1 * diffxto1 + diffyto1 * diffyto1) + (int)Math.sqrt(diffxto2 * diffxto2 + diffyto2 * diffyto2)) >= lastdiff) continue;
            ret = area;
            lastdiff = diff;
        }
        return ret;
    }

    public static Farbbereich getTopMostArea(ArrayList<Farbbereich> areas) {
        Farbbereich ret = areas.get(0);
        for (Farbbereich area : areas) {
            if (ret.getCenter().y <= area.getCenter().y) continue;
            ret = area;
        }
        return ret;
    }

    public static Farbbereich getRightMostArea(ArrayList<Farbbereich> areas) {
        Farbbereich ret = areas.get(0);
        for (Farbbereich area : areas) {
            if (ret.getCenter().x >= area.getCenter().x) continue;
            ret = area;
        }
        return ret;
    }

    public static Farbbereich getLeftMostArea(ArrayList<Farbbereich> areas) {
        Farbbereich ret = areas.get(0);
        for (Farbbereich area : areas) {
            if (ret.getCenter().x <= area.getCenter().x) continue;
            ret = area;
        }
        return ret;
    }

    public static Farbbereich getLowestArea(ArrayList<Farbbereich> areas) {
        Farbbereich ret = areas.get(0);
        for (Farbbereich area : areas) {
            if (ret.getCenter().y >= area.getCenter().y) continue;
            ret = area;
        }
        return ret;
    }
}

