/*
 * Decompiled with CFR 0.152.
 */
package popometer.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import popometer.graphics.PositionMarker;

public class SimpleMarker
extends PositionMarker {
    int size;
    int size2;
    int dragX;
    int dragY;
    Shape shape;

    public SimpleMarker(int size, Shape shape) {
        super(size, size);
        this.size = size;
        this.size2 = size / 2;
        this.dragX = -1;
        this.dragY = -1;
        this.shape = shape;
    }

    public SimpleMarker(int size) {
        this(size, Shape.X);
    }

    public boolean isDragStartPosition(int x, int y) {
        return Math.abs(this.getX() - x) < 3 && Math.abs(this.getY() - y) < 3;
    }

    public void draw(Graphics2D g2d) {
        int y;
        int x;
        if (this.getX() < 0 || this.getY() < 0) {
            return;
        }
        Stroke stroke = g2d.getStroke();
        if (this.dragX >= 0 && this.dragY >= 0) {
            x = this.dragX;
            y = this.dragY;
            BasicStroke bsDash = new BasicStroke(2.0f, 0, 2, 2.0f, new float[]{5.0f, 5.0f}, 2.5f);
            g2d.setStroke(bsDash);
        } else {
            x = super.getX();
            y = super.getY();
        }
        switch (this.shape) {
            case PLUS: {
                g2d.setXORMode(Color.WHITE);
                g2d.drawLine(x + this.size2, y, x + this.size2, y + this.size);
                g2d.drawLine(x, y + this.size2, x + this.size, y + this.size2);
                break;
            }
            default: {
                g2d.setXORMode(Color.WHITE);
                g2d.drawLine(x, y, x + this.size, y + this.size);
                g2d.drawLine(x, y + this.size, x + this.size, y);
            }
        }
        g2d.setPaintMode();
        g2d.setStroke(stroke);
    }

    public void moveTo(int x, int y) {
        super.moveTo(x - this.size2, y - this.size2);
    }

    public void dragTo(int x, int y) {
        this.dragX = x - this.size2;
        this.dragY = y - this.size2;
    }

    public void drop(int x, int y) {
        this.dragX = -1;
        this.dragY = -1;
        this.moveTo(x, y);
    }

    public int getX() {
        return super.getX() + this.size2;
    }

    public int getY() {
        return super.getY() + this.size2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Shape {
        X,
        PLUS;

    }
}

