/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import popometer.graphics.Farbbereich;
import popometer.graphics.ImageHelper;
import popometer.graphics.Messpunkt;
import popometer.math.Koerperberechnung;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanFotoImage
extends JPanel {
    private Image fotoImage;
    private BufferedImage bufferedImage;
    private Koerperberechnung.Messpunkte messpunkte;
    ArrayList<Farbbereich> areas;
    private Point messbereichstart;
    private Point messbereichend;
    private boolean blncolorRegion;
    int markerColor;
    int farbabweichung = 30;
    int bereichsabweichung = 140;

    PanFotoImage(Image demoImage, Koerperberechnung.Messpunkte messpunkte) {
        super(null);
        this.setImage(demoImage);
        this.messpunkte = messpunkte;
    }

    public void setColorRegion(boolean blncolorRegion) {
        this.blncolorRegion = blncolorRegion;
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }

    public BufferedImage createBFImage() {
        BufferedImage bfImage = ImageHelper.toBufferedImage(this.fotoImage);
        Graphics g = bfImage.getGraphics();
        this.paint(g);
        return bfImage;
    }

    public void setImage(Image fotoImage) {
        this.fotoImage = fotoImage;
        this.bufferedImage = fotoImage == null ? null : ImageHelper.toBufferedImage(fotoImage);
    }

    public void setAreas(ArrayList<Farbbereich> areas) {
        this.areas = areas;
    }

    public void setMessbereich(Point mbstart, Point mbend) {
        this.messbereichend = mbend;
        this.messbereichstart = mbstart;
    }

    @Override
    public synchronized void paint(Graphics g) {
        int i;
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage((Image)this.bufferedImage, 0, 0, this);
        if (this.messpunkte.koerperMesspunkte.length == 0) {
            return;
        }
        if (this.blncolorRegion) {
            g2d.setColor(Color.RED);
            for (Farbbereich area : this.areas) {
                for (Point p : area.Pixels) {
                    g2d.drawRect(p.x, p.y, 1, 1);
                }
            }
        }
        g2d.setColor(Color.BLACK);
        for (i = 0; i < this.messpunkte.koerperMesspunkte.length; ++i) {
            this.messpunkte.koerperMesspunkte[i].draw(g2d);
        }
        g2d.setXORMode(Color.GRAY);
        Messpunkt messpunkt0 = this.messpunkte.koerperMesspunkte[0];
        for (i = 1; i < this.messpunkte.koerperMesspunkte.length; ++i) {
            Messpunkt messpunkt = this.messpunkte.koerperMesspunkte[i];
            if (messpunkt0.getX() > 0 && messpunkt0.getY() > 0 && messpunkt.getX() > 0 && messpunkt.getY() > 0) {
                g2d.drawLine(messpunkt0.getX(), messpunkt0.getY(), messpunkt.getX(), messpunkt.getY());
            }
            messpunkt0 = messpunkt;
        }
        if (!this.messpunkte.calibStart.isNull() && !this.messpunkte.calibEnd.isNull()) {
            this.messpunkte.calibStart.draw(g2d);
            this.messpunkte.calibEnd.draw(g2d);
        }
        g2d.setPaintMode();
        g2d.setColor(Color.BLACK);
        g2d.drawLine(this.messbereichstart.x, this.messbereichstart.y, this.messbereichstart.x, this.messbereichend.y);
        g2d.drawLine(this.messbereichstart.x, this.messbereichstart.y, this.messbereichend.x, this.messbereichstart.y);
        g2d.drawLine(this.messbereichend.x, this.messbereichend.y, this.messbereichstart.x, this.messbereichend.y);
        g2d.drawLine(this.messbereichend.x, this.messbereichend.y, this.messbereichend.x, this.messbereichstart.y);
    }

    void findDefaultMarkers() {
        this.areas = new ArrayList();
        for (int y = this.messbereichstart.y; y < this.messbereichend.y && y < this.bufferedImage.getHeight(); ++y) {
            for (int x = this.messbereichstart.x; x < this.messbereichend.x && this.areas.size() < 200 && x < this.bufferedImage.getWidth(); ++x) {
                int c = this.bufferedImage.getRGB(x, y);
                int red = c >> 16 & 0xFF;
                int green = c >> 8 & 0xFF;
                int blue = c & 0xFF;
                int markerred = this.markerColor >> 16 & 0xFF;
                int markergreen = this.markerColor >> 8 & 0xFF;
                int markerblue = this.markerColor & 0xFF;
                if (Math.abs(green - markergreen) >= this.farbabweichung || Math.abs(red - markerred) >= this.farbabweichung || Math.abs(blue - markerblue) >= this.farbabweichung) continue;
                Point p = new Point(x, y);
                Boolean added = false;
                for (Farbbereich area : this.areas) {
                    if (!area.isNeighbor(p).booleanValue()) continue;
                    area.addPoint(p);
                    added = true;
                    break;
                }
                if (added.booleanValue()) continue;
                Farbbereich a = new Farbbereich();
                a.addPoint(p);
                this.areas.add(a);
            }
        }
        this.setAreas((ArrayList)this.areas.clone());
        ArrayList<Farbbereich> areastodelete = new ArrayList<Farbbereich>();
        for (Farbbereich area : this.areas) {
            if (area.Pixels.size() > this.bereichsabweichung) continue;
            areastodelete.add(area);
        }
        for (Farbbereich area : areastodelete) {
            this.areas.remove(area);
        }
        areastodelete.clear();
        for (Farbbereich area : this.areas) {
            if (area.getRoundness() > 80) continue;
            areastodelete.add(area);
        }
        for (Farbbereich area : areastodelete) {
            this.areas.remove(area);
        }
    }

    String connectAreas() {
        if (this.areas.size() < 6) {
            this.messpunkte.clear();
            return "Keine 6 Bereiche gefunden.Einstellungen \u00e4ndern oder manuell setzen.";
        }
        try {
            Farbbereich die = Farbbereich.getTopMostArea(this.areas);
            this.messpunkte.schulter.set(die.getCenter().x, die.getCenter().y);
            die = Farbbereich.getLowestArea(this.areas);
            this.messpunkte.pedal.set(die.getCenter().x, die.getCenter().y);
            die = Farbbereich.getLeftMostArea(this.areas);
            this.messpunkte.sitz.set(die.getCenter().x, die.getCenter().y);
            die = Farbbereich.getRightMostArea(this.areas);
            this.messpunkte.griff.set(die.getCenter().x, die.getCenter().y);
            die = Farbbereich.getAreaMostLikelyBetween(this.areas, this.messpunkte.pedal, this.messpunkte.sitz);
            this.messpunkte.knie.set(die.getCenter().x, die.getCenter().y);
            die = Farbbereich.getAreaMostLikelyBetween(this.areas, this.messpunkte.schulter, this.messpunkte.griff);
            this.messpunkte.arm.set(die.getCenter().x, die.getCenter().y);
            return "";
        }
        catch (Exception ex) {
            return "Nicht alle Messpunkte eindeutig gefunden. Einstellungen \u00e4ndern oder manuell setzen.";
        }
    }
}

