/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YROKunde;
import popometer.graphics.Farbbereich;
import popometer.math.Koerperberechnung;
import popometer.math.MagischesDreieck;
import popometer.panels.PanFotoImage;
import popometer.panels.PanMessung;
import projektY.base.YException;
import projektY.base.YUserException;
import projektY.database.YDatabaseData;
import projektY.database.YDetailList;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;
import projektY.database.YSubRowList;
import projektY.swing.YJPanelManager;
import projektY.utils.YConfigFile;

public class PanKoerper
extends PanMessung {
    private File fotoCmdFile;
    private FotoThread fotoThread;
    private File fotoImageFile;
    private File bfImageFile;
    private Image defaultImage;
    private PanFotoImage panFotoImage;
    private Koerperberechnung.Messpunkte messpunkte;
    private Koerperberechnung koerperberechnung;
    private MagischesDreieck magischesDreieck;
    private MouseMode mouseMode;
    private Point messbereichstart;
    private Point messbereichend;
    private YDetailList kundeneinsbed;
    private final int einsbereichIdSitzknochen;
    private long lastUpdate;
    private JButton btnMessbereich;
    private JButton btncalibrate;
    private JCheckBox cbAutomatisch;
    private JCheckBox cbColorAreas;
    private JButton cmdBerechnen;
    private JButton cmdColor;
    private JButton cmdMagischesDreieck;
    private JButton cmdManual;
    private JButton cmdRestoreSettings;
    private JButton cmdSaveSettings;
    private JButton cmdTakePicture;
    public JTextField fldLOberarm;
    public JTextField fldLOberkoerper;
    public JTextField fldLOberschenkel;
    public JTextField fldLUnterarm;
    public JTextField fldLUnterschenkel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel lblDreieck;
    public JLabel lblDreieckLinks;
    public JLabel lblDreieckOben;
    public JLabel lblDreieckRechts;
    private JLabel lblMarkerColor;
    public JLabel lblWinkel;
    private JTextArea lbloutput;
    private JPanel panActions;
    private JPanel panDreieck;
    private JPanel panDreieckBild;
    private JPanel panEinstellungenSpeichern;
    private JPanel panKoerperMasse;
    private JPanel panMessung;
    private JPanel panSettings;
    private JScrollPane scrlImage;
    private JScrollPane scrlMessung;
    private JSlider sliFarbabweichung;
    private JSlider sliSizeabweichung;
    private JTabbedPane tabRechts;

    public PanKoerper(YPopometerSession session, YROKunde kunde, FrmNavigator frmNavigator) throws YException {
        super(session, kunde, frmNavigator);
        float pedallaenge;
        float hueftabstand;
        float hueftePlusY;
        float hueftePlusX;
        float lCalib;
        YConfigFile configFile = session.getConfigFile();
        try {
            lCalib = Float.valueOf(configFile.getEntry("LCALIB", "100")).floatValue();
            hueftePlusX = Float.valueOf(configFile.getEntry("HUEFTEPLUSX", "0")).floatValue();
            hueftePlusY = Float.valueOf(configFile.getEntry("HUEFTEPLUSY", "0")).floatValue();
        }
        catch (NumberFormatException e) {
            throw new YUserException("Ung\u00fcltige L\u00e4ngenangabe in der Konfiguration:\n" + e.toString() + "\n" + "Bitte in der H\u00e4ndlersicht korrigieren und neu starten.");
        }
        this.koerperberechnung = new Koerperberechnung(lCalib, hueftePlusX, hueftePlusY);
        this.messpunkte = new Koerperberechnung.Messpunkte();
        try {
            hueftabstand = Float.valueOf(configFile.getEntry("HUEFTABSTAND", "8")).floatValue();
            pedallaenge = Float.valueOf(configFile.getEntry("PEDALLAENGE", "17")).floatValue();
        }
        catch (NumberFormatException e) {
            throw new YUserException("Ung\u00fcltige L\u00e4ngenangabe in der Konfiguration:\n" + e.toString() + "\n" + "Bitte in der H\u00e4ndlersicht korrigieren und neu starten.");
        }
        this.magischesDreieck = new MagischesDreieck(hueftabstand, pedallaenge);
        this.fotoThread = null;
        this.panFotoImage = new PanFotoImage(null, this.messpunkte);
        this.panFotoImage.setPreferredSize(session.createBodyImageSize());
        this.mouseMode = MouseMode.STARTUP;
        this.panFotoImage.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanKoerper.this.fotoMouseClicked(evt);
            }
        });
        this.panFotoImage.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                PanKoerper.this.fotoMouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
            }
        });
        this.mouseMode = MouseMode.STARTUP;
        this.initComponents();
        this.readSettings();
        YJPanelManager.createPanelManager((JComponent)this.panKoerperMasse, (YDatabaseData)kunde);
        this.mouseMode = MouseMode.NULL;
        this.fotoCmdFile = session.createFotoCmd();
        this.fotoImageFile = session.createBodyImage();
        this.bfImageFile = session.createBFImage();
        this.defaultImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/popometer/pictures/fotobeispiel.jpeg"));
        this.changePicture(this.defaultImage);
        this.centerFoto();
        YRowObjectList einsatzbereiche = session.getRowObjectList("vs_einsatzbereiche");
        int iRow = einsatzbereiche.find("sitzknochenabstand", "messgroesse_teilbereich");
        if (iRow < 0) {
            iRow = einsatzbereiche.find("_sitzknochenabstand", "messgroesse_teilbereich");
        }
        if (iRow < 0) {
            throw new YException("Kein Einsatzteilbereich 'sitzknochenabstand' oder '_sitzknochenabstand'");
        }
        this.kundeneinsbed = kunde.getDetailList("vh_kundeneinsbed");
        this.einsbereichIdSitzknochen = einsatzbereiche.getAsInt(iRow, "einsbereich_id");
    }

    private void centerFoto() {
        this.scrlImage.revalidate();
        this.scrlImage.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dimension portSize = PanKoerper.this.scrlImage.getViewport().getSize();
                Dimension viewSize = PanKoerper.this.scrlImage.getViewport().getView().getSize();
                PanKoerper.this.scrollRectToVisible(new Rectangle((viewSize.width - portSize.width) / 2, (viewSize.height - portSize.height) / 2, portSize.width, portSize.height));
            }
        });
    }

    private void readSettings() {
        try {
            this.messpunkte.calibStart.set(this.readSetting("CALIBSTART", "(0,0)"));
            this.messpunkte.calibEnd.set(this.readSetting("CALIBEND", "(0,0)"));
            this.koerperberechnung.calibrieren(this.messpunkte);
        }
        catch (YException e) {
            // empty catch block
        }
        this.panFotoImage.markerColor = new Integer(this.readSetting("MARKERCOLOR", "100"));
        this.panFotoImage.bereichsabweichung = new Integer(this.readSetting("SIZEDEVIATION", "100"));
        this.panFotoImage.farbabweichung = new Integer(this.readSetting("COLORDEVIATION", "100"));
        int x = new Integer(this.readSetting("REGIONSTARTX", "0"));
        int y = new Integer(this.readSetting("REGIONSTARTY", "0"));
        this.messbereichstart = new Point(x, y);
        x = new Integer(this.readSetting("REGIONENDX", String.valueOf(1000)));
        y = new Integer(this.readSetting("REGIONENDY", String.valueOf(960)));
        this.messbereichend = new Point(x, y);
        this.panFotoImage.setMessbereich(this.messbereichstart, this.messbereichend);
        this.lblMarkerColor.setBackground(new Color(this.panFotoImage.markerColor));
        this.sliFarbabweichung.setValue(this.panFotoImage.farbabweichung);
        this.sliSizeabweichung.setValue(this.panFotoImage.bereichsabweichung);
    }

    private String readSetting(String name, String defaultvalue) {
        if (this.session.getConfigFile().entryExists(name)) {
            return this.session.getConfigFile().findValue(name);
        }
        return defaultvalue;
    }

    private void findDefaultMarkers() {
        Cursor hourglassCursor = new Cursor(3);
        this.setCursor(hourglassCursor);
        this.panFotoImage.findDefaultMarkers();
        Cursor normalCursor = new Cursor(0);
        this.setCursor(normalCursor);
    }

    private void connectAreas() {
        this.lbloutput.setText(this.panFotoImage.connectAreas());
    }

    private void fotoMouseMoved(MouseEvent evt) {
        if (this.mouseMode != MouseMode.COLOR) {
            return;
        }
        if (System.currentTimeMillis() - this.lastUpdate < 100L) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        int x = evt.getX();
        if (x >= this.panFotoImage.getImage().getWidth()) {
            return;
        }
        int y = evt.getY();
        if (y >= this.panFotoImage.getImage().getHeight()) {
            return;
        }
        try {
            int col = this.panFotoImage.getImage().getRGB(x, y);
            this.setVergleichsFarbe(col);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.printf("Fehler: %s\n", e.toString());
        }
    }

    private void fotoMouseClicked(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        boolean repaintneeded = false;
        switch (this.mouseMode) {
            case COLOR: {
                this.mouseMode = MouseMode.NULL;
                this.panFotoImage.markerColor = this.panFotoImage.getImage().getRGB(x, y);
                this.findDefaultMarkers();
                this.connectAreas();
                this.setVergleichsFarbe(this.panFotoImage.markerColor);
                repaintneeded = true;
                this.lbloutput.setText("");
                break;
            }
            case CALIBRATE: {
                if (this.messpunkte.calibStart.isNull()) {
                    this.messpunkte.calibStart.moveTo(x, y);
                    this.lbloutput.setText("Jetzt den Endpunkt markieren");
                    break;
                }
                this.messpunkte.calibEnd.moveTo(x, y);
                boolean kalibriert = this.koerperberechnung.calibrieren(this.messpunkte);
                this.mouseMode = MouseMode.NULL;
                this.lbloutput.setText(kalibriert ? "Erfolgreich kalibriert." : "Kalibrierung fehlgeschlagen.");
                this.berechneAbstaende();
                repaintneeded = true;
                break;
            }
            case REGION: {
                if (this.messbereichstart == null) {
                    this.messbereichstart = new Point(x, y);
                    this.lbloutput.setText("Jetzt die andere Ecke markieren");
                    break;
                }
                this.messbereichend = new Point(x, y);
                this.mouseMode = MouseMode.NULL;
                this.panFotoImage.setMessbereich(this.messbereichstart, this.messbereichend);
                this.findDefaultMarkers();
                this.connectAreas();
                this.berechneAbstaende();
                repaintneeded = true;
                this.lbloutput.setText("");
                break;
            }
            case MANUAL: {
                this.panFotoImage.areas.add(new Farbbereich(new Point(x, y), 5));
                if (this.panFotoImage.areas.size() == 6) {
                    this.lbloutput.setText("");
                    this.mouseMode = MouseMode.NULL;
                    this.connectAreas();
                    this.berechneAbstaende();
                    this.panFotoImage.setColorRegion(this.cbColorAreas.isSelected());
                } else {
                    this.lbloutput.setText("Noch " + (6 - this.panFotoImage.areas.size()) + " Bereich(e) markieren");
                }
                repaintneeded = true;
            }
        }
        if (repaintneeded) {
            this.panFotoImage.repaint();
        }
    }

    private void setVergleichsFarbe(int col) {
        this.lblMarkerColor.setBackground(new Color(col));
    }

    private int findPosNrSitzhaltung() throws YException {
        this.kunde.requestValuesToStore();
        YRowValues rvKundeneinsbed = this.kundeneinsbed.findRow(String.valueOf(this.einsbereichIdSitzknochen), "einsbereich_id");
        if (rvKundeneinsbed == null) {
            throw new YUserException("Das \"Magische Dreieck\" kann nur mit der Sitzhaltung berechnet werden,\ndie beim Sitzknochenabstand erfa\u00dft wird.");
        }
        String strEinsbedingungId = rvKundeneinsbed.getAsString("einsbedingung_id");
        YSubRowList srlEinsatzbedingungen = (YSubRowList)this.session.getRowObjectList("vs_einsatzbereiche").getSubRowList("einsatzbedingungen");
        YRowValues rvEinsatzbedingung = srlEinsatzbedingungen.findRow(strEinsbedingungId, "einsbedingung_id");
        if (rvEinsatzbedingung == null) {
            throw new YException("Nicht existierende Einsatzbedingung id=" + strEinsbedingungId);
        }
        return rvEinsatzbedingung.getAsInt("pos_nr");
    }

    private void berechneDreieck(FocusEvent evt) {
        JTextField[] fldLaengen = new JTextField[]{this.fldLUnterarm, this.fldLOberarm, this.fldLOberkoerper, this.fldLOberschenkel, this.fldLUnterschenkel};
        boolean iLUnterarm = false;
        boolean iLOberarm = true;
        int iLOberkoerper = 2;
        int iLOberschenkel = 3;
        int iLUnterschenkel = 4;
        int[] massIdx = new int[]{0, 1, 2, 3, 4};
        int iErr = 0;
        for (JTextField fldLaenge : fldLaengen) {
            if (fldLaenge.getText().length() != 0) continue;
            this.cmdBerechnen.setEnabled(false);
            return;
        }
        this.cmdBerechnen.setEnabled(true);
        Koerperberechnung.Koerpermasse koerpermasse = new Koerperberechnung.Koerpermasse();
        NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
        try {
            block12: for (int idx : massIdx) {
                String text = fldLaengen[idx].getText();
                if (!Pattern.matches("[0-9]+", text) && !Pattern.matches("[0-9]+[.,][0-9]*", text)) {
                    iErr = idx;
                    throw new ParseException(text, iErr);
                }
                float l = fmt.parse(text).floatValue();
                switch (idx) {
                    case 0: {
                        koerpermasse.ua = l;
                        continue block12;
                    }
                    case 1: {
                        koerpermasse.oa = l;
                        continue block12;
                    }
                    case 2: {
                        koerpermasse.ok = l;
                        continue block12;
                    }
                    case 3: {
                        koerpermasse.os = l;
                        continue block12;
                    }
                    case 4: {
                        koerpermasse.usf = l;
                    }
                }
            }
        }
        catch (ParseException e) {
            if (evt != null && evt.getSource() != fldLaengen[iErr]) {
                return;
            }
            JOptionPane.showMessageDialog(this, "Ung\u00fcltige Zahl: " + fldLaengen[iErr].getText(), "Fehler", 0);
        }
        if (!koerpermasse.vollstaendig()) {
            return;
        }
        try {
            int winkelsatzId = this.findPosNrSitzhaltung();
            this.magischesDreieck.berechnen(winkelsatzId, koerpermasse);
            this.lblDreieckOben.setText(String.format("%2.1f", Float.valueOf(this.magischesDreieck.getOben())));
            this.lblDreieckOben.setVisible(true);
            this.lblDreieckLinks.setText(String.format("%2.1f", Float.valueOf(this.magischesDreieck.getHinten())));
            this.lblDreieckLinks.setVisible(true);
            this.lblDreieckRechts.setText(String.format("%2.1f", Float.valueOf(this.magischesDreieck.getVorn())));
            this.lblDreieckRechts.setVisible(true);
            this.lblWinkel.setText(String.format("%2.1f\u00b0", Float.valueOf(this.magischesDreieck.getNeigungswinkel())));
            this.lblWinkel.setVisible(true);
            this.cmdMagischesDreieck.setEnabled(true);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void berechneAbstaende() {
        Koerperberechnung.Koerpermasse koerpermasse = this.koerperberechnung.berechneKoerpermasse(this.messpunkte);
        if (koerpermasse.ua > 0.0f) {
            this.fldLUnterarm.setText(String.format("%3.1f", Float.valueOf(koerpermasse.ua)));
        }
        if (koerpermasse.oa > 0.0f) {
            this.fldLOberarm.setText(String.format("%3.1f", Float.valueOf(koerpermasse.oa)));
        }
        if (koerpermasse.ok > 0.0f) {
            this.fldLOberkoerper.setText(String.format("%3.1f", Float.valueOf(koerpermasse.ok)));
        }
        if (koerpermasse.os > 0.0f) {
            this.fldLOberschenkel.setText(String.format("%3.1f", Float.valueOf(koerpermasse.os)));
        }
        if (koerpermasse.usf > 0.0f) {
            this.fldLUnterschenkel.setText(String.format("%3.1f", Float.valueOf(koerpermasse.usf)));
        }
        this.berechneDreieck(null);
    }

    private void ergebnisseLoeschen() {
        this.messpunkte.clear();
        this.fldLOberarm.setText("");
        this.fldLOberkoerper.setText("");
        this.fldLOberschenkel.setText("");
        this.fldLUnterarm.setText("");
        this.fldLUnterschenkel.setText("");
        this.lblDreieckOben.setVisible(false);
        this.lblDreieckLinks.setVisible(false);
        this.lblDreieckRechts.setVisible(false);
        this.lblWinkel.setVisible(false);
    }

    protected void neuerKunde() throws YException {
        this.ergebnisseLoeschen();
        this.cmdMagischesDreieck.setEnabled(false);
    }

    private void initComponents() {
        this.scrlImage = new JScrollPane();
        this.scrlImage.setViewportView(this.panFotoImage);
        this.scrlMessung = new JScrollPane();
        this.panMessung = new JPanel();
        this.panKoerperMasse = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldLUnterarm = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldLOberarm = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldLOberkoerper = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldLOberschenkel = new JTextField();
        this.jLabel6 = new JLabel();
        this.fldLUnterschenkel = new JTextField();
        this.panDreieck = new JPanel();
        this.panDreieckBild = new JPanel();
        this.lblDreieckOben = new JLabel();
        this.lblDreieckOben.setVisible(false);
        this.lblDreieckLinks = new JLabel();
        this.lblDreieckLinks.setVisible(false);
        this.lblDreieckRechts = new JLabel();
        this.lblDreieckRechts.setVisible(false);
        this.lblDreieck = new JLabel();
        this.lblWinkel = new JLabel();
        this.lblWinkel.setVisible(false);
        this.cmdBerechnen = new JButton();
        this.cmdMagischesDreieck = new JButton();
        this.tabRechts = new JTabbedPane();
        this.panActions = new JPanel();
        this.cmdTakePicture = new JButton();
        this.cmdManual = new JButton();
        this.cbAutomatisch = new JCheckBox();
        this.panSettings = new JPanel();
        this.lblMarkerColor = new JLabel();
        this.cmdColor = new JButton();
        this.btncalibrate = new JButton();
        this.btnMessbereich = new JButton();
        this.jLabel1 = new JLabel();
        this.sliFarbabweichung = new JSlider();
        this.jLabel8 = new JLabel();
        this.sliSizeabweichung = new JSlider();
        this.cbColorAreas = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.panEinstellungenSpeichern = new JPanel();
        this.cmdSaveSettings = new JButton();
        this.cmdRestoreSettings = new JButton();
        this.lbloutput = new JTextArea();
        this.setLayout(new BorderLayout());
        this.scrlImage.setBackground(new Color(255, 255, 255));
        this.add((Component)this.scrlImage, "Center");
        this.scrlMessung.setHorizontalScrollBarPolicy(31);
        this.scrlMessung.setVerticalScrollBarPolicy(22);
        this.panMessung.setLayout(new GridBagLayout());
        this.panKoerperMasse.setBackground(new Color(255, 255, 255));
        this.panKoerperMasse.setBorder(BorderFactory.createTitledBorder("L\u00e4ngen (cm):"));
        this.panKoerperMasse.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.fldLUnterarm);
        this.jLabel2.setText("Unterarm:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel2, gridBagConstraints);
        this.fldLUnterarm.setHorizontalAlignment(4);
        this.fldLUnterarm.setMinimumSize(new Dimension(80, 19));
        this.fldLUnterarm.setName("l_unterarm");
        this.fldLUnterarm.setPreferredSize(new Dimension(40, 19));
        this.fldLUnterarm.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLUnterarmFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLUnterarm, gridBagConstraints);
        this.jLabel3.setLabelFor(this.fldLOberarm);
        this.jLabel3.setText("Oberarm:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel3, gridBagConstraints);
        this.fldLOberarm.setHorizontalAlignment(4);
        this.fldLOberarm.setName("l_oberarm");
        this.fldLOberarm.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberarmFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberarm, gridBagConstraints);
        this.jLabel4.setLabelFor(this.fldLOberkoerper);
        this.jLabel4.setText("Oberk\u00f6rper+Sitz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel4, gridBagConstraints);
        this.fldLOberkoerper.setHorizontalAlignment(4);
        this.fldLOberkoerper.setName("l_oberkoerper");
        this.fldLOberkoerper.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberkoerperFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberkoerper, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fldLOberschenkel);
        this.jLabel5.setText("Oberschenkel:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel5, gridBagConstraints);
        this.fldLOberschenkel.setHorizontalAlignment(4);
        this.fldLOberschenkel.setName("l_oberschenkel");
        this.fldLOberschenkel.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberschenkelFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberschenkel, gridBagConstraints);
        this.jLabel6.setLabelFor(this.fldLUnterschenkel);
        this.jLabel6.setText("Unterschenkel+Ferse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panKoerperMasse.add((Component)this.jLabel6, gridBagConstraints);
        this.fldLUnterschenkel.setHorizontalAlignment(4);
        this.fldLUnterschenkel.setName("l_unterschenkel");
        this.fldLUnterschenkel.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLUnterschenkelFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLUnterschenkel, gridBagConstraints);
        this.panDreieck.setPreferredSize(new Dimension(208, 213));
        this.panDreieck.setLayout(new GridBagLayout());
        this.panDreieckBild.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblDreieckOben.setHorizontalAlignment(11);
        this.lblDreieckOben.setText("77");
        this.lblDreieckOben.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblDreieckOben, new AbsoluteConstraints(80, 24, -1, -1));
        this.lblDreieckLinks.setHorizontalAlignment(11);
        this.lblDreieckLinks.setText("97");
        this.lblDreieckLinks.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblDreieckLinks, new AbsoluteConstraints(10, 110, 30, -1));
        this.lblDreieckRechts.setText("84");
        this.lblDreieckRechts.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblDreieckRechts, new AbsoluteConstraints(140, 110, -1, -1));
        this.lblDreieck.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/magischesDreieck.gif")));
        this.panDreieckBild.add((Component)this.lblDreieck, new AbsoluteConstraints(0, 0, 208, 213));
        this.lblWinkel.setHorizontalAlignment(11);
        this.lblWinkel.setText("5\u00b0");
        this.lblWinkel.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblWinkel, new AbsoluteConstraints(174, 180, -1, -1));
        this.panDreieck.add((Component)this.panDreieckBild, new GridBagConstraints());
        this.cmdBerechnen.setText("(Neu) Berechnen");
        this.cmdBerechnen.setEnabled(false);
        this.cmdBerechnen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdBerechnenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panDreieck.add((Component)this.cmdBerechnen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.panKoerperMasse.add((Component)this.panDreieck, gridBagConstraints);
        this.cmdMagischesDreieck.setText("O.K.");
        this.cmdMagischesDreieck.setToolTipText("Rahmen ermitteln");
        this.cmdMagischesDreieck.setEnabled(false);
        this.cmdMagischesDreieck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMagischesDreieckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panKoerperMasse.add((Component)this.cmdMagischesDreieck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.panMessung.add((Component)this.panKoerperMasse, gridBagConstraints);
        this.tabRechts.setBackground(new Color(255, 255, 255));
        this.tabRechts.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.panActions.setBackground(new Color(255, 255, 255));
        this.panActions.setAlignmentX(0.0f);
        this.panActions.setAlignmentY(0.0f);
        this.panActions.setRequestFocusEnabled(false);
        this.panActions.setLayout(new GridBagLayout());
        this.cmdTakePicture.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/messen.gif")));
        this.cmdTakePicture.setText("Foto schiessen");
        this.cmdTakePicture.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdTakePictureActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panActions.add((Component)this.cmdTakePicture, gridBagConstraints);
        this.cmdManual.setText("Messpunkte manuell neu setzen");
        this.cmdManual.setEnabled(false);
        this.cmdManual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdManualActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.panActions.add((Component)this.cmdManual, gridBagConstraints);
        this.cbAutomatisch.setSelected(true);
        this.cbAutomatisch.setText("Messpunkte automatisch suchen");
        this.cbAutomatisch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cbAutomatischActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.panActions.add((Component)this.cbAutomatisch, gridBagConstraints);
        this.tabRechts.addTab("Aktion", this.panActions);
        this.panSettings.setBackground(new Color(255, 255, 255));
        this.panSettings.setLayout(new GridBagLayout());
        this.lblMarkerColor.setBackground(new Color(102, 102, 255));
        this.lblMarkerColor.setText("       ");
        this.lblMarkerColor.setToolTipText("Vergleichsfarbe");
        this.lblMarkerColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblMarkerColor.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panSettings.add((Component)this.lblMarkerColor, gridBagConstraints);
        this.cmdColor.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/farbwahl.png")));
        this.cmdColor.setText("Farbe festlegen");
        this.cmdColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.panSettings.add((Component)this.cmdColor, gridBagConstraints);
        this.btncalibrate.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/messen.gif")));
        this.btncalibrate.setText("L\u00e4nge kalibrieren");
        this.btncalibrate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.btncalibrateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.panSettings.add((Component)this.btncalibrate, gridBagConstraints);
        this.btnMessbereich.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/messbereich.png")));
        this.btnMessbereich.setText("Messbereich w\u00e4hlen");
        this.btnMessbereich.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.btnMessbereichActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.panSettings.add((Component)this.btnMessbereich, gridBagConstraints);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Farbabweichung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.sliFarbabweichung.setMajorTickSpacing(5);
        this.sliFarbabweichung.setMaximum(75);
        this.sliFarbabweichung.setMinimum(5);
        this.sliFarbabweichung.setValue(30);
        this.sliFarbabweichung.setMinimumSize(new Dimension(100, 25));
        this.sliFarbabweichung.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanKoerper.this.sliFarbabweichungStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panSettings.add((Component)this.sliFarbabweichung, gridBagConstraints);
        this.jLabel8.setFont(new Font("Dialog", 0, 12));
        this.jLabel8.setText("Gr\u00f6ssenabweichung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panSettings.add((Component)this.jLabel8, gridBagConstraints);
        this.sliSizeabweichung.setMajorTickSpacing(10);
        this.sliSizeabweichung.setMaximum(200);
        this.sliSizeabweichung.setMinimum(10);
        this.sliSizeabweichung.setValue(10);
        this.sliSizeabweichung.setMinimumSize(new Dimension(100, 25));
        this.sliSizeabweichung.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanKoerper.this.sliSizeabweichungStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panSettings.add((Component)this.sliSizeabweichung, gridBagConstraints);
        this.cbColorAreas.setText("Erkannte Bereiche einf\u00e4rben");
        this.cbColorAreas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cbColorAreasActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.panSettings.add((Component)this.cbColorAreas, gridBagConstraints);
        this.jLabel7.setFont(new Font("Dialog", 0, 12));
        this.jLabel7.setText("Messpunktfarbe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panSettings.add((Component)this.jLabel7, gridBagConstraints);
        this.cmdSaveSettings.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/save.gif")));
        this.cmdSaveSettings.setToolTipText("Einstellungen speichern");
        this.cmdSaveSettings.setMaximumSize(new Dimension(25, 25));
        this.cmdSaveSettings.setMinimumSize(new Dimension(25, 25));
        this.cmdSaveSettings.setPreferredSize(new Dimension(25, 25));
        this.cmdSaveSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdSaveSettingsActionPerformed(evt);
            }
        });
        this.panEinstellungenSpeichern.add(this.cmdSaveSettings);
        this.cmdRestoreSettings.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/undo.gif")));
        this.cmdRestoreSettings.setToolTipText("Zuletzt gespeichere Einstellungen wiederherstellen");
        this.cmdRestoreSettings.setMaximumSize(new Dimension(25, 25));
        this.cmdRestoreSettings.setMinimumSize(new Dimension(25, 25));
        this.cmdRestoreSettings.setPreferredSize(new Dimension(25, 25));
        this.cmdRestoreSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdRestoreSettingsActionPerformed(evt);
            }
        });
        this.panEinstellungenSpeichern.add(this.cmdRestoreSettings);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.panSettings.add((Component)this.panEinstellungenSpeichern, gridBagConstraints);
        this.tabRechts.addTab("Einstellungen", this.panSettings);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panMessung.add((Component)this.tabRechts, gridBagConstraints);
        this.lbloutput.setColumns(20);
        this.lbloutput.setRows(5);
        this.lbloutput.setEnabled(false);
        this.lbloutput.setMinimumSize(new Dimension(336, 42));
        this.lbloutput.setPreferredSize(new Dimension(336, 42));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.panMessung.add((Component)this.lbloutput, gridBagConstraints);
        this.scrlMessung.setViewportView(this.panMessung);
        this.add((Component)this.scrlMessung, "East");
    }

    private void cmdMagischesDreieckActionPerformed(ActionEvent evt) {
        try {
            BufferedImage bfImage = this.panFotoImage.createBFImage();
            try {
                ImageIO.write((RenderedImage)bfImage, "jpg", this.bfImageFile);
            }
            catch (IOException e) {
                throw new YException(e.toString());
            }
            this.frmNavigator.setEinsbedingung("koerpermasse", this.magischesDreieck.getHinten());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdColorActionPerformed(ActionEvent evt) {
        this.lbloutput.setText("Markieren Sie mit der Maus einen Punkt der Markierungsfarbe");
        this.mouseMode = MouseMode.COLOR;
    }

    private void cmdTakePictureActionPerformed(ActionEvent evt) {
        try {
            int a;
            this.kunde.requestValuesToStore();
            int iRow = this.kundeneinsbed.find(String.valueOf(this.einsbereichIdSitzknochen), "einsbereich_id");
            if (iRow < 0 && (a = JOptionPane.showConfirmDialog(this, "Das \"Magische Dreieck\" kann nur mit der Sitzhaltung berechnet werden,\ndie beim Sitzknochenabstand erfa\u00dft wird.", "Warnung", 2)) == 2) {
                return;
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
        if (!this.fotoCmdFile.exists()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.fotoCmdFile.getPath() + "' zum Fotografieren existiert nicht.", "Fehler", 0);
            return;
        }
        if (!this.fotoCmdFile.canExecute()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.fotoCmdFile.getPath() + "' zum Fotografieren ist nicht ausf\u00fchrbar.", "Fehler", 0);
            return;
        }
        this.ergebnisseLoeschen();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PanKoerper.this.fotoThread = new FotoThread(PanKoerper.this.fotoCmdFile.getPath());
                PanKoerper.this.fotoThread.start();
            }
        });
    }

    private void changePicture(Image bodyImage) {
        this.panFotoImage.setImage(bodyImage);
        if (this.cbAutomatisch.isSelected()) {
            this.findDefaultMarkers();
            this.connectAreas();
        }
        this.fldLOberarm.setText("");
        this.fldLOberkoerper.setText("");
        this.fldLOberschenkel.setText("");
        this.fldLUnterarm.setText("");
        this.fldLUnterschenkel.setText("");
        this.lblDreieckOben.setVisible(false);
        this.lblDreieckLinks.setVisible(false);
        this.lblDreieckRechts.setVisible(false);
        this.lblWinkel.setVisible(false);
        this.cmdMagischesDreieck.setEnabled(false);
        if (this.cbAutomatisch.isSelected() && bodyImage != this.defaultImage) {
            this.berechneAbstaende();
        }
        this.panFotoImage.repaint();
    }

    private void btncalibrateActionPerformed(ActionEvent evt) {
        this.lbloutput.setText("Markieren Sie mit der Maus mit 2 Klicks einen Meter");
        this.mouseMode = MouseMode.CALIBRATE;
        this.messpunkte.calibStart.moveTo(0, 0);
        this.panFotoImage.repaint();
    }

    private void btnMessbereichActionPerformed(ActionEvent evt) {
        this.lbloutput.setText("Markieren Sie erst den linken oberen Punkt des Messbereiches, anschliessend den rechten unteren.");
        this.mouseMode = MouseMode.REGION;
        this.messbereichstart = null;
        this.messbereichend = null;
    }

    private void sliFarbabweichungStateChanged(ChangeEvent evt) {
        if (this.mouseMode == MouseMode.STARTUP) {
            return;
        }
        if (System.currentTimeMillis() - this.lastUpdate < 100L) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.panFotoImage.farbabweichung = this.sliFarbabweichung.getValue();
        this.findDefaultMarkers();
        this.connectAreas();
        this.berechneAbstaende();
        this.panFotoImage.repaint();
    }

    private void sliSizeabweichungStateChanged(ChangeEvent evt) {
        if (this.mouseMode == MouseMode.STARTUP) {
            return;
        }
        if (System.currentTimeMillis() - this.lastUpdate < 100L) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.panFotoImage.bereichsabweichung = this.sliSizeabweichung.getValue();
        this.findDefaultMarkers();
        this.connectAreas();
        this.berechneAbstaende();
        this.panFotoImage.repaint();
    }

    private void cmdSaveSettingsActionPerformed(ActionEvent evt) {
        this.session.getConfigFile().setEntry("CALIBSTART", this.messpunkte.calibStart.toString());
        this.session.getConfigFile().setEntry("CALIBEND", this.messpunkte.calibEnd.toString());
        this.session.getConfigFile().setEntry("MARKERCOLOR", String.valueOf(this.panFotoImage.markerColor));
        this.session.getConfigFile().setEntry("COLORDEVIATION", String.valueOf(this.panFotoImage.farbabweichung));
        this.session.getConfigFile().setEntry("SIZEDEVIATION", String.valueOf(this.panFotoImage.bereichsabweichung));
        this.session.getConfigFile().setEntry("REGIONSTARTX", String.valueOf(this.messbereichstart.x));
        this.session.getConfigFile().setEntry("REGIONSTARTY", String.valueOf(this.messbereichstart.y));
        this.session.getConfigFile().setEntry("REGIONENDX", String.valueOf(this.messbereichend.x));
        this.session.getConfigFile().setEntry("REGIONENDY", String.valueOf(this.messbereichend.y));
        this.lbloutput.setText("Einstellungen gespeichert");
    }

    private void cmdRestoreSettingsActionPerformed(ActionEvent evt) {
        this.readSettings();
        this.findDefaultMarkers();
        this.connectAreas();
        this.berechneAbstaende();
        this.panFotoImage.repaint();
        this.lbloutput.setText("Einstellungen zur\u00fcckgesetzt");
    }

    private void cbColorAreasActionPerformed(ActionEvent evt) {
        this.panFotoImage.setColorRegion(this.cbColorAreas.isSelected());
        this.panFotoImage.repaint();
    }

    private void cmdManualActionPerformed(ActionEvent evt) {
        this.lbloutput.setText("Markieren Sie die 6 Messpunkte");
        this.messpunkte.clear();
        this.panFotoImage.setAreas(new ArrayList<Farbbereich>());
        this.mouseMode = MouseMode.MANUAL;
        this.panFotoImage.setColorRegion(true);
        this.panFotoImage.repaint();
    }

    private void cbAutomatischActionPerformed(ActionEvent evt) {
        if (this.cbAutomatisch.isSelected()) {
            this.cmdManual.setEnabled(false);
            this.findDefaultMarkers();
            this.connectAreas();
            this.panFotoImage.repaint();
            this.berechneAbstaende();
        } else {
            this.cmdManual.setEnabled(true);
            this.cmdManualActionPerformed(evt);
        }
    }

    private void fldLUnterarmFocusLost(FocusEvent evt) {
        this.berechneDreieck(evt);
    }

    private void fldLOberarmFocusLost(FocusEvent evt) {
        this.berechneDreieck(evt);
    }

    private void fldLOberkoerperFocusLost(FocusEvent evt) {
        this.berechneDreieck(evt);
    }

    private void fldLOberschenkelFocusLost(FocusEvent evt) {
        this.berechneDreieck(evt);
    }

    private void fldLUnterschenkelFocusLost(FocusEvent evt) {
        this.berechneDreieck(evt);
    }

    private void cmdBerechnenActionPerformed(ActionEvent evt) {
        this.berechneDreieck(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MouseMode {
        NULL,
        COLOR,
        CALIBRATE,
        REGION,
        MANUAL,
        STARTUP;

    }

    private class FotoThread
    extends Thread {
        private String fotoCmd;
        private Runtime rt;
        private Process proc;
        private BufferedReader procerr;
        private BufferedReader procout;
        private StringBuffer errmsg;
        private boolean error;

        public FotoThread(String fotoCmd) {
            this.fotoCmd = fotoCmd;
            this.errmsg = new StringBuffer(80);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                PanKoerper.this.cmdTakePicture.setEnabled(false);
                this.errmsg.setLength(0);
                this.rt = Runtime.getRuntime();
                this.proc = this.rt.exec(this.fotoCmd);
                this.procerr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
                this.proc.waitFor();
                if (this.proc.exitValue() == 0) {
                    Image bodyImage = Toolkit.getDefaultToolkit().createImage(PanKoerper.this.fotoImageFile.getAbsolutePath());
                    PanKoerper.this.changePicture(bodyImage);
                }
            }
            catch (Exception exception) {
            }
            finally {
                PanKoerper.this.cmdTakePicture.setEnabled(true);
            }
        }
    }
}

