/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import projektY.base.YException;
import projektY.base.YUnimplementedException;
import projektY.database.YFieldValue;
import projektY.database.YSQLDml;
import projektY.database.YSQLQuery;

public abstract class YDatabase {
    private String driver;
    private String URL;
    private String user;
    private Locale locale;
    private Connection dbconn;
    protected boolean initializedTransaction;
    protected boolean inTransaction;
    protected boolean sqlLog;
    protected YSQLQuery sqlQuery;
    protected YSQLDml sqlDml;

    public boolean isConnected() {
        return this.dbconn != null;
    }

    public Connection getConnection() throws YException {
        if (this.dbconn == null) {
            throw new YException("Es besteht keine Verbindung zu einer Datenbank.");
        }
        return this.dbconn;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public GregorianCalendar getCal() {
        return new GregorianCalendar(this.locale);
    }

    public YDatabase(String driver, String URL2, Locale locale) throws YException {
        try {
            this.initializedTransaction = false;
            this.inTransaction = false;
            this.driver = driver;
            this.URL = URL2;
            this.locale = locale;
            Class.forName(driver);
            this.sqlLog = false;
            this.sqlQuery = new YSQLQuery(this);
            this.sqlDml = new YSQLDml(this);
            this.user = null;
        }
        catch (ClassNotFoundException e) {
            throw new YException("Der JDBC-Treiber " + driver + " konnte nicht geladen werden.");
        }
    }

    public void connect(String user, String password) throws YException {
        try {
            if (this.dbconn != null) {
                this.dbconn.close();
            }
            this.user = null;
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.dbconn = null;
        try {
            this.dbconn = DriverManager.getConnection(this.URL, user, password);
            this.user = user;
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    protected boolean ensureConnection(Connection dbconn0) throws YException {
        if (this.dbconn == null) {
            throw new YException("Keine Verbindung zum Server.");
        }
        try {
            if (this.dbconn.isClosed()) {
                throw new YException("Keine Verbindung zum Server.");
            }
        }
        catch (SQLException e) {
            throw new YException("Fehler in der Datenbankverbindung:\n" + e.getMessage());
        }
        return false;
    }

    public void disconnect() {
        if (this.dbconn != null) {
            try {
                this.dbconn.close();
                this.user = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dbconn = null;
        }
    }

    public void setSqlLog(boolean sqlLog) {
        this.sqlLog = sqlLog;
    }

    public String getUser() {
        return this.user;
    }

    public void startTransaction() throws YException {
        this.initializedTransaction = true;
    }

    public void begin() throws YException {
        this.initializedTransaction = false;
        if (this.inTransaction) {
            throw new YException("Verschachtelte Transaktionen sind nicht erlaubt.");
        }
        this.inTransaction = true;
    }

    public void commit() throws YException {
        this.initializedTransaction = false;
        if (this.inTransaction) {
            this.sqlDml.execute("COMMIT");
        }
        this.inTransaction = false;
        this.initializedTransaction = false;
    }

    public void rollback() throws YException {
        this.initializedTransaction = false;
        if (this.inTransaction) {
            this.sqlDml.execute("ROLLBACK");
        }
        this.inTransaction = false;
    }

    public boolean isInTransaction() {
        return this.initializedTransaction || this.inTransaction;
    }

    public abstract int nextId(String var1) throws YException;

    public String sqlString(String s) {
        int i;
        StringBuffer sql = new StringBuffer();
        int i0 = 0;
        sql.append('\'');
        while ((i = s.indexOf(39, i0)) >= 0) {
            if (i > i0) {
                sql.append(s.substring(i0, i));
            }
            sql.append("''");
            i0 = i + 1;
        }
        if (i0 < s.length()) {
            sql.append(s.substring(i0));
        }
        sql.append('\'');
        return new String(sql);
    }

    public String sqlDate(int day, int month, int year) {
        NumberFormat fmt = NumberFormat.getInstance();
        assert (fmt instanceof DecimalFormat);
        DecimalFormat dfmt = (DecimalFormat)fmt;
        StringBuffer date = new StringBuffer();
        date.append('\'');
        dfmt.applyPattern("0000");
        date.append(dfmt.format(year));
        date.append('-');
        dfmt.applyPattern("00");
        date.append(dfmt.format(month));
        date.append('-');
        date.append(dfmt.format(day));
        date.append('\'');
        return new String(date);
    }

    public String sqlTime(int hour, int minute, int second) {
        NumberFormat fmt = NumberFormat.getInstance();
        assert (fmt instanceof DecimalFormat);
        DecimalFormat dfmt = (DecimalFormat)fmt;
        StringBuffer time = new StringBuffer();
        time.append('\'');
        dfmt.applyPattern("00");
        time.append(dfmt.format(hour));
        time.append(':');
        dfmt.applyPattern("00");
        time.append(dfmt.format(minute));
        time.append(':');
        time.append(dfmt.format(second));
        time.append('\'');
        return new String(time);
    }

    public final String sqlToday(GregorianCalendar cal) {
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        return this.sqlDate(day, month, year);
    }

    public String getTrue() {
        return "1";
    }

    public String getFalse() {
        return "0";
    }

    abstract void createUser(String var1, char[] var2) throws YException;

    abstract void dropUser(String var1) throws YException;

    abstract void alterPasswd(String var1, char[] var2) throws YException;

    abstract void grantAdmin(String var1) throws YException;

    abstract void revokeAdmin(String var1) throws YException;

    abstract void grantRole(String var1, String var2) throws YException;

    abstract void revokeRole(String var1, String var2) throws YException;

    abstract boolean isFkViolation(SQLException var1);

    abstract boolean isUniqueViolation(SQLException var1);

    public void setPasswdUser(String passwdUser) throws YUnimplementedException, YException {
        throw new YUnimplementedException(this);
    }

    public void modifyPasswdField(YFieldValue pwdFv, char[] passwd) throws YUnimplementedException, YException {
        throw new YUnimplementedException(this);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getURL() {
        return this.URL;
    }
}

