/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YFilteredList;
import projektY.database.YParamSql;
import projektY.database.YSession;

public class YEvaluationList
extends YFilteredList {
    protected String[] groupBy;
    protected String having;

    public YEvaluationList(YSession session, int maxColumns, int maxRows) throws YProgramException {
        super(session, maxColumns, maxRows);
    }

    public YEvaluationList(YSession session, int maxColumns) throws YProgramException {
        super(session, maxColumns, true);
    }

    public YEvaluationList(YSession session, int maxColumns, String name) throws YProgramException {
        super(session, maxColumns, true);
        this.name = name;
    }

    public YColumnDefinition addDatabaseField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        return this.addDBField(fieldName, fieldType);
    }

    public void setSqlSelect(String sqlSelect) throws YProgramException {
        try {
            super.setSQLSelect(sqlSelect);
        }
        catch (AssertionError e) {
            throw new YProgramException(this, ((Throwable)((Object)e)).toString());
        }
    }

    public void setSQLSelect(String sqlSelect) throws YProgramException {
        try {
            super.setSQLSelect(sqlSelect);
        }
        catch (AssertionError e) {
            throw new YProgramException(this, ((Throwable)((Object)e)).toString());
        }
    }

    public void setParamSelect(String paramSelect) throws YProgramException {
        try {
            super.setParamSelect(paramSelect);
        }
        catch (AssertionError e) {
            throw new YProgramException(this, ((Throwable)((Object)e)).toString());
        }
    }

    public void setParamSelect(String paramSelect, YParamSql.Filter[] filter) throws YProgramException {
        try {
            super.setParamSelect(paramSelect, filter);
        }
        catch (AssertionError e) {
            throw new YProgramException(this, ((Throwable)((Object)e)).toString());
        }
    }

    public void setAndWhere(String andWhere) throws YProgramException {
        try {
            super.setAndWhere(andWhere);
        }
        catch (AssertionError e) {
            throw new YProgramException(this, ((Throwable)((Object)e)).toString());
        }
    }

    public void setGroupBy(String[] groupBy) throws YProgramException {
        if (this.paramSelect != null) {
            throw new YProgramException(this, "setGroupBy() kann nicht zusammen mit paramSelect verwendet werden.");
        }
        this.groupBy = groupBy;
    }

    public void setHaving(String having) throws YProgramException {
        if (this.paramSelect != null) {
            throw new YProgramException(this, "setHaving() kann nicht zusammen mit paramSelect verwendet werden.");
        }
        this.having = having;
    }

    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
    }

    public String sqlValue(String value, YColumnDefinition.FieldType fieldType) throws YException {
        return super.sqlValue(value, fieldType);
    }

    public void finalize() throws YException {
        super.finalizeDefinition();
    }

    protected String createSelectWhere() throws YException {
        if (this.paramSelect != null) {
            return this.paramSelect.createSQL(this);
        }
        StringBuffer sql = new StringBuffer(this.sqlSelect);
        StringBuffer where = new StringBuffer();
        where.append(this.createFilterExpression());
        if (this.andWhere != null) {
            if (where.length() > 0) {
                where.insert(0, '(');
                where.append(')');
                where.append(" AND ");
            }
            where.append(this.andWhere);
        }
        if (where.length() > 0) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        if (this.groupBy != null) {
            sql.append(" GROUP BY ");
            for (int i = 0; i < this.groupBy.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(this.groupBy[i]);
            }
            if (this.having != null) {
                sql.append(" HAVING ");
                sql.append(this.having);
            }
        }
        return new String(sql);
    }
}

