/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.base.YProgramException;
import projektY.base.YUnimplementedException;
import projektY.base.YUserException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabase;
import projektY.database.YDatabaseList;
import projektY.database.YDetailList;
import projektY.database.YFieldValue;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YRowDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.YSubRowListImplementation;

public class YLinkedDetailList
extends YDetailList {
    protected String detailName;
    protected String detailTableName;
    protected YColumnDefinition detailFkDefinition;
    protected Vector<YColumnDefinition> linkDefinitions;
    protected Vector<YColumnDefinition> detailDefinitions;

    private void initialize() {
        this.linkDefinitions = new Vector(20, 10);
        this.detailDefinitions = new Vector(30, 10);
        this.onRemove = YDetailList.OnRemove.UNLINK;
    }

    public YLinkedDetailList(YSession session, int maxColumns, YRowObject masterRowObject) throws YException {
        super(session, maxColumns, masterRowObject);
        this.initialize();
    }

    public YLinkedDetailList(YSession session, int maxColumns, int masterId) throws YException {
        super(session, maxColumns, masterId);
        this.initialize();
    }

    public YLinkedDetailList(YSession session, int maxColumns) throws YException {
        super(session, maxColumns);
        this.initialize();
    }

    public YColumnDefinition addRowObjectFkField(String fieldName) throws YException {
        if (this.rowObjectFkDefinition != null) {
            throw new YProgramException(this, "Detaillisten gestatten nur ein Master-Fremdschl\u00fcsselfeld.");
        }
        this.masterRowFkDefinition = this.rowObjectFkDefinition = this.rowDefinition.addColumnDefinition(fieldName, YColumnDefinition.FieldType.INT, true, false);
        this.linkDefinitions.add(this.rowObjectFkDefinition);
        return this.rowObjectFkDefinition;
    }

    public YColumnDefinition addDetailFkField(String fieldName) throws YException {
        this.detailFkDefinition = this.rowDefinition.addColumnDefinition(fieldName, YColumnDefinition.FieldType.INT, true, false);
        this.linkDefinitions.add(this.detailFkDefinition);
        return this.detailFkDefinition;
    }

    public YColumnDefinition addDBField(String fieldName, YColumnDefinition.FieldType fieldType) throws YProgramException {
        throw new YProgramException(this, "Statt addDBField() mu\u00df addLinkDBField() oder addDetailDBField() verwendet werden.");
    }

    public YColumnDefinition addROField(String fieldName, YColumnDefinition.FieldType fieldType) throws YProgramException {
        throw new YProgramException(this, "Statt addROField() mu\u00df addLinkROField() oder addDetailROField() verwendet werden.");
    }

    public YLookUpDBColumnDefinition addLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YException {
        throw new YProgramException(this, "Statt addLookUpDBField() mu\u00df addLinkLookUpDBField() oder addDetailLookUpDBField() verwendet werden.");
    }

    public YLookUpDBColumnDefinition addLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName) throws YException {
        throw new YProgramException(this, "Statt addLookUpDBField() mu\u00df addLinkLookUpDBField() oder addDetailLookUpDBField() verwendet werden.");
    }

    public YLookUpDomainColumnDefinition addLookUpDomainField(String fieldName, YColumnDefinition.FieldType fieldType, YLookUpDomain domain) throws YException {
        throw new YProgramException(this, "Statt addLookUpDomainField() mu\u00df addLinkLookUpDomainField() oder addDetailLookUpDomainField() verwendet werden.");
    }

    public YLookUpDomainColumnDefinition addLookUpDomainField(String fieldName, YLookUpDomain domain) throws YException {
        throw new YProgramException(this, "Statt addLookUpDomainField() mu\u00df addLinkLookUpDomainField() oder addDetailLookUpDomainField() verwendet werden.");
    }

    public YColumnDefinition addLinkDBField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        YColumnDefinition columnDefinition = super.addDBField(fieldName, fieldType);
        this.linkDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YColumnDefinition addLinkROField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        YColumnDefinition columnDefinition = super.addROField(fieldName, fieldType);
        this.linkDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDBColumnDefinition addLinkLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YException {
        YLookUpDBColumnDefinition columnDefinition = super.addLookUpDBField(fieldName, lookUpList, valueFieldName, altFieldName);
        this.linkDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDBColumnDefinition addLinkLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName) throws YException {
        YLookUpDBColumnDefinition columnDefinition = super.addLookUpDBField(fieldName, lookUpList, valueFieldName);
        this.linkDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDomainColumnDefinition addLinkLookUpDomainField(String fieldName, YColumnDefinition.FieldType fieldType, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition columnDefinition = super.addLookUpDomainField(fieldName, fieldType, domain);
        this.linkDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDomainColumnDefinition addLinkLookUpDomainField(String fieldName, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition columnDefinition = super.addLookUpDomainField(fieldName, domain);
        this.linkDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDBColumnDefinition addDetailLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YException {
        YLookUpDBColumnDefinition columnDefinition = super.addLookUpDBField(fieldName, lookUpList, valueFieldName, altFieldName);
        this.detailDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDBColumnDefinition addDetailLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName) throws YException {
        YLookUpDBColumnDefinition columnDefinition = super.addLookUpDBField(fieldName, lookUpList, valueFieldName);
        this.detailDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDomainColumnDefinition addDetailLookUpDomainField(String fieldName, YColumnDefinition.FieldType fieldType, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition columnDefinition = super.addLookUpDomainField(fieldName, fieldType, domain);
        this.detailDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YLookUpDomainColumnDefinition addDetailLookUpDomainField(String fieldName, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition columnDefinition = super.addLookUpDomainField(fieldName, domain);
        this.detailDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YColumnDefinition addDetailPkField(String fieldName) throws YProgramException {
        if (this.rowPkDefinition != null) {
            throw new YProgramException(this, "YLinkedDetailList gestattet nur ein Schl\u00fcsselfeld.");
        }
        if (this.detailFkDefinition == null) {
            throw new YProgramException(this, "YLinkedDetailList: addDetailFkField() mu\u00df vor addDetailPkField() erfolgen.");
        }
        this.rowPkDefinition = new YColumnDefinition(this.detailFkDefinition.getFieldValueIndex(), fieldName, YColumnDefinition.FieldType.INT, true, false);
        this.detailDefinitions.add(this.rowPkDefinition);
        return this.rowPkDefinition;
    }

    public YColumnDefinition addDetailDBField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        YColumnDefinition columnDefinition = super.addDBField(fieldName, fieldType);
        this.detailDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    public YColumnDefinition addDetailROField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        YColumnDefinition columnDefinition = super.addROField(fieldName, fieldType);
        this.detailDefinitions.add(columnDefinition);
        return columnDefinition;
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
        this.detailTableName = detailName;
    }

    public void setDetailName(String detailName, String detailTableName) {
        this.detailName = detailName;
        this.detailTableName = detailTableName;
    }

    protected String generateSqlSelect() throws YProgramException {
        int iRow;
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT ");
        int nRows = this.linkDefinitions.size();
        for (iRow = 0; iRow < nRows; ++iRow) {
            if (iRow > 0) {
                sql.append(", ");
            }
            sql.append("l." + this.linkDefinitions.get(iRow).getName());
        }
        nRows = this.detailDefinitions.size();
        for (iRow = 0; iRow < nRows; ++iRow) {
            sql.append(", d." + this.detailDefinitions.get(iRow).getName());
        }
        sql.append(" FROM " + this.tableName + " l");
        sql.append(" JOIN " + this.detailName + " d ON (l." + this.detailFkDefinition.getName());
        sql.append("=d." + this.rowPkDefinition.getName() + ")");
        this.rowObjectFkAlias = "l.";
        return sql.toString();
    }

    protected void checkFinalized() throws YProgramException {
        if (this.tableName == null) {
            throw new YProgramException(this, "Der Name der Verkn\u00fcpfungstabelle wurde nicht gesetzt.");
        }
        if (this.detailName == null) {
            throw new YProgramException(this, "Der Name der Detailtabelle wurde nicht gesetzt.");
        }
        super.checkFinalized();
    }

    public YRowValues append(YRowObject rowObject) throws YException {
        throw new YUnimplementedException(this);
    }

    public boolean setDefaults() throws YException {
        boolean defaultsSet = false;
        int nCols = this.rowDefinition.getNColumns();
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            YRowValues rowValues = this.getAbsRowValues(iRow);
            YFieldValue detailFkValue = rowValues.getFieldValue(this.detailFkDefinition);
            if (detailFkValue.getValueAsInt(0) > 0 || !this.hasValuesToStore(rowValues)) continue;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                defaultsSet |= rowValues.getFieldValue(iCol).setDefaultIfNull();
            }
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            defaultsSet |= ((YSubRowListImplementation)this.subListImplementations.get(iSub)).setDefaults();
        }
        return defaultsSet;
    }

    protected boolean hasValuesToStore(YRowValues rowValues) throws YException {
        for (int iCol = 0; iCol < this.dispColCount; ++iCol) {
            YFieldValue fieldValue = rowValues.getFieldValue(this.dispIndicees[iCol]);
            if (!this.detailDefinitions.contains(fieldValue.getColumnDefinition()) || fieldValue.isNull()) continue;
            return true;
        }
        return false;
    }

    protected void postThis() throws YException {
        YDatabase database = this.session.getDatabase();
        StringBuffer sql = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        int[][] linkKeys = new int[this.getRowCount()][2];
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            int iColval;
            YFieldValue fieldValue;
            YColumnDefinition columnDefinition;
            int iColdef;
            YRowValues rowValues = this.getAbsRowValues(iRow);
            boolean hasValuesToStore = this.hasValuesToStore(rowValues);
            this.beforeRow(iRow, rowValues);
            YFieldValue fvMasterFk = rowValues.getFieldValue(this.masterRowFkDefinition);
            YFieldValue fvDetailFk = rowValues.getFieldValue(this.detailFkDefinition);
            if (hasValuesToStore) {
                linkKeys[iRow][0] = fvMasterFk.getValueAsInt(0);
                linkKeys[iRow][1] = fvDetailFk.getValueAsInt(0);
                if (linkKeys[iRow][0] != 0 && linkKeys[iRow][1] != 0) {
                    for (int iRowKeys = 0; iRowKeys < iRow; ++iRowKeys) {
                        if (linkKeys[iRowKeys][0] == 0 || linkKeys[iRowKeys][1] == 0 || linkKeys[iRowKeys][0] != linkKeys[iRow][0] || linkKeys[iRowKeys][1] != linkKeys[iRow][1]) continue;
                        throw new YUserException("Unzul\u00e4ssiger doppelter Eintrag in \"" + this.getLabel() + "\"");
                    }
                }
            } else {
                linkKeys[iRow][0] = 0;
                linkKeys[iRow][1] = 0;
            }
            int nSqlFields = 0;
            if (fvDetailFk.getValueAsInt(0) <= 0) {
                if (hasValuesToStore) {
                    if (!database.isInTransaction()) {
                        database.startTransaction();
                    }
                    int detailId = database.nextId(this.detailTableName);
                    rowValues.getFieldValue(this.rowPkDefinition).setAutoId(detailId);
                    sql.append("INSERT INTO " + this.detailName + " (");
                    sql2.append(" VALUES (");
                    for (iColdef = 0; iColdef < this.detailDefinitions.size(); ++iColdef) {
                        columnDefinition = this.detailDefinitions.get(iColdef);
                        if (columnDefinition.isReadOnly() || (fieldValue = rowValues.getFieldValue(iColval = columnDefinition.getFieldValueIndex())).isNull()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                            sql2.append(", ");
                        }
                        sql.append(columnDefinition.getName());
                        sql2.append(this.sqlValue(fieldValue));
                        ++nSqlFields;
                    }
                    sql.append(")");
                    sql.append(sql2);
                    sql.append(")");
                    rowValues.setPostMark();
                    this.sqlDml.execute(sql.toString());
                    sql.delete(0, sql.length());
                    sql2.delete(0, sql2.length());
                    fvDetailFk.setAutoId(detailId);
                    fvMasterFk.modifyValue(Integer.toString(this.rowObjectId));
                    nSqlFields = 0;
                    sql.append("INSERT INTO " + this.tableName + " (");
                    sql2.append(" VALUES (");
                    for (iColdef = 0; iColdef < this.linkDefinitions.size(); ++iColdef) {
                        columnDefinition = this.linkDefinitions.get(iColdef);
                        if (columnDefinition.isReadOnly() || (fieldValue = rowValues.getFieldValue(iColval = columnDefinition.getFieldValueIndex())).isNull()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                            sql2.append(", ");
                        }
                        sql.append(columnDefinition.getName());
                        sql2.append(this.sqlValue(fieldValue));
                        ++nSqlFields;
                    }
                    sql.append(")");
                    sql.append(sql2);
                    sql.append(")");
                }
            } else if (this.hasValuesToStore(rowValues)) {
                if (fvMasterFk.wasNull()) {
                    if (fvMasterFk.isNull()) {
                        fvMasterFk.modifyValue(this.getMasterFkValueAsInt(rowValues));
                    }
                    sql.append("INSERT INTO " + this.tableName + " (");
                    sql2.append(" VALUES (");
                    for (iColdef = 0; iColdef < this.linkDefinitions.size(); ++iColdef) {
                        columnDefinition = this.linkDefinitions.get(iColdef);
                        if (columnDefinition.isReadOnly() || (fieldValue = rowValues.getFieldValue(iColval = columnDefinition.getFieldValueIndex())).isNull()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                            sql2.append(", ");
                        }
                        sql.append(columnDefinition.getName());
                        sql2.append(this.sqlValue(fieldValue));
                        ++nSqlFields;
                    }
                    sql.append(")");
                    sql2.append(")");
                } else {
                    sql.append("UPDATE " + this.detailName + " SET ");
                    for (iColdef = 0; iColdef < this.detailDefinitions.size(); ++iColdef) {
                        columnDefinition = this.detailDefinitions.get(iColdef);
                        iColval = columnDefinition.getFieldValueIndex();
                        fieldValue = rowValues.getFieldValue(iColval);
                        if (columnDefinition.isPrimaryKey()) {
                            sql2.append(" WHERE " + columnDefinition.getName() + "=" + fieldValue.getValue0());
                            continue;
                        }
                        if (columnDefinition.isReadOnly() || !fieldValue.hasChanged()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                        }
                        sql.append(columnDefinition.getName() + "=" + this.sqlValue(fieldValue));
                        ++nSqlFields;
                    }
                }
                if (nSqlFields > 0) {
                    sql.append(sql2);
                    rowValues.setPostMark();
                    if (!database.isInTransaction()) {
                        database.startTransaction();
                    }
                    this.sqlDml.execute(sql.toString());
                    nSqlFields = 0;
                }
                sql.delete(0, sql.length());
                sql2.delete(0, sql2.length());
                if (!fvMasterFk.wasNull()) {
                    sql.append("UPDATE " + this.tableName + " SET ");
                    for (iColdef = 0; iColdef < this.linkDefinitions.size(); ++iColdef) {
                        columnDefinition = this.linkDefinitions.get(iColdef);
                        iColval = columnDefinition.getFieldValueIndex();
                        fieldValue = rowValues.getFieldValue(iColval);
                        if (columnDefinition.isPrimaryKey()) {
                            if (sql2.length() > 0) {
                                sql2.append(" AND ");
                            }
                            sql2.append(columnDefinition.getName() + "=" + fieldValue.getValue0());
                            continue;
                        }
                        if (columnDefinition.isReadOnly() || !fieldValue.hasChanged()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                        }
                        sql.append(columnDefinition.getName() + "=" + this.sqlValue(fieldValue));
                        ++nSqlFields;
                    }
                    if (nSqlFields == 0) {
                        sql.delete(0, sql.length());
                        sql2.delete(0, sql2.length());
                        continue;
                    }
                    sql.append(" WHERE ");
                    sql.append(sql2);
                }
            } else {
                assert (this.onRemove == YDetailList.OnRemove.UNLINK);
                boolean cancelDelete = false;
                sql.append("DELETE FROM " + this.tableName + " WHERE ");
                for (iColdef = 0; iColdef < this.linkDefinitions.size(); ++iColdef) {
                    columnDefinition = this.linkDefinitions.get(iColdef);
                    iColval = columnDefinition.getFieldValueIndex();
                    fieldValue = rowValues.getFieldValue(iColval);
                    if (!columnDefinition.isPrimaryKey()) continue;
                    if (fieldValue.wasNull()) {
                        cancelDelete = true;
                        break;
                    }
                    if (sql2.length() > 0) {
                        sql2.append(" AND ");
                    }
                    sql2.append(columnDefinition.getName() + "=" + fieldValue.getValue0());
                }
                if (cancelDelete) {
                    sql.delete(0, sql.length());
                    sql2.delete(0, sql2.length());
                } else {
                    sql.append(sql2);
                }
                rowValues.setDeleteMark();
            }
            if (sql.length() > 0) {
                if (!rowValues.hasDeleteMark()) {
                    rowValues.setPostMark();
                }
                if (!database.isInTransaction()) {
                    database.startTransaction();
                }
                this.sqlDml.execute(sql.toString());
                sql.delete(0, sql.length());
                sql2.delete(0, sql2.length());
            }
            this.afterRow(iRow, rowValues);
        }
    }

    public void post() throws YException {
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
            if (this.getRowValues(this.activeRow).hasChanged()) {
                this.fireUpdate(this.activeRow);
            }
        }
        if (!wasInTransaction) {
            this.checkNotNull();
        }
        try {
            this.postThis();
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
                this.setPosted();
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
                this.unsetPosted();
            }
            throw e;
        }
    }

    YRowValues qualifyDetails(int rowObjId) throws YException {
        try {
            assert (this.finalized);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM " + this.detailName);
            sql.append(" WHERE " + this.rowPkDefinition.getName());
            sql.append("=");
            sql.append(rowObjId);
            this.sqlQuery.execute(sql.toString());
            if (this.sqlQuery.next()) {
                YRowValues rowValues = this.createRowValues();
                for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                    YFieldValue fieldValue = rowValues.getFieldValue(i);
                    YColumnDefinition columnDefinition = fieldValue.getColumnDefinition();
                    if (!this.detailDefinitions.contains(columnDefinition)) continue;
                    this.getQueryResult(fieldValue);
                }
                YRowValues yRowValues = rowValues;
                return yRowValues;
            }
            throw new YException("Das Objekt id=" + Integer.toString(rowObjId) + " Tabelle=" + this.detailName + " existiert nicht.");
        }
        finally {
            this.sqlQuery.close();
        }
    }

    public int qualify(int rowObjId) throws YException {
        YRowValues rowValues = this.qualifyDetails(rowObjId);
        rowValues.getFieldValue(this.rowObjectFkDefinition).modifyValue(this.rowObjectId);
        rowValues.getFieldValue(this.detailFkDefinition).gotValue(Integer.toString(rowObjId));
        this.addRowValues(rowValues);
        return this.getAbsRowCount() - 1;
    }

    public void transferDetailValues(int iRow, YRowObject rowObject) throws YException {
        if (!this.detailName.equals(rowObject.getTableName())) {
            throw new YProgramException(this, rowObject.getTableName() + " kann nicht als zu " + this.detailName + " geh\u00f6rend qualifiziert werden");
        }
        YRowDefinition rowDefinition0 = rowObject.rowDefinition;
        YRowValues rowValues = this.getRowValues(iRow);
        for (int iCol0 = 0; iCol0 < this.rowDefinition.getNColumns(); ++iCol0) {
            int iCol;
            YFieldValue fieldValue = rowValues.getFieldValue(iCol0);
            YColumnDefinition columnDefinition = fieldValue.getColumnDefinition();
            if (!this.detailDefinitions.contains(columnDefinition)) continue;
            for (iCol = 0; iCol < rowDefinition0.getNColumns() && !rowDefinition0.getColumnDefinition(iCol).equals(columnDefinition); ++iCol) {
            }
            if (iCol >= rowDefinition0.getNColumns()) continue;
            String fvAsString = rowObject.getFieldValue(rowDefinition0.getColumnDefinition(iCol).getName()).toString();
            fieldValue.gotValue(fvAsString);
        }
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, rowValues));
    }

    public int qualify(YRowObject rowObject) throws YException {
        assert (this.finalized);
        YRowValues rowValues = this.createRowValues();
        this.addRowValues(rowValues);
        int iRow = this.getRowCount() - 1;
        this.transferDetailValues(iRow, rowObject);
        if (this.rowObjectId > 0) {
            rowValues.getFieldValue(this.rowObjectFkDefinition).modifyValue(this.rowObjectId);
        }
        rowValues.getFieldValue(this.detailFkDefinition).gotValue(rowObject.getPkFieldValue().toString());
        return iRow;
    }

    public void requery(int iRow) throws YException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM " + this.detailName);
        sql.append(" WHERE " + this.rowPkDefinition.getName());
        sql.append("=");
        sql.append(this.getPkValue(iRow).toString());
        this.sqlQuery.execute(sql.toString());
        YRowValues rowValues = null;
        if (this.sqlQuery.next()) {
            rowValues = this.getRowValues(iRow);
            for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                YFieldValue fieldValue = rowValues.getFieldValue(i);
                YColumnDefinition columnDefinition = fieldValue.getColumnDefinition();
                if (!this.detailDefinitions.contains(columnDefinition)) continue;
                this.getQueryResult(fieldValue);
            }
        }
        if (rowValues != null) {
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, rowValues));
        }
    }

    public void revert() throws YException {
        int nRows = this.getAbsRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues rowValues = this.getAbsRowValues(iRow);
            if (rowValues.getFieldValue(this.rowObjectFkDefinition).wasNull()) {
                this.removeRowValues(iRow);
                --iRow;
                --nRows;
                continue;
            }
            rowValues.revert();
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            ((YSubRowListImplementation)this.subListImplementations.get(iSub)).revert();
        }
        this.fireChanged(new YDBOChangeEvent());
    }

    public void removeAll() throws YException {
        assert (this.onRemove == YDetailList.OnRemove.UNLINK);
        throw new YUnimplementedException(this);
    }
}

