/*
 * Decompiled with CFR 0.152.
 */
package projektY.database.jLibY;

import java.util.Vector;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.jLibY.YAsColumnDefinition;
import projektY.database.jLibY.YExtensionRowDefinition;
import projektY.database.jLibY.YPostableRowDefinition;

public class YStandardRowDefinition
extends YPostableRowDefinition {
    Vector<Extension> extensions = new Vector(10);

    YStandardRowDefinition(String tableName, YColumnDefinition pkDefinition) throws YProgramException {
        super(tableName, pkDefinition);
    }

    protected YStandardRowDefinition(String tableName, String pkName) throws YProgramException {
        super(tableName, pkName);
    }

    protected YStandardRowDefinition(String tableName, String pkName, String fkName) throws YProgramException {
        super(tableName, pkName, fkName);
    }

    protected YAsColumnDefinition createIsExtensionColumnDefinition(String extensionName, int fieldValueIndex) throws YProgramException {
        YAsColumnDefinition isExtensionColumnDefinition = new YAsColumnDefinition(fieldValueIndex, "is_" + extensionName, YColumnDefinition.FieldType.BOOLEAN);
        return isExtensionColumnDefinition;
    }

    protected Extension addExtension(Extension newExtension) throws YProgramException {
        int nExt = this.extensions.size();
        for (int iExt = 0; iExt < nExt; ++iExt) {
            Extension extension = this.extensions.get(iExt);
            if (!extension.isNamedAs(newExtension.name)) continue;
            throw new YProgramException(this, "Zwei Erweiterungen namens '" + extension.name + "' sind nicht erlaubt.");
        }
        this.extensions.add(newExtension);
        YAsColumnDefinition isExtensionColumnDefinition = this.createIsExtensionColumnDefinition(newExtension.name, this.getNColumns());
        if (isExtensionColumnDefinition != null) {
            newExtension.isExtensionColumnDefinition = isExtensionColumnDefinition;
            this.addColumnDefinition(isExtensionColumnDefinition);
        }
        return newExtension;
    }

    public Extension getExtension(String name) throws YProgramException {
        int nExt = this.extensions.size();
        for (int iExt = 0; iExt < nExt; ++iExt) {
            Extension extension = this.extensions.get(iExt);
            if (!extension.isNamedAs(name)) continue;
            return extension;
        }
        throw new YProgramException(this, "Die Zeile hat keine Erweiterung namens '" + name + "'");
    }

    protected int organizeAliasIds(int startWithAlias) throws YProgramException {
        int continueWithAlias = super.organizeAliasIds(startWithAlias);
        int nExt = this.extensions.size();
        for (int iExt = 0; iExt < nExt; ++iExt) {
            Extension extension = this.extensions.get(iExt);
            if (!extension.isUsed()) continue;
            YExtensionRowDefinition rowDefinition = extension.getRowDefinition();
            rowDefinition.aliasId = continueWithAlias++;
            System.out.print(rowDefinition.aliasId);
            System.out.print(" " + rowDefinition.getTableName() + " -> ");
            System.out.println(this.getTableName());
            continueWithAlias = rowDefinition.organizeAliasIds(continueWithAlias);
        }
        return continueWithAlias;
    }

    protected void appendAsColumns(StringBuffer sql) throws YProgramException {
        int nExt = this.extensions.size();
        for (int iExt = 0; iExt < nExt; ++iExt) {
            Extension extension = this.extensions.get(iExt);
            if (!extension.isUsed()) continue;
            YExtensionRowDefinition embeddedRowDefinition = extension.getRowDefinition();
            sql.append(", (t" + embeddedRowDefinition.aliasId + "." + embeddedRowDefinition.getIdColumnDefinition().getName() + " IS NOT NULL) AS " + extension.getIsExtensionColumnDefinition().getName());
        }
    }

    protected void appendJoins(StringBuffer sql) throws YProgramException {
        String rowAlias = this.aliasId == 0 ? "t" : "t" + this.aliasId;
        super.appendJoins(sql);
        int nExt = this.extensions.size();
        for (int iExt = 0; iExt < nExt; ++iExt) {
            Extension extension = this.extensions.get(iExt);
            if (!extension.isUsed()) continue;
            YExtensionRowDefinition embeddedRowDefinition = extension.getRowDefinition();
            String tableName = embeddedRowDefinition.getTableName();
            sql.append(" LEFT OUTER JOIN " + tableName + " t" + embeddedRowDefinition.aliasId + " ON (" + "t" + embeddedRowDefinition.aliasId + "." + embeddedRowDefinition.getIdColumnDefinition().getName() + "=" + rowAlias + "." + this.getIdColumnDefinition().getName() + ")");
            super.appendJoins(sql, embeddedRowDefinition);
        }
    }

    public boolean isExtension() {
        return false;
    }

    public abstract class Extension {
        private String name;
        private YExtensionRowDefinition rowDefinition;
        private YAsColumnDefinition isExtensionColumnDefinition;

        public Extension(String name) {
            this.name = name;
            this.rowDefinition = null;
            this.isExtensionColumnDefinition = null;
        }

        protected abstract YExtensionRowDefinition createRowDefinition() throws YProgramException;

        public String getName() {
            return this.name;
        }

        public YAsColumnDefinition getIsExtensionColumnDefinition() {
            return this.isExtensionColumnDefinition;
        }

        public YExtensionRowDefinition getRowDefinition() throws YProgramException {
            if (this.rowDefinition == null) {
                this.rowDefinition = this.createRowDefinition();
            }
            return this.rowDefinition;
        }

        boolean isUsed() {
            return this.rowDefinition != null;
        }

        boolean isNamedAs(String name) {
            return this.name.equals(name);
        }
    }
}

