/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.sqfit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQfitGraphicsUtils
extends SynthGraphicsUtils {
    private Map<?, ?> desktopHints;

    public static RenderingHints getRenderingHints(Graphics2D g2d, Map<?, ?> hintsToSave, RenderingHints savedHints) {
        if (savedHints == null) {
            savedHints = new RenderingHints(null);
        } else {
            savedHints.clear();
        }
        if (hintsToSave.size() == 0) {
            return savedHints;
        }
        for (Object o : hintsToSave.keySet()) {
            RenderingHints.Key key = (RenderingHints.Key)o;
            Object value = g2d.getRenderingHint(key);
            savedHints.put(key, value);
        }
        return savedHints;
    }

    @Override
    public void paintText(SynthContext ss, Graphics g, String text, int x, int y, int mnemonicIndex) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.desktopHints == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        }
        Object oldAA = null;
        RenderingHints oldHints = null;
        if (this.desktopHints != null) {
            oldHints = SQfitGraphicsUtils.getRenderingHints(g2, this.desktopHints, null);
            g2.addRenderingHints(this.desktopHints);
        } else {
            oldAA = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintText(ss, g, text, x, y, mnemonicIndex);
        if (oldHints != null) {
            g2.addRenderingHints(oldHints);
        } else if (oldAA != null) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAA);
        }
    }

    public static BufferedImage loadImage(String imgName) {
        try {
            return ImageIO.read(SQfitGraphicsUtils.class.getClassLoader().getResource("com/sun/java/swing/plaf/sqfit/images/" + imgName));
        }
        catch (Exception e) {
            System.err.println("Error loading image \"com/sun/java/swing/plaf/sqfit/images/" + imgName + "\"");
            e.printStackTrace();
            return null;
        }
    }

    public static Color getWebColor(String c) {
        if (c.startsWith("#")) {
            c = c.substring(1);
        }
        return new Color(Integer.parseInt(c.substring(0, 2), 16), Integer.parseInt(c.substring(2, 4), 16), Integer.parseInt(c.substring(4, 6), 16));
    }

    public static Color getMidWebColor(String c1, String c2) {
        if (c1.startsWith("#")) {
            c1 = c1.substring(1);
        }
        if (c2.startsWith("#")) {
            c2 = c2.substring(1);
        }
        int rTop = Integer.parseInt(c1.substring(0, 2), 16);
        int gTop = Integer.parseInt(c1.substring(2, 4), 16);
        int bTop = Integer.parseInt(c1.substring(4, 6), 16);
        int rBot = Integer.parseInt(c2.substring(0, 2), 16);
        int gBot = Integer.parseInt(c2.substring(2, 4), 16);
        int bBot = Integer.parseInt(c2.substring(4, 6), 16);
        int rMid = rTop + (rBot - rTop) / 2;
        int gMid = gTop + (gBot - gTop) / 2;
        int bMid = bTop + (bBot - bTop) / 2;
        return new Color(rMid, gMid, bMid);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height, 3);
    }

    public static BufferedImage getAlphaMask(BufferedImage srcImg, int dstWidth, int dstHeight) {
        int offsetX = (dstWidth - srcImg.getWidth()) / 2;
        int offsetY = (dstHeight - srcImg.getHeight()) / 2;
        BufferedImage greyImg = new BufferedImage(dstWidth, dstHeight, 10);
        int[] buffer = new int[srcImg.getWidth() * srcImg.getHeight()];
        WritableRaster a = srcImg.getAlphaRaster();
        a.getPixels(0, 0, srcImg.getWidth(), srcImg.getHeight(), buffer);
        greyImg.getRaster().setPixels(offsetX, offsetY, srcImg.getWidth(), srcImg.getHeight(), buffer);
        return greyImg;
    }

    public static BufferedImage createColorMaskImage(BufferedImage alpha, Color c) {
        int pixel = c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
        int w = alpha.getWidth();
        int h = alpha.getHeight();
        BufferedImage dstImg = SQfitGraphicsUtils.createCompatibleTranslucentImage(w, h);
        byte[] alphaData = ((DataBufferByte)alpha.getRaster().getDataBuffer()).getData();
        int[] dstData = ((DataBufferInt)dstImg.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < dstData.length; ++i) {
            dstData[i] = alphaData[i] << 24 | pixel;
        }
        return dstImg;
    }

    public static Kernel[] getSeparateGaussianKernel(int radius) {
        int i;
        float[] kernel = new float[radius * 2 + 1];
        double sum = 0.0;
        int w = 2 * radius + 1;
        double deviation = (double)radius / 3.0;
        double devSqr2 = 2.0 * Math.pow(deviation, 2.0);
        double piDevSqr2 = Math.PI * devSqr2;
        double piDevSqrt = Math.sqrt(piDevSqr2);
        for (i = 0; i < w; ++i) {
            kernel[i] = (float)(Math.pow(Math.E, (double)(-((i - radius) * (i - radius))) / devSqr2) / piDevSqrt);
            sum += (double)kernel[i];
        }
        i = 0;
        while (i < w) {
            int n = i++;
            kernel[n] = (float)((double)kernel[n] / sum);
        }
        Kernel hk = new Kernel(w, 1, kernel);
        Kernel vk = new Kernel(1, w, kernel);
        return new Kernel[]{hk, vk};
    }
}

