/*
 * Decompiled with CFR 0.152.
 */
package popometer.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.regex.Pattern;
import popometer.graphics.GraphObject;
import popometer.graphics.PositionMarker;
import popometer.graphics.SimpleMarker;
import projektY.base.YException;

public class Messpunkt
extends GraphObject {
    private PositionMarker marker;

    public Messpunkt(PositionMarker marker) {
        this.marker = marker;
    }

    public Messpunkt() {
        this.marker = new SimpleMarker(12);
    }

    public String toString() {
        return "(" + this.getX() + "," + this.getY() + ")";
    }

    public void set(int x, int y) {
        this.moveTo(x, y);
    }

    @Override
    public void moveTo(int x, int y) {
        super.moveTo(x, y);
        this.marker.moveTo(x, y);
    }

    public void set(String punkt) throws YException {
        String[] wertepaar;
        if (punkt.startsWith("(") && punkt.endsWith(")") && (wertepaar = punkt.substring(1, punkt.length() - 1).split(",")).length == 2 && Pattern.matches("[0-9]+", wertepaar[0]) && Pattern.matches("[0-9]+", wertepaar[1])) {
            int x = Integer.parseInt(wertepaar[0]);
            int y = Integer.parseInt(wertepaar[1]);
            this.set(x, y);
            return;
        }
        throw new YException("Ung\u00fcltige Koordinaten: " + punkt);
    }

    @Override
    public void draw(Graphics2D g2d) {
        Color color0 = g2d.getColor();
        Stroke stroke0 = g2d.getStroke();
        float[] dash = new float[]{1.0f, 1.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
        g2d.setStroke(stroke);
        g2d.setColor(Color.WHITE);
        g2d.setColor(color0);
        g2d.setStroke(stroke0);
        if (this.getX() > 0 && this.getY() > 0) {
            this.marker.draw(g2d);
        }
    }

    public float distanceTo(Messpunkt messpunkt2) {
        if (this.getX() == 0 || this.getY() == 0) {
            return 0.0f;
        }
        if (messpunkt2.getX() == 0 || messpunkt2.getY() == 0) {
            return 0.0f;
        }
        int a = Math.abs(this.getX() - messpunkt2.getX());
        int b = Math.abs(this.getY() - messpunkt2.getY());
        return (float)Math.sqrt(a * a + b * b);
    }

    public boolean isNull() {
        return this.getX() == 0 && this.getY() == 0;
    }

    public boolean euqals(Messpunkt messpunkt2) {
        return this.getX() == messpunkt2.getX() && this.getY() == messpunkt2.getY();
    }
}

