/*
 * Decompiled with CFR 0.152.
 */
package popometer.math;

import popometer.graphics.Messpunkt;
import popometer.graphics.SimpleMarker;

public class Koerperberechnung {
    private float lCalib;
    private float mtopxRatio;
    private float hueftePlusX;
    private float hueftePlusY;
    private Koerpermasse koerpermasse;

    public Koerperberechnung(float lCalib, float hueftePlusX, float hueftePlusY) {
        this.lCalib = lCalib;
        this.hueftePlusX = hueftePlusX;
        this.hueftePlusY = hueftePlusY;
        this.koerpermasse = new Koerpermasse();
        this.mtopxRatio = -1.0f;
    }

    public boolean calibrieren(Messpunkte messpunkte) {
        Messpunkt calibStart = messpunkte.calibStart;
        Messpunkt calibEnd = messpunkte.calibEnd;
        if (calibStart.isNull() || calibEnd.isNull() || calibStart.euqals(calibEnd)) {
            calibStart.set(0, 0);
            calibEnd.set(0, 0);
            this.mtopxRatio = -1.0f;
            return false;
        }
        float dist = calibStart.distanceTo(calibEnd);
        this.mtopxRatio = dist * 100.0f / this.lCalib;
        return true;
    }

    public Koerpermasse berechneKoerpermasse(Messpunkte messpunkte) {
        if (this.mtopxRatio < 0.0f) {
            this.koerpermasse.ua = 0.0f;
            this.koerpermasse.oa = 0.0f;
            this.koerpermasse.ok = 0.0f;
            this.koerpermasse.os = 0.0f;
            this.koerpermasse.usf = 0.0f;
        } else {
            float k = 100.0f / this.mtopxRatio;
            int hX = (int)(this.hueftePlusX / k);
            int hY = (int)(this.hueftePlusY / k);
            messpunkte.huefte.moveTo(messpunkte.sitz.getX() + hX, messpunkte.sitz.getY() - hY);
            this.koerpermasse.ua = messpunkte.griff.distanceTo(messpunkte.arm) * k;
            this.koerpermasse.oa = messpunkte.arm.distanceTo(messpunkte.schulter) * k;
            this.koerpermasse.ok = messpunkte.schulter.distanceTo(messpunkte.huefte) * k;
            this.koerpermasse.os = messpunkte.huefte.distanceTo(messpunkte.knie) * k;
            this.koerpermasse.usf = messpunkte.knie.distanceTo(messpunkte.pedal) * k;
        }
        return this.koerpermasse;
    }

    public static class Koerpermasse {
        public float ok;
        public float oa;
        public float ua;
        public float os;
        public float usf;

        public void clear() {
            this.ok = 0.0f;
            this.oa = 0.0f;
            this.ua = 0.0f;
            this.os = 0.0f;
            this.usf = 0.0f;
        }

        public boolean vollstaendig() {
            if (this.ok == 0.0f) {
                return false;
            }
            if (this.oa == 0.0f) {
                return false;
            }
            if (this.ua == 0.0f) {
                return false;
            }
            if (this.os == 0.0f) {
                return false;
            }
            return this.usf != 0.0f;
        }
    }

    public static class Messpunkte {
        public Messpunkt pedal = new Messpunkt();
        public Messpunkt knie = new Messpunkt();
        public Messpunkt sitz = new Messpunkt();
        public Messpunkt huefte = new Messpunkt();
        public Messpunkt schulter = new Messpunkt();
        public Messpunkt arm = new Messpunkt();
        public Messpunkt griff = new Messpunkt();
        public Messpunkt[] koerperMesspunkte = new Messpunkt[]{this.pedal, this.knie, this.huefte, this.schulter, this.arm, this.griff};
        public Messpunkt calibStart = new Messpunkt(new SimpleMarker(12, SimpleMarker.Shape.PLUS));
        public Messpunkt calibEnd = new Messpunkt(new SimpleMarker(12, SimpleMarker.Shape.PLUS));

        public void clear() {
            this.schulter.set(0, 0);
            this.pedal.set(0, 0);
            this.sitz.set(0, 0);
            this.griff.set(0, 0);
            this.knie.set(0, 0);
            this.arm.set(0, 0);
        }
    }
}

