/*
 * Decompiled with CFR 0.152.
 */
package popometer.math;

import popometer.math.Koerperberechnung;
import popometer.math.Polygonzug;
import projektY.base.YException;

public class MagischesDreieck {
    final float hueftabstand;
    final float pedallaenge;
    private float oben;
    private float hinten;
    private float vorn;
    private float neigungswinkel;
    private Winkelsatz[] winkelsaetze;
    private Polygonzug.Punkt A;
    private Polygonzug.Punkt B;
    private Polygonzug.Punkt C;

    public MagischesDreieck(float hueftabstand, float pedallaenge) {
        this.hueftabstand = hueftabstand;
        this.pedallaenge = pedallaenge;
        this.winkelsaetze = new Winkelsatz[]{new Winkelsatz(1, "aufrecht", 85.0f, 45.0f, 180.0f, 125.0f, 135.0f), new Winkelsatz(2, "leicht gebeugt", 100.0f, 49.0f, 180.0f, 125.0f, 135.0f), new Winkelsatz(3, "moderat", 120.0f, 65.0f, 180.0f, 120.0f, 138.0f), new Winkelsatz(4, "gestreckt", 130.0f, 70.0f, 180.0f, 120.0f, 142.0f), new Winkelsatz(5, "Triathlon", 155.0f, 68.0f, 100.0f, 110.0f, 142.0f)};
        this.A = new Polygonzug.Punkt();
        this.B = new Polygonzug.Punkt();
        this.C = new Polygonzug.Punkt();
        this.oben = 0.0f;
        this.hinten = 0.0f;
        this.vorn = 0.0f;
        this.neigungswinkel = 0.0f;
    }

    public void berechnen(int winkelsatzId, Koerperberechnung.Koerpermasse koerpermasse) throws YException {
        Winkelsatz winkelsatz = null;
        for (Winkelsatz ws : this.winkelsaetze) {
            if (ws.id != winkelsatzId) continue;
            winkelsatz = ws;
            break;
        }
        if (winkelsatz == null) {
            throw new YException("Ung\u00fcltige winkelsatzId: " + winkelsatzId);
        }
        Polygonzug pzOK = new Polygonzug();
        Polygonzug pzBein = new Polygonzug();
        pzOK.append(winkelsatz.rw, false, koerpermasse.ok);
        pzOK.append(winkelsatz.sw, true, koerpermasse.oa);
        pzOK.append(winkelsatz.ew, false, koerpermasse.ua);
        pzBein.append(winkelsatz.bw, true, koerpermasse.os);
        pzBein.append(winkelsatz.kw, true, koerpermasse.usf);
        pzBein.endPunkt(this.A);
        pzOK.endPunkt(this.B);
        this.C.x = 0.0f;
        this.C.y = -this.hueftabstand;
        float f = (this.A.a - this.pedallaenge) / this.A.a;
        this.A.x *= f;
        this.A.y *= f;
        this.A.a -= this.pedallaenge;
        this.oben = this.B.a;
        this.hinten = this.C.abstand(this.A);
        this.vorn = this.A.abstand(this.B);
        this.neigungswinkel = Polygonzug.VektorSumme.radToDeg((float)Math.asin((this.B.y - this.C.y) / this.B.abstand(this.C)));
    }

    public float getOben() {
        return this.oben;
    }

    public float getHinten() {
        return this.hinten;
    }

    public float getVorn() {
        return this.vorn;
    }

    public float getNeigungswinkel() {
        return this.neigungswinkel;
    }

    public String toString() {
        return String.format("A%s B%s C%s: oben=%2.1f hinten=%2.1f vorn=%2.1f neigungswinkel=%2.1f", this.A.toString(), this.B.toString(), this.C.toString(), Float.valueOf(this.oben), Float.valueOf(this.hinten), Float.valueOf(this.vorn), Float.valueOf(this.neigungswinkel));
    }

    public static class Koerpermasse {
        public float ok;
        public float oa;
        public float ua;
        public float os;
        public float usf;

        public void clear() {
            this.ok = 0.0f;
            this.oa = 0.0f;
            this.ua = 0.0f;
            this.os = 0.0f;
            this.usf = 0.0f;
        }

        public boolean vollstaendig() {
            if (this.ok == 0.0f) {
                return false;
            }
            if (this.oa == 0.0f) {
                return false;
            }
            if (this.ua == 0.0f) {
                return false;
            }
            if (this.os == 0.0f) {
                return false;
            }
            return this.usf != 0.0f;
        }
    }

    public static class Winkelsatz {
        private int id;
        private String name;
        private float rw;
        private float sw;
        private float ew;
        private float bw;
        private float kw;

        public Winkelsatz(int id, String name, float rw, float sw, float ew, float bw, float kw) {
            this.id = id;
            this.name = name;
            this.rw = rw;
            this.sw = sw;
            this.ew = ew;
            this.bw = bw;
            this.kw = kw;
        }
    }
}

