/*
 * Decompiled with CFR 0.152.
 */
package popometer.print;

import java.io.File;
import java.io.OutputStream;
import javax.swing.JTabbedPane;
import popometer.dbobjects.YROAusfuehrung;
import popometer.panels.PanErgebnis;
import popometer.panels.PanKoerper;
import popometer.panels.PanKundendaten;
import projektY.base.YException;
import projektY.database.YDatabaseList;
import projektY.latex.YLaTeXGenerator;
import projektY.latex.YLaTeXParser;
import projektY.utils.YConfigFile;

public class YBikeAndFitReport
extends YLaTeXGenerator {
    private PanKundendaten panKundendaten;
    private PanKoerper panKoerper;
    private JTabbedPane panProdukte;
    private String imageCacheDir;
    PanErgebnis panErgebnis;
    int idxProduktart;
    YDatabaseList databaseList;
    int nextIdxRow;
    YROAusfuehrung roTopProdukt;

    public YBikeAndFitReport(OutputStream output, PanKundendaten panKundendaten, PanKoerper panKoerper, JTabbedPane panProdukte, YConfigFile configFile) {
        super(output);
        this.panKundendaten = panKundendaten;
        this.panKoerper = panKoerper;
        this.panProdukte = panProdukte;
        this.imageCacheDir = configFile.findValue("CACHEDIR");
        this.imageCacheDir = this.imageCacheDir.endsWith("/") ? this.imageCacheDir + "images/" : this.imageCacheDir + "/images/";
        this.panErgebnis = null;
        this.idxProduktart = -1;
        this.roTopProdukt = null;
    }

    protected void insertText(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        String name = attributes.getAttributeValue("name");
        if (this.idxProduktart >= 0) {
            if (name.equals("Produktart")) {
                this.writeAsLaTeX(this.panProdukte.getTitleAt(this.idxProduktart));
            } else if (name.equals("Bildname")) {
                if (this.roTopProdukt != null) {
                    this.writeAsLaTeX(this.roTopProdukt.getAsString("bildname"));
                }
            } else if (name.equals("Bild")) {
                String bildname = this.roTopProdukt.getAsString("bildname");
                if (bildname.length() > 0) {
                    File imageFile = new File(this.imageCacheDir + bildname + ".jpg");
                    if (imageFile.exists()) {
                        this.writePlain("\\includegraphics[natwidth=39.4mm,natheight=19.4mm,width=4cm]{" + this.imageCacheDir + bildname + ".jpg" + "}");
                    }
                    return;
                }
                this.writeAsLaTeX("Leider kein Bild.");
            }
            return;
        }
        if (!(name.equals("") || name.equals("") || name.equals("") || name.equals("") || name.equals("") || name.equals("") || name.equals(""))) {
            if (name.equals("lUA")) {
                this.writeAsLaTeX(this.panKoerper.fldLUnterarm.getText());
            } else if (name.equals("lOA")) {
                this.writeAsLaTeX(this.panKoerper.fldLOberarm.getText());
            } else if (name.equals("lOK")) {
                this.writeAsLaTeX(this.panKoerper.fldLOberkoerper.getText());
            } else if (name.equals("lOS")) {
                this.writeAsLaTeX(this.panKoerper.fldLOberschenkel.getText());
            } else if (name.equals("lUSF")) {
                this.writeAsLaTeX(this.panKoerper.fldLUnterschenkel.getText());
            } else if (name.equals("Sitzposition")) {
                this.writeAsLaTeX("(Sitzposition)");
            } else if (name.equals("mdOben")) {
                this.writeAsLaTeX(this.panKoerper.lblDreieckOben.getText());
            } else if (name.equals("mdVorn")) {
                this.writeAsLaTeX(this.panKoerper.lblDreieckRechts.getText());
            } else if (name.equals("mdHinten")) {
                this.writeAsLaTeX(this.panKoerper.lblDreieckLinks.getText());
            } else if (name.equals("mdWinkel")) {
                String winkel = this.panKoerper.lblWinkel.getText();
                this.writeAsLaTeX(winkel.substring(0, winkel.length() - 1));
            }
        }
    }

    protected boolean nextLoop(YLaTeXParser.YLaTeXTagAttributes attributes) {
        String name = attributes.getAttributeValue("name");
        if (name.equals("Produktarten")) {
            ++this.idxProduktart;
            while (this.idxProduktart < this.panProdukte.getComponentCount()) {
                if (this.panProdukte.getComponentAt(this.idxProduktart) instanceof PanErgebnis && this.panProdukte.isEnabledAt(this.idxProduktart)) {
                    this.panErgebnis = (PanErgebnis)this.panProdukte.getComponentAt(this.idxProduktart);
                    this.roTopProdukt = this.panErgebnis.roTopProdukte[0];
                    return true;
                }
                ++this.idxProduktart;
            }
            this.idxProduktart = -1;
            this.panErgebnis = null;
            this.roTopProdukt = null;
        }
        return false;
    }

    protected boolean startTable(YLaTeXParser.YLaTeXTagAttributes attributes) {
        String name = attributes.getAttributeValue("name");
        if (this.panErgebnis == null) {
            return false;
        }
        if (name.equals("produkte")) {
            this.databaseList = this.panErgebnis.evAusfuehrungen;
            this.nextIdxRow = -1;
            return true;
        }
        if (name.equals("eignung")) {
            this.databaseList = this.panErgebnis.evProduktBewertungen[0];
            this.nextIdxRow = -1;
            return true;
        }
        return false;
    }

    protected void endTable() {
        this.databaseList = null;
    }

    protected boolean nextRow(YLaTeXParser.YLaTeXTagAttributes attributes) {
        try {
            return ++this.nextIdxRow < this.databaseList.getRowCount();
        }
        catch (YException e) {
            return false;
        }
    }

    protected void insertTD(YLaTeXParser.YLaTeXTagAttributes attributes) {
        String name = attributes.getAttributeValue("name");
        try {
            this.writeAsLaTeX(this.databaseList.getAsString(this.nextIdxRow, name));
        }
        catch (YException e) {
            try {
                this.writeAsLaTeX("ERR");
            }
            catch (YException e2) {
                // empty catch block
            }
        }
    }
}

