/*
 * Decompiled with CFR 0.152.
 */
package popometer.math;

import java.util.Vector;

public class Polygonzug {
    private Vector<Vektor> vektoren = new Vector(20, 5);
    private Vector<VektorSumme> vektorsummen = new Vector(20, 5);

    public Polygonzug() {
        this.vektoren.add(new Vektor());
        this.vektorsummen.add(new VektorSumme());
    }

    public void print() {
        for (VektorSumme summe : this.vektorsummen) {
            System.out.println(summe.toString());
        }
    }

    public void append(float winkel, boolean seiteRechts, float laenge) {
        Vektor neuerVektor = new Vektor(winkel, seiteRechts, laenge);
        int iV = this.vektoren.size() - 1;
        this.vektoren.add(neuerVektor);
        this.vektorsummen.add(this.vektorsummen.get(iV).add(neuerVektor));
    }

    public void endPunkt(Punkt p) {
        int i = this.vektorsummen.size() - 1;
        p.x = this.vektorsummen.get(i).x;
        p.y = this.vektorsummen.get(i).y;
        p.a = this.vektorsummen.get(i).laenge;
    }

    public static class VektorSumme {
        private float winkel = 0.0f;
        private float laenge = 0.0f;
        private float x = 0.0f;
        private float y = 0.0f;

        public String toString() {
            return String.format("w=%2.1f l=%3.1f x=%3.1f y=%3.1f", Float.valueOf(this.winkel), Float.valueOf(this.laenge), Float.valueOf(this.x), Float.valueOf(this.y));
        }

        public static float degToRad(float deg) {
            return (float)((double)deg * Math.PI) / 180.0f;
        }

        public static float radToDeg(float rad) {
            return rad * 180.0f / (float)Math.PI;
        }

        public VektorSumme clone() {
            VektorSumme neueSumme = new VektorSumme();
            neueSumme.winkel = this.winkel;
            neueSumme.laenge = this.laenge;
            neueSumme.x = this.x;
            neueSumme.y = this.y;
            return neueSumme;
        }

        public VektorSumme add(Vektor summand) {
            VektorSumme summe = this.clone();
            summe.winkel = summand.winkelRechts ? (summe.winkel += 180.0f + summand.winkel) : (summe.winkel += 180.0f - summand.winkel);
            if (summe.winkel > 360.0f) {
                summe.winkel -= 360.0f;
            }
            float radW = VektorSumme.degToRad(summe.winkel);
            summe.x += summand.laenge * (float)Math.cos(radW);
            summe.y += summand.laenge * (float)Math.sin(radW);
            summe.laenge = (float)Math.sqrt(summe.x * summe.x + summe.y * summe.y);
            return summe;
        }
    }

    public static class Vektor {
        private float winkel;
        private boolean winkelRechts;
        private float laenge;

        public Vektor(float winkel, boolean seiteRechts, float laenge) {
            this.winkel = winkel;
            this.winkelRechts = seiteRechts;
            this.laenge = laenge;
        }

        public Vektor() {
            this.winkel = 0.0f;
            this.winkelRechts = false;
            this.laenge = 0.0f;
        }
    }

    public static class Punkt {
        public float x = 0.0f;
        public float y = 0.0f;
        public float a = 0.0f;

        public float abstand(Punkt p) {
            float dx = this.x - p.x;
            float dy = this.y - p.y;
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        public String toString() {
            return String.format("(%2.1f;%2.1f/%2.1f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.a));
        }
    }
}

