/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import popometer.graphics.ImageContainer;
import popometer.graphics.RectScaler;

public class PanFotoImage
extends JPanel
implements ImageContainer {
    private Image image;
    protected BufferedImage bufferedImage;
    private RectScaler rectScaler;
    private boolean selected;

    PanFotoImage(RectScaler rectScaler) {
        super(null);
        this.rectScaler = rectScaler;
        this.selected = false;
    }

    public PanFotoImage() {
        this(new RectScaler());
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Image getImage() {
        return this.bufferedImage;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public BufferedImage setImage(Image image) {
        this.image = image;
        if (image instanceof BufferedImage) {
            this.bufferedImage = (BufferedImage)image;
        } else {
            image = new ImageIcon(image).getImage();
            this.bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D gfx = this.bufferedImage.createGraphics();
            gfx.drawImage(image, 0, 0, null);
            gfx.dispose();
        }
        this.repaint();
        return this.bufferedImage;
    }

    public synchronized void paint(Graphics2D g2d, int scaleWidth, int scaleHeight) {
        if (this.bufferedImage == null) {
            return;
        }
        this.rectScaler.scale(scaleWidth, scaleHeight, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        g2d.drawImage(this.bufferedImage, this.rectScaler.getX(), this.rectScaler.getY(), this.rectScaler.getWidth(), this.rectScaler.getHeight(), this);
        if (this.selected) {
            Stroke stroke = g2d.getStroke();
            Color color = g2d.getColor();
            g2d.setColor(new Color(255, 255, 255));
            g2d.setStroke(new BasicStroke(4.0f));
            g2d.drawRect(this.rectScaler.getX(), this.rectScaler.getY(), this.rectScaler.getWidth(), this.rectScaler.getHeight());
            g2d.setColor(color);
            g2d.setStroke(stroke);
        }
    }

    public synchronized void paint(Graphics g) {
        this.paint((Graphics2D)g, this.getWidth(), this.getHeight());
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }
}

