/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YROKunde;
import popometer.panels.PanMessung;
import projektY.base.YException;
import projektY.database.YDatabaseData;
import projektY.swing.YJPanelManager;

public class PanVorschau
extends PanMessung {
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel panKoerperMasse;
    private JSlider sliBW;
    private JSlider sliEW;
    private JSlider sliKW;
    private JSlider sliRW;
    private JSlider sliSW;

    public PanVorschau(YPopometerSession session, YROKunde kunde, FrmNavigator frmNavigator) throws YException {
        super(session, kunde, frmNavigator);
        this.initComponents();
        this.DrawBody();
        YJPanelManager.createPanelManager((JComponent)this.panKoerperMasse, (YDatabaseData)kunde);
    }

    private void DrawBody() throws YException {
        this.jScrollPane1.removeAll();
        Graphics g = this.jScrollPane1.getGraphics();
        if (g == null) {
            return;
        }
        int lOK = 68;
        int lOA = 37;
        int lUA = 39;
        int lOS = 54;
        int lUS = 59;
        int lFL = 15;
        int RW = this.sliRW.getValue();
        int SW = this.sliSW.getValue();
        int EW = this.sliEW.getValue();
        int BW = this.sliBW.getValue();
        int KW = this.sliKW.getValue();
        StrampelVektor[] lowerbody = new StrampelVektor[]{new StrampelVektor(lOS, BW - RW, "OS"), new StrampelVektor(lUS, 180 - KW, "US"), new StrampelVektor(lFL, 270, "FS")};
        StrampelVektor[] upperbody = new StrampelVektor[]{new StrampelVektor(lOK, 180 + RW, "OK"), new StrampelVektor(lOA, 180 - SW, "OA"), new StrampelVektor(lUA, 180 + EW, "UA")};
        Dimension size = this.getSize();
        g.clearRect(0, 0, size.height, size.width);
        g.setColor(Color.black);
        int x = size.width / 4;
        int y = size.height / 2;
        this.DrawVektorZug(upperbody, x, y, g);
        this.DrawVektorZug(lowerbody, x, y, g);
    }

    private void DrawVektorZug(StrampelVektor[] vektorzug, int startx, int starty, Graphics g) {
        BufferedImage img = null;
        int angelfromdefault = 0;
        Point lastjoint = new Point(startx, starty);
        for (StrampelVektor strampelVektor : vektorzug) {
            try {
                URL imageUrl = this.getClass().getResource("/popometer/pictures/sitzvorschau/muscles/" + strampelVektor.Image + ".png");
                img = ImageIO.read(imageUrl);
            }
            catch (IOException e) {
                g.drawString(e.getMessage(), startx, starty);
            }
            angelfromdefault += strampelVektor.Angel;
            img = this.scaleAndRotateImg(img, strampelVektor.Length, angelfromdefault %= 360);
            Point joint = this.findJoint(img, 0, 255, 0);
            g.drawImage(img, lastjoint.x - joint.x, lastjoint.y - joint.y, this);
            Point nextjoint = this.findJoint(img, 255, 255, 0);
            lastjoint = new Point(lastjoint.x + (nextjoint.x - joint.x), lastjoint.y - (joint.y - nextjoint.y));
        }
    }

    private BufferedImage scaleAndRotateImg(BufferedImage img, int scalex, int radrotation) {
        AffineTransform at = new AffineTransform();
        at = new AffineTransform();
        at.rotate(Math.toRadians(radrotation), img.getHeight() / 2, img.getWidth() / 2);
        AffineTransformOp bio = new AffineTransformOp(at, 2);
        img = bio.filter(img, null);
        return img;
    }

    private Point findJoint(BufferedImage img, int r, int g, int b) {
        int h = img.getHeight(this);
        int w = img.getWidth(this);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int c = img.getRGB(x, y);
                int red = c >> 16 & 0xFF;
                int green = c >> 8 & 0xFF;
                int blue = c & 0xFF;
                if (green != g || red != r || blue != b) continue;
                return new Point(x, y);
            }
        }
        return new Point(0, 0);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panKoerperMasse = new JPanel();
        this.sliEW = new JSlider();
        this.sliRW = new JSlider();
        this.sliSW = new JSlider();
        this.sliBW = new JSlider();
        this.sliKW = new JSlider();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Vorschau"));
        this.jPanel1.setLayout(new GridLayout());
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jPanel1.add(this.jScrollPane1);
        this.panKoerperMasse.setBackground(new Color(255, 255, 255));
        this.panKoerperMasse.setBorder(BorderFactory.createTitledBorder("L\u00e4ngen (cm):"));
        this.panKoerperMasse.setToolTipText("");
        this.panKoerperMasse.setLayout(new GridBagLayout());
        this.sliEW.setMaximum(150);
        this.sliEW.setMinorTickSpacing(1);
        this.sliEW.setPaintLabels(true);
        this.sliEW.setToolTipText("Ellenbogen");
        this.sliEW.setValue(120);
        this.sliEW.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanVorschau.this.sliEWStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 194;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.panKoerperMasse.add((Component)this.sliEW, gridBagConstraints);
        this.sliRW.setMaximum(150);
        this.sliRW.setMinorTickSpacing(1);
        this.sliRW.setPaintLabels(true);
        this.sliRW.setToolTipText("Oberk\u00f6rper");
        this.sliRW.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanVorschau.this.sliRWStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 194;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.panKoerperMasse.add((Component)this.sliRW, gridBagConstraints);
        this.sliSW.setMinorTickSpacing(1);
        this.sliSW.setPaintLabels(true);
        this.sliSW.setToolTipText("Schulter");
        this.sliSW.setValue(45);
        this.sliSW.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanVorschau.this.sliSWStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 194;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.panKoerperMasse.add((Component)this.sliSW, gridBagConstraints);
        this.sliBW.setMaximum(150);
        this.sliBW.setMinorTickSpacing(1);
        this.sliBW.setPaintLabels(true);
        this.sliBW.setToolTipText("Bein");
        this.sliBW.setValue(140);
        this.sliBW.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanVorschau.this.sliBWStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 194;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.panKoerperMasse.add((Component)this.sliBW, gridBagConstraints);
        this.sliKW.setMaximum(150);
        this.sliKW.setMinorTickSpacing(1);
        this.sliKW.setPaintLabels(true);
        this.sliKW.setToolTipText("Knie");
        this.sliKW.setValue(90);
        this.sliKW.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanVorschau.this.sliKWStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 194;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.panKoerperMasse.add((Component)this.sliKW, gridBagConstraints);
        this.jPanel1.add(this.panKoerperMasse);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void sliRWStateChanged(ChangeEvent evt) {
        try {
            this.DrawBody();
        }
        catch (YException ex) {
            Logger.getLogger(PanVorschau.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void sliSWStateChanged(ChangeEvent evt) {
        try {
            this.DrawBody();
        }
        catch (YException ex) {
            Logger.getLogger(PanVorschau.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void sliEWStateChanged(ChangeEvent evt) {
        try {
            this.DrawBody();
        }
        catch (YException ex) {
            Logger.getLogger(PanVorschau.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void sliBWStateChanged(ChangeEvent evt) {
        try {
            this.DrawBody();
        }
        catch (YException ex) {
            Logger.getLogger(PanVorschau.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void sliKWStateChanged(ChangeEvent evt) {
        try {
            this.DrawBody();
        }
        catch (YException ex) {
            Logger.getLogger(PanVorschau.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    class StrampelVektor {
        protected String Image;
        protected int Length;
        protected int Angel;

        public StrampelVektor(int Length, int Angel, String Image2) {
            this.Length = Length;
            this.Angel = Angel;
            this.Image = Image2;
        }

        public String getImage() {
            return this.Image;
        }

        public void setImage(String Image2) {
            this.Image = Image2;
        }

        public int getAngel() {
            return this.Angel;
        }

        public void setAngel(int Angel) {
            this.Angel = Angel;
        }

        public int getLength() {
            return this.Length;
        }

        public void setLength(int Length) {
            this.Length = Length;
        }
    }
}

