/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.sqfit.painters;

import com.sun.java.swing.plaf.sqfit.SQfitGraphicsUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class InternalFramePainter
extends SynthPainter {
    private static final BufferedImage FRAME_IMG = SQfitGraphicsUtils.loadImage("inner_frame.png");
    private static final BufferedImage FRAME_IMG_NONFOCUSED = SQfitGraphicsUtils.loadImage("inner_frame_defocused.png");
    private static final BufferedImage FRAME_CLOSE_DULL = SQfitGraphicsUtils.loadImage("frame_close_dull.png");
    private static final BufferedImage FRAME_CLOSE = SQfitGraphicsUtils.loadImage("frame_close.png");
    private static final BufferedImage FRAME_CLOSE_OVER = SQfitGraphicsUtils.loadImage("frame_close_over.png");
    private static final BufferedImage FRAME_CLOSE_PRESSED = SQfitGraphicsUtils.loadImage("frame_close_pressed.png");
    private static final BufferedImage FRAME_MAXIMIZE_DULL = SQfitGraphicsUtils.loadImage("frame_maximize_dull.png");
    private static final BufferedImage FRAME_MAXIMIZE = SQfitGraphicsUtils.loadImage("frame_maximize.png");
    private static final BufferedImage FRAME_MAXIMIZE_OVER = SQfitGraphicsUtils.loadImage("frame_maximize_over.png");
    private static final BufferedImage FRAME_MAXIMIZE_PRESSED = SQfitGraphicsUtils.loadImage("frame_maximize_pressed.png");
    private static final BufferedImage FRAME_MENU_BTN_DULL = SQfitGraphicsUtils.loadImage("frame_menu_btn_dull.png");
    private static final BufferedImage FRAME_MENU_BTN = SQfitGraphicsUtils.loadImage("frame_menu_btn.png");
    private static final BufferedImage FRAME_MENU_BTN_OVER = SQfitGraphicsUtils.loadImage("frame_menu_btn_over.png");
    private static final BufferedImage FRAME_MENU_BTN_PRESSED = SQfitGraphicsUtils.loadImage("frame_menu_btn_pressed.png");
    private static final BufferedImage FRAME_MINIMIZE_DULL = SQfitGraphicsUtils.loadImage("frame_minimize_dull.png");
    private static final BufferedImage FRAME_MINIMIZE = SQfitGraphicsUtils.loadImage("frame_minimize.png");
    private static final BufferedImage FRAME_MINIMIZE_OVER = SQfitGraphicsUtils.loadImage("frame_minimize_over.png");
    private static final BufferedImage FRAME_MINIMIZE_PRESSED = SQfitGraphicsUtils.loadImage("frame_minimize_pressed.png");
    private static final BufferedImage FRAME_WINDOWIZE_DULL = SQfitGraphicsUtils.loadImage("frame_windowize_dull.png");
    private static final BufferedImage FRAME_WINDOWIZE = SQfitGraphicsUtils.loadImage("frame_windowize.png");
    private static final BufferedImage FRAME_WINDOWIZE_OVER = SQfitGraphicsUtils.loadImage("frame_windowize_over.png");
    private static final BufferedImage FRAME_WINDOWIZE_PRESSED = SQfitGraphicsUtils.loadImage("frame_windowize_pressed.png");

    public void paintDesktopPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(new GradientPaint(x, y, SQfitGraphicsUtils.getWebColor("ffd19f"), x, y + h, SQfitGraphicsUtils.getWebColor("ff8500")));
        g2.fillRect(x, y, w, h);
    }

    public void paintDesktopPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    public void paintInternalFrameBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        g.setColor(SQfitGraphicsUtils.getWebColor("EBEDF2"));
        g.fillRect(x + 1, y + 1, w - 2, h - 2);
    }

    public void paintInternalFrameBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Color frameColor;
        BufferedImage img;
        if (((JInternalFrame)context.getComponent()).isSelected()) {
            img = FRAME_IMG;
            frameColor = SQfitGraphicsUtils.getWebColor("2b2e33");
        } else {
            img = FRAME_IMG_NONFOCUSED;
            frameColor = SQfitGraphicsUtils.getWebColor("525761");
        }
        g.setColor(frameColor);
        g.drawLine(x, y + 1, x, h - 2);
        g.drawLine(x + w - 1, y + 1, x + w - 1, h - 2);
        g.drawLine(x + 1, y, x + w - 2, y);
        g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        g.drawImage(img, x + 1, y + 1, x + 6, y + 25, 0, 0, 5, 24, null);
        g.drawImage(img, x + 1, y + 25, x + 6, y + h - 6, 0, 25, 5, 26, null);
        g.drawImage(img, x + 1, y + h - 6, x + 6, y + h - 1, 0, 25, 5, 29, null);
        g.drawImage(img, x + 6, y + h - 6, x + w - 6, y + h - 1, 6, 25, 7, 29, null);
        g.drawImage(img, x + w - 6, y + 1, x + w, y + 25, 6, 0, 12, 24, null);
        g.drawImage(img, x + w - 6, y + 25, x + w, y + h - 6, 6, 25, 12, 26, null);
        g.drawImage(img, x + w - 6, y + h - 6, x + w, y + h - 1, 6, 25, 12, 29, null);
    }

    public void paintInternalFrameTitlePaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        BufferedImage img = (context.getComponentState() & 0x200) != 0 ? FRAME_IMG : FRAME_IMG_NONFOCUSED;
        g.drawImage(img, x, y, x + w, y + 24, 6, 0, 7, 24, null);
    }

    public void paintInternalFrameTitlePaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    public void paintButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        JButton button = (JButton)context.getComponent();
        if ("InternalFrameTitlePane.menuButton".equals(button.getName())) {
            if (InternalFramePainter.isNotSelected(button)) {
                g.drawImage(FRAME_MENU_BTN_DULL, x, y, button);
            } else if ((context.getComponentState() & 4) != 0) {
                g.drawImage(FRAME_MENU_BTN_PRESSED, x, y, button);
            } else if ((context.getComponentState() & 2) != 0) {
                g.drawImage(FRAME_MENU_BTN_OVER, x, y, button);
            } else {
                g.drawImage(FRAME_MENU_BTN, x, y, button);
            }
        } else if ("InternalFrameTitlePane.iconifyButton".equals(button.getName())) {
            if (InternalFramePainter.isNotSelected(button)) {
                g.drawImage(FRAME_MAXIMIZE_DULL, x, y, button);
            } else if ((context.getComponentState() & 4) != 0) {
                g.drawImage(FRAME_MINIMIZE_PRESSED, x, y, button);
            } else if ((context.getComponentState() & 2) != 0) {
                g.drawImage(FRAME_MINIMIZE_OVER, x, y, button);
            } else {
                g.drawImage(FRAME_MINIMIZE, x, y, button);
            }
        } else if ("InternalFrameTitlePane.maximizeButton".equals(button.getName())) {
            if (InternalFramePainter.isMaximized(button)) {
                if (InternalFramePainter.isNotSelected(button)) {
                    g.drawImage(FRAME_WINDOWIZE_DULL, x, y, button);
                } else if ((context.getComponentState() & 4) != 0) {
                    g.drawImage(FRAME_WINDOWIZE_PRESSED, x, y, button);
                } else if ((context.getComponentState() & 2) != 0) {
                    g.drawImage(FRAME_WINDOWIZE_OVER, x, y, button);
                } else {
                    g.drawImage(FRAME_WINDOWIZE, x, y, button);
                }
            } else if (InternalFramePainter.isNotSelected(button)) {
                g.drawImage(FRAME_MAXIMIZE_DULL, x, y, button);
            } else if ((context.getComponentState() & 4) != 0) {
                g.drawImage(FRAME_MAXIMIZE_PRESSED, x, y, button);
            } else if ((context.getComponentState() & 2) != 0) {
                g.drawImage(FRAME_MAXIMIZE_OVER, x, y, button);
            } else {
                g.drawImage(FRAME_MAXIMIZE, x, y, button);
            }
        } else if ("InternalFrameTitlePane.closeButton".equals(button.getName())) {
            if (InternalFramePainter.isNotSelected(button)) {
                g.drawImage(FRAME_CLOSE_DULL, x, y, button);
            } else if ((context.getComponentState() & 4) != 0) {
                g.drawImage(FRAME_CLOSE_PRESSED, x, y, button);
            } else if ((context.getComponentState() & 2) != 0) {
                g.drawImage(FRAME_CLOSE_OVER, x, y, button);
            } else {
                g.drawImage(FRAME_CLOSE, x, y, button);
            }
        }
    }

    private static boolean isMaximized(JButton btn) {
        for (Container p = btn.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JInternalFrame)) continue;
            return ((JInternalFrame)p).isMaximum();
        }
        return false;
    }

    private static boolean isNotSelected(JButton btn) {
        for (Container p = btn.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JInternalFrame)) continue;
            return !((JInternalFrame)p).isSelected();
        }
        return true;
    }
}

