/*
 * Decompiled with CFR 0.152.
 */
package projektY.database.jLibY;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YCheckColumnDefinition;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabase;
import projektY.database.YFieldValue;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YMatrixRowDefinition;
import projektY.database.YRowDefinition;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.jLibY.YParamDBList;
import projektY.database.jLibY.YStorableDBList;

public class YMatrixList
extends YStorableDBList {
    private YParamDBList matrixColumnsDefinitionList;
    private String rfkName;
    private YMatrixRowDefinition matrixRowDefinition = null;
    private int matrixColumnCount = 0;
    private YColumnDefinition leftFKDefinition;
    private YColumnDefinition rightFKDefinition;
    private YColumnDefinition matrixColumnDefinition;
    private Vector<YColumnDefinition> matrixColumnDefinitions = new Vector(40, 20);
    private Vector<YRowValues> matrixRows = new Vector(30, 20);
    private String matrixTableName;
    private boolean dispMatrixColumns = true;

    public YMatrixList(YSession session, int maxColumns) throws YException {
        super(session, maxColumns);
    }

    protected YColumnDefinition addLeftFkField(String lFkName) throws YException {
        if (this.leftFKDefinition != null) {
            throw new YProgramException(this, "Mehrfaches Hinzuf\u00fcgen des linken Fremdschl\u00fcssels");
        }
        this.leftFKDefinition = super.addDBField(lFkName, YColumnDefinition.FieldType.INT);
        return this.leftFKDefinition;
    }

    protected YColumnDefinition addRightFkField(String rFkName) throws YException {
        if (this.rightFKDefinition != null) {
            throw new YProgramException(this, "Mehrfaches Hinzuf\u00fcgen des rechten Fremdschl\u00fcssels");
        }
        this.rightFKDefinition = super.addDBField(rFkName, YColumnDefinition.FieldType.INT);
        return this.rightFKDefinition;
    }

    protected void setMatrixColumnDefinition(YColumnDefinition matrixColumnDefinition) throws YException {
        if (this.matrixColumnDefinition != null) {
            throw new YProgramException(this, "Mehrfaches Setzen der Definition der Matrixspalte.");
        }
        this.matrixColumnDefinition = matrixColumnDefinition;
    }

    protected void setMatrixColumnsDefinitionList(YParamDBList matrixColumnsDefinitionList, String rfkName) throws YException {
        if (this.matrixColumnsDefinitionList != null) {
            throw new YProgramException(this, "Mehrfaches Setzen der Definitionsliste der Matrixspalten.");
        }
        this.matrixColumnsDefinitionList = matrixColumnsDefinitionList;
        this.rfkName = rfkName;
    }

    protected void setMatrixTableName(String matrixTableName) throws YException {
        if (this.matrixTableName != null) {
            throw new YProgramException(this, "Mehrfaches Setzen des Matrixtabellennamens.");
        }
        this.matrixTableName = matrixTableName;
    }

    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        if (this.leftFKDefinition == null) {
            throw new YProgramException(this, "Der linke FK der Matrixtabelle wurde nicht definiert");
        }
        if (this.rightFKDefinition == null) {
            throw new YProgramException(this, "Der rechte FK der Matrixtabelle wurde nicht definiert");
        }
        if (this.matrixColumnDefinition == null) {
            throw new YProgramException(this, "Die Definition der Matrixspalte wurde nicht \u00fcbergeben");
        }
        if (this.matrixTableName == null) {
            throw new YProgramException(this, "Der Name der Matrixtabelle wurde nicht definiert");
        }
        if (this.matrixColumnsDefinitionList == null) {
            throw new YProgramException(this, "Die Liste f\u00fcr die Spaltendefinition wurde nicht bereitgestellt");
        }
        YRowDefinition rowDefinition = super.getRowDefinition();
        int nCols = rowDefinition.getNColumns();
        for (int iCol = 0; iCol < nCols; ++iCol) {
            YColumnDefinition columnDefinition = rowDefinition.getColumnDefinition(iCol);
            if (columnDefinition == this.matrixColumnDefinition) continue;
            columnDefinition.setReadOnly();
        }
    }

    public YColumnDefinition getIdColumnDefinition() throws YException {
        return this.rightFKDefinition;
    }

    protected void afterFetch(int objId) throws YException {
    }

    public YMatrixList fetch(int objId) throws YException {
        int iMColDef;
        int nColumns = this.rowDefinition.getNColumns() - 1;
        boolean structureChanged = false;
        this.startChangeBlock();
        this.matrixColumnsDefinitionList.fetch(objId);
        this.matrixColumnCount = this.matrixColumnsDefinitionList.getRowCount();
        YColumnDefinition columnDefinition = this.matrixColumnDefinition;
        String matrixColumnName = this.matrixColumnDefinition.getName();
        for (iMColDef = 0; iMColDef < this.matrixColumnCount; ++iMColDef) {
            YColumnDefinition reorgColumnDefinition;
            int rfkValue = this.matrixColumnsDefinitionList.getAsInt(iMColDef, this.rfkName);
            if (iMColDef + 1 > this.matrixColumnDefinitions.size()) {
                if (columnDefinition instanceof YLookUpDomainColumnDefinition) {
                    YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = (YLookUpDomainColumnDefinition)columnDefinition;
                    reorgColumnDefinition = new YLookUpDomainColumnDefinition(nColumns + iMColDef, matrixColumnName + "+" + iMColDef, lookUpDomainColumnDefinition.getLookUpDomain());
                } else {
                    reorgColumnDefinition = columnDefinition instanceof YCheckColumnDefinition ? new YCheckColumnDefinition(nColumns + iMColDef, matrixColumnName + "+" + iMColDef) : new YColumnDefinition(nColumns + iMColDef, matrixColumnName + "+" + iMColDef, columnDefinition);
                }
                this.matrixColumnDefinitions.add(reorgColumnDefinition);
                structureChanged = true;
            } else {
                reorgColumnDefinition = this.matrixColumnDefinitions.get(iMColDef);
                structureChanged = structureChanged || reorgColumnDefinition.getColumnId() != rfkValue;
            }
            reorgColumnDefinition.setColumnId(rfkValue);
            reorgColumnDefinition.setLabel(this.matrixColumnsDefinitionList.getRowValues(iMColDef).toString());
        }
        super.fetch(objId);
        this.endChangeBlock();
        if (structureChanged || this.matrixRowDefinition == null) {
            this.matrixRowDefinition = new YMatrixRowDefinition(this.rowDefinition, columnDefinition, this.matrixColumnCount);
            for (iMColDef = 0; iMColDef < this.matrixColumnCount; ++iMColDef) {
                this.matrixRowDefinition.addColumnDefinition(this.matrixColumnDefinitions.get(iMColDef));
            }
        }
        this.matrixRows.clear();
        YRowValues rowValues = null;
        int iRow = 0;
        int iCol = this.matrixColumnCount;
        for (int iRow0 = 0; iRow0 < super.getRowCount(); ++iRow0) {
            if (iCol >= this.matrixColumnCount) {
                if (rowValues != null) {
                    this.matrixRows.add(rowValues);
                }
                rowValues = this.matrixRowDefinition.createRowValues(super.getAbsRowValues(iRow0), iRow);
                this.matrixRowDefinition.mapFieldValue(rowValues, ((YRowValues)this.rows.get(iRow0)).getFieldValue(matrixColumnName), this.matrixColumnDefinitions.get(0));
                ++iRow;
                iCol = 1;
                continue;
            }
            this.matrixRowDefinition.mapFieldValue(rowValues, ((YRowValues)this.rows.get(iRow0)).getFieldValue(matrixColumnName), this.matrixColumnDefinitions.get(iCol));
            ++iCol;
        }
        if (rowValues != null) {
            this.matrixRows.add(rowValues);
        }
        this.afterFetch(objId);
        if (structureChanged) {
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.RESTRUCTURE));
        } else {
            this.fireChanged(new YDBOChangeEvent());
        }
        return this;
    }

    public int getMatrixColumnCount() {
        return this.matrixColumnCount;
    }

    public YColumnDefinition getMatrixColumnDefinition(int iMatrixCol) throws YProgramException {
        try {
            return this.matrixColumnDefinitions.get(iMatrixCol);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Matrixspaltenindex: " + iMatrixCol);
        }
    }

    public int getRowCount() throws YException {
        return this.matrixRows.size();
    }

    public YRowValues getRowValues(int iRow) throws YException {
        return this.matrixRows.get(iRow);
    }

    public YRowValues getAbsRowValues(int iRow) throws YException {
        return this.matrixRows.get(iRow);
    }

    public void setDispFields(String[] insideTable, String[] outsideTable) throws YException {
        int iField;
        String matrixColumnName = this.matrixColumnDefinition.getName();
        this.dispMatrixColumns = false;
        for (iField = 0; iField < insideTable.length; ++iField) {
            if (!insideTable[iField].equals(matrixColumnName)) continue;
            this.dispMatrixColumns = true;
            break;
        }
        if (iField >= insideTable.length && outsideTable != null) {
            for (iField = 0; iField < outsideTable.length; ++iField) {
                if (!insideTable[iField].equals(matrixColumnName)) continue;
                this.dispMatrixColumns = true;
                break;
            }
        }
        super.setDispFields(insideTable, outsideTable);
    }

    public int getDispColCount() throws YException {
        return super.getDispColCount() + (this.dispMatrixColumns ? this.matrixColumnCount - 1 : 0);
    }

    public YColumnDefinition getDispColumnDefinition(int iCol) throws YException {
        if (iCol < super.getDispColCount() - (this.dispMatrixColumns ? 1 : 0)) {
            return super.getDispColumnDefinition(iCol);
        }
        if ((iCol -= super.getDispColCount() - (this.dispMatrixColumns ? 1 : 0)) >= (this.dispMatrixColumns ? this.matrixColumnCount : -1)) {
            throw new YProgramException(this, "Ung\u00fcltiger Matrix-Spaltenindex: " + iCol);
        }
        return this.matrixColumnDefinitions.get(iCol);
    }

    public YFieldValue getDispValue(int iRow, int iCol) throws YException {
        if (iCol < super.getDispColCount() - (this.dispMatrixColumns ? 1 : 0)) {
            return this.matrixRows.get(iRow).getFieldValue(this.dispIndicees[iCol]);
        }
        if (!this.dispMatrixColumns && (iCol -= super.getDispColCount() - (this.dispMatrixColumns ? 1 : 0)) > -1) {
            throw new YProgramException(this, "Ung\u00fcltiger Matrix-Spaltenindex: " + iCol);
        }
        return this.matrixRows.get(iRow).getFieldValue(iCol += this.matrixRowDefinition.getNListColumns());
    }

    public String getDispString(int iRow, int iCol) throws YException {
        return this.getDispValue(iRow, iCol).toString();
    }

    public void setDispString(int iRow, int iCol, String dispString) throws YException {
        this.getDispValue(iRow, iCol).modifyValue(dispString);
    }

    public boolean hasChanged() throws YException {
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
        }
        for (int iRow = 0; iRow < this.matrixRows.size(); ++iRow) {
            if (!this.matrixRows.get(iRow).hasChanged()) continue;
            return true;
        }
        return false;
    }

    protected boolean setPosted() throws YException {
        int nRows = this.matrixRows.size();
        boolean rowsChanged = false;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues row = this.matrixRows.get(iRow);
            if (row.hasDeleteMark()) {
                this.matrixRows.remove(iRow);
                --iRow;
                --nRows;
                rowsChanged = true;
                this.activeRow = -1;
                continue;
            }
            rowsChanged |= row.setPosted();
        }
        return rowsChanged;
    }

    protected void unsetPosted() throws YException {
        for (int iRow = 0; iRow < this.matrixRows.size(); ++iRow) {
            YRowValues rowValues = this.matrixRows.get(iRow);
            rowValues.resetMarks();
        }
    }

    protected boolean prepareThis() throws YException {
        return false;
    }

    protected void postThis() throws YException {
        YDatabase database = this.session.getDatabase();
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            YRowValues rowValues = this.matrixRows.get(iRow);
            for (int iCol = 0; iCol < this.matrixRowDefinition.getNColumns(); ++iCol) {
                String sql;
                int columnId;
                YFieldValue fieldValue = rowValues.getFieldValue(iCol);
                if (!fieldValue.hasChanged() || (columnId = fieldValue.getColumnDefinition().getColumnId()) == 0) continue;
                if (fieldValue.wasNull()) {
                    sql = "INSERT INTO " + this.matrixTableName + "(" + this.leftFKDefinition.getName() + ", " + this.rightFKDefinition.getName() + "," + this.matrixColumnDefinition.getName() + ")" + " VALUES (" + this.sqlValue(rowValues.getFieldValue(this.leftFKDefinition)) + ", " + fieldValue.getColumnDefinition().getColumnId() + ", " + this.sqlValue(fieldValue) + ")";
                } else if (fieldValue.isNull()) {
                    sql = "DELETE FROM " + this.matrixTableName + " WHERE " + this.leftFKDefinition.getName() + "=" + this.sqlValue(rowValues.getFieldValue(this.leftFKDefinition)) + " AND " + this.rightFKDefinition.getName() + "=" + fieldValue.getColumnDefinition().getColumnId();
                } else {
                    if (!fieldValue.hasChanged()) continue;
                    sql = "UPDATE " + this.matrixTableName + " SET " + this.matrixColumnDefinition.getName() + "=" + this.sqlValue(fieldValue) + " WHERE " + this.leftFKDefinition.getName() + "=" + this.sqlValue(rowValues.getFieldValue(this.leftFKDefinition)) + " AND " + this.rightFKDefinition.getName() + "=" + fieldValue.getColumnDefinition().getColumnId();
                }
                rowValues.setPostMark();
                if (!database.isInTransaction()) {
                    database.startTransaction();
                }
                this.sqlDml.execute(sql.toString());
            }
        }
    }
}

