/*
 * Decompiled with CFR 0.152.
 */
package SQlabLookAndFeel.painters;

import SQlabLookAndFeel.SQlabGraphicsUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ProgressPainter
extends SynthPainter {
    private static final float[] NORMAL_BG_PTS = new float[]{0.0f, 0.06f, 0.216f, 0.44f, 0.46f, 0.694f, 0.85f, 0.95f, 1.0f};
    private static final Color[] NORMAL_BG = new Color[]{SQlabGraphicsUtils.getWebColor("FFFFFF"), SQlabGraphicsUtils.getWebColor("EFF0F2"), SQlabGraphicsUtils.getMidWebColor("EFF0F2", "DADBDE"), SQlabGraphicsUtils.getWebColor("DADBDE"), SQlabGraphicsUtils.getWebColor("CED0D4"), SQlabGraphicsUtils.getMidWebColor("CED0D4", "E3E5E9"), SQlabGraphicsUtils.getWebColor("E3E5E9"), SQlabGraphicsUtils.getWebColor("F9FBFF"), SQlabGraphicsUtils.getWebColor("F9FBFF")};
    private static final float[] NORMAL_FG_PTS = new float[]{0.0f, 0.05f, 0.95f, 1.0f};
    private static final Color[] NORMAL_FG = new Color[]{SQlabGraphicsUtils.getWebColor("888B91"), SQlabGraphicsUtils.getWebColor("888B91"), SQlabGraphicsUtils.getWebColor("AEB1B7"), SQlabGraphicsUtils.getWebColor("AEB1B7")};
    private static final float[] BAR_BG_PTS = new float[]{0.0f, 0.06f, 0.216f, 0.44f, 0.46f, 0.694f, 0.85f, 0.95f, 1.0f};
    private static final Color[] BAR_BG = new Color[]{SQlabGraphicsUtils.getWebColor("ECD1B3"), SQlabGraphicsUtils.getWebColor("DBA76B"), SQlabGraphicsUtils.getMidWebColor("DBA76B", "CB7F2A"), SQlabGraphicsUtils.getWebColor("CB7F2A"), SQlabGraphicsUtils.getWebColor("C06600"), SQlabGraphicsUtils.getMidWebColor("C06600", "E88E2B"), SQlabGraphicsUtils.getWebColor("E88E2B"), SQlabGraphicsUtils.getWebColor("FFB146"), SQlabGraphicsUtils.getWebColor("FFB146")};
    private static final float[] BAR_FG_PTS = new float[]{0.0f, 0.1f, 0.6f, 0.78f, 0.9f, 0.95f, 1.0f};
    private static final Color[] BAR_FG = new Color[]{SQlabGraphicsUtils.getWebColor("983E00"), SQlabGraphicsUtils.getWebColor("A34900"), SQlabGraphicsUtils.getWebColor("A34900"), SQlabGraphicsUtils.getMidWebColor("A34900", "E88E28"), SQlabGraphicsUtils.getWebColor("E88E28"), SQlabGraphicsUtils.getWebColor("721800"), SQlabGraphicsUtils.getWebColor("721800")};

    public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new LinearGradientPaint(x, y + 3, x, y + h - 4, NORMAL_BG_PTS, NORMAL_BG));
        g2.fillRect(x + 2, y + 2, w - 5, h - 5);
        g2.setPaint(new LinearGradientPaint(x, y + 2, x, y + h - 5, NORMAL_FG_PTS, NORMAL_FG));
        g2.drawRect(x + 2, y + 2, w - 5, h - 5);
    }

    public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        boolean isComplete;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new LinearGradientPaint(x, y + 3, x, y + h - 4, BAR_BG_PTS, BAR_BG));
        g2.fillRect(x + 2, y + 2, w - 5, h - 5);
        g2.setPaint(new LinearGradientPaint(x, y + 2, x, y + h - 2, BAR_FG_PTS, BAR_FG));
        g2.drawRect(x + 2, y + 2, w - 5, h - 5);
        JProgressBar progressBar = (JProgressBar)context.getComponent();
        boolean bl = isComplete = progressBar.getValue() == progressBar.getMaximum();
        if (isComplete) {
            g2.setPaint(new Color(232, 142, 40, 130));
            g2.drawLine(x + 2, y + 1, x + w - 2, y + 1);
            g2.drawLine(x + 2, y + h - 2, x + w - 2, y + h - 2);
            g2.drawLine(x + 1, y + 1, x + 1, y + h - 2);
            g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
            g2.setPaint(new Color(232, 142, 40, 80));
            g2.drawLine(x, y, x + w - 1, y);
            g2.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g2.drawLine(x, y + 1, x, y + h - 2);
            g2.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
        } else {
            g2.setPaint(new Color(232, 142, 40, 130));
            g2.drawLine(x + 2, y + 1, x + w - 3, y + 1);
            g2.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
            g2.drawLine(x + 1, y + 1, x + 1, y + h - 2);
            g2.setPaint(new Color(232, 142, 40, 80));
            g2.drawLine(x, y, x + w - 3, y);
            g2.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
            g2.drawLine(x, y + 1, x, y + h - 2);
        }
    }

    public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
    }
}

