/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import popometer.JNimbusTable;
import popometer.YPopometerSession;
import popometer.dbobjects.YEVAusfuehrungen;
import popometer.dbobjects.YEVProduktbewertung;
import popometer.dbobjects.YROAusfuehrung;
import projektY.base.YException;
import projektY.database.YDatabaseList;
import projektY.swing.YJTableManager;
import projektY.swing.YTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanErgebnis
extends JPanel {
    private static final int maxTopProdukte = 5;
    private int prodartId;
    private YPopometerSession session;
    private YEVAusfuehrungen ausfuehrungen;
    private YROAusfuehrung[] topProdukte;
    private YEVProduktbewertung[] produktBewertungen;
    private JEditorPane[] editorPanes;
    private boolean[] beschreibungAngezeigt;
    private YTableModel tmTopProdukte;
    private JNimbusTable tblTopProdukte;
    private JNimbusTable tblDetails;
    private ImageViewer imageViewer;
    private static final int IMAGE_WIDTH = 300;
    private ButtonGroup bgBestellen;
    private JEditorPane edpanHtml1;
    private JEditorPane edpanHtml2;
    private JEditorPane edpanHtml3;
    private JEditorPane edpanHtml4;
    private JEditorPane edpanHtml5;
    private JLabel lblBild;
    private JPanel panBeschreibung;
    private JPanel panBestellen;
    private JPanel panBild;
    private JPanel panDetails;
    private JPanel panProdukte;
    private JPanel panSpacer;
    private JPanel panTopProdukte;
    private JScrollPane scrlHtml1;
    private JScrollPane scrlHtml2;
    private JScrollPane scrlHtml3;
    private JScrollPane scrlHtml4;
    private JScrollPane scrlHtml5;
    private JScrollPane scrlPlain;
    private JScrollPane scrlProdukte;
    private JTextArea txtPlain;

    public PanErgebnis(YPopometerSession session, int prodartId) throws YException {
        this.initComponents();
        this.session = session;
        this.prodartId = prodartId;
        this.imageViewer = new ImageViewer();
        this.imageViewer.setPreferredSize(new Dimension(300, 100));
        this.panBild.add(this.imageViewer);
        this.ausfuehrungen = new YEVAusfuehrungen(session);
        this.ausfuehrungen.setDispFields(new String[]{"bewertung", "bezeichnung", "verkauft"});
        this.tblTopProdukte = new JNimbusTable();
        this.tmTopProdukte = YJTableManager.createTableManager((JTable)this.tblTopProdukte, (YDatabaseList)this.ausfuehrungen).getTableModel();
        this.tblTopProdukte.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PanErgebnis.this.tblTopProdukteRowSelected(e);
            }
        });
        this.panTopProdukte.add((Component)this.tblTopProdukte, "Center");
        this.tblDetails = new JNimbusTable();
        this.tblDetails.setModel(new DefaultTableModel(0, 3){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        this.tblDetails.setColumnAlignRight(2);
        this.panDetails.add((Component)this.tblDetails, "First");
        this.topProdukte = new YROAusfuehrung[5];
        this.produktBewertungen = new YEVProduktbewertung[5];
        this.beschreibungAngezeigt = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            this.topProdukte[i] = new YROAusfuehrung(session);
            this.produktBewertungen[i] = new YEVProduktbewertung(session);
            this.beschreibungAngezeigt[i] = false;
        }
        this.editorPanes = new JEditorPane[5];
        this.editorPanes[0] = this.edpanHtml1;
        this.editorPanes[1] = this.edpanHtml2;
        this.editorPanes[2] = this.edpanHtml3;
        this.editorPanes[3] = this.edpanHtml4;
        this.editorPanes[4] = this.edpanHtml5;
        String[] style = session.getStyle();
        if (style != null) {
            for (int iPan = 0; iPan < 5; ++iPan) {
                StyleSheet styleSheet = ((HTMLEditorKit)this.editorPanes[iPan].getEditorKit()).getStyleSheet();
                styleSheet.addRule("body {background-color: white}");
                for (int iRule = 0; iRule < style.length; ++iRule) {
                    styleSheet.addRule(style[iRule]);
                }
            }
        }
    }

    private void zeigeProdukt(int iProdukt) throws YException {
        int iCol;
        int iRow;
        YEVProduktbewertung produktBewertung = this.produktBewertungen[iProdukt];
        this.imageViewer.setImage(this.topProdukte[iProdukt].getAsString("bildname"));
        produktBewertung.fetch();
        DefaultTableModel tmDetails = (DefaultTableModel)this.tblDetails.getModel();
        tmDetails.setRowCount(produktBewertung.getRowCount());
        for (iRow = 0; iRow < produktBewertung.getRowCount(); ++iRow) {
            for (iCol = 0; iCol < produktBewertung.getDispColCount(); ++iCol) {
                tmDetails.setValueAt(produktBewertung.getDispString(iRow, iCol), iRow, iCol);
            }
        }
        TableColumnModel columnModel = this.tblDetails.getColumnModel();
        for (iCol = 0; iCol < this.tblDetails.getColumnCount(); ++iCol) {
            int max = 0;
            for (iRow = 0; iRow < this.tblDetails.getRowCount(); ++iRow) {
                TableCellRenderer rend = this.tblDetails.getCellRenderer(iRow, iCol);
                Object value = this.tblDetails.getValueAt(iRow, iCol);
                Component comp = rend.getTableCellRendererComponent(this.tblDetails, value, false, false, iRow, iCol);
                max = Math.max(comp.getPreferredSize().width, max);
            }
            TableColumn column = columnModel.getColumn(iCol);
            column.setPreferredWidth(max);
        }
        String beschreibung = this.topProdukte[iProdukt].getAsString("beschreibung");
        if (beschreibung.startsWith("<HTML>") || beschreibung.startsWith("<html>")) {
            if (!this.beschreibungAngezeigt[iProdukt]) {
                this.editorPanes[iProdukt].setText(beschreibung);
            }
            ((CardLayout)this.panBeschreibung.getLayout()).show(this.panBeschreibung, "cardHtml" + (iProdukt + 1));
        } else {
            this.txtPlain.setText(beschreibung);
            ((CardLayout)this.panBeschreibung.getLayout()).show(this.panBeschreibung, "cardPlain");
        }
        this.beschreibungAngezeigt[iProdukt] = true;
    }

    public void holeProdukte(Vector<Integer> einsbedingungIds) throws YException {
        Object[] objEinsbedingungIds = einsbedingungIds.toArray();
        int n = einsbedingungIds.size();
        this.ausfuehrungen.setSQLSelect("SELECT b.ausfuehrung_id, SUM(b.bewertung)/" + einsbedingungIds.size() + ".0 AS bewertung, a.bezeichnung" + " FROM bewertungen b" + " JOIN ausfuehrungen a ON (a.ausfuehrung_id=b.ausfuehrung_id)" + " JOIN produkte p ON (p.produkt_id=a.produkt_id AND p.prodart_id=" + this.prodartId + ")");
        this.ausfuehrungen.setFilterValues("einsbedingung_id", objEinsbedingungIds);
        this.ausfuehrungen.fetch();
        n = Math.min(this.topProdukte.length, this.ausfuehrungen.getRowCount());
        for (int i = 0; i < n; ++i) {
            this.topProdukte[i].fetch(this.ausfuehrungen.getAsInt(i, "ausfuehrung_id"));
            this.produktBewertungen[i].setFilterValues("einsbedingung_id", objEinsbedingungIds);
            this.produktBewertungen[i].setFilterValue("ausfuehrung_id", this.ausfuehrungen.getAsString(i, "ausfuehrung_id"));
            this.beschreibungAngezeigt[i] = false;
        }
        if (n > 0) {
            this.tblTopProdukte.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void getVerkauft(Vector<YROAusfuehrung> produkte, Vector<Boolean> verkauft) throws YException {
        for (int iRow = 0; iRow < this.ausfuehrungen.getRowCount(); ++iRow) {
            boolean v = this.ausfuehrungen.getAsBool(iRow, "verkauft");
            if (iRow != 0 && !v) continue;
            produkte.add(this.topProdukte[iRow]);
            verkauft.add(v);
        }
    }

    public YROAusfuehrung getTopProdukt() {
        return this.topProdukte[0];
    }

    private void tblTopProdukteRowSelected(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int iRow = this.tblTopProdukte.getSelectedRow();
            if (iRow >= 0) {
                this.zeigeProdukt(iRow);
            }
        }
        catch (YException ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "Fehler", 0);
        }
    }

    private void initComponents() {
        this.bgBestellen = new ButtonGroup();
        this.scrlProdukte = new JScrollPane();
        this.panProdukte = new JPanel();
        this.panTopProdukte = new JPanel();
        this.panBestellen = new JPanel();
        this.panBild = new JPanel();
        this.lblBild = new JLabel();
        this.panDetails = new JPanel();
        this.panSpacer = new JPanel();
        this.panBeschreibung = new JPanel();
        this.scrlPlain = new JScrollPane();
        this.txtPlain = new JTextArea();
        this.scrlHtml1 = new JScrollPane();
        this.edpanHtml1 = new JEditorPane();
        this.scrlHtml2 = new JScrollPane();
        this.edpanHtml2 = new JEditorPane();
        this.scrlHtml3 = new JScrollPane();
        this.edpanHtml3 = new JEditorPane();
        this.scrlHtml4 = new JScrollPane();
        this.edpanHtml4 = new JEditorPane();
        this.scrlHtml5 = new JScrollPane();
        this.edpanHtml5 = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.panProdukte.setLayout(new GridBagLayout());
        this.panTopProdukte.setBorder(BorderFactory.createTitledBorder("Verkaufte oder bestellte Produkte bitte kennzeichnen:"));
        this.panTopProdukte.setLayout(new BorderLayout());
        this.panTopProdukte.add((Component)this.panBestellen, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panProdukte.add((Component)this.panTopProdukte, gridBagConstraints);
        this.panBild.setBorder(BorderFactory.createTitledBorder("Abbildung"));
        this.panBild.add(this.lblBild);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panProdukte.add((Component)this.panBild, gridBagConstraints);
        this.panDetails.setBorder(BorderFactory.createTitledBorder("Detailergebnisse"));
        this.panDetails.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panProdukte.add((Component)this.panDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panProdukte.add((Component)this.panSpacer, gridBagConstraints);
        this.scrlProdukte.setViewportView(this.panProdukte);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrlProdukte, gridBagConstraints);
        this.panBeschreibung.setBorder(BorderFactory.createTitledBorder("Beschreibung"));
        this.panBeschreibung.setLayout(new CardLayout());
        this.txtPlain.setColumns(20);
        this.txtPlain.setEditable(false);
        this.txtPlain.setLineWrap(true);
        this.txtPlain.setRows(5);
        this.txtPlain.setWrapStyleWord(true);
        this.scrlPlain.setViewportView(this.txtPlain);
        this.panBeschreibung.add((Component)this.scrlPlain, "cardPlain");
        this.edpanHtml1.setContentType("text/html");
        this.edpanHtml1.setEditable(false);
        this.scrlHtml1.setViewportView(this.edpanHtml1);
        this.panBeschreibung.add((Component)this.scrlHtml1, "cardHtml1");
        this.edpanHtml2.setContentType("text/html");
        this.edpanHtml2.setEditable(false);
        this.scrlHtml2.setViewportView(this.edpanHtml2);
        this.panBeschreibung.add((Component)this.scrlHtml2, "cardHtml2");
        this.edpanHtml3.setContentType("text/html");
        this.edpanHtml3.setEditable(false);
        this.scrlHtml3.setViewportView(this.edpanHtml3);
        this.panBeschreibung.add((Component)this.scrlHtml3, "cardHtml3");
        this.edpanHtml4.setContentType("text/html");
        this.edpanHtml4.setEditable(false);
        this.scrlHtml4.setViewportView(this.edpanHtml4);
        this.panBeschreibung.add((Component)this.scrlHtml4, "cardHtml4");
        this.edpanHtml5.setContentType("text/html");
        this.edpanHtml5.setEditable(false);
        this.scrlHtml5.setViewportView(this.edpanHtml5);
        this.panBeschreibung.add((Component)this.scrlHtml5, "cardHtml5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panBeschreibung, gridBagConstraints);
    }

    private class ImageViewer
    extends JPanel {
        Image image;
        boolean bildGeladen;
        int w;
        int h;

        private ImageViewer() {
        }

        public void setImage(String bildName) throws YException {
            this.image = PanErgebnis.this.session.createImage(bildName);
            this.w = 0;
            this.h = 0;
            this.bildGeladen = false;
            this.w = this.image.getWidth(this);
            this.h = this.image.getHeight(this);
            this.repaint();
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 1) != 0) {
                this.w = width;
            }
            if ((infoflags & 2) != 0) {
                this.h = height;
            }
            if ((infoflags & 0x20) != 0) {
                if (!this.bildGeladen) {
                    Dimension preferredSize = this.getPreferredSize();
                    float f = 300.0f / (float)this.w;
                    this.h = (int)((float)this.h * f) + 1;
                    if (this.h != preferredSize.height) {
                        preferredSize.height = this.h;
                        this.setPreferredSize(preferredSize);
                        this.revalidate();
                    }
                    this.bildGeladen = true;
                }
                this.repaint();
                return false;
            }
            return true;
        }

        public void paint(Graphics g) {
            if (this.image != null && this.bildGeladen) {
                g.drawImage(this.image, 0, 0, 300, this.h, this);
            }
        }
    }
}

