/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.sqfit;

import com.sun.java.swing.plaf.sqfit.SQfitGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.synth.SynthContext;

public class SQfitComboBoxUI
extends BasicComboBoxUI
implements MouseListener {
    private static final BufferedImage combo_normal = SQfitGraphicsUtils.loadImage("combobox_DEFAULT.png");
    private static final BufferedImage combo_over = SQfitGraphicsUtils.loadImage("combo_over.png");
    private static final BufferedImage combo_pressed = SQfitGraphicsUtils.loadImage("combo_pressed.png");
    private static final BufferedImage combo_disabled = SQfitGraphicsUtils.loadImage("combo_disabled.png");
    private static final BufferedImage combo_edit_btn = SQfitGraphicsUtils.loadImage("combo_edit_btn.png");
    private static final BufferedImage combo_edit_btn_over = SQfitGraphicsUtils.loadImage("combo_edit_btn_over.png");
    private static final BufferedImage combo_edit_btn_pressed = SQfitGraphicsUtils.loadImage("combo_edit_btn_pressed.png");
    private static Dimension BTN_SIZE = new Dimension(24, 24);
    private Dimension btnSize = new Dimension(BTN_SIZE);
    private boolean mouseInside = false;
    private boolean mouseDown = false;

    public static ComponentUI createUI(JComponent c) {
        return new SQfitComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    protected void installListeners() {
        super.installListeners();
        this.comboBox.addMouseListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        this.btnSize.height = size.height = Math.max(size.height, SQfitComboBoxUI.BTN_SIZE.height);
        this.btnSize.width = (int)((double)SQfitComboBoxUI.BTN_SIZE.width / (double)SQfitComboBoxUI.BTN_SIZE.height * (double)this.btnSize.height);
        size.height += insets.top + insets.bottom;
        size.width += insets.left + insets.right + this.btnSize.width;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    protected JButton createArrowButton() {
        JButton button = new JButton(){

            protected void paintComponent(Graphics g) {
                if (SQfitComboBoxUI.this.comboBox.isEditable()) {
                    BufferedImage img = combo_edit_btn;
                    if (SQfitComboBoxUI.this.mouseDown) {
                        img = combo_edit_btn_pressed;
                    } else if (!SQfitComboBoxUI.this.comboBox.isEnabled()) {
                        img = combo_edit_btn;
                    } else if (SQfitComboBoxUI.this.mouseInside) {
                        img = combo_edit_btn_over;
                    }
                    g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), 0, 0, img.getWidth(), img.getHeight(), SQfitComboBoxUI.this.comboBox);
                }
            }
        };
        button.addMouseListener(this);
        button.setMinimumSize(BTN_SIZE);
        button.setPreferredSize(BTN_SIZE);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    public void paintComboBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        ListCellRenderer renderer = this.comboBox.getRenderer();
        Rectangle r = new Rectangle(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight());
        this.paintCurrentValueBackground(g, r, this.hasFocus);
        if (!this.comboBox.isEditable()) {
            if (renderer instanceof JComponent) {
                ((JComponent)((Object)renderer)).setOpaque(false);
                ((JComponent)((Object)renderer)).setForeground(this.comboBox.getForeground());
            }
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), false);
            if (renderer instanceof JComponent) {
                ((JComponent)((Object)renderer)).setOpaque(true);
            }
        }
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (!this.comboBox.isEditable()) {
            BufferedImage img = combo_normal;
            if (!this.comboBox.isEnabled()) {
                img = combo_disabled;
            } else if (this.mouseDown) {
                img = combo_pressed;
            } else if (this.mouseInside) {
                img = combo_over;
            }
            g.drawImage(img, bounds.x, bounds.y, bounds.x + 4, bounds.y + bounds.height, 0, 0, 4, 20, this.comboBox);
            g.drawImage(img, bounds.x + 4, bounds.y, bounds.x + bounds.width - 17, bounds.y + bounds.height, 5, 0, 6, 20, this.comboBox);
            g.drawImage(img, bounds.x + bounds.width - 17, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 7, 0, 24, 20, this.comboBox);
        } else {
            g.setColor(Color.WHITE);
            g.fillRect(bounds.x, bounds.y, bounds.width - this.btnSize.width, bounds.height - 1);
            int x = bounds.x;
            int y = bounds.y;
            int w = bounds.width - this.btnSize.width;
            int h = bounds.height - 1;
            Insets insets = this.getInsets();
            g.setColor(new Color(255, 255, 255));
            g.drawLine(x, y, x + insets.left, y);
            g.setColor(new Color(255, 255, 255));
            g.drawLine(x + 1, y + 1, x + insets.left, y + 1);
            g.setColor(new Color(255, 255, 255));
            g.drawLine(x, y + 1, x, y + 1);
            g.setColor(new Color(255, 255, 255));
            g.drawLine(x + 1, y + 2, x + insets.left, y + 2);
            g.setColor(new Color(255, 255, 255));
            g.drawLine(x, y + 2, x, y + 2);
            g.setColor(new Color(255, 255, 255));
            g.drawLine(x, y + h, x + insets.left, y + h);
            g.setColor(new Color(255, 255, 255));
            g.drawLine(x, y + 3, x, y + h);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new ComboLayout();
    }

    protected Insets getInsets() {
        return new Insets(0, 5, 0, 0);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (this.comboBox.isEditable()) {
            if (e.getComponent() == this.arrowButton) {
                this.mouseInside = true;
            }
        } else {
            this.mouseInside = true;
            this.comboBox.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.comboBox.isEditable()) {
            if (e.getComponent() == this.arrowButton) {
                this.mouseInside = false;
            }
        } else {
            this.mouseInside = false;
            this.comboBox.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.comboBox.isEditable()) {
            if (e.getComponent() == this.arrowButton) {
                this.mouseDown = true;
            }
        } else {
            this.mouseDown = true;
            this.comboBox.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.comboBox.isEditable()) {
            if (e.getComponent() == this.arrowButton) {
                this.mouseDown = false;
            }
        } else {
            this.mouseDown = false;
            this.comboBox.repaint();
        }
    }

    private class ComboLayout
    implements LayoutManager {
        private ComboLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            Insets insets = SQfitComboBoxUI.this.getInsets();
            if (SQfitComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SQfitComboBoxUI.this.arrowButton.setBounds(width - (insets.right + ((SQfitComboBoxUI)SQfitComboBoxUI.this).btnSize.width), insets.top, ((SQfitComboBoxUI)SQfitComboBoxUI.this).btnSize.width, ((SQfitComboBoxUI)SQfitComboBoxUI.this).btnSize.height);
                } else {
                    SQfitComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, ((SQfitComboBoxUI)SQfitComboBoxUI.this).btnSize.width, ((SQfitComboBoxUI)SQfitComboBoxUI.this).btnSize.height);
                }
            }
            if (SQfitComboBoxUI.this.editor != null) {
                Rectangle cvb = SQfitComboBoxUI.this.rectangleForCurrentValue();
                SQfitComboBoxUI.this.editor.setBounds(cvb.x, cvb.y, cvb.width, cvb.height);
            }
        }
    }
}

