/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import popometer.JNimbusTable;
import popometer.YPopometerSession;
import popometer.forms.DlgExport;
import projektY.base.YException;
import projektY.base.YUserException;
import projektY.database.YColumnDefinition;
import projektY.database.YEvaluationList;
import projektY.database.YParamSql;
import projektY.swing.YJTableManager;

public class PanAuswertungen
extends JPanel {
    private Frame parent;
    private YPopometerSession session;
    private YEvaluationList evAnfragen;
    private JNimbusTable tblAnfragen;
    private YEvaluationList evTopProdukte;
    private JNimbusTable tblTopProdukte;
    private YEvaluationList evTopEinsatzbereiche;
    private JNimbusTable tblTopEinsatzbereiche;
    private YEvaluationList evTopVerkaeufer;
    private JNimbusTable tblTopVerkaeufer;
    private DlgExport dlgExport;
    private JButton cmdDieseWoche;
    private JButton cmdDieserMonat;
    private JButton cmdDiesesJahr;
    private JButton cmdExport;
    private JButton cmdHeute;
    private JButton cmdStart;
    private JTextField fldAb;
    private JTextField fldBis;
    private JTextField fldMaxResults;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel panDatum;
    private JPanel panZeitraum;
    private JScrollPane scrlAnfragen;
    private JScrollPane scrlTopEinsatzbereiche;
    private JScrollPane scrlTopProdukte;
    private JScrollPane scrlTopVerkaeufer;
    private JTabbedPane tabErgebnisse;

    private void addFilter(YEvaluationList ev) throws YException {
        ev.addFilter("datum_ab", "datum>=:value:", YColumnDefinition.FieldType.DATE);
        ev.addFilter("datum_bis", "datum<=:value:", YColumnDefinition.FieldType.DATE);
    }

    public PanAuswertungen(Frame parent, YPopometerSession session) throws YException {
        this.initComponents();
        this.parent = parent;
        this.session = session;
        this.evAnfragen = new YEvaluationList(session, 8);
        this.evAnfragen.addDBField("datum", YColumnDefinition.FieldType.DATE).setLabel("Datum");
        this.evAnfragen.addDBField("bezeichnung", YColumnDefinition.FieldType.STRING).setLabel("Produkt");
        this.evAnfragen.addDBField("kundennr", YColumnDefinition.FieldType.STRING).setLabel("Kundennr.");
        this.evAnfragen.addDBField("vorname", YColumnDefinition.FieldType.STRING).setLabel("Vorname");
        this.evAnfragen.addDBField("name", YColumnDefinition.FieldType.STRING).setLabel("Name");
        this.evAnfragen.addDBField("telefon", YColumnDefinition.FieldType.STRING).setLabel("Telefon");
        this.evAnfragen.addDBField("email", YColumnDefinition.FieldType.STRING).setLabel("eMail");
        this.evAnfragen.setSQLSelect("SELECT a.datum, p.bezeichnung, k.kundennr, k.vorname, k.name, k.telefon, k.email FROM vh_anfragen a JOIN vh_anfrageprodukte p ON (a.anfrage_id=p.anfrage_id) LEFT OUTER JOIN vh_kunden k ON (a.kunde_id = k.kunde_id)");
        this.addFilter(this.evAnfragen);
        this.evAnfragen.setAndWhere("p.verkauft=TRUE");
        this.evAnfragen.setOrder(new String[]{"datum"}, true);
        this.evAnfragen.finalize();
        this.evAnfragen.setDispFields(new String[]{"datum", "bezeichnung", "kundennr", "vorname", "name", "telefon", "email"});
        this.tblAnfragen = new JNimbusTable();
        YJTableManager.createTableManager(this.tblAnfragen, this.evAnfragen, true);
        this.scrlAnfragen.setViewportView(this.tblAnfragen);
        this.evTopProdukte = new YEvaluationList(session, 3);
        this.evTopProdukte.addDBField("anzahl", YColumnDefinition.FieldType.INT).setLabel("Verkauft");
        this.evTopProdukte.addDBField("bezeichnung", YColumnDefinition.FieldType.STRING).setLabel("Produkt");
        this.evTopProdukte.setSQLSelect("SELECT COUNT(*) AS anzahl, p.bezeichnung FROM vh_anfragen a JOIN vh_anfrageprodukte p ON (p.anfrage_id=a.anfrage_id)");
        this.evTopProdukte.setGroupBy(new String[]{"bezeichnung"});
        this.evTopProdukte.setOrder(new String[]{"anzahl"}, true);
        this.addFilter(this.evTopProdukte);
        this.evTopProdukte.setAndWhere("p.verkauft=TRUE");
        this.evTopProdukte.finalize();
        this.evTopProdukte.setDispFields(new String[]{"bezeichnung", "anzahl"});
        this.tblTopProdukte = new JNimbusTable();
        YJTableManager.createTableManager(this.tblTopProdukte, this.evTopProdukte, true);
        this.scrlTopProdukte.setViewportView(this.tblTopProdukte);
        this.evTopEinsatzbereiche = new YEvaluationList(session, 3);
        this.evTopEinsatzbereiche.addDBField("einsatzbereich", YColumnDefinition.FieldType.STRING);
        this.evTopEinsatzbereiche.addDBField("anzahl", YColumnDefinition.FieldType.INT).setLabel("Anzahl Anfragen");
        this.evTopEinsatzbereiche.addDBField("bedingung", YColumnDefinition.FieldType.STRING).setLabel("Einsatzbereich");
        this.evTopEinsatzbereiche.setParamSelect("SELECT CASE WHEN rank() OVER (PARTITION BY einsatzbereich ORDER BY anzahl DESC, bedingung) = 1 THEN einsatzbereich ELSE NULL END AS einsatzbereich, anzahl, bedingung FROM (SELECT b.einsatzbereich, COUNT(*) AS anzahl, b.bedingung FROM vh_kundeneinsbed b WHERE b.kunde_id IN (SELECT kunde_id FROM vh_anfragen WHERE TRUE :ab(FEXPR): :bis(FEXPR):) GROUP BY einsatzbereich, bedingung) AS xyz", new YParamSql.Filter[]{new YParamSql.Filter("ab", "AND datum>=:datum_ab(DATE):"), new YParamSql.Filter("bis", "AND datum<=:datum_bis(DATE):")});
        this.evTopEinsatzbereiche.finalize();
        this.evTopEinsatzbereiche.setDispFields(new String[]{"einsatzbereich", "anzahl", "bedingung"});
        this.tblTopEinsatzbereiche = new JNimbusTable();
        YJTableManager.createTableManager(this.tblTopEinsatzbereiche, this.evTopEinsatzbereiche, true);
        this.scrlTopEinsatzbereiche.setViewportView(this.tblTopEinsatzbereiche);
        this.evTopVerkaeufer = new YEvaluationList(session, 3);
        this.evTopVerkaeufer.addDBField("anzahl", YColumnDefinition.FieldType.INT).setLabel("Anzahl Anfragen");
        this.evTopVerkaeufer.addDBField("vorname", YColumnDefinition.FieldType.STRING).setLabel("Vorname");
        this.evTopVerkaeufer.addDBField("name", YColumnDefinition.FieldType.STRING).setLabel("Name");
        this.evTopVerkaeufer.setSQLSelect("SELECT COUNT(*) AS anzahl, p.vorname, p.name FROM vh_anfragen a JOIN vh_personen p ON (p.pers_id=a.pers_id)");
        this.evTopVerkaeufer.setGroupBy(new String[]{"vorname", "name"});
        this.evTopVerkaeufer.setOrder(new String[]{"Anzahl"}, true);
        this.addFilter(this.evTopVerkaeufer);
        this.evTopVerkaeufer.finalize();
        this.evTopVerkaeufer.setDispFields(new String[]{"anzahl", "vorname", "name"});
        this.tblTopVerkaeufer = new JNimbusTable();
        YJTableManager.createTableManager(this.tblTopVerkaeufer, this.evTopVerkaeufer, true);
        this.scrlTopVerkaeufer.setViewportView(this.tblTopVerkaeufer);
    }

    private void setFilterValues(YEvaluationList ev) throws YException {
        ev.clearFilterValues();
        if (this.fldAb.getText().length() > 0) {
            ev.setFilterValue("datum_ab", this.fldAb.getText());
        }
        if (this.fldBis.getText().length() > 0) {
            ev.setFilterValue("datum_bis", this.fldBis.getText());
        }
        if (this.fldMaxResults.getText().length() > 0) {
            try {
                ev.setMaxRows(Integer.parseInt(this.fldMaxResults.getText()));
            }
            catch (NumberFormatException e) {
                throw new YUserException("Ung\u00fcltige Zahl: " + this.fldMaxResults.getText());
            }
        } else {
            ev.setMaxRows(0);
        }
    }

    private void execEvaluation(YEvaluationList ev) throws YException {
        this.setFilterValues(ev);
        ev.fetch();
    }

    private void initComponents() {
        this.panZeitraum = new JPanel();
        this.panDatum = new JPanel();
        this.cmdStart = new JButton();
        this.cmdExport = new JButton();
        this.cmdDiesesJahr = new JButton();
        this.cmdDieserMonat = new JButton();
        this.cmdDieseWoche = new JButton();
        this.cmdHeute = new JButton();
        this.jLabel1 = new JLabel();
        this.fldAb = new JTextField();
        this.jLabel2 = new JLabel();
        this.fldBis = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldMaxResults = new JTextField();
        this.jLabel4 = new JLabel();
        this.tabErgebnisse = new JTabbedPane();
        this.scrlAnfragen = new JScrollPane();
        this.scrlTopProdukte = new JScrollPane();
        this.scrlTopEinsatzbereiche = new JScrollPane();
        this.scrlTopVerkaeufer = new JScrollPane();
        this.setLayout(new GridBagLayout());
        this.panZeitraum.setLayout(new GridLayout(0, 1));
        this.panDatum.setBorder(BorderFactory.createTitledBorder("Datum"));
        this.cmdStart.setText("Start !");
        this.cmdStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanAuswertungen.this.cmdStartActionPerformed(evt);
            }
        });
        this.cmdExport.setText("Export ...");
        this.cmdExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanAuswertungen.this.cmdExportActionPerformed(evt);
            }
        });
        this.cmdDiesesJahr.setText("Dieses Jahr");
        this.cmdDiesesJahr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanAuswertungen.this.cmdDiesesJahrActionPerformed(evt);
            }
        });
        this.cmdDieserMonat.setText("Dieser Monat");
        this.cmdDieserMonat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanAuswertungen.this.cmdDieserMonatActionPerformed(evt);
            }
        });
        this.cmdDieseWoche.setText("Diese Woche");
        this.cmdDieseWoche.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanAuswertungen.this.cmdDieseWocheActionPerformed(evt);
            }
        });
        this.cmdHeute.setText("Heute");
        this.cmdHeute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanAuswertungen.this.cmdHeuteActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Zeitraum ab:");
        this.fldAb.setPreferredSize(new Dimension(90, 19));
        this.jLabel2.setText("... bis:");
        this.fldBis.setPreferredSize(new Dimension(90, 19));
        this.jLabel3.setText("(max.");
        this.fldMaxResults.setHorizontalAlignment(11);
        this.fldMaxResults.setText("50");
        this.fldMaxResults.setPreferredSize(new Dimension(40, 19));
        this.jLabel4.setText("Ergebnisse)");
        GroupLayout panDatumLayout = new GroupLayout(this.panDatum);
        this.panDatum.setLayout(panDatumLayout);
        panDatumLayout.setHorizontalGroup(panDatumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDatumLayout.createSequentialGroup().addContainerGap().addGroup(panDatumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDatumLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(12, 12, 12).addComponent(this.fldAb, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldBis, -2, -1, -2).addGap(27, 27, 27).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldMaxResults, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)).addGroup(panDatumLayout.createSequentialGroup().addComponent(this.cmdHeute).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdDieseWoche).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdDieserMonat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panDatumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDatumLayout.createSequentialGroup().addComponent(this.cmdExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdStart)).addComponent(this.cmdDiesesJahr)))).addGap(332, 332, 332)));
        panDatumLayout.setVerticalGroup(panDatumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDatumLayout.createSequentialGroup().addContainerGap().addGroup(panDatumLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fldAb, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.fldBis, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.fldMaxResults, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panDatumLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdHeute).addComponent(this.cmdDieserMonat).addComponent(this.cmdDieseWoche).addComponent(this.cmdDiesesJahr)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panDatumLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdExport).addComponent(this.cmdStart))));
        this.panZeitraum.add(this.panDatum);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panZeitraum, gridBagConstraints);
        this.scrlAnfragen.setBackground(new Color(255, 255, 255));
        this.scrlAnfragen.setBorder(BorderFactory.createTitledBorder(null, "", 0, 5, new Font("DejaVu Sans", 0, 0)));
        this.tabErgebnisse.addTab("Anfragen", this.scrlAnfragen);
        this.scrlTopProdukte.setBackground(new Color(255, 255, 255));
        this.scrlTopProdukte.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("DejaVu Sans", 0, 0)));
        this.tabErgebnisse.addTab("Top-Produkte", this.scrlTopProdukte);
        this.scrlTopEinsatzbereiche.setBackground(new Color(255, 255, 255));
        this.scrlTopEinsatzbereiche.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("DejaVu Sans", 0, 0)));
        this.tabErgebnisse.addTab("Top-Einsatzbereiche", this.scrlTopEinsatzbereiche);
        this.scrlTopVerkaeufer.setBackground(new Color(255, 255, 255));
        this.scrlTopVerkaeufer.setBorder(BorderFactory.createTitledBorder(""));
        this.tabErgebnisse.addTab("Top-Verk\u00e4ufer", this.scrlTopVerkaeufer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabErgebnisse, gridBagConstraints);
    }

    private void cmdStartActionPerformed(ActionEvent evt) {
        try {
            this.execEvaluation(this.evAnfragen);
            this.execEvaluation(this.evTopProdukte);
            this.execEvaluation(this.evTopEinsatzbereiche);
            this.execEvaluation(this.evTopVerkaeufer);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdHeuteActionPerformed(ActionEvent evt) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.session.getLocale());
        GregorianCalendar cal = this.session.getCal();
        Date date = cal.getTime();
        this.fldAb.setText(dateFormat.format(date));
    }

    private void cmdDieserMonatActionPerformed(ActionEvent evt) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.session.getLocale());
        GregorianCalendar cal = this.session.getCal();
        cal.set(5, 1);
        Date date = cal.getTime();
        this.fldAb.setText(dateFormat.format(date));
    }

    private void cmdDieseWocheActionPerformed(ActionEvent evt) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.session.getLocale());
        GregorianCalendar cal = this.session.getCal();
        cal.set(7, 2);
        Date date = cal.getTime();
        this.fldAb.setText(dateFormat.format(date));
    }

    private void cmdDiesesJahrActionPerformed(ActionEvent evt) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.session.getLocale());
        GregorianCalendar cal = this.session.getCal();
        cal.set(6, 1);
        Date date = cal.getTime();
        this.fldAb.setText(dateFormat.format(date));
    }

    private void cmdExportActionPerformed(ActionEvent evt) {
        try {
            if (this.dlgExport == null) {
                this.dlgExport = new DlgExport(this.parent);
            }
            this.setFilterValues(this.evAnfragen);
            this.setFilterValues(this.evTopProdukte);
            this.setFilterValues(this.evTopEinsatzbereiche);
            this.setFilterValues(this.evTopVerkaeufer);
            this.dlgExport.execute(this.evAnfragen, this.evTopProdukte, this.evTopEinsatzbereiche, this.evTopVerkaeufer);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }
}

