/*
 * Decompiled with CFR 0.152.
 */
package popometer;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import popometer.FrmNavigator;
import popometer.SplashScreen;
import popometer.YPopometerDatabase;
import popometer.YPopometerSession;
import popometer.swing.DlgPasswd;
import projektY.base.YAuthenticationException;
import projektY.base.YException;
import projektY.swing.DlgConnect;
import projektY.swing.Utils;
import projektY.utils.YConfigFile;

public class Main {
    private static YConfigFile yConfigFile;
    private static YPopometerSession session;
    private static DlgConnect dlgConnect;

    public static void main(String[] args) {
        int i;
        JFrame loginFenster = new JFrame();
        loginFenster.setIconImage(Main.getImage());
        File popometerHome = null;
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.sqlab.SQlabLookAndFeel");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage() + "\nDas Programm kann trotzdem ausgef\u00fchrt werden.", " Hinweis", 2);
        }
        try {
            File configFile;
            popometerHome = new File(System.getProperty("user.home"), ".popometer");
            if (popometerHome.exists()) {
                if (!popometerHome.isDirectory()) {
                    throw new YException(popometerHome.getAbsolutePath() + " ist kein Verzeichnis.\n" + "Bitte l\u00f6schen Sie diese Datei und starten Sie danach neu.");
                }
            } else if (!popometerHome.mkdir()) {
                throw new YException("Das Verzeichnis kann nicht angelegt werden.");
            }
            if (!(configFile = new File(popometerHome, "/popometer.conf")).exists()) {
                InputStream is = new Main().getClass().getResourceAsStream("/popometer/resourcen/popometer.conf");
                if (is != null) {
                    try {
                        int b;
                        configFile.createNewFile();
                        FileOutputStream os = new FileOutputStream(configFile);
                        while ((b = is.read()) > 0) {
                            os.write(b);
                        }
                        os.close();
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, "Fehler bei der \u00dcbernahme der Anfangskonfiguration:\n" + e1.getMessage() + "\nVor dem Login mu\u00df deshalb die DBURL eingetragen werden.", "Fehler", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Die Anfangskonfiguration fehlt im Softwarepaket.\nVor dem Login mu\u00df deshalb die DBURL eingetragen werden.", "Fehler", 0);
                }
            }
            yConfigFile = new YConfigFile(popometerHome.getAbsolutePath() + "/popometer.conf");
            String[] pathExtensions = new String[]{"", "/images", "/images/thumbs"};
            String cacheDirPathName = yConfigFile.findValue("CACHEDIR");
            boolean setCacheName = false;
            if (cacheDirPathName.length() == 0) {
                cacheDirPathName = popometerHome.getAbsolutePath() + "/cache";
                setCacheName = true;
            }
            for (int iExt = 0; iExt < pathExtensions.length; ++iExt) {
                File cacheDir = new File(cacheDirPathName + pathExtensions[iExt]);
                if (cacheDir.exists()) {
                    if (cacheDir.isDirectory()) continue;
                    throw new YException("Cache kann nicht angelegt werden:\n" + cacheDirPathName + " existiert bereits und ist kein Verzeichnis.");
                }
                if (cacheDir.mkdir()) continue;
                throw new YException("Cache kann nicht angelegt werden:\n" + cacheDirPathName);
            }
            if (setCacheName) {
                yConfigFile.setEntry("CACHEDIR", cacheDirPathName);
                yConfigFile.write();
            }
            String[] imgUrlConfigNames = new String[]{"SITIMG_URL", "BODYIMG_URL"};
            for (int iUrl = 0; iUrl < imgUrlConfigNames.length; ++iUrl) {
                String url = yConfigFile.findValue(imgUrlConfigNames[iUrl]);
                boolean setUrl = false;
                if (url.length() == 0) {
                    i = imgUrlConfigNames[iUrl].indexOf(95);
                    url = "file://" + popometerHome.getAbsolutePath() + "/" + imgUrlConfigNames[iUrl].substring(0, i).toLowerCase();
                    setUrl = true;
                }
                if (!url.startsWith("file://")) {
                    throw new YException(imgUrlConfigNames[iUrl] + "=" + url + ":\n Protokoll wird nicht unterst\u00fctzt.");
                }
                File imgDir = new File(url.substring(7));
                if (imgDir.exists()) {
                    if (!imgDir.isDirectory()) {
                        throw new YException("Bilderspeicher kann nicht angelegt werden:\n" + imgDir.toString() + " existiert bereits und ist kein Verzeichnis.");
                    }
                } else if (!imgDir.mkdirs()) {
                    throw new YException("Bilderverzeichnis kann nicht angelegt werden:\n" + imgDir.toString());
                }
                if (!setUrl) continue;
                yConfigFile.setEntry(imgUrlConfigNames[iUrl], url);
                yConfigFile.write();
            }
        }
        catch (YException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage(), " Fehler", 0);
            System.exit(1);
        }
        String lastLogin = yConfigFile.findValue("LAST_LOGIN");
        dlgConnect = new DlgConnect((Frame)loginFenster, "SQ-Lab Profiler Anmeldung", yConfigFile, true);
        dlgConnect.setUser(lastLogin);
        SplashScreen splashScreen = new SplashScreen();
        boolean versuch1 = true;
        while (true) {
            if (!dlgConnect.execute()) {
                System.exit(0);
            }
            if (versuch1) {
                splashScreen.showFor(5);
            }
            try {
                YPopometerDatabase database = new YPopometerDatabase(dlgConnect.getDriver(), dlgConnect.getURL(), Locale.getDefault());
                session = new YPopometerSession(yConfigFile, popometerHome, database, dlgConnect.getUser(), dlgConnect.getPassword(), splashScreen);
                if (args.length > 0 && args[0].equals("-l")) {
                    database.setSqlLog(true);
                    Main.session.messageLog = true;
                }
                int major = session.getDbversion().getAsInt("major");
                int minor = session.getDbversion().getAsInt("minor");
                int revision = session.getDbversion().getAsInt("revision");
                if (major != 1 || minor < 2 || revision < 11) {
                    int a = JOptionPane.showConfirmDialog(null, "Die Version Ihrer Software pa\u00dft nicht zum verbundenen Server.\nEs ist mit erheblichen Problemen zu rechnen.\nDas Programm trotzdem starten ?", "Versionskonflikt", 2, 0);
                    if (a == 1) {
                        System.exit(1);
                    }
                } else if (minor > 2) {
                    JOptionPane.showMessageDialog(null, "Ihre Software ist nicht aktuell.\n", "Neue Version verf\u00fcgbar", 2);
                }
                yConfigFile.setEntry("LAST_LOGIN", dlgConnect.getUser());
                Popometer popometer = new Popometer(splashScreen);
                EventQueue.invokeLater(popometer);
                break;
            }
            catch (YAuthenticationException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), " Fehler", 0);
            }
            catch (YException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), " Fehler", 0);
                System.exit(1);
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String msg = e.toString();
                for (i = 0; i < stackTrace.length && i < 5; ++i) {
                    msg = msg + "\n" + stackTrace[i];
                }
                JOptionPane.showMessageDialog(null, msg, " Fehler", 0);
                System.exit(1);
            }
            versuch1 = false;
        }
    }

    protected static Image getImage() {
        URL imgURL = Main.class.getResource("pictures/popometer.png");
        if (imgURL != null) {
            return new ImageIcon(imgURL).getImage();
        }
        return null;
    }

    private static class Popometer
    implements Runnable {
        private SplashScreen splashScreen;

        public Popometer(SplashScreen splashScreen) {
            this.splashScreen = splashScreen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int len;
                FrmNavigator frmNavigator = new FrmNavigator(session, yConfigFile, this.splashScreen);
                frmNavigator.setTitle("Profiler - " + dlgConnect.getUser());
                frmNavigator.setSize(1440, 900);
                Utils.centerWindow(frmNavigator);
                frmNavigator.setIconImage(Main.getImage());
                YPopometerDatabase database = (YPopometerDatabase)session.getDatabase();
                database.setPasswdRequestListener(new DlgPasswd(frmNavigator));
                String strTimeout = yConfigFile.findValue("TIMEOUT");
                int intTimeout = 20;
                if (strTimeout.length() > 0) {
                    try {
                        intTimeout = Integer.parseInt(strTimeout);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                database.setTimeout(intTimeout * 60);
                InputStream isFotobeispiel = this.getClass().getResourceAsStream("/popometer/pictures/fotobeispiel.jpeg");
                String bodyImagePath = yConfigFile.findValue("BODYIMAGE");
                FileOutputStream osFotobeispiel = new FileOutputStream(bodyImagePath);
                int bufSize = 100;
                byte[] buf = new byte[100];
                while ((len = isFotobeispiel.read(buf)) > 0) {
                    osFotobeispiel.write(buf, 0, len);
                }
                osFotobeispiel.close();
                isFotobeispiel.close();
                UIManager.put("FileChooser.readOnly", Boolean.TRUE);
                frmNavigator.setVisible(true);
            }
            catch (YException ex) {
                this.splashScreen.wipeOut();
                JOptionPane.showMessageDialog(null, ex.getMessage(), " Fehler", 0);
                System.exit(1);
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String msg = e.toString();
                for (int i = 0; i < stackTrace.length && i < 5; ++i) {
                    msg = msg + "\n" + stackTrace[i];
                }
                this.splashScreen.wipeOut();
                JOptionPane.showMessageDialog(null, msg, " Fehler", 0);
                System.exit(1);
            }
            finally {
                this.splashScreen.wipeOut();
            }
        }
    }
}

