/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

public class HSVWert {
    private int h = 0;
    private int s = 0;
    private int v = 0;
    private int sumR;
    private int sumG;
    private int sumB;
    private int nRGB;

    public void assign(HSVWert hsvWert0) {
        this.h = hsvWert0.h;
        this.s = hsvWert0.s;
        this.v = hsvWert0.v;
    }

    public int getH() {
        return (int)Math.round((double)this.h * 359.0 / 1024.0);
    }

    public int getHAs1024() {
        return this.h;
    }

    public int getS() {
        return (int)Math.round((double)this.s * 100.0 / 255.0);
    }

    public int getS255() {
        return this.s;
    }

    public int getV() {
        return (int)Math.round((double)this.v * 100.0 / 255.0);
    }

    public int getVAs256() {
        return this.v;
    }

    public static int hTo1024(int h) throws IllegalArgumentException {
        if (h < 0 || h > 359) {
            throw new IllegalArgumentException(h + " ist kein g\u00fcltiger Winkel.");
        }
        return (int)((double)(h * 1024) / 360.0);
    }

    public static int svlTo255(int svl) throws IllegalArgumentException {
        if (svl < 0 || svl > 255) {
            throw new IllegalArgumentException(svl + " ist keine g\u00fcltige Prozentangabe.");
        }
        return (int)((double)svl * 2.55);
    }

    public void setAsRGB(int r, int g, int b) {
        int max = r;
        int min = r;
        if (g > max) {
            max = g;
        } else {
            min = g;
        }
        if (b > max) {
            max = b;
        }
        if (b < min) {
            min = b;
        }
        if (max == min) {
            this.h = -1;
        } else {
            float dmm = max - min;
            if (max == r) {
                this.h = (int)(170.67 * (double)(g - b) / (double)dmm);
            } else if (max == g) {
                this.h = (int)(170.67 * (double)(2.0f + (float)(b - r) / dmm));
            } else if (max == b) {
                this.h = (int)(170.67 * (double)(4.0f + (float)(r - g) / dmm));
            }
            if (this.h < 0) {
                this.h += 1024;
            }
        }
        this.s = max == 0 ? 0 : 255 * (max - min) / max;
        this.v = max;
    }

    public void setAsRGB(int rgb) {
        this.setAsRGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public void addRGB(int rgb) {
        this.sumR += rgb >> 16 & 0xFF;
        this.sumG += rgb >> 8 & 0xFF;
        this.sumB += rgb & 0xFF;
        ++this.nRGB;
    }

    public void calcFromRGBSums() {
        if (this.nRGB > 0) {
            this.setAsRGB(this.sumR / this.nRGB, this.sumG / this.nRGB, this.sumB / this.nRGB);
        }
        this.sumR = 0;
        this.sumG = 0;
        this.sumB = 0;
        this.nRGB = 0;
    }
}

