/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.bikeandfit.HSVWert;
import popometer.bikeandfit.Koerperberechnung;
import popometer.bikeandfit.Koerpermasse;
import popometer.bikeandfit.MagischesDreieck;
import popometer.bikeandfit.Parameter;
import popometer.bikeandfit.Treffer;
import popometer.bikeandfit.Trefferliste;
import popometer.dbobjects.YROKunde;
import popometer.forms.DlgFotos;
import popometer.graphics.Messpunkt;
import popometer.panels.PanBikeAndFitImage;
import popometer.panels.PanFotoImage;
import popometer.panels.PanMessung;
import projektY.base.YException;
import projektY.base.YUserException;
import projektY.database.YDetailList;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;
import projektY.database.YSubRowList;
import projektY.swing.YJPanelManager;
import projektY.utils.YConfigFile;

public class PanKoerper
extends PanMessung {
    private File fotoCmdFile;
    private File fotoImageFile;
    private BufferedImage imgFoto;
    private VerwalteteParameter parameter;
    private AngezeigteKoerpermasse koerpermasse;
    private Image defaultImage;
    private PanFotoImage panFotoImage;
    private Koerperberechnung koerperberechnung;
    private DlgFotos dlgFotos;
    private JFileChooser openJpegDialog;
    private Point messbereichstart;
    private Point messbereichend;
    private YDetailList kundeneinsbed;
    private final int einsbereichIdSitzknochen;
    private ButtonGroup bgBlickrichtung;
    private ButtonGroup bgMesspunktsuche;
    private JButton cmdBeispielbild;
    private JButton cmdDreieckBerechnen;
    private JButton cmdFotoSchiessen;
    private JButton cmdKalibrierungSpeichern;
    private JButton cmdKalibrierungWiederherstellen;
    private JButton cmdLetzteFotos;
    private JButton cmdMagischesDreieck;
    private JButton cmdMesspunktParameterSpeichern;
    private JButton cmdMesspunktParameterWiederherstellen;
    private JButton cmdMesspunktsuche;
    private JButton cmdMesspunktsuche2;
    private JTextField fldAbstandSitzGriff;
    private JTextField fldBminKorona;
    private JTextField fldHmaxKorona;
    private JTextField fldHminKorona;
    private JTextField fldHueftabstand;
    public JTextField fldLOberarm;
    public JTextField fldLOberkoerper;
    public JTextField fldLOberschenkel;
    public JTextField fldLUnterarm;
    public JTextField fldLUnterschenkel;
    private JTextField fldOffsetFussX;
    private JTextField fldOffsetFussY;
    private JTextField fldOffsetHandX;
    private JTextField fldOffsetHandY;
    private JTextField fldOffsetHuefteX;
    private JTextField fldOffsetHuefteY;
    private JTextField fldPedallaenge;
    private JTextField fldRmaxAussen;
    private JTextField fldRminInnen;
    private JTextField fldSmaxInnen;
    private JTextField fldSminKorona;
    private JTextField fldVminInnen;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel lblDreieck;
    public JLabel lblDreieckLinks;
    public JLabel lblDreieckOben;
    public JLabel lblDreieckRechts;
    private JLabel lblFehlermeldung;
    private JLabel lblProblem;
    private JLabel lblStatusmeldung;
    public JLabel lblWinkel;
    private JPanel panDreieck;
    private JPanel panDreieckBild;
    private JTabbedPane panEinrichtung;
    private JPanel panFotoSchiessen;
    private JPanel panGeometrie;
    private JPanel panInnenpunkt;
    private JPanel panKalibrierung;
    private JPanel panKalibrierungSpeichern;
    private JPanel panKoerperMasse;
    private JPanel panKoronapunkt;
    private JPanel panMesspunkte;
    private JPanel panMesspunkteSpeichern;
    private JPanel panMesspunktsuche;
    private JPanel panMessung;
    private JRadioButton rbBlickLinks;
    private JRadioButton rbBlickRechts;
    private JRadioButton rbManuell;
    private JRadioButton rbNurFahrrad;
    private JRadioButton rbVollautomatisch;
    private JScrollPane scrlImage;
    private JScrollPane scrlMessung;
    private JTabbedPane tabControl;

    public PanKoerper(YPopometerSession session, YROKunde kunde, FrmNavigator frmNavigator) throws YException {
        super(session, kunde, frmNavigator);
        this.parameter = new VerwalteteParameter(session.getConfigFile());
        this.koerperberechnung = new Koerperberechnung(this.parameter);
        this.dlgFotos = null;
        this.panFotoImage = new PanBikeAndFitImage(this.koerperberechnung);
        this.panFotoImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PanKoerper.this.fotoMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PanKoerper.this.fotoMousePressed(e);
            }
        });
        this.panFotoImage.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PanKoerper.this.fotoMouseDragged(e);
            }
        });
        this.initComponents();
        this.parameter.setInput();
        this.koerpermasse = new AngezeigteKoerpermasse();
        YJPanelManager.createPanelManager(this.panKoerperMasse, kunde);
        this.fotoCmdFile = session.createFotoCmd();
        this.fotoImageFile = session.createBodyImage();
        this.defaultImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/popometer/pictures/fotobeispiel.jpeg"));
        this.changePicture(this.defaultImage);
        this.lblStatusmeldung.setText(BfStatus.BFSTATUS_BEREIT.toString());
        this.setFehlermeldung("");
        YRowObjectList einsatzbereiche = session.getRowObjectList("vs_einsatzbereiche");
        int iRow = einsatzbereiche.find("sitzknochenabstand", "messgroesse_teilbereich");
        if (iRow < 0) {
            iRow = einsatzbereiche.find("_sitzknochenabstand", "messgroesse_teilbereich");
        }
        if (iRow < 0) {
            throw new YException("Kein Einsatzteilbereich 'sitzknochenabstand' oder '_sitzknochenabstand'");
        }
        this.kundeneinsbed = kunde.getDetailList("vh_kundeneinsbed");
        this.einsbereichIdSitzknochen = einsatzbereiche.getAsInt(iRow, "einsbereich_id");
    }

    public void fotoMousePressed(MouseEvent e) {
        if (this.koerperberechnung.messpunkte.fotoMousePressed(e)) {
            this.panFotoImage.repaint();
        }
    }

    public void fotoMouseDragged(MouseEvent e) {
        if (this.koerperberechnung.messpunkte.fotoMouseDragged(e)) {
            this.panFotoImage.repaint();
        }
    }

    public void fotoMouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            Dimension offset = new Dimension();
            Messpunkt messpunkt = this.koerperberechnung.messpunkte.findeMesspunkt(offset, e);
            if (messpunkt == null) {
                return;
            }
            this.parameter.getFromInput();
            this.checkPixel(messpunkt.x, messpunkt.y, this.parameter, null, true);
            return;
        }
        boolean repaint = this.koerperberechnung.messpunkte.fotoMouseClicked(e);
        if (this.koerperberechnung.messpunkte.messpunktVerschoben) {
            this.koerperberechnung.messpunkte.messpunktVerschoben = false;
            try {
                StringBuffer fehler = new StringBuffer();
                BfStatus status = this.bikeAndFit(BfStart.BFSTART_BENENNEN, fehler);
                this.lblStatusmeldung.setText(status.toString());
                this.setFehlermeldung(fehler.toString());
            }
            catch (YException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Fehler", 0);
            }
        }
        if (repaint) {
            this.panFotoImage.repaint();
        }
    }

    private void setFehlermeldung(String text) {
        this.lblFehlermeldung.setText(text);
        this.lblProblem.setVisible(text.length() > 0);
    }

    private boolean turboCheckPixel(int x, int y, Parameter parameter) {
        return true;
    }

    private boolean checkPixel(int mpX, int mpY, Parameter parameter, Treffer treffer, boolean dbglog) {
        int x = mpX;
        int y = mpY;
        HSVWert hsvRing0 = new HSVWert();
        HSVWert hsvRing = new HSVWert();
        int nDddVS0 = 0;
        int r = 0;
        int r2 = 0;
        int d = 0;
        int[] eH = new int[parameter.maxRAussen + 1];
        int[] eS = new int[parameter.maxRAussen + 1];
        int[] eDddVS = new int[parameter.maxRAussen + 1];
        int iDddVSMin = -1;
        int rgb = this.imgFoto.getRGB(x, y);
        hsvRing0.setAsRGB(rgb);
        int ddVS0 = 0;
        eDddVS[0] = 0;
        eDddVS[1] = 0;
        int dddVSMin = 0;
        if (hsvRing0.getVAs256() < parameter.minVInnen) {
            return false;
        }
        eS[0] = hsvRing0.getS255();
        try {
            for (r = 1; r <= parameter.maxRAussen; ++r) {
                x = mpX - r;
                y = mpY - r;
                d = -r;
                while (d <= r) {
                    hsvRing.addRGB(this.imgFoto.getRGB(x, y));
                    ++d;
                    ++x;
                }
                x = mpX - r;
                y = mpY + r;
                d = -r;
                while (d <= r) {
                    hsvRing.addRGB(this.imgFoto.getRGB(x, y));
                    ++d;
                    ++x;
                }
                r2 = r - 2;
                x = mpX - r;
                y = mpY - r + 1;
                d = -r;
                while (d <= r2) {
                    hsvRing.addRGB(this.imgFoto.getRGB(x, y));
                    ++d;
                    ++y;
                }
                x = mpX + r;
                y = mpY - r + 1;
                d = -r;
                while (d <= r2) {
                    hsvRing.addRGB(this.imgFoto.getRGB(x, y));
                    ++d;
                    ++y;
                }
                hsvRing.calcFromRGBSums();
                int dVS0 = hsvRing0.getV() - hsvRing0.getS();
                int dVS = hsvRing.getV() - hsvRing.getS();
                int ddVS = dVS - dVS0;
                eH[r] = hsvRing.getHAs1024();
                eS[r] = hsvRing.getS255();
                if (r > 1) {
                    int dddVS;
                    eDddVS[r] = dddVS = ddVS - ddVS0;
                    if (eDddVS[r] < dddVSMin) {
                        dddVSMin = eDddVS[r];
                        iDddVSMin = r;
                    }
                    if (dddVS > 0) break;
                    if (dddVS == 0) {
                        if (++nDddVS0 > 2) {
                            return false;
                        }
                    } else {
                        nDddVS0 = 0;
                    }
                }
                if (ddVS > 0) {
                    return false;
                }
                if (iDddVSMin < 0 && hsvRing.getVAs256() < parameter.minVInnen) {
                    return false;
                }
                ddVS0 = ddVS;
                hsvRing0.assign(hsvRing);
            }
            if (iDddVSMin < parameter.minRInnen) {
                return false;
            }
            int bKorona = r - iDddVSMin + 1;
            if (bKorona < parameter.minBKorona) {
                return false;
            }
            int sSI = 0;
            for (d = 0; d < iDddVSMin; ++d) {
                sSI += eS[d];
            }
            if ((sSI /= iDddVSMin) > parameter.maxSInnen) {
                return false;
            }
            int sSK = 0;
            for (d = iDddVSMin; d <= r; ++d) {
                sSK += eS[d];
            }
            if ((sSK /= bKorona) < parameter.minSKorona) {
                return false;
            }
            int sH = 0;
            for (d = iDddVSMin; d <= r; ++d) {
                sH += eH[d];
            }
            if ((sH = (int)Math.round((double)(sH / bKorona) * 359.0 / 1024.0)) < parameter.minHKorona || sH > parameter.maxHKorona) {
                return false;
            }
            treffer.set(mpX, mpY, r);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (dbglog) {
                System.out.printf("%s: mpX=%d, mpY=%d, x=%d, y=%d, r=%d, r2=%d, d=%d\n", e.toString(), mpX, mpY, x, y, r, r2, d);
            }
            return false;
        }
    }

    private int messpunktsuche(boolean dbglog) {
        Treffer treffer = new Treffer();
        Trefferliste trefferListe = new Trefferliste();
        int rand = this.parameter.maxRAussen + 1;
        this.parameter.getFromInput();
        int sizeX = this.imgFoto.getWidth() - rand;
        int sizeY = this.imgFoto.getHeight() - rand;
        if (dbglog) {
            System.out.printf("Bildgr\u00f6\u00dfe: %d x %d\n", this.imgFoto.getWidth(), this.imgFoto.getHeight());
        }
        for (int x = rand; x < sizeX; ++x) {
            for (int y = rand; y < sizeY; ++y) {
                if (!this.checkPixel(x, y, this.parameter, treffer, dbglog)) continue;
                if (dbglog) {
                    System.out.printf("Gefunden: x=%d, y=%d\n", x, y);
                }
                trefferListe.add(treffer);
            }
        }
        this.koerperberechnung.messpunkte.resetAktiv();
        this.koerperberechnung.koerperpunkte.abgeleitet = false;
        this.koerperberechnung.messpunkte.init();
        int i = this.koerperberechnung.messpunkte.get().size();
        for (int it = 0; it < trefferListe.getCount() && --i >= 0; ++it) {
            Messpunkt m = this.koerperberechnung.messpunkte.get(i);
            treffer = trefferListe.getTreffer(it);
            m.move(treffer.getX(), treffer.getY());
        }
        this.panFotoImage.repaint();
        return trefferListe.getCount();
    }

    private int findPosNrSitzhaltung() throws YException {
        this.kunde.requestValuesToStore();
        YRowValues rvKundeneinsbed = this.kundeneinsbed.findRow(String.valueOf(this.einsbereichIdSitzknochen), "einsbereich_id");
        if (rvKundeneinsbed == null) {
            return 0;
        }
        String strEinsbedingungId = rvKundeneinsbed.getAsString("einsbedingung_id");
        YSubRowList srlEinsatzbedingungen = (YSubRowList)this.session.getRowObjectList("vs_einsatzbereiche").getSubRowList("einsatzbedingungen");
        YRowValues rvEinsatzbedingung = srlEinsatzbedingungen.findRow(strEinsbedingungId, "einsbedingung_id");
        if (rvEinsatzbedingung == null) {
            throw new YException("Nicht existierende Einsatzbedingung id=" + strEinsbedingungId);
        }
        return rvEinsatzbedingung.getAsInt("pos_nr");
    }

    private void berechneDreieck() {
        StringBuffer fehler = new StringBuffer();
        try {
            BfStatus status = this.bikeAndFit(BfStart.BFSTART_DREIECK, fehler);
            this.lblStatusmeldung.setText(status.toString());
        }
        catch (YException e) {
            fehler.append(e.toString());
        }
        this.setFehlermeldung(fehler.toString());
    }

    private void loescheMasse(boolean alleMasse) {
        if (alleMasse) {
            this.fldLOberarm.setText("");
            this.fldLOberkoerper.setText("");
            this.fldLOberschenkel.setText("");
            this.fldLUnterarm.setText("");
            this.fldLUnterschenkel.setText("");
            this.cmdDreieckBerechnen.setEnabled(false);
        }
        this.lblDreieckOben.setVisible(false);
        this.lblDreieckLinks.setVisible(false);
        this.lblDreieckRechts.setVisible(false);
        this.lblWinkel.setVisible(false);
        this.cmdMagischesDreieck.setEnabled(false);
    }

    private BfStatus bikeAndFit(BfStart startPunkt, StringBuffer fehler) throws YException {
        fehler.setLength(0);
        switch (startPunkt) {
            case BFSTART_SUCHE: {
                this.loescheMasse(true);
                int nGefunden = this.messpunktsuche(true);
                int nGesucht = this.rbNurFahrrad.isSelected() ? 5 : 8;
                switch (nGefunden) {
                    case 8: {
                        break;
                    }
                    case 5: {
                        if (nGesucht == 5) {
                            return BfStatus.BFSTATUS_GEFUNDEN;
                        }
                    }
                    default: {
                        fehler.append(String.format("%d statt %d Me\u00dfpunkte gefunden", nGefunden, nGesucht));
                        return nGefunden > 0 ? BfStatus.BFSTATUS_GEFUNDEN : BfStatus.BFSTATUS_BEREIT;
                    }
                }
            }
            case BFSTART_BENENNEN: {
                if (startPunkt == BfStart.BFSTART_BENENNEN) {
                    this.loescheMasse(true);
                }
                if (!this.koerperberechnung.messpunkte.benennen8(this.parameter.blickrichtungRechts)) {
                    this.koerperberechnung.koerperpunkte.abgeleitet = false;
                    this.panFotoImage.repaint();
                    fehler.append("Unklare Me\u00dfpunktverteilung");
                    return BfStatus.BFSTATUS_GEFUNDEN;
                }
                this.koerperberechnung.kalibrieren();
                this.koerperberechnung.koerperpunkteAbleiten();
                this.panFotoImage.repaint();
                this.koerpermasse.set(this.koerperberechnung.berechneKoerpermasse());
                if (this.koerpermasse.absurd()) {
                    this.koerperberechnung.koerperpunkte.abgeleitet = false;
                    this.panFotoImage.repaint();
                    fehler.append("Absurde K\u00f6rperma\u00dfe");
                    return BfStatus.BFSTATUS_GEFUNDEN;
                }
                this.koerpermasse.setInput();
            }
            case BFSTART_DREIECK: {
                int winkelsatzId;
                if (startPunkt == BfStart.BFSTART_DREIECK) {
                    this.loescheMasse(false);
                    if (!this.koerpermasse.getInput()) {
                        fehler.append("K\u00f6rperma\u00dfe unvollst\u00e4ndig");
                        return BfStatus.BFSTATUS_BEREIT;
                    }
                }
                if ((winkelsatzId = this.findPosNrSitzhaltung()) == 0) {
                    fehler.append("Sitzposition nicht eingegeben");
                    return BfStatus.BFSTATUS_KOERPER_BERECHNET;
                }
                MagischesDreieck magischesDreieck = this.koerperberechnung.magischesDreieck;
                magischesDreieck.berechnen(winkelsatzId, this.koerpermasse);
                this.lblDreieckOben.setText(String.format("%2.1f", Float.valueOf(magischesDreieck.getOben())));
                this.lblDreieckOben.setVisible(true);
                this.lblDreieckLinks.setText(String.format("%2.1f", Float.valueOf(magischesDreieck.getHinten())));
                this.lblDreieckLinks.setVisible(true);
                this.lblDreieckRechts.setText(String.format("%2.1f", Float.valueOf(magischesDreieck.getVorn())));
                this.lblDreieckRechts.setVisible(true);
                this.lblWinkel.setText(String.format("%2.1f\u00b0", Float.valueOf(magischesDreieck.getNeigungswinkel())));
                this.lblWinkel.setVisible(true);
                this.cmdMagischesDreieck.setEnabled(true);
                return BfStatus.BFSTATUS_DREIECK_BERECHNET;
            }
        }
        return BfStatus.BFSTATUS_NULL;
    }

    @Override
    protected void neuerKunde() throws YException {
        this.changePicture(this.defaultImage);
        this.lblStatusmeldung.setText(BfStatus.BFSTATUS_BEREIT.toString());
        this.setFehlermeldung("");
    }

    private void initComponents() {
        this.bgMesspunktsuche = new ButtonGroup();
        this.bgBlickrichtung = new ButtonGroup();
        this.scrlImage = new JScrollPane();
        this.scrlImage.setViewportView(this.panFotoImage);
        this.scrlMessung = new JScrollPane();
        this.panMessung = new JPanel();
        this.panKoerperMasse = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldLUnterarm = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldLOberarm = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldLOberkoerper = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldLOberschenkel = new JTextField();
        this.jLabel6 = new JLabel();
        this.fldLUnterschenkel = new JTextField();
        this.panDreieck = new JPanel();
        this.panDreieckBild = new JPanel();
        this.lblDreieckOben = new JLabel();
        this.lblDreieckOben.setVisible(false);
        this.lblDreieckLinks = new JLabel();
        this.lblDreieckLinks.setVisible(false);
        this.lblDreieckRechts = new JLabel();
        this.lblDreieckRechts.setVisible(false);
        this.lblDreieck = new JLabel();
        this.lblWinkel = new JLabel();
        this.lblWinkel.setVisible(false);
        this.cmdDreieckBerechnen = new JButton();
        this.cmdMagischesDreieck = new JButton();
        this.tabControl = new JTabbedPane();
        this.panFotoSchiessen = new JPanel();
        this.cmdFotoSchiessen = new JButton();
        this.lblFehlermeldung = new JLabel();
        this.lblStatusmeldung = new JLabel();
        this.cmdBeispielbild = new JButton();
        this.jLabel30 = new JLabel();
        this.lblProblem = new JLabel();
        this.cmdLetzteFotos = new JButton();
        this.panEinrichtung = new JTabbedPane();
        this.panKalibrierung = new JPanel();
        this.cmdMesspunktsuche = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel18 = new JLabel();
        this.fldAbstandSitzGriff = new JTextField();
        this.fldOffsetHuefteX = new JTextField();
        this.fldOffsetHuefteY = new JTextField();
        this.fldOffsetHandX = new JTextField();
        this.fldOffsetHandY = new JTextField();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel25 = new JLabel();
        this.fldOffsetFussX = new JTextField();
        this.fldOffsetFussY = new JTextField();
        this.panKalibrierungSpeichern = new JPanel();
        this.cmdKalibrierungSpeichern = new JButton();
        this.cmdKalibrierungWiederherstellen = new JButton();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.fldHueftabstand = new JTextField();
        this.fldPedallaenge = new JTextField();
        this.jLabel29 = new JLabel();
        this.jLabel31 = new JLabel();
        this.rbBlickLinks = new JRadioButton();
        this.rbBlickRechts = new JRadioButton();
        this.panMesspunkte = new JPanel();
        this.panMesspunktsuche = new JPanel();
        this.rbVollautomatisch = new JRadioButton();
        this.rbNurFahrrad = new JRadioButton();
        this.rbManuell = new JRadioButton();
        this.panMesspunkteSpeichern = new JPanel();
        this.cmdMesspunktParameterSpeichern = new JButton();
        this.cmdMesspunktParameterWiederherstellen = new JButton();
        this.cmdMesspunktsuche2 = new JButton();
        this.panInnenpunkt = new JPanel();
        this.jLabel32 = new JLabel();
        this.fldVminInnen = new JTextField();
        this.jLabel33 = new JLabel();
        this.fldSmaxInnen = new JTextField();
        this.panKoronapunkt = new JPanel();
        this.jLabel7 = new JLabel();
        this.fldHminKorona = new JTextField();
        this.jLabel8 = new JLabel();
        this.fldHmaxKorona = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldSminKorona = new JTextField();
        this.panGeometrie = new JPanel();
        this.fldBminKorona = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.fldRminInnen = new JTextField();
        this.jLabel12 = new JLabel();
        this.fldRmaxAussen = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.setLayout(new BorderLayout());
        this.scrlImage.setBackground(new Color(255, 255, 255));
        this.add((Component)this.scrlImage, "Center");
        this.scrlMessung.setHorizontalScrollBarPolicy(31);
        this.scrlMessung.setVerticalScrollBarPolicy(22);
        this.panMessung.setLayout(new GridBagLayout());
        this.panKoerperMasse.setBackground(new Color(255, 255, 255));
        this.panKoerperMasse.setBorder(BorderFactory.createTitledBorder("L\u00e4ngen (cm):"));
        this.panKoerperMasse.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.fldLUnterarm);
        this.jLabel2.setText("Unterarm:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel2, gridBagConstraints);
        this.fldLUnterarm.setHorizontalAlignment(4);
        this.fldLUnterarm.setMinimumSize(new Dimension(80, 19));
        this.fldLUnterarm.setName("l_unterarm");
        this.fldLUnterarm.setPreferredSize(new Dimension(40, 19));
        this.fldLUnterarm.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLUnterarmFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLUnterarm, gridBagConstraints);
        this.jLabel3.setLabelFor(this.fldLOberarm);
        this.jLabel3.setText("Oberarm:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel3, gridBagConstraints);
        this.fldLOberarm.setHorizontalAlignment(4);
        this.fldLOberarm.setName("l_oberarm");
        this.fldLOberarm.setPreferredSize(new Dimension(40, 19));
        this.fldLOberarm.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberarmFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberarm, gridBagConstraints);
        this.jLabel4.setLabelFor(this.fldLOberkoerper);
        this.jLabel4.setText("Oberk\u00f6rper+Sitz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel4, gridBagConstraints);
        this.fldLOberkoerper.setHorizontalAlignment(4);
        this.fldLOberkoerper.setName("l_oberkoerper");
        this.fldLOberkoerper.setPreferredSize(new Dimension(40, 19));
        this.fldLOberkoerper.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberkoerperFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberkoerper, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fldLOberschenkel);
        this.jLabel5.setText("Oberschenkel:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel5, gridBagConstraints);
        this.fldLOberschenkel.setHorizontalAlignment(4);
        this.fldLOberschenkel.setName("l_oberschenkel");
        this.fldLOberschenkel.setPreferredSize(new Dimension(40, 19));
        this.fldLOberschenkel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberschenkelFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberschenkel, gridBagConstraints);
        this.jLabel6.setLabelFor(this.fldLUnterschenkel);
        this.jLabel6.setText("Unterschenkel+Ferse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panKoerperMasse.add((Component)this.jLabel6, gridBagConstraints);
        this.fldLUnterschenkel.setHorizontalAlignment(4);
        this.fldLUnterschenkel.setName("l_unterschenkel");
        this.fldLUnterschenkel.setPreferredSize(new Dimension(40, 19));
        this.fldLUnterschenkel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLUnterschenkelFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLUnterschenkel, gridBagConstraints);
        this.panDreieck.setPreferredSize(new Dimension(208, 213));
        this.panDreieck.setLayout(new GridBagLayout());
        this.panDreieckBild.setPreferredSize(new Dimension(220, 220));
        this.panDreieckBild.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblDreieckOben.setHorizontalAlignment(11);
        this.lblDreieckOben.setText("77");
        this.lblDreieckOben.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblDreieckOben, new AbsoluteConstraints(80, 24, -1, -1));
        this.lblDreieckLinks.setHorizontalAlignment(11);
        this.lblDreieckLinks.setText("97");
        this.lblDreieckLinks.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblDreieckLinks, new AbsoluteConstraints(10, 110, 30, -1));
        this.lblDreieckRechts.setText("84");
        this.lblDreieckRechts.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblDreieckRechts, new AbsoluteConstraints(140, 110, -1, -1));
        this.lblDreieck.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/magischesDreieck.gif")));
        this.lblDreieck.setIconTextGap(0);
        this.panDreieckBild.add((Component)this.lblDreieck, new AbsoluteConstraints(0, 0, -1, -1));
        this.lblWinkel.setHorizontalAlignment(11);
        this.lblWinkel.setText("5\u00b0");
        this.lblWinkel.setPreferredSize(new Dimension(32, 15));
        this.panDreieckBild.add((Component)this.lblWinkel, new AbsoluteConstraints(174, 180, -1, -1));
        this.panDreieck.add((Component)this.panDreieckBild, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        this.panKoerperMasse.add((Component)this.panDreieck, gridBagConstraints);
        this.cmdDreieckBerechnen.setText("(Neu) Berechnen");
        this.cmdDreieckBerechnen.setEnabled(false);
        this.cmdDreieckBerechnen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdDreieckBerechnenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKoerperMasse.add((Component)this.cmdDreieckBerechnen, gridBagConstraints);
        this.cmdMagischesDreieck.setText("O.K.");
        this.cmdMagischesDreieck.setToolTipText("Rahmen ermitteln");
        this.cmdMagischesDreieck.setEnabled(false);
        this.cmdMagischesDreieck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMagischesDreieckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panKoerperMasse.add((Component)this.cmdMagischesDreieck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.panMessung.add((Component)this.panKoerperMasse, gridBagConstraints);
        this.tabControl.setBackground(new Color(255, 255, 255));
        this.tabControl.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tabControl.setTabPlacement(3);
        this.panFotoSchiessen.setBackground(new Color(255, 255, 255));
        this.panFotoSchiessen.setAlignmentX(0.0f);
        this.panFotoSchiessen.setAlignmentY(0.0f);
        this.panFotoSchiessen.setPreferredSize(new Dimension(0, 15));
        this.panFotoSchiessen.setRequestFocusEnabled(false);
        this.panFotoSchiessen.setLayout(new GridBagLayout());
        this.cmdFotoSchiessen.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/kamera.png")));
        this.cmdFotoSchiessen.setText("Foto schiessen ...");
        this.cmdFotoSchiessen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdFotoSchiessenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.panFotoSchiessen.add((Component)this.cmdFotoSchiessen, gridBagConstraints);
        this.lblFehlermeldung.setText("Das ist ein m\u00f6glicher Fehlertext.");
        this.lblFehlermeldung.setPreferredSize(new Dimension(240, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.panFotoSchiessen.add((Component)this.lblFehlermeldung, gridBagConstraints);
        this.lblStatusmeldung.setText("Das ist der Berechnungsstatus.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panFotoSchiessen.add((Component)this.lblStatusmeldung, gridBagConstraints);
        this.cmdBeispielbild.setText("Beispielfoto \u00f6ffnen ...");
        this.cmdBeispielbild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdBeispielbildActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(40, 0, 0, 0);
        this.panFotoSchiessen.add((Component)this.cmdBeispielbild, gridBagConstraints);
        this.jLabel30.setText("Bike & Fit Status:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panFotoSchiessen.add((Component)this.jLabel30, gridBagConstraints);
        this.lblProblem.setText("Problem:");
        this.lblProblem.setPreferredSize(new Dimension(240, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.panFotoSchiessen.add((Component)this.lblProblem, gridBagConstraints);
        this.cmdLetzteFotos.setText("Letzte Fotos ...");
        this.cmdLetzteFotos.setEnabled(false);
        this.cmdLetzteFotos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdLetzteFotosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.panFotoSchiessen.add((Component)this.cmdLetzteFotos, gridBagConstraints);
        this.tabControl.addTab("Foto", this.panFotoSchiessen);
        this.panKalibrierung.setLayout(new GridBagLayout());
        this.cmdMesspunktsuche.setText("Me\u00dfpunkte suchen");
        this.cmdMesspunktsuche.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktsucheActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.panKalibrierung.add((Component)this.cmdMesspunktsuche, gridBagConstraints);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Abstand der Kalibrierungspunkte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.panKalibrierung.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel15.setText("Versatz Me\u00dfpunkt-K\u00f6rperpunkt bei Blickrichtung rechts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setFont(new Font("Dialog", 0, 12));
        this.jLabel16.setText("Sitz -> H\u00fcfte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 16;
        this.panKalibrierung.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel18.setFont(new Font("Dialog", 0, 12));
        this.jLabel18.setText("Lenker -> Hand");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 16;
        this.panKalibrierung.add((Component)this.jLabel18, gridBagConstraints);
        this.fldAbstandSitzGriff.setHorizontalAlignment(4);
        this.fldAbstandSitzGriff.setText("70");
        this.fldAbstandSitzGriff.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldAbstandSitzGriff, gridBagConstraints);
        this.fldOffsetHuefteX.setHorizontalAlignment(4);
        this.fldOffsetHuefteX.setText("5");
        this.fldOffsetHuefteX.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldOffsetHuefteX, gridBagConstraints);
        this.fldOffsetHuefteY.setHorizontalAlignment(4);
        this.fldOffsetHuefteY.setText("15");
        this.fldOffsetHuefteY.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldOffsetHuefteY, gridBagConstraints);
        this.fldOffsetHandX.setHorizontalAlignment(4);
        this.fldOffsetHandX.setText("0");
        this.fldOffsetHandX.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldOffsetHandX, gridBagConstraints);
        this.fldOffsetHandY.setHorizontalAlignment(4);
        this.fldOffsetHandY.setText("0");
        this.fldOffsetHandY.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldOffsetHandY, gridBagConstraints);
        this.jLabel20.setFont(new Font("Dialog", 0, 12));
        this.jLabel20.setText("(Ma\u00dfe in cm)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setFont(new Font("Dialog", 0, 12));
        this.jLabel21.setText("horizontal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel22.setFont(new Font("Dialog", 0, 12));
        this.jLabel22.setText("vertikal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setFont(new Font("Dialog", 0, 12));
        this.jLabel23.setText("horizontal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setFont(new Font("Dialog", 0, 12));
        this.jLabel24.setText("vertikal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel17.setFont(new Font("Dialog", 0, 12));
        this.jLabel17.setText("Pedal -> Fu\u00df");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 16;
        this.panKalibrierung.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabel19.setFont(new Font("Dialog", 0, 12));
        this.jLabel19.setText("horizontal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel19, gridBagConstraints);
        this.jLabel25.setFont(new Font("Dialog", 0, 12));
        this.jLabel25.setText("vertikal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel25, gridBagConstraints);
        this.fldOffsetFussX.setHorizontalAlignment(4);
        this.fldOffsetFussX.setText("2,5");
        this.fldOffsetFussX.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldOffsetFussX, gridBagConstraints);
        this.fldOffsetFussY.setHorizontalAlignment(4);
        this.fldOffsetFussY.setText("3");
        this.fldOffsetFussY.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldOffsetFussY, gridBagConstraints);
        this.cmdKalibrierungSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/save.gif")));
        this.cmdKalibrierungSpeichern.setToolTipText("Einstellungen speichern");
        this.cmdKalibrierungSpeichern.setMaximumSize(new Dimension(25, 25));
        this.cmdKalibrierungSpeichern.setMinimumSize(new Dimension(25, 25));
        this.cmdKalibrierungSpeichern.setPreferredSize(new Dimension(25, 25));
        this.cmdKalibrierungSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdKalibrierungSpeichernActionPerformed(evt);
            }
        });
        this.panKalibrierungSpeichern.add(this.cmdKalibrierungSpeichern);
        this.cmdKalibrierungWiederherstellen.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/undo.gif")));
        this.cmdKalibrierungWiederherstellen.setToolTipText("Zuletzt gespeichere Einstellungen wiederherstellen");
        this.cmdKalibrierungWiederherstellen.setMaximumSize(new Dimension(25, 25));
        this.cmdKalibrierungWiederherstellen.setMinimumSize(new Dimension(25, 25));
        this.cmdKalibrierungWiederherstellen.setPreferredSize(new Dimension(25, 25));
        this.cmdKalibrierungWiederherstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdKalibrierungWiederherstellenActionPerformed(evt);
            }
        });
        this.panKalibrierungSpeichern.add(this.cmdKalibrierungWiederherstellen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.panKalibrierungSpeichern, gridBagConstraints);
        this.jLabel26.setText("Berechnung des \"Magischen Dreiecks\":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setFont(new Font("Dialog", 0, 12));
        this.jLabel27.setText("Abstand H\u00fcfte -> links oben:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 16;
        this.panKalibrierung.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel28.setFont(new Font("Dialog", 0, 12));
        this.jLabel28.setText("Pedall\u00e4nge:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 16;
        this.panKalibrierung.add((Component)this.jLabel28, gridBagConstraints);
        this.fldHueftabstand.setHorizontalAlignment(4);
        this.fldHueftabstand.setText("8");
        this.fldHueftabstand.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldHueftabstand, gridBagConstraints);
        this.fldPedallaenge.setHorizontalAlignment(4);
        this.fldPedallaenge.setText("17");
        this.fldPedallaenge.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldPedallaenge, gridBagConstraints);
        this.jLabel29.setText("Me\u00dffahrrad:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panKalibrierung.add((Component)this.jLabel29, gridBagConstraints);
        this.jLabel31.setText("Fahrer blickt nach:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panKalibrierung.add((Component)this.jLabel31, gridBagConstraints);
        this.bgBlickrichtung.add(this.rbBlickLinks);
        this.rbBlickLinks.setFont(new Font("Dialog", 0, 12));
        this.rbBlickLinks.setText("links.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panKalibrierung.add((Component)this.rbBlickLinks, gridBagConstraints);
        this.bgBlickrichtung.add(this.rbBlickRechts);
        this.rbBlickRechts.setFont(new Font("Dialog", 0, 12));
        this.rbBlickRechts.setSelected(true);
        this.rbBlickRechts.setText("rechts.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panKalibrierung.add((Component)this.rbBlickRechts, gridBagConstraints);
        this.panEinrichtung.addTab("Kalibrierung", this.panKalibrierung);
        this.panMesspunkte.setBackground(new Color(255, 255, 255));
        this.panMesspunkte.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.panMesspunkte.setLayout(new GridBagLayout());
        this.panMesspunktsuche.setBorder(BorderFactory.createTitledBorder("Automatisch gesuchte Me\u00dfpunkte:"));
        this.bgMesspunktsuche.add(this.rbVollautomatisch);
        this.rbVollautomatisch.setFont(new Font("Dialog", 0, 12));
        this.rbVollautomatisch.setSelected(true);
        this.rbVollautomatisch.setText("Alle");
        this.panMesspunktsuche.add(this.rbVollautomatisch);
        this.bgMesspunktsuche.add(this.rbNurFahrrad);
        this.rbNurFahrrad.setFont(new Font("Dialog", 0, 12));
        this.rbNurFahrrad.setText("Nur die am Fahrrad");
        this.panMesspunktsuche.add(this.rbNurFahrrad);
        this.bgMesspunktsuche.add(this.rbManuell);
        this.rbManuell.setFont(new Font("Dialog", 0, 12));
        this.rbManuell.setText("Keiner");
        this.panMesspunktsuche.add(this.rbManuell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.panMesspunkte.add((Component)this.panMesspunktsuche, gridBagConstraints);
        this.cmdMesspunktParameterSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/save.gif")));
        this.cmdMesspunktParameterSpeichern.setToolTipText("Einstellungen speichern");
        this.cmdMesspunktParameterSpeichern.setMaximumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterSpeichern.setMinimumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterSpeichern.setPreferredSize(new Dimension(25, 25));
        this.cmdMesspunktParameterSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktParameterSpeichernActionPerformed(evt);
            }
        });
        this.panMesspunkteSpeichern.add(this.cmdMesspunktParameterSpeichern);
        this.cmdMesspunktParameterWiederherstellen.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/undo.gif")));
        this.cmdMesspunktParameterWiederherstellen.setToolTipText("Zuletzt gespeichere Einstellungen wiederherstellen");
        this.cmdMesspunktParameterWiederherstellen.setMaximumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterWiederherstellen.setMinimumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterWiederherstellen.setPreferredSize(new Dimension(25, 25));
        this.cmdMesspunktParameterWiederherstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktParameterWiederherstellenActionPerformed(evt);
            }
        });
        this.panMesspunkteSpeichern.add(this.cmdMesspunktParameterWiederherstellen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.panMesspunkte.add((Component)this.panMesspunkteSpeichern, gridBagConstraints);
        this.cmdMesspunktsuche2.setText("Me\u00dfpunkte suchen");
        this.cmdMesspunktsuche2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktsucheActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.panMesspunkte.add((Component)this.cmdMesspunktsuche2, gridBagConstraints);
        this.panInnenpunkt.setBorder(BorderFactory.createTitledBorder("Innen"));
        this.panInnenpunkt.setLayout(new GridBagLayout());
        this.jLabel32.setText("V(k.o.) min [%]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panInnenpunkt.add((Component)this.jLabel32, gridBagConstraints);
        this.fldVminInnen.setText("90");
        this.fldVminInnen.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panInnenpunkt.add((Component)this.fldVminInnen, gridBagConstraints);
        this.jLabel33.setText("S(\u00f8) max [%]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panInnenpunkt.add((Component)this.jLabel33, gridBagConstraints);
        this.fldSmaxInnen.setText("10");
        this.fldSmaxInnen.setPreferredSize(new Dimension(40, 19));
        this.panInnenpunkt.add((Component)this.fldSmaxInnen, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panMesspunkte.add((Component)this.panInnenpunkt, gridBagConstraints);
        this.panKoronapunkt.setBorder(BorderFactory.createTitledBorder("Korona"));
        this.panKoronapunkt.setLayout(new GridBagLayout());
        this.jLabel7.setText("H(\u00f8) von [\u00b0]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panKoronapunkt.add((Component)this.jLabel7, gridBagConstraints);
        this.fldHminKorona.setText("335");
        this.fldHminKorona.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panKoronapunkt.add((Component)this.fldHminKorona, gridBagConstraints);
        this.jLabel8.setText("bis [\u00b0]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panKoronapunkt.add((Component)this.jLabel8, gridBagConstraints);
        this.fldHmaxKorona.setText("348");
        this.fldHmaxKorona.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panKoronapunkt.add((Component)this.fldHmaxKorona, gridBagConstraints);
        this.jLabel9.setText("S(\u00f8) min [%]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panKoronapunkt.add((Component)this.jLabel9, gridBagConstraints);
        this.fldSminKorona.setText("35");
        this.fldSminKorona.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panKoronapunkt.add((Component)this.fldSminKorona, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panMesspunkte.add((Component)this.panKoronapunkt, gridBagConstraints);
        this.panGeometrie.setBorder(BorderFactory.createTitledBorder("Geometrie"));
        this.panGeometrie.setLayout(new GridBagLayout());
        this.fldBminKorona.setText("3");
        this.fldBminKorona.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panGeometrie.add((Component)this.fldBminKorona, gridBagConstraints);
        this.jLabel10.setText("Min. Koronabreite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setText("Min. Innenradius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel11, gridBagConstraints);
        this.fldRminInnen.setText("3");
        this.fldRminInnen.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panGeometrie.add((Component)this.fldRminInnen, gridBagConstraints);
        this.jLabel12.setText("Max. Aussenradius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel12, gridBagConstraints);
        this.fldRmaxAussen.setText("12");
        this.fldRmaxAussen.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.panGeometrie.add((Component)this.fldRmaxAussen, gridBagConstraints);
        this.jLabel13.setFont(new Font("Dialog", 0, 12));
        this.jLabel13.setText("(Alle Angaben einschl. Mittelpunkt)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setFont(new Font("Dialog", 0, 12));
        this.jLabel14.setText("(Abbruchkriterium)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.panGeometrie.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panMesspunkte.add((Component)this.panGeometrie, gridBagConstraints);
        this.panEinrichtung.addTab("LED-Me\u00dfpunktsuche", this.panMesspunkte);
        this.tabControl.addTab("Einrichtung", this.panEinrichtung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panMessung.add((Component)this.tabControl, gridBagConstraints);
        this.scrlMessung.setViewportView(this.panMessung);
        this.add((Component)this.scrlMessung, "East");
    }

    private void cmdMagischesDreieckActionPerformed(ActionEvent evt) {
        try {
            Image image = this.panFotoImage.getImage();
            BufferedImage bfImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D gfx = bfImage.createGraphics();
            gfx.drawImage(image, 0, 0, null);
            gfx.dispose();
            this.panFotoImage.paint((Graphics2D)bfImage.getGraphics(), bfImage.getWidth(), bfImage.getHeight());
            String bodyImagePath = this.session.getConfigFile().findValue("BFIMAGE");
            File bfImageFile = new File(bodyImagePath);
            try {
                ImageIO.write((RenderedImage)bfImage, "jpg", bfImageFile);
            }
            catch (IOException e) {
                throw new YException(e.toString());
            }
            this.frmNavigator.setEinsbedingung("koerpermasse", this.koerperberechnung.magischesDreieck.getHinten());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdFotoSchiessenActionPerformed(ActionEvent evt) {
        try {
            int a;
            this.kunde.requestValuesToStore();
            int iRow = this.kundeneinsbed.find(String.valueOf(this.einsbereichIdSitzknochen), "einsbereich_id");
            if (iRow < 0 && (a = JOptionPane.showConfirmDialog(this, "Das \"Magische Dreieck\" kann nur mit der Sitzhaltung berechnet werden,\ndie beim Sitzknochenabstand erfa\u00dft wird.", "Warnung", 2)) == 2) {
                return;
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
        if (!this.fotoCmdFile.exists()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.fotoCmdFile.getPath() + "' zum Fotografieren existiert nicht.", "Fehler", 0);
            return;
        }
        if (!this.fotoCmdFile.canExecute()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.fotoCmdFile.getPath() + "' zum Fotografieren ist nicht ausf\u00fchrbar.", "Fehler", 0);
            return;
        }
        this.loescheMasse(true);
        this.cmdFotoSchiessen.setEnabled(false);
        this.cmdLetzteFotos.setEnabled(false);
        try {
            Image image;
            if (this.dlgFotos == null) {
                this.dlgFotos = new DlgFotos((Frame)this.frmNavigator, this.fotoCmdFile.getPath(), this.fotoImageFile);
            }
            if ((image = this.dlgFotos.execute(evt.getSource() == this.cmdFotoSchiessen)) != null) {
                this.changePicture(image);
                StringBuffer fehler = new StringBuffer();
                try {
                    BfStatus status = this.bikeAndFit(BfStart.BFSTART_SUCHE, fehler);
                    this.lblStatusmeldung.setText(status.toString());
                    this.setFehlermeldung(fehler.toString());
                }
                catch (YException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler", 0);
                }
            }
        }
        finally {
            this.cmdLetzteFotos.setEnabled(true);
            this.cmdFotoSchiessen.setEnabled(true);
        }
    }

    private void changePicture(Image bodyImage) {
        this.imgFoto = this.panFotoImage.setImage(bodyImage);
        this.loescheMasse(true);
        this.koerperberechnung.messpunkte.init();
        this.panFotoImage.repaint();
    }

    private void cmdMesspunktParameterSpeichernActionPerformed(ActionEvent evt) {
        this.parameter.getFromInput();
        this.parameter.saveToConfig(Parametergruppe.MESSPUNKTSUCHE);
    }

    private void cmdMesspunktParameterWiederherstellenActionPerformed(ActionEvent evt) {
        this.parameter.getFromConfig(Parametergruppe.MESSPUNKTSUCHE);
        this.parameter.setInput(Parametergruppe.MESSPUNKTSUCHE);
    }

    private void fldLUnterarmFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLOberarmFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLOberkoerperFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLOberschenkelFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLUnterschenkelFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void cmdDreieckBerechnenActionPerformed(ActionEvent evt) {
        this.berechneDreieck();
    }

    private void cmdMesspunktsucheActionPerformed(ActionEvent evt) {
        StringBuffer fehler = new StringBuffer();
        try {
            BfStatus status = this.bikeAndFit(BfStart.BFSTART_SUCHE, fehler);
            this.lblStatusmeldung.setText(status.toString());
            this.setFehlermeldung(fehler.toString());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler", 0);
        }
    }

    private void cmdKalibrierungSpeichernActionPerformed(ActionEvent evt) {
        this.parameter.getFromInput();
        this.parameter.saveToConfig(Parametergruppe.KALIBRIERUNG);
    }

    private void cmdKalibrierungWiederherstellenActionPerformed(ActionEvent evt) {
        this.parameter.getFromConfig(Parametergruppe.KALIBRIERUNG);
        this.parameter.setInput(Parametergruppe.KALIBRIERUNG);
    }

    private void cmdBeispielbildActionPerformed(ActionEvent evt) {
        int rc;
        File startDir = new File(System.getProperty("user.home"), ".popometer/bodyimg");
        if (this.openJpegDialog == null) {
            this.openJpegDialog = new JFileChooser();
            this.openJpegDialog.setDialogType(0);
            this.openJpegDialog.setFileSelectionMode(0);
            this.openJpegDialog.setMultiSelectionEnabled(false);
            FileFilter jpegFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String fname = f.getName().toUpperCase();
                    if (f.isDirectory()) {
                        return true;
                    }
                    return fname.endsWith(".JPG") || fname.endsWith(".JPEG");
                }

                @Override
                public String getDescription() {
                    return "JPEG-Dateien";
                }
            };
            this.openJpegDialog.addChoosableFileFilter(jpegFilter);
            this.openJpegDialog.setFileFilter(jpegFilter);
            if (startDir.isDirectory()) {
                this.openJpegDialog.setCurrentDirectory(startDir);
            }
        }
        if ((rc = this.openJpegDialog.showOpenDialog(this)) != 0) {
            return;
        }
        File jpegFile = this.openJpegDialog.getSelectedFile();
        Image image = Toolkit.getDefaultToolkit().createImage(jpegFile.getAbsolutePath());
        this.changePicture(image);
        StringBuffer fehler = new StringBuffer();
        try {
            BfStatus status = this.bikeAndFit(BfStart.BFSTART_SUCHE, fehler);
            this.lblStatusmeldung.setText(status.toString());
            this.setFehlermeldung(fehler.toString());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler", 0);
        }
    }

    private void cmdLetzteFotosActionPerformed(ActionEvent evt) {
        if (this.dlgFotos == null) {
            JOptionPane.showMessageDialog(this, "Es gibt noch keine Fotos", "Hinweis", 1);
            return;
        }
        this.cmdFotoSchiessenActionPerformed(evt);
    }

    private static enum BfStatus {
        BFSTATUS_NULL,
        BFSTATUS_BEREIT,
        BFSTATUS_GEFUNDEN,
        BFSTATUS_BENANNT,
        BFSTATUS_KALIBRIERT,
        BFSTATUS_KOERPER_BERECHNET,
        BFSTATUS_DREIECK_BERECHNET;


        public String toString() {
            switch (this) {
                case BFSTATUS_BEREIT: {
                    return "Bereit";
                }
                case BFSTATUS_GEFUNDEN: {
                    return "Me\u00dfpunkte gefunden";
                }
                case BFSTATUS_BENANNT: {
                    return "Me\u00dfpunkte benannt";
                }
                case BFSTATUS_KALIBRIERT: {
                    return "Kalibriert";
                }
                case BFSTATUS_KOERPER_BERECHNET: {
                    return "K\u00f6rperma\u00dfe berechnet";
                }
                case BFSTATUS_DREIECK_BERECHNET: {
                    return "\"Magisches Dreieck\" berechnet";
                }
            }
            return "";
        }
    }

    private static enum BfStart {
        BFSTART_SUCHE,
        BFSTART_BENENNEN,
        BFSTART_DREIECK;

    }

    private class AngezeigteKoerpermasse
    extends Koerpermasse {
        JTextField[] fldLaengen;

        public AngezeigteKoerpermasse() {
            this.fldLaengen = new JTextField[]{PanKoerper.this.fldLUnterarm, PanKoerper.this.fldLOberarm, PanKoerper.this.fldLOberkoerper, PanKoerper.this.fldLOberschenkel, PanKoerper.this.fldLUnterschenkel};
        }

        public void set(Koerpermasse koerpermasse) {
            this.oa = koerpermasse.oa;
            this.ok = koerpermasse.ok;
            this.os = koerpermasse.os;
            this.ua = koerpermasse.ua;
            this.usf = koerpermasse.usf;
        }

        public boolean getInput() throws YUserException {
            for (JTextField fldLaenge : this.fldLaengen) {
                if (fldLaenge.getText().length() != 0) continue;
                PanKoerper.this.cmdDreieckBerechnen.setEnabled(false);
                return false;
            }
            PanKoerper.this.cmdDreieckBerechnen.setEnabled(true);
            boolean iLUnterarm = false;
            boolean iLOberarm = true;
            int iLOberkoerper = 2;
            int iLOberschenkel = 3;
            int iLUnterschenkel = 4;
            int[] massIdx = new int[]{0, 1, 2, 3, 4};
            NumberFormat fmt = NumberFormat.getNumberInstance(PanKoerper.this.session.getLocale());
            int iErr = 0;
            try {
                block10: for (int idx : massIdx) {
                    String text = this.fldLaengen[idx].getText();
                    if (!Pattern.matches("[0-9]+", text) && !Pattern.matches("[0-9]+[.,][0-9]*", text)) {
                        iErr = idx;
                        throw new YUserException("Ung\u00fcltige Zahl: " + this.fldLaengen[iErr].getText());
                    }
                    float l = fmt.parse(text).floatValue();
                    switch (idx) {
                        case 0: {
                            this.ua = l;
                            continue block10;
                        }
                        case 1: {
                            this.oa = l;
                            continue block10;
                        }
                        case 2: {
                            this.ok = l;
                            continue block10;
                        }
                        case 3: {
                            this.os = l;
                            continue block10;
                        }
                        case 4: {
                            this.usf = l;
                        }
                    }
                }
            }
            catch (ParseException e) {
                throw new YUserException("Ung\u00fcltige Zahl: " + this.fldLaengen[iErr].getText());
            }
            return true;
        }

        public void setInput() {
            PanKoerper.this.fldLUnterarm.setText(String.format("%3.1f", Float.valueOf(this.ua)));
            PanKoerper.this.fldLOberarm.setText(String.format("%3.1f", Float.valueOf(this.oa)));
            PanKoerper.this.fldLOberkoerper.setText(String.format("%3.1f", Float.valueOf(this.ok)));
            PanKoerper.this.fldLOberschenkel.setText(String.format("%3.1f", Float.valueOf(this.os)));
            PanKoerper.this.fldLUnterschenkel.setText(String.format("%3.1f", Float.valueOf(this.usf)));
            PanKoerper.this.cmdDreieckBerechnen.setEnabled(true);
        }
    }

    private class VerwalteteParameter
    extends Parameter {
        private YConfigFile configFile;

        public VerwalteteParameter(YConfigFile configFile) {
            this.configFile = configFile;
            this.getFromConfig();
        }

        public void getFromConfig(Parametergruppe gruppe) {
            try {
                switch (gruppe) {
                    case KALIBRIERUNG: {
                        this.blickrichtungRechts = this.configFile.getEntry("blickrichtung", "rechts").equals("rechts");
                        this.abstandSitzGriff = Float.parseFloat(this.configFile.getEntry("abstandSitzGriff", "70"));
                        this.abstandSitzPedal = Float.parseFloat(this.configFile.getEntry("abstandSitzPedal", "75"));
                        this.abstandGriffPedal = Float.parseFloat(this.configFile.getEntry("abstandGriffPedal", "95"));
                        this.offsetHuefteX = Float.parseFloat(this.configFile.getEntry("offsetHuefteX", "5"));
                        this.offsetHuefteY = Float.parseFloat(this.configFile.getEntry("offsetHuefteY", "15"));
                        this.offsetFussX = Float.parseFloat(this.configFile.getEntry("offsetFussX", "2.5"));
                        this.offsetFussY = Float.parseFloat(this.configFile.getEntry("offsetFussY", "3"));
                        this.offsetHandX = Float.parseFloat(this.configFile.getEntry("offsetHandX", "0"));
                        this.offsetHandY = Float.parseFloat(this.configFile.getEntry("offsetHandY", "0"));
                        this.hueftabstand = Float.parseFloat(this.configFile.getEntry("hueftabstand", "8"));
                        this.pedallaenge = Float.parseFloat(this.configFile.getEntry("pedallaenge", "17"));
                        break;
                    }
                    case MESSPUNKTSUCHE: {
                        switch (Integer.parseInt(this.configFile.getEntry("autosuche", "5"))) {
                            case 0: {
                                this.autosuche = 0;
                                break;
                            }
                            case 6: {
                                this.autosuche = 8;
                                break;
                            }
                            default: {
                                this.autosuche = 5;
                            }
                        }
                        this.maxSInnenConf = Integer.parseInt(this.configFile.getEntry("maxSInnen", "10"));
                        this.minVInnenConf = Integer.parseInt(this.configFile.getEntry("minVInnen", "90"));
                        this.minSKoronaConf = Integer.parseInt(this.configFile.getEntry("minSKorona", "35"));
                        this.minHKorona = Integer.parseInt(this.configFile.getEntry("minHKorona", "335"));
                        this.maxHKorona = Integer.parseInt(this.configFile.getEntry("maxHKorona", "348"));
                        this.minRInnen = Integer.parseInt(this.configFile.getEntry("minRInnen", "3"));
                        this.minBKorona = Integer.parseInt(this.configFile.getEntry("minBKorona", "3"));
                        this.maxRAussen = Integer.parseInt(this.configFile.getEntry("maxRAussen", "12"));
                        this.maxSInnen = HSVWert.svlTo255(this.maxSInnenConf);
                        this.minVInnen = HSVWert.svlTo255(this.minVInnenConf);
                        this.minSKorona = HSVWert.svlTo255(this.minSKoronaConf);
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void getFromConfig() {
            for (Parametergruppe gruppe : Parametergruppe.values()) {
                this.getFromConfig(gruppe);
            }
        }

        public void saveToConfig(Parametergruppe gruppe) {
            switch (gruppe) {
                case KALIBRIERUNG: {
                    this.configFile.setEntry("blickrichtung", this.blickrichtungRechts ? "rechts" : "links");
                    this.configFile.setEntry("abstandSitzGriff", String.valueOf(this.abstandSitzGriff));
                    this.configFile.setEntry("abstandSitzPedal", String.valueOf(this.abstandSitzPedal));
                    this.configFile.setEntry("abstandGriffPedal", String.valueOf(this.abstandGriffPedal));
                    this.configFile.setEntry("offsetHuefteX", String.valueOf(this.offsetHuefteX));
                    this.configFile.setEntry("offsetHuefteY", String.valueOf(this.offsetHuefteY));
                    this.configFile.setEntry("offsetFussX", String.valueOf(this.offsetFussX));
                    this.configFile.setEntry("offsetFussY", String.valueOf(this.offsetFussY));
                    this.configFile.setEntry("offsetHandX", String.valueOf(this.offsetHandX));
                    this.configFile.setEntry("offsetHandY", String.valueOf(this.offsetHandY));
                    this.configFile.setEntry("hueftabstand", String.valueOf(this.hueftabstand));
                    this.configFile.setEntry("pedallaenge", String.valueOf(this.pedallaenge));
                    break;
                }
                case MESSPUNKTSUCHE: {
                    switch (this.autosuche) {
                        case 0: {
                            this.configFile.setEntry("autosuche", "0");
                            break;
                        }
                        case 6: {
                            this.configFile.setEntry("autosuche", "6");
                            break;
                        }
                        default: {
                            this.configFile.setEntry("autosuche", "3");
                        }
                    }
                    this.configFile.setEntry("maxSInnen", String.valueOf(this.maxSInnenConf));
                    this.configFile.setEntry("minVInnen", String.valueOf(this.minVInnenConf));
                    this.configFile.setEntry("minSKorona", String.valueOf(this.minSKoronaConf));
                    this.configFile.setEntry("minHKorona", String.valueOf(this.minHKorona));
                    this.configFile.setEntry("maxHKorona", String.valueOf(this.maxHKorona));
                    this.configFile.setEntry("minRInnen", String.valueOf(this.minRInnen));
                    this.configFile.setEntry("minBKorona", String.valueOf(this.minBKorona));
                    this.configFile.setEntry("maxRAussen", String.valueOf(this.maxRAussen));
                    break;
                }
            }
        }

        public void saveToConfig() {
            for (Parametergruppe gruppe : Parametergruppe.values()) {
                this.saveToConfig(gruppe);
            }
        }

        public void getFromInput() {
            float[] werte = new float[9];
            try {
                int i = 0;
                for (JTextField f : new JTextField[]{PanKoerper.this.fldAbstandSitzGriff, PanKoerper.this.fldOffsetFussX, PanKoerper.this.fldOffsetFussY, PanKoerper.this.fldOffsetHandX, PanKoerper.this.fldOffsetHandY, PanKoerper.this.fldOffsetHuefteX, PanKoerper.this.fldOffsetHuefteY, PanKoerper.this.fldHueftabstand, PanKoerper.this.fldPedallaenge}) {
                    werte[i++] = Float.parseFloat(f.getText().replace(',', '.'));
                }
                this.abstandSitzGriff = werte[0];
                this.offsetFussX = werte[1];
                this.offsetFussY = werte[2];
                this.offsetHandX = werte[3];
                this.offsetHandY = werte[4];
                this.offsetHuefteX = werte[5];
                this.offsetHuefteY = werte[6];
                this.hueftabstand = werte[7];
                this.pedallaenge = werte[8];
                this.blickrichtungRechts = PanKoerper.this.rbBlickRechts.isSelected();
                this.autosuche = PanKoerper.this.rbManuell.isSelected() ? 0 : (PanKoerper.this.rbVollautomatisch.isSelected() ? 6 : 3);
                this.maxSInnenConf = Integer.parseInt(PanKoerper.this.fldSmaxInnen.getText());
                this.minVInnenConf = Integer.parseInt(PanKoerper.this.fldVminInnen.getText());
                this.minSKoronaConf = Integer.parseInt(PanKoerper.this.fldSminKorona.getText());
                this.minHKorona = Integer.parseInt(PanKoerper.this.fldHminKorona.getText());
                this.maxHKorona = Integer.parseInt(PanKoerper.this.fldHmaxKorona.getText());
                this.minRInnen = Integer.parseInt(PanKoerper.this.fldRminInnen.getText());
                this.minBKorona = Integer.parseInt(PanKoerper.this.fldBminKorona.getText());
                this.maxRAussen = Integer.parseInt(PanKoerper.this.fldRmaxAussen.getText());
                this.maxSInnen = HSVWert.svlTo255(this.maxSInnenConf);
                this.minVInnen = HSVWert.svlTo255(this.minVInnenConf);
                this.minSKorona = HSVWert.svlTo255(this.minSKoronaConf);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setInput(Parametergruppe gruppe) {
            switch (gruppe) {
                case KALIBRIERUNG: {
                    if (this.blickrichtungRechts) {
                        PanKoerper.this.rbBlickRechts.setSelected(true);
                    } else {
                        PanKoerper.this.rbBlickLinks.setSelected(true);
                    }
                    Object[][] kalib = new Object[][]{{PanKoerper.this.fldAbstandSitzGriff, Float.valueOf(this.abstandSitzGriff)}, {PanKoerper.this.fldOffsetFussX, Float.valueOf(this.offsetFussX)}, {PanKoerper.this.fldOffsetFussY, Float.valueOf(this.offsetFussY)}, {PanKoerper.this.fldOffsetHandX, Float.valueOf(this.offsetHandX)}, {PanKoerper.this.fldOffsetHandY, Float.valueOf(this.offsetHandY)}, {PanKoerper.this.fldOffsetHuefteX, Float.valueOf(this.offsetHuefteX)}, {PanKoerper.this.fldOffsetHuefteY, Float.valueOf(this.offsetHuefteY)}, {PanKoerper.this.fldHueftabstand, Float.valueOf(this.hueftabstand)}, {PanKoerper.this.fldPedallaenge, Float.valueOf(this.pedallaenge)}};
                    for (int i = 0; i < kalib.length; ++i) {
                        ((JTextField)kalib[i][0]).setText(String.valueOf(kalib[i][1]).replace('.', ','));
                    }
                    break;
                }
                case MESSPUNKTSUCHE: {
                    switch (this.autosuche) {
                        case 0: {
                            PanKoerper.this.rbManuell.setSelected(true);
                            break;
                        }
                        case 6: {
                            PanKoerper.this.rbVollautomatisch.setSelected(true);
                            break;
                        }
                        default: {
                            PanKoerper.this.rbNurFahrrad.setSelected(true);
                        }
                    }
                    PanKoerper.this.fldSmaxInnen.setText(String.valueOf(this.maxSInnenConf));
                    PanKoerper.this.fldVminInnen.setText(String.valueOf(this.minVInnenConf));
                    PanKoerper.this.fldSminKorona.setText(String.valueOf(this.minSKoronaConf));
                    PanKoerper.this.fldHminKorona.setText(String.valueOf(this.minHKorona));
                    PanKoerper.this.fldHmaxKorona.setText(String.valueOf(this.maxHKorona));
                    PanKoerper.this.fldRminInnen.setText(String.valueOf(this.minRInnen));
                    PanKoerper.this.fldBminKorona.setText(String.valueOf(this.minBKorona));
                    PanKoerper.this.fldRmaxAussen.setText(String.valueOf(this.maxRAussen));
                    break;
                }
            }
        }

        public void setInput() {
            for (Parametergruppe gruppe : Parametergruppe.values()) {
                this.setInput(gruppe);
            }
        }
    }

    public static enum Parametergruppe {
        KALIBRIERUNG,
        MESSPUNKTSUCHE;

    }
}

