/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YRLEinsatzbereiche;
import popometer.dbobjects.YRLKundendaten;
import popometer.dbobjects.YSRLVsEinsatzbedingungen;
import projektY.base.YException;
import projektY.base.YUserException;
import projektY.database.YDBOChangeEvent;
import projektY.database.YRowValues;
import projektY.swing.YJTableManager;

public class PanKunden
extends JPanel {
    private FrmNavigator navigator;
    private YPopometerSession session;
    private YRLEinsatzbereiche rlEinsatzbereiche;
    private YSRLVsEinsatzbedingungen srlVsEinsatzbedingungen;
    private YRLKundendaten kundendaten;
    private JFileChooser fileChooser;
    private FileFilter csvFilter;
    private JButton cmdClearFilter;
    private JButton cmdExport;
    private JButton cmdFetch;
    private JButton cmdPost;
    private JButton cmdRevert;
    private JTextField fldMaxResults;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel panControl;
    private JPanel panFilter;
    private JScrollPane scrlEinsatzbedingungen;
    private JScrollPane scrlEinsatzbereiche;
    private JScrollPane scrlKundendaten;
    private JSplitPane spltDaten;
    private JTable tblEinsatzbedingungen;
    private JTable tblEinsatzbereiche;
    private JTable tblKundendaten;

    public PanKunden(FrmNavigator navigator, YPopometerSession session) throws YException {
        this.initComponents();
        this.navigator = navigator;
        this.session = session;
        this.rlEinsatzbereiche = new YRLEinsatzbereiche(session);
        this.srlVsEinsatzbedingungen = (YSRLVsEinsatzbedingungen)this.rlEinsatzbereiche.getSubRowList("vs_einsatzbedingungen");
        this.rlEinsatzbereiche.fetch();
        this.rlEinsatzbereiche.setDispFields(new String[]{"bezeichnung"});
        this.srlVsEinsatzbedingungen.setDispFields(new String[]{"bedingung", "auswahl"});
        YJTableManager.createTableManager(this.tblEinsatzbereiche, this.rlEinsatzbereiche, true);
        YJTableManager.createTableManager(this.tblEinsatzbedingungen, this.srlVsEinsatzbedingungen);
        this.kundendaten = new YRLKundendaten(this.rlEinsatzbereiche);
        YJTableManager.createTableManager(this.tblKundendaten, this.kundendaten);
        this.fileChooser = new JFileChooser(System.getProperty("user.home"));
        this.fileChooser.setDialogTitle("Ausgabedatei");
        this.fileChooser.setDialogType(1);
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setApproveButtonText("Start !");
        this.csvFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String fname = f.getName();
                return fname.toUpperCase().endsWith(".CSV");
            }

            @Override
            public String getDescription() {
                return "CSV-Dateien";
            }
        };
        this.fileChooser.addChoosableFileFilter(this.csvFilter);
        this.fileChooser.setFileFilter(this.csvFilter);
    }

    public boolean hasChanged() throws YException {
        return this.kundendaten.hasChanged();
    }

    private void initComponents() {
        this.panControl = new JPanel();
        this.cmdClearFilter = new JButton();
        this.cmdFetch = new JButton();
        this.cmdExport = new JButton();
        this.cmdPost = new JButton();
        this.cmdRevert = new JButton();
        this.jLabel3 = new JLabel();
        this.fldMaxResults = new JTextField();
        this.jLabel4 = new JLabel();
        this.spltDaten = new JSplitPane();
        this.panFilter = new JPanel();
        this.scrlEinsatzbereiche = new JScrollPane();
        this.tblEinsatzbereiche = new JTable();
        this.scrlEinsatzbedingungen = new JScrollPane();
        this.tblEinsatzbedingungen = new JTable();
        this.scrlKundendaten = new JScrollPane();
        this.tblKundendaten = new JTable();
        this.setLayout(new BorderLayout());
        this.panControl.setLayout(new FlowLayout(0));
        this.cmdClearFilter.setText("Filter l\u00f6schen");
        this.cmdClearFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKunden.this.cmdClearFilterActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdClearFilter);
        this.cmdFetch.setText("Anzeigen !");
        this.cmdFetch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKunden.this.cmdFetchActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdFetch);
        this.cmdExport.setText("Export ...");
        this.cmdExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKunden.this.cmdExportActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdExport);
        this.cmdPost.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/save.gif")));
        this.cmdPost.setToolTipText("\u00c4nderungen an Kundendaten speichern");
        this.cmdPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKunden.this.cmdPostActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdPost);
        this.cmdRevert.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/undo.gif")));
        this.cmdRevert.setToolTipText("\u00c4nderungen an Kundendaten verwerfen");
        this.cmdRevert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKunden.this.cmdRevertActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdRevert);
        this.jLabel3.setText("(max.");
        this.panControl.add(this.jLabel3);
        this.fldMaxResults.setHorizontalAlignment(11);
        this.fldMaxResults.setText("200");
        this.fldMaxResults.setPreferredSize(new Dimension(40, 19));
        this.panControl.add(this.fldMaxResults);
        this.jLabel4.setText("Ergebnisse)");
        this.panControl.add(this.jLabel4);
        this.add((Component)this.panControl, "North");
        this.spltDaten.setDividerLocation(300);
        this.panFilter.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.panFilter.setLayout(new GridBagLayout());
        this.scrlEinsatzbereiche.setBackground(new Color(255, 255, 255));
        this.scrlEinsatzbereiche.setViewportView(this.tblEinsatzbereiche);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panFilter.add((Component)this.scrlEinsatzbereiche, gridBagConstraints);
        this.scrlEinsatzbedingungen.setBackground(new Color(255, 255, 255));
        this.scrlEinsatzbedingungen.setViewportView(this.tblEinsatzbedingungen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panFilter.add((Component)this.scrlEinsatzbedingungen, gridBagConstraints);
        this.spltDaten.setLeftComponent(this.panFilter);
        this.scrlKundendaten.setBackground(new Color(255, 255, 255));
        this.scrlKundendaten.setBorder(BorderFactory.createTitledBorder("Kunden"));
        this.tblKundendaten.setAutoResizeMode(0);
        this.scrlKundendaten.setViewportView(this.tblKundendaten);
        this.spltDaten.setRightComponent(this.scrlKundendaten);
        this.add((Component)this.spltDaten, "Center");
    }

    private void setFilter() throws YException {
        String einsbereichId0 = "";
        String einsbereichId = "";
        this.kundendaten.clearFilterValues();
        int nRows = this.srlVsEinsatzbedingungen.getAbsRowCount();
        String[] values = new String[nRows];
        int nFilter = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues rowValues = this.srlVsEinsatzbedingungen.getAbsRowValues(iRow);
            einsbereichId = rowValues.getAsString("einsbereich_id");
            if (!einsbereichId.equals(einsbereichId0)) {
                if (einsbereichId0.length() > 0 && nFilter > 0) {
                    this.kundendaten.setFilterValues("f" + einsbereichId0, Arrays.copyOfRange(values, 0, nFilter));
                }
                einsbereichId0 = einsbereichId;
                nFilter = 0;
            }
            if (!rowValues.getAsBool("auswahl", false)) continue;
            values[nFilter++] = rowValues.getAsString("bedingung");
        }
        if (einsbereichId.length() > 0 && nFilter > 0) {
            this.kundendaten.setFilterValues("f" + einsbereichId, Arrays.copyOfRange(values, 0, nFilter));
        }
        if (this.fldMaxResults.getText().length() > 0) {
            try {
                this.kundendaten.setMaxRows(Integer.parseInt(this.fldMaxResults.getText()));
            }
            catch (NumberFormatException e) {
                throw new YUserException("Ung\u00fcltige Zahl: " + this.fldMaxResults.getText());
            }
        } else {
            this.kundendaten.setMaxRows(0);
        }
    }

    private void cmdFetchActionPerformed(ActionEvent evt) {
        try {
            this.setFilter();
            this.kundendaten.fetch();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdClearFilterActionPerformed(ActionEvent evt) {
        try {
            int nRows = this.srlVsEinsatzbedingungen.getAbsRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                this.srlVsEinsatzbedingungen.getAbsRowValues(iRow).setAsBool("auswahl", false);
            }
            this.srlVsEinsatzbedingungen.fireChanged(new YDBOChangeEvent());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdPostActionPerformed(ActionEvent evt) {
        try {
            this.kundendaten.post();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdRevertActionPerformed(ActionEvent evt) {
        try {
            this.kundendaten.revert();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdExportActionPerformed(ActionEvent evt) {
        int a;
        int rc = this.fileChooser.showSaveDialog(this);
        if (rc != 0) {
            return;
        }
        File csvFile = this.fileChooser.getSelectedFile();
        if (!csvFile.exists() && this.fileChooser.getFileFilter() == this.csvFilter && !csvFile.getName().toUpperCase().endsWith(".CSV")) {
            csvFile = new File(csvFile.getAbsolutePath() + ".csv");
        }
        if (csvFile.exists() && (a = JOptionPane.showConfirmDialog(this, csvFile + " existiert bereits ?\n" + "Datei \u00fcberschreiben ?", "Datei existiert bereits", 0, 3)) == 1) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(csvFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, System.getProperty("file.encoding"));
            this.setFilter();
            this.kundendaten.fetchAsCSV(osw, ';', '\"', System.getProperty("line.separator"), true);
            osw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "I/O-Fehler", 0);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }
}

