/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.base.YVersion;
import projektY.database.YDatabase;
import projektY.database.YFieldValue;
import projektY.database.YRowObjectList;
import projektY.utils.YLabelProvider;

public class YSession {
    private static YVersion yVersion = new YVersion(0, 6, 0);
    protected static int sessionId = 0;
    private YDatabase database;
    protected GregorianCalendar cal_start;
    private YLabelProvider labelProvider;
    private Vector<YRowObjectList> rowObjectLists;

    public YSession(YDatabase database) throws YException {
        ++sessionId;
        this.database = database;
        this.cal_start = new GregorianCalendar(database.getLocale());
        this.labelProvider = null;
        this.rowObjectLists = new Vector(50);
    }

    public YSession(YDatabase database, String yuser, String passwd) throws YException {
        this(database);
        database.connect(yuser, passwd);
    }

    public static YVersion getYVersion() {
        return yVersion;
    }

    public int getSessionId() {
        return sessionId;
    }

    public YDatabase getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.database.getUser();
    }

    public Locale getLocale() {
        return this.database.getLocale();
    }

    public GregorianCalendar getCal() {
        return new GregorianCalendar(this.database.getLocale());
    }

    public GregorianCalendar getCalStart() {
        return this.cal_start;
    }

    public void setLabelProvider(YLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public YLabelProvider getLabelProvider() throws YProgramException {
        if (this.labelProvider == null) {
            throw new YProgramException(this, "Es wurde kein Labelprovider definiert.");
        }
        return this.labelProvider;
    }

    public void addRowObjectList(YRowObjectList rowObjectList) throws YException {
        if (this.findRowObjectList(rowObjectList.getName()) != null) {
            throw new YProgramException(this, "Eine RowObjectListe mit dem Namen '" + rowObjectList.getName() + "' wurde bereits hinzugef\u00fcgt.");
        }
        this.rowObjectLists.add(rowObjectList);
    }

    public YRowObjectList findRowObjectList(String name) throws YException {
        int nRowObjectLists = this.rowObjectLists.size();
        for (int iRowObjectList = 0; iRowObjectList < nRowObjectLists; ++iRowObjectList) {
            YRowObjectList rowObjectList = this.rowObjectLists.get(iRowObjectList);
            if (!rowObjectList.getName().equals(name)) continue;
            return rowObjectList;
        }
        return null;
    }

    public YRowObjectList getRowObjectList(String name) throws YProgramException, YException {
        YRowObjectList rowObjectList = this.findRowObjectList(name);
        if (rowObjectList != null) {
            return rowObjectList;
        }
        throw new YProgramException(this, "getRowObjectList() '" + name + "' nicht gefunden.");
    }

    public String stringToday() {
        DateFormat df = DateFormat.getDateInstance(2, this.database.getLocale());
        return df.format(this.getCal().getTime());
    }

    public final String sqlToday() {
        return this.database.sqlToday(this.getCal());
    }

    protected boolean isAdmin() throws YException {
        return true;
    }

    public void createUser(String user, char[] passwd) throws YException {
        if (!this.isAdmin()) {
            throw new YUserException("Keine Berechtigung.");
        }
        this.database.createUser(user, passwd);
    }

    public void alterPasswd(String user, char[] passwd) throws YException {
        if (!user.equals(this.database.getUser()) && !this.isAdmin()) {
            throw new YUserException("Keine Berechtigung.");
        }
        this.database.alterPasswd(user, passwd);
    }

    public void grantAdmin(String user) throws YException {
        if (!this.isAdmin()) {
            throw new YUserException("Keine Berechtigung.");
        }
        this.database.grantAdmin(user);
    }

    public void revokeAdmin(String user) throws YException {
        if (!this.isAdmin()) {
            throw new YUserException("Keine Berechtigung.");
        }
        this.database.revokeAdmin(user);
    }

    public void dropUser(String user) throws YException {
        if (!this.isAdmin()) {
            throw new YUserException("Keine Berechtigung.");
        }
        if (user.equals(this.database.getUser())) {
            throw new YUserException("Sie k\u00f6nnen sich nicht selbst l\u00f6schen");
        }
        this.database.dropUser(user);
    }

    public void grantRole(String role, String user) throws YException {
        if (!this.isAdmin()) {
            throw new YUserException("Keine Berechtigung.");
        }
        this.database.grantRole(role, user);
    }

    public void revokeRole(String role, String user) throws YException {
        if (!this.isAdmin()) {
            throw new YUserException("Keine Berechtigung.");
        }
        this.database.revokeRole(role, user);
    }

    public void setPasswdUser(String passwdUser) throws YException {
        this.database.setPasswdUser(passwdUser);
    }

    public void modifyPasswdField(YFieldValue pwdFv, char[] passwd) throws YException {
        this.database.modifyPasswdField(pwdFv, passwd);
    }
}

