/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YROKunde;
import projektY.base.YException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YEvaluationList;
import projektY.database.YFieldValue;
import projektY.database.YSession;
import projektY.swing.YJPanelManager;
import projektY.swing.YJTableManager;

public class PanKundendaten
extends JPanel {
    private YPopometerSession session;
    private FrmNavigator frmNavigator;
    private YEvaluationList evKundenliste;
    private String expertName;
    private String expertVorname;
    private YROKunde kunde;
    private int iRowKundeSelected;
    private JComboBox cmbLand;
    private JButton cmdKundeCancel;
    private JButton cmdKundeClear;
    private JButton cmdKundeDelete;
    private JButton cmdKundePost;
    private JButton cmdSuchen;
    private JTextField fldEmail;
    private JTextField fldKundennr;
    private JTextField fldName;
    private JTextField fldOrt;
    private JTextField fldPlz;
    private JTextField fldStrNr;
    private JTextField fldSucheKundennr;
    private JTextField fldSucheName;
    private JTextField fldSucheVorname;
    private JTextField fldTelefon;
    private JTextField fldVorname;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel lblKundenNr;
    private JLabel lblMoreResults;
    private JLabel lblNachname;
    private JLabel lblTitel;
    private JLabel lblUeberschrift;
    private JLabel lblVorname;
    private JPanel panAnfragen;
    private JPanel panGefKunden;
    private JPanel panKundendaten;
    private JPanel panKundensuche;
    private JPanel panLinks;
    private JPanel panRechts;
    private JPanel panWillkommen;
    private JScrollPane scrlAnfragen;
    private JScrollPane scrlBemerkungen;
    private JScrollPane scrlKundenliste;
    private JTable tblAnfragen;
    private JTable tblKundenliste;
    private JTextArea txtBemerkungen;

    public PanKundendaten(YPopometerSession session, YROKunde kunde, final FrmNavigator frmNavigator) throws YException {
        this.session = session;
        this.frmNavigator = frmNavigator;
        this.initComponents();
        this.evKundenliste = new YEvaluationList((YSession)session, 5, 50);
        this.evKundenliste.addDBField("kunde_id", YColumnDefinition.FieldType.INT);
        this.evKundenliste.addDBField("kundennr", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addDBField("name", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addDBField("vorname", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addDBField("ort", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.setLabels("kundensuche");
        this.evKundenliste.setSQLSelect("SELECT kunde_id, kundennr, vorname, name, ort FROM vh_kunden");
        this.evKundenliste.setOrder(new String[]{"name", "vorname", "kundennr"});
        this.evKundenliste.addFilter("name", "lower(name) LIKE :value:||'%'", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addFilter("vorname", "lower(vorname) LIKE :value:||'%'", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addFilter("kundennr", "kundennr=:value:", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.setDispFields(new String[]{"kundennr", "vorname", "name", "ort"});
        this.evKundenliste.finalize();
        this.evKundenliste.setMaxRows(50);
        YEvaluationList evBenutzer = new YEvaluationList(session, 2);
        evBenutzer.addDBField("vorname", YColumnDefinition.FieldType.STRING);
        evBenutzer.addDBField("name", YColumnDefinition.FieldType.STRING);
        evBenutzer.setSQLSelect("SELECT vorname, name FROM vh_personen WHERE pers_id=GetBenutzerId()");
        evBenutzer.finalize();
        evBenutzer.fetch();
        if (evBenutzer.getRowCount() > 0) {
            this.expertVorname = evBenutzer.getAsString(0, "vorname");
            this.expertName = evBenutzer.getAsString(0, "name");
        } else {
            this.expertVorname = "Ergonomic";
            this.expertName = "Expert";
        }
        this.kunde = kunde;
        YJPanelManager.createPanelManager(this.panKundendaten, kunde);
        YJPanelManager.createPanelManager(this.panAnfragen, kunde);
        this.lblKundenNr.setText(kunde.getColumnLabel("kundennr") + ":");
        this.lblNachname.setText(kunde.getColumnLabel("name") + ":");
        this.lblVorname.setText(kunde.getColumnLabel("vorname") + ":");
        YJTableManager.createTableManager(this.tblKundenliste, this.evKundenliste, true);
        this.tblKundenliste.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PanKundendaten.this.tblKundenlisteSelectionChanged(e);
            }
        });
        this.lblMoreResults.setVisible(false);
        AbstractAction actUp = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmNavigator.panMainRequestFocus();
            }
        };
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 512), "up");
        this.getActionMap().put("up", actUp);
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.fldKundennr.requestFocusInWindow();
    }

    public boolean hasChanged() throws YException {
        return this.kunde.hasChanged();
    }

    public void clearKundenlisteSelection() throws YException {
        this.evKundenliste.unsetActiveRow();
        this.tblKundenliste.clearSelection();
    }

    private void tblKundenlisteSelectionChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        try {
            int a;
            int iRow = this.evKundenliste.getActiveRow();
            if (iRow < 0) {
                this.iRowKundeSelected = -1;
                return;
            }
            if (this.kunde.hasChanged() && (a = JOptionPane.showConfirmDialog(this, "\u00c4nderungen an '" + this.kunde.toString() + "' speichern ?\n" + "(" + this.kunde.getLastHasChanged() + ")", "\u00c4nderungen", 0)) == 0) {
                this.kunde.post();
                if (this.iRowKundeSelected >= 0 && this.evKundenliste.getAsInt(this.iRowKundeSelected, "kunde_id") == this.kunde.getPkFieldValueAsInt()) {
                    this.evKundenliste.setAsString(this.iRowKundeSelected, "vorname", this.kunde.getAsString("vorname"));
                    this.evKundenliste.setAsString(this.iRowKundeSelected, "name", this.kunde.getAsString("name"));
                    this.evKundenliste.setAsString(this.iRowKundeSelected, "ort", this.kunde.getAsString("ort"));
                    this.evKundenliste.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, this.iRowKundeSelected, this.iRowKundeSelected));
                }
            }
            int kundeId = this.evKundenliste.getAsInt(iRow, "kunde_id");
            this.kunde.fetch(kundeId);
            this.iRowKundeSelected = iRow;
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    public String getExpertVorname() {
        return this.expertVorname;
    }

    public String getExpertName() {
        return this.expertName;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panLinks = new JPanel();
        this.panWillkommen = new JPanel();
        this.panKundensuche = new JPanel();
        this.lblKundenNr = new JLabel();
        this.lblVorname = new JLabel();
        this.lblNachname = new JLabel();
        this.fldSucheKundennr = new JTextField();
        this.fldSucheVorname = new JTextField();
        this.fldSucheName = new JTextField();
        this.cmdSuchen = new JButton();
        this.jLabel12 = new JLabel();
        this.jLabel11 = new JLabel();
        this.lblMoreResults = new JLabel();
        this.panGefKunden = new JPanel();
        this.scrlKundenliste = new JScrollPane();
        this.tblKundenliste = new JTable();
        this.lblTitel = new JLabel();
        this.panRechts = new JPanel();
        this.panKundendaten = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel1 = new JLabel();
        this.fldKundennr = new JTextField();
        this.fldVorname = new JTextField();
        this.fldName = new JTextField();
        this.fldTelefon = new JTextField();
        this.fldEmail = new JTextField();
        this.fldStrNr = new JTextField();
        this.fldPlz = new JTextField();
        this.fldOrt = new JTextField();
        this.cmbLand = new JComboBox();
        this.jPanel2 = new JPanel();
        this.cmdKundeClear = new JButton();
        this.cmdKundePost = new JButton();
        this.jPanel4 = new JPanel();
        this.cmdKundeCancel = new JButton();
        this.cmdKundeDelete = new JButton();
        this.scrlBemerkungen = new JScrollPane();
        this.txtBemerkungen = new JTextArea();
        this.panAnfragen = new JPanel();
        this.scrlAnfragen = new JScrollPane();
        this.tblAnfragen = new JTable();
        this.lblUeberschrift = new JLabel();
        this.jLabel14 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.panLinks.setBorder(BorderFactory.createTitledBorder(""));
        this.panLinks.setLayout(new GridBagLayout());
        this.panWillkommen.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panLinks.add((Component)this.panWillkommen, gridBagConstraints);
        this.panKundensuche.setLayout(new GridBagLayout());
        this.lblKundenNr.setText("Kundennummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblKundenNr, gridBagConstraints);
        this.lblVorname.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblVorname, gridBagConstraints);
        this.lblNachname.setText("Nachname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblNachname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheKundennr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheVorname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheName, gridBagConstraints);
        this.cmdSuchen.setText("Suchen");
        this.cmdSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdSuchenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panKundensuche.add((Component)this.cmdSuchen, gridBagConstraints);
        this.jLabel12.setText("(max. 50 Treffer)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panKundensuche.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel11.setForeground(new Color(212, 55, 28));
        this.jLabel11.setText("Kundensuche");
        this.jLabel11.setName("headline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panKundensuche.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panLinks.add((Component)this.panKundensuche, gridBagConstraints);
        this.lblMoreResults.setText("Es wurden noch mehr Kunden gefunden.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panLinks.add((Component)this.lblMoreResults, gridBagConstraints);
        this.panGefKunden.setPreferredSize(new Dimension(460, 280));
        this.panGefKunden.setLayout(new GridBagLayout());
        this.scrlKundenliste.setBackground(new Color(255, 255, 255));
        this.scrlKundenliste.setBorder(null);
        this.tblKundenliste.getSelectionModel().setSelectionMode(0);
        this.scrlKundenliste.setViewportView(this.tblKundenliste);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panGefKunden.add((Component)this.scrlKundenliste, gridBagConstraints);
        this.lblTitel.setForeground(new Color(212, 55, 28));
        this.lblTitel.setText("Gefundene Kunden");
        this.lblTitel.setName("headline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panGefKunden.add((Component)this.lblTitel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panLinks.add((Component)this.panGefKunden, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panLinks, gridBagConstraints);
        this.panRechts.setBorder(BorderFactory.createTitledBorder(""));
        this.panRechts.setLayout(new GridBagLayout());
        this.panKundendaten.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.fldKundennr);
        this.jLabel2.setText("Kundennummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setLabelFor(this.fldVorname);
        this.jLabel3.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setLabelFor(this.fldName);
        this.jLabel4.setText("Nachname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fldTelefon);
        this.jLabel5.setText("Telefon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setLabelFor(this.fldEmail);
        this.jLabel6.setText("E-Mail:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setLabelFor(this.fldStrNr);
        this.jLabel7.setText("Stra\u00dfe/Nr:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setLabelFor(this.fldPlz);
        this.jLabel8.setText("Postleitzahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setLabelFor(this.fldOrt);
        this.jLabel9.setText("Ort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setLabelFor(this.cmbLand);
        this.jLabel10.setText("Land:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel1.setText("Bemerkungen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.panKundendaten.add((Component)this.jLabel1, gridBagConstraints);
        this.fldKundennr.setFont(new Font("SansSerif", 0, 12));
        this.fldKundennr.setName("kundennr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldKundennr, gridBagConstraints);
        this.fldVorname.setFont(new Font("SansSerif", 0, 12));
        this.fldVorname.setName("vorname");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldVorname, gridBagConstraints);
        this.fldName.setFont(new Font("SansSerif", 0, 12));
        this.fldName.setName("name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldName, gridBagConstraints);
        this.fldTelefon.setFont(new Font("SansSerif", 0, 12));
        this.fldTelefon.setName("telefon");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldTelefon, gridBagConstraints);
        this.fldEmail.setFont(new Font("SansSerif", 0, 12));
        this.fldEmail.setName("email");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldEmail, gridBagConstraints);
        this.fldStrNr.setFont(new Font("SansSerif", 0, 12));
        this.fldStrNr.setName("str_nr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldStrNr, gridBagConstraints);
        this.fldPlz.setFont(new Font("SansSerif", 0, 12));
        this.fldPlz.setName("plz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldPlz, gridBagConstraints);
        this.fldOrt.setFont(new Font("SansSerif", 0, 12));
        this.fldOrt.setName("ort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldOrt, gridBagConstraints);
        this.cmbLand.setFont(this.cmbLand.getFont());
        this.cmbLand.setName("land_kz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.cmbLand, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.cmdKundeClear.setText("Neuer Kunde");
        this.cmdKundeClear.setToolTipText("Neuer Kunde");
        this.cmdKundeClear.setFocusable(false);
        this.cmdKundeClear.setHorizontalTextPosition(0);
        this.cmdKundeClear.setVerticalTextPosition(3);
        this.cmdKundeClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.cmdKundeClear, gridBagConstraints);
        this.cmdKundePost.setText("Kundendaten Speichern");
        this.cmdKundePost.setToolTipText("Kundendaten Speichern");
        this.cmdKundePost.setFocusable(false);
        this.cmdKundePost.setHorizontalTextPosition(0);
        this.cmdKundePost.setVerticalTextPosition(3);
        this.cmdKundePost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundePostActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.cmdKundePost, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.cmdKundeCancel.setText("Verwerfen");
        this.cmdKundeCancel.setToolTipText("Verwerfen");
        this.cmdKundeCancel.setFocusable(false);
        this.cmdKundeCancel.setHorizontalTextPosition(0);
        this.cmdKundeCancel.setVerticalTextPosition(3);
        this.cmdKundeCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.cmdKundeCancel, new GridBagConstraints());
        this.cmdKundeDelete.setText("Kunde l\u00f6schen");
        this.cmdKundeDelete.setToolTipText("Kunde l\u00f6schen");
        this.cmdKundeDelete.setEnabled(false);
        this.cmdKundeDelete.setFocusable(false);
        this.cmdKundeDelete.setHorizontalTextPosition(0);
        this.cmdKundeDelete.setVerticalTextPosition(3);
        this.cmdKundeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel2.add((Component)this.cmdKundeDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 17, 0);
        this.panKundendaten.add((Component)this.jPanel2, gridBagConstraints);
        this.txtBemerkungen.setColumns(20);
        this.txtBemerkungen.setRows(5);
        this.txtBemerkungen.setName("bemerkungen");
        this.scrlBemerkungen.setViewportView(this.txtBemerkungen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panKundendaten.add((Component)this.scrlBemerkungen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panRechts.add((Component)this.panKundendaten, gridBagConstraints);
        this.panAnfragen.setPreferredSize(new Dimension(400, 200));
        this.panAnfragen.setLayout(new GridBagLayout());
        this.scrlAnfragen.setBackground(new Color(255, 255, 255));
        this.scrlAnfragen.setBorder(null);
        this.tblAnfragen.setName("vh_anfrageprodukte");
        this.tblAnfragen.setOpaque(false);
        this.scrlAnfragen.setViewportView(this.tblAnfragen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panAnfragen.add((Component)this.scrlAnfragen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panRechts.add((Component)this.panAnfragen, gridBagConstraints);
        this.lblUeberschrift.setForeground(new Color(212, 55, 28));
        this.lblUeberschrift.setText("Kundendaten");
        this.lblUeberschrift.setName("headline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panRechts.add((Component)this.lblUeberschrift, gridBagConstraints);
        this.jLabel14.setForeground(new Color(212, 55, 28));
        this.jLabel14.setText("Letzte Anfragen");
        this.jLabel14.setName("headline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panRechts.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panRechts, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void cmdSuchenActionPerformed(ActionEvent evt) {
        try {
            this.evKundenliste.clearFilterValues();
            if (this.fldSucheKundennr.getText().length() > 0) {
                this.evKundenliste.setFilterValue("kundennr", this.fldSucheKundennr.getText().toLowerCase(this.session.getLocale()));
            }
            if (this.fldSucheName.getText().length() > 0) {
                this.evKundenliste.setFilterValue("name", this.fldSucheName.getText().toLowerCase(this.session.getLocale()));
            }
            if (this.fldSucheVorname.getText().length() > 0) {
                this.evKundenliste.setFilterValue("vorname", this.fldSucheVorname.getText().toLowerCase(this.session.getLocale()));
            }
            this.lblMoreResults.setVisible(false);
            this.evKundenliste.fetch();
            this.lblMoreResults.setVisible(this.evKundenliste.hasMoreRows());
            this.frmNavigator.disableProdukte();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeClearActionPerformed(ActionEvent evt) {
        try {
            if (this.kunde.hasChanged()) {
                JOptionPane.showMessageDialog(this, "\u00c4nderungen an '" + this.kunde.toString() + "' bitte vorher speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 0);
                return;
            }
            this.kunde.clear();
            this.iRowKundeSelected = -1;
            this.tblKundenliste.clearSelection();
            this.frmNavigator.disableProdukte();
            this.clearKundenlisteSelection();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeDeleteActionPerformed(ActionEvent evt) {
        try {
            YFieldValue fieldValue = this.kunde.getPkFieldValue();
            if (fieldValue.wasNull()) {
                this.kunde.clear();
            } else {
                int a = JOptionPane.showConfirmDialog(this, this.kunde.toString() + " l\u00f6schen ?", "Best\u00e4tigung", 0);
                if (a == 1) {
                    return;
                }
                this.kunde.delete();
            }
            if (this.iRowKundeSelected >= 0) {
                int iRow = this.iRowKundeSelected;
                this.evKundenliste.removeRow(iRow);
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeCancelActionPerformed(ActionEvent evt) {
        try {
            this.kunde.revert();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundePostActionPerformed(ActionEvent evt) {
        int iRow = this.tblKundenliste.getSelectedRow();
        try {
            int a;
            if (!this.kunde.hasKontaktDaten() && (a = JOptionPane.showConfirmDialog(this, "Kunden ohne oder mit unvollst\u00e4ndigen Kontakdaten speichern?\n(Telefonnummer oder eMail-Adresse w\u00fcrde ausreichen.))", "Fehlende Kontaktdaten", 0, 3)) == 1) {
                return;
            }
            this.kunde.post();
            if (iRow < 0) {
                return;
            }
            if (this.kunde.getPkFieldValueAsInt() != this.evKundenliste.getAsInt(iRow, "kunde_id")) {
                return;
            }
            this.evKundenliste.setAsString(iRow, "vorname", this.kunde.getAsString("vorname"));
            this.evKundenliste.setAsString(iRow, "name", this.kunde.getAsString("name"));
            this.evKundenliste.setAsString(iRow, "ort", this.kunde.getAsString("ort"));
            this.evKundenliste.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, iRow));
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }
}

