/*
 * Decompiled with CFR 0.152.
 */
package popometer.print;

import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JTabbedPane;
import popometer.dbobjects.YROAusfuehrung;
import popometer.dbobjects.YROHaendler;
import popometer.panels.PanErgebnis;
import popometer.panels.PanKoerper;
import popometer.panels.PanKundendaten;
import projektY.base.YException;
import projektY.database.YDatabaseList;
import projektY.latex.YLaTeXGenerator;
import projektY.latex.YLaTeXParser;
import projektY.utils.YConfigFile;

public class YBikeAndFitReport
extends YLaTeXGenerator {
    private YROHaendler haendler;
    private PanKundendaten panKundendaten;
    private PanKoerper panKoerper;
    private JTabbedPane panProdukte;
    private String bodyImagePath;
    private String imageCacheDir;
    PanErgebnis panErgebnis;
    int idxProduktart;
    YDatabaseList databaseList;
    int nextIdxRow;
    YROAusfuehrung roTopProdukt;

    public YBikeAndFitReport(OutputStream output, YROHaendler haendler, PanKundendaten panKundendaten, PanKoerper panKoerper, JTabbedPane panProdukte, YConfigFile configFile) {
        super(output);
        this.haendler = haendler;
        this.panKundendaten = panKundendaten;
        this.panKoerper = panKoerper;
        this.panProdukte = panProdukte;
        this.bodyImagePath = configFile.findValue("BFIMAGE");
        this.imageCacheDir = configFile.findValue("CACHEDIR");
        this.imageCacheDir = this.imageCacheDir.endsWith("/") ? this.imageCacheDir + "images/" : this.imageCacheDir + "/images/";
        this.panErgebnis = null;
        this.idxProduktart = -1;
        this.roTopProdukt = null;
    }

    @Override
    protected void insertText(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        String name = attributes.getAttributeValue("name");
        if (this.idxProduktart >= 0) {
            if (name.equals("Produktart")) {
                this.writeAsLaTeX(this.panProdukte.getTitleAt(this.idxProduktart));
            } else if (name.equals("Bildname")) {
                if (this.roTopProdukt != null) {
                    this.writeAsLaTeX(this.roTopProdukt.getAsString("bildname"));
                }
            } else if (name.equals("Bild")) {
                String bildname = this.roTopProdukt.getAsString("bildname");
                if (bildname.length() > 0) {
                    File imageFile = new File(this.imageCacheDir + bildname + ".jpg");
                    if (imageFile.exists()) {
                        this.writePlain("\\includegraphics[natwidth=39.4mm,natheight=19.4mm,width=4cm]{" + this.imageCacheDir + bildname + ".jpg" + "}");
                    }
                    return;
                }
                this.writeAsLaTeX("Leider kein Bild.");
            }
            return;
        }
        if (name.equals("Datum")) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("d.M.yyyy");
            this.writeAsLaTeX(sdf.format(cal.getTime()));
        } else if (name.equals("BFIMAGE")) {
            this.writePlain(this.bodyImagePath);
        } else if (name.equals("ExpertVorname")) {
            this.writeAsLaTeX(this.panKundendaten.getExpertVorname());
        } else if (name.equals("ExpertName")) {
            this.writeAsLaTeX(this.panKundendaten.getExpertName());
        } else if (name.equals("firma")) {
            this.writeAsLaTeX(this.haendler.getAsString("firma"));
        } else if (name.equals("str_nr")) {
            this.writeAsLaTeX(this.haendler.getAsString("str_nr"));
        } else if (name.equals("plz_ort")) {
            this.writeAsLaTeX(this.haendler.getAsString("plz") + " " + this.haendler.getAsString("ort"));
        } else if (name.equals("lUA")) {
            this.writeAsLaTeX(this.panKoerper.fldLUnterarm.getText());
        } else if (name.equals("lOA")) {
            this.writeAsLaTeX(this.panKoerper.fldLOberarm.getText());
        } else if (name.equals("lOK")) {
            this.writeAsLaTeX(this.panKoerper.fldLOberkoerper.getText());
        } else if (name.equals("lOS")) {
            this.writeAsLaTeX(this.panKoerper.fldLOberschenkel.getText());
        } else if (name.equals("lUSF")) {
            this.writeAsLaTeX(this.panKoerper.fldLUnterschenkel.getText());
        } else if (name.equals("Sitzposition")) {
            this.writeAsLaTeX(this.panKoerper.lblSitzposition.getText());
        } else if (name.equals("mdOben")) {
            this.writeAsLaTeX(this.panKoerper.lblDreieckOben.getText());
        } else if (name.equals("mdVorn")) {
            this.writeAsLaTeX(this.panKoerper.lblDreieckVorn.getText());
        } else if (name.equals("mdHinten")) {
            this.writeAsLaTeX(this.panKoerper.lblDreieckHinten.getText());
        } else if (name.equals("mdWinkel")) {
            String winkel = this.panKoerper.lblDreieckWinkel.getText();
            this.writeAsLaTeX(winkel.substring(0, winkel.length() - 1));
        }
    }

    @Override
    protected boolean nextLoop(YLaTeXParser.YLaTeXTagAttributes attributes) {
        String name = attributes.getAttributeValue("name");
        if (name.equals("Produktarten")) {
            ++this.idxProduktart;
            while (this.idxProduktart < this.panProdukte.getComponentCount()) {
                if (this.panProdukte.getComponentAt(this.idxProduktart) instanceof PanErgebnis && this.panProdukte.isEnabledAt(this.idxProduktart)) {
                    this.panErgebnis = (PanErgebnis)this.panProdukte.getComponentAt(this.idxProduktart);
                    this.roTopProdukt = this.panErgebnis.roTopProdukte[0];
                    return true;
                }
                ++this.idxProduktart;
            }
            this.idxProduktart = -1;
            this.panErgebnis = null;
            this.roTopProdukt = null;
        }
        return false;
    }

    @Override
    protected boolean startTable(YLaTeXParser.YLaTeXTagAttributes attributes) {
        String name = attributes.getAttributeValue("name");
        if (this.panErgebnis == null) {
            return false;
        }
        if (name.equals("produkte")) {
            this.databaseList = this.panErgebnis.evAusfuehrungen;
            this.nextIdxRow = -1;
            return true;
        }
        if (name.equals("eignung")) {
            this.databaseList = this.panErgebnis.evProduktBewertungen[0];
            this.nextIdxRow = -1;
            return true;
        }
        return false;
    }

    @Override
    protected void endTable() {
        this.databaseList = null;
    }

    @Override
    protected boolean nextRow(YLaTeXParser.YLaTeXTagAttributes attributes) {
        try {
            return ++this.nextIdxRow < this.databaseList.getRowCount();
        }
        catch (YException e) {
            return false;
        }
    }

    @Override
    protected void insertTD(YLaTeXParser.YLaTeXTagAttributes attributes) {
        String name = attributes.getAttributeValue("name");
        try {
            this.writeAsLaTeX(this.databaseList.getAsString(this.nextIdxRow, name));
        }
        catch (YException e) {
            try {
                this.writeAsLaTeX("ERR");
            }
            catch (YException e2) {
                // empty catch block
            }
        }
    }
}

