/*
 * Decompiled with CFR 0.152.
 */
package projektY.latex;

import java.io.FileNotFoundException;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.database.YColumnDefinition;
import projektY.database.YEvaluationList;
import projektY.database.YFieldValue;
import projektY.database.YSession;
import projektY.latex.YLaTeXGenerator;
import projektY.latex.YLaTeXParser;

public abstract class YLaTeXReportGenerator
extends YLaTeXGenerator {
    private YSession session;
    private Vector<YEvaluationList> evaluationLists;
    private Stack<YEvaluationList> tableLists;

    protected YLaTeXReportGenerator(String nameOutputFile, YSession session) throws FileNotFoundException {
        super(nameOutputFile);
        this.session = session;
        this.evaluationLists = new Vector(5);
        this.tableLists = new Stack();
    }

    private YEvaluationList getEvaluationList(String name) throws YException {
        for (int i = 0; i < this.evaluationLists.size(); ++i) {
            YEvaluationList evaluationList = this.evaluationLists.get(i);
            if (!evaluationList.getName().equals(name)) continue;
            return evaluationList;
        }
        throw new YException("Zeile " + this.getRunTag().getILine() + ": YSQL id=" + name + " existiert nicht.");
    }

    private YColumnDefinition.FieldType strToFieldType(String fieldTypeAsString) throws YException {
        if (fieldTypeAsString.equals("STRING")) {
            return YColumnDefinition.FieldType.STRING;
        }
        if (fieldTypeAsString.equals("INT")) {
            return YColumnDefinition.FieldType.INT;
        }
        if (fieldTypeAsString.equals("FLOAT")) {
            return YColumnDefinition.FieldType.FLOAT;
        }
        if (fieldTypeAsString.equals("BOOLEAN")) {
            return YColumnDefinition.FieldType.BOOLEAN;
        }
        if (fieldTypeAsString.equals("DATE")) {
            return YColumnDefinition.FieldType.DATE;
        }
        if (fieldTypeAsString.equals("DOUBLE")) {
            return YColumnDefinition.FieldType.DOUBLE;
        }
        if (fieldTypeAsString.equals("LONG")) {
            return YColumnDefinition.FieldType.LONG;
        }
        if (fieldTypeAsString.equals("SHORT")) {
            return YColumnDefinition.FieldType.SHORT;
        }
        if (fieldTypeAsString.equals("TIMESTAMP")) {
            return YColumnDefinition.FieldType.TIMESTAMP;
        }
        throw new YException("Unbekannter Feldtyp: " + fieldTypeAsString);
    }

    protected abstract String askParameter(String var1) throws YException;

    @Override
    protected void handleTag(YLaTeXParser.YLaTeXTag tag) throws YException {
        String tagName = tag.getName();
        YLaTeXParser.YLaTeXTagAttributes attributes = tag.getAttributes();
        if (tagName.equals("YSQL")) {
            int nFields;
            String id = tag.getAttributeValue("id");
            String attribute = tag.getAttributeValue("nfields");
            try {
                nFields = Integer.parseInt(attribute);
            }
            catch (NumberFormatException e) {
                throw new YException("Zeile " + tag.getILine() + ": ung\u00fcltige Zahl f\u00fcr nfields.");
            }
            attribute = tag.getAttributeValue("sql");
            YEvaluationList evaluationList = new YEvaluationList(this.session, nFields, id);
            evaluationList.setSQLSelect(attribute);
            attribute = tag.getAttributes().getAttributeValue("order");
            if (attribute != null) {
                evaluationList.setOrder(attribute.split("[, ]"));
            }
            this.evaluationLists.add(evaluationList);
        } else if (tagName.equals("YFIELD")) {
            if (this.evaluationLists.size() == 0) {
                throw new YException("Zeile " + tag.getILine() + ": YFIELD ohne vorhergehendes YSQL.");
            }
            YEvaluationList evaluationList = this.evaluationLists.get(this.evaluationLists.size() - 1);
            String id = tag.getAttributeValue("id");
            String type = attributes.getAttributeValue("type");
            String format = attributes.getAttributeValue("format");
            YColumnDefinition columnDefinition = evaluationList.addDBField(id, this.strToFieldType(type));
            if (format != null) {
                columnDefinition.setNumFormat(format);
            }
        } else if (tagName.equals("YPARAM")) {
            String filterValue;
            String ysqlId = tag.getAttributeValue("ysqlid");
            YEvaluationList evaluationList = this.getEvaluationList(ysqlId);
            String id = tag.getAttributeValue("id");
            String sourcesqlid = attributes.getAttributeValue("sourcesqlid");
            if (!evaluationList.existsFilter(id)) {
                String sql = tag.getAttributeValue("sql");
                String type = tag.getAttributeValue("type");
                evaluationList.addFilter(id, sql, this.strToFieldType(type));
            }
            if (sourcesqlid == null) {
                String label = attributes.getAttributeValue("label");
                if (label == null) {
                    label = id;
                }
                if ((filterValue = this.askParameter(label)) == null) {
                    this.writeAsLaTeX("Reportgenerierung vom Benutzer abgebrochen.\n\\end{document}");
                    throw new YUserException("Reportgenerierung abgebrochen");
                }
            } else {
                YEvaluationList sourceList = this.getEvaluationList(sourcesqlid);
                int iRow = sourceList.getActiveRow();
                String sourceid = tag.getAttributeValue("sourceid");
                if (iRow < 0) {
                    throw new YProgramException(this, id + " f\u00fcr " + ysqlId + " kann nicht gesetzt werden:\n" + sourcesqlid + " hat keinen aktiven Datensatz.");
                }
                filterValue = sourceList.getAsString(iRow, sourceid);
            }
            evaluationList.setFilterValue(id, filterValue);
            evaluationList.unsetActiveRow();
        }
    }

    private YEvaluationList initYSQL() throws YException {
        int iRow;
        String ysqlId = this.getRunTag().getAttributeValue("ysqlid");
        YEvaluationList evaluationList = this.getEvaluationList(ysqlId);
        if (!evaluationList.isFinalized()) {
            evaluationList.finalize();
        }
        if ((iRow = evaluationList.getActiveRow()) < 0) {
            evaluationList.fetch();
        }
        return evaluationList;
    }

    @Override
    protected boolean nextLoop(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        YEvaluationList evaluationList = this.initYSQL();
        int iRow = evaluationList.getActiveRow();
        if (++iRow >= evaluationList.getRowCount()) {
            evaluationList.fetch();
            iRow = evaluationList.getActiveRow();
            return false;
        }
        evaluationList.setActiveRow(iRow);
        return true;
    }

    @Override
    protected boolean startTable(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        this.tableLists.push(this.initYSQL());
        return true;
    }

    @Override
    protected boolean nextRow(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        YEvaluationList evaluationList;
        try {
            evaluationList = this.tableLists.peek();
        }
        catch (EmptyStackException e) {
            throw new YException("Zeile " + this.getRunTag().getILine() + ": YTR au\u00dferhalb einer Tabelle.");
        }
        int iRow = evaluationList.getActiveRow();
        if (++iRow >= evaluationList.getRowCount()) {
            return false;
        }
        evaluationList.setActiveRow(iRow);
        return true;
    }

    private void insertText(YEvaluationList evaluationList, YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        String id = attributes.getAttributeValue("id");
        if (id == null) {
            throw new YException("Zeile " + this.getRunTag().getILine() + ": Fehlendes id-Attribut in Zeile.");
        }
        YFieldValue fvValue = evaluationList.getActiveRowValues().getFieldValue(id);
        String value = "";
        if (fvValue.isNull()) {
            value = attributes.getAttributeValue("ifnull");
            if (value != null) {
                this.writePlain(value);
            }
        } else {
            value = attributes.getAttributeValue("prefix");
            if (value != null) {
                this.writePlain(value);
            }
            value = evaluationList.getActiveRowValues().getAsString(id);
            this.writeAsLaTeX(value);
            value = attributes.getAttributeValue("postfix");
            if (value != null) {
                this.writePlain(value);
            }
        }
    }

    @Override
    protected void insertTD(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        YEvaluationList evaluationList;
        try {
            evaluationList = this.tableLists.peek();
        }
        catch (EmptyStackException e) {
            throw new YException("Zeile " + this.getRunTag().getILine() + ": YTD au\u00dferhalb einer Tabelle.");
        }
        this.insertText(evaluationList, attributes);
    }

    @Override
    protected void insertText(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        String ysqlId = attributes.getAttributeValue("ysqlid");
        YEvaluationList evaluationList = this.getEvaluationList(ysqlId);
        this.insertText(evaluationList, attributes);
    }

    @Override
    protected void endTable() throws YException {
        try {
            this.tableLists.pop();
        }
        catch (EmptyStackException e) {
            throw new YException("Zeile " + this.getRunTag().getILine() + ": YTABLE/ ohne zugeh\u00f6rigess Starttag.");
        }
    }
}

