/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.base.YProgramException;
import projektY.database.YCheckColumnDefinition;
import projektY.database.YColumnDefinition;
import projektY.database.YDatabaseList;
import projektY.database.YDatabaseObject;
import projektY.database.YFieldValue;
import projektY.database.YListFkColumnDefinition;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YRowFkColumnDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;

public class YRowDefinition {
    private YDatabaseObject databaseObject;
    int nColumns;
    YColumnDefinition[] columnDefinitions;
    private int nPkCols;
    private YColumnDefinition pkColumnDefinition;
    YColumnDefinition[] toStringColumns;
    boolean concatToString;
    String concatString;

    public YRowDefinition(YDatabaseObject databaseObject, int maxColumns) {
        this.databaseObject = databaseObject;
        this.columnDefinitions = new YColumnDefinition[maxColumns];
        this.nColumns = 0;
        this.nPkCols = 0;
        this.pkColumnDefinition = null;
    }

    private void addColumnDefinition(YColumnDefinition columnDefinition) throws YException {
        int j;
        int i;
        if (this.nColumns >= this.columnDefinitions.length) {
            throw new YProgramException(this.databaseObject, "Zu viele Spaltendefinitionen.");
        }
        String name = columnDefinition.getName();
        for (i = 0; i < this.nColumns; ++i) {
            j = this.columnDefinitions[i].getName().compareTo(name);
            if (j == 0) {
                throw new YProgramException(this.databaseObject, "Die Spalte '" + name + "' ist bereits definiert.");
            }
            if (j > 0) break;
        }
        for (j = this.nColumns; j > i; --j) {
            this.columnDefinitions[j] = this.columnDefinitions[j - 1];
        }
        this.columnDefinitions[j] = columnDefinition;
        ++this.nColumns;
        if (columnDefinition.isPrimaryKey()) {
            this.pkColumnDefinition = ++this.nPkCols == 1 ? columnDefinition : null;
        }
    }

    public YColumnDefinition addColumnDefinition(String name, YColumnDefinition.FieldType fieldType, boolean primaryKey, boolean readOnly) throws YException {
        YColumnDefinition columnDefinition = new YColumnDefinition(this.nColumns, name, fieldType, primaryKey, readOnly);
        this.addColumnDefinition(columnDefinition);
        return columnDefinition;
    }

    public YColumnDefinition addAliasDefinition(String name, YColumnDefinition columnDefinition) throws YException {
        YColumnDefinition aliasDefinition = new YColumnDefinition(this.nColumns, name, columnDefinition);
        this.addColumnDefinition(aliasDefinition);
        return aliasDefinition;
    }

    public YRowFkColumnDefinition addFkColumnDefinition(String name, YRowObject referencedObject) throws YException {
        YRowFkColumnDefinition rowFkColumnDefinition = new YRowFkColumnDefinition(this.nColumns, name, referencedObject);
        this.addColumnDefinition(rowFkColumnDefinition);
        return rowFkColumnDefinition;
    }

    public YRowFkColumnDefinition addPkFkColumnDefinition(String name, YRowObject referencedObject) throws YException {
        YRowFkColumnDefinition rowFkColumnDefinition = new YRowFkColumnDefinition(this.nColumns, name, referencedObject, true);
        this.addColumnDefinition(rowFkColumnDefinition);
        return rowFkColumnDefinition;
    }

    public YLookUpDBColumnDefinition addLookUpDBColumnDefinition(String name, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YException {
        YLookUpDBColumnDefinition lookUpColumnDefinition = new YLookUpDBColumnDefinition(this.nColumns, name, lookUpList, valueFieldName, altFieldName);
        this.addColumnDefinition(lookUpColumnDefinition);
        return lookUpColumnDefinition;
    }

    public YLookUpDBColumnDefinition addLookUpDBColumnDefinition(String name, YDatabaseList lookUpList, String valueFieldName) throws YException {
        YLookUpDBColumnDefinition lookUpColumnDefinition = new YLookUpDBColumnDefinition(this.nColumns, name, lookUpList, valueFieldName);
        this.addColumnDefinition(lookUpColumnDefinition);
        return lookUpColumnDefinition;
    }

    public YLookUpDomainColumnDefinition addLookUpDomainDefinition(String name, YColumnDefinition.FieldType fieldType, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = new YLookUpDomainColumnDefinition(this.nColumns, name, fieldType, domain);
        this.addColumnDefinition(lookUpDomainColumnDefinition);
        return lookUpDomainColumnDefinition;
    }

    public YLookUpDomainColumnDefinition addLookUpDomainDefinition(String name, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = new YLookUpDomainColumnDefinition(this.nColumns, name, domain);
        this.addColumnDefinition(lookUpDomainColumnDefinition);
        return lookUpDomainColumnDefinition;
    }

    public YCheckColumnDefinition addCheckColumnDefinition(String name) throws YException {
        YCheckColumnDefinition checkColumnDefinition = new YCheckColumnDefinition(this.nColumns, name);
        this.addColumnDefinition(checkColumnDefinition);
        return checkColumnDefinition;
    }

    public YListFkColumnDefinition addFkColumnDefinition(String name, YRowObjectList referencedRowList) throws YException {
        YListFkColumnDefinition listFkColumnDefinition = new YListFkColumnDefinition(this.nColumns, name, referencedRowList);
        this.addColumnDefinition(listFkColumnDefinition);
        return listFkColumnDefinition;
    }

    void setToStringFields(String[] fieldNames, String concatWith) throws YException {
        if (concatWith == null) {
            this.concatToString = false;
            this.concatString = null;
        } else {
            this.concatToString = true;
            this.concatString = concatWith;
        }
        int nToStringColumns = fieldNames.length;
        this.toStringColumns = new YColumnDefinition[nToStringColumns];
        for (int i = 0; i < nToStringColumns; ++i) {
            this.toStringColumns[i] = this.getColumnDefinition(fieldNames[i]);
        }
    }

    void setToStringFields(String[] fieldNames) throws YException {
        this.setToStringFields(fieldNames, null);
    }

    void setToStringFields(String[] fieldNames, boolean concat) throws YException {
        if (concat) {
            this.setToStringFields(fieldNames, " ");
        } else {
            this.setToStringFields(fieldNames);
        }
    }

    void setToStringField(String fieldName) throws YException {
        this.setToStringFields(new String[]{fieldName}, false);
    }

    private int getArrayIndex(String columnName) {
        int l = 0;
        int r = this.nColumns - 1;
        while (l <= r) {
            int i = (l + r) / 2;
            int c = this.columnDefinitions[i].getName().compareTo(columnName);
            if (c > 0) {
                r = i - 1;
                continue;
            }
            if (c < 0) {
                l = i + 1;
                continue;
            }
            return i;
        }
        return -1;
    }

    public boolean isColumnDefined(String columnName) {
        return this.getArrayIndex(columnName) >= 0;
    }

    public int getFieldValueIndex(String columnName) throws YException {
        int i = this.getArrayIndex(columnName);
        if (i < 0) {
            throw new YProgramException(this.databaseObject, "Unbekannte Datenbankspalte: " + columnName);
        }
        return this.columnDefinitions[i].getFieldValueIndex();
    }

    public boolean columnExists(String columnName) {
        return this.getArrayIndex(columnName) >= 0;
    }

    public YColumnDefinition getPkColumnDefinition() throws YProgramException {
        if (this.pkColumnDefinition == null) {
            throw new YProgramException(this, "Es gibt kein eindeutiges Prim\u00e4rschl\u00fcsselfeld.");
        }
        return this.pkColumnDefinition;
    }

    public int getMaxColumns() {
        if (this.columnDefinitions == null) {
            return 0;
        }
        return this.columnDefinitions.length;
    }

    public int getNColumns() {
        return this.nColumns;
    }

    public YColumnDefinition getColumnDefinition(int i) {
        return this.columnDefinitions[i];
    }

    public YColumnDefinition getColumnDefinition(String columnName) throws YException {
        int i = this.getArrayIndex(columnName);
        if (i < 0) {
            throw new YProgramException(this.databaseObject, "Unbekannte Datenbankspalte: " + columnName);
        }
        return this.columnDefinitions[i];
    }

    public YRowValues createRowValues(int rowId) throws YException {
        int iCol;
        int nToStringColumns = this.toStringColumns == null ? 0 : this.toStringColumns.length;
        YRowValues rowValues = new YRowValues(this, rowId);
        for (iCol = 0; iCol < this.nColumns; ++iCol) {
            YColumnDefinition columnDefinition = this.columnDefinitions[iCol];
            if (columnDefinition.isRowFk()) {
                rowValues.createFkFieldValue((YRowFkColumnDefinition)columnDefinition);
                continue;
            }
            if (columnDefinition.isListFk()) {
                rowValues.createFkFieldValue((YListFkColumnDefinition)columnDefinition);
                continue;
            }
            if (columnDefinition.isLookUp()) {
                rowValues.createLookUpFieldValue((YLookUpColumnDefinition)columnDefinition);
                continue;
            }
            if (columnDefinition.isCheck()) {
                rowValues.createCheckFieldValue((YCheckColumnDefinition)columnDefinition);
                continue;
            }
            rowValues.createDBFieldValue(columnDefinition);
        }
        if (nToStringColumns > 0) {
            rowValues.toStringValues = new YFieldValue[nToStringColumns];
            for (iCol = 0; iCol < nToStringColumns; ++iCol) {
                rowValues.toStringValues[iCol] = rowValues.getFieldValue(this.toStringColumns[iCol]);
            }
        }
        return rowValues;
    }
}

