/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabase;
import projektY.database.YFieldValue;
import projektY.database.YFilteredList;
import projektY.database.YListFkColumnDefinition;
import projektY.database.YListFkFieldValue;
import projektY.database.YNullValueException;
import projektY.database.YRowDefinition;
import projektY.database.YRowFkColumnDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.YSubRowList;
import projektY.database.YSubRowListImplementation;

public class YRowObjectList
extends YFilteredList {
    private YRowObject postObject = null;
    private YFieldValue[] postValues;
    YColumnDefinition rowPkDefinition;
    private boolean defaultsSet;
    protected Vector<YSubRowListImplementation> subListImplementations;

    public YRowObjectList(YSession session, int maxColumns, int maxRows) {
        super(session, maxColumns, maxRows);
        this.postValues = null;
        this.subListImplementations = new Vector(3, 3);
    }

    public YRowObjectList(YSession session, int maxColumns, boolean readOnly) {
        super(session, maxColumns, readOnly);
        this.subListImplementations = new Vector(3, 3);
    }

    public YRowObjectList(YSession session, int maxColumns) {
        this(session, maxColumns, false);
    }

    public YRowObjectList(YRowObject rowObject) throws YException {
        this(rowObject.getSession(), rowObject.getColumnCount());
        int iCol;
        String tableName = rowObject.getTableName();
        Vector<YRowObject> rowObjects = rowObject.getRowobjects();
        int nRoObj = rowObjects.size();
        YRowDefinition rowDefinition0 = rowObject.getRowDefinition();
        int nCols = rowDefinition0.getNColumns();
        YColumnDefinition columnDefinition = null;
        StringBuffer selectSQL = new StringBuffer(200);
        StringBuffer fromSQL = new StringBuffer(200);
        fromSQL.append(" FROM " + tableName);
        for (iCol = 0; iCol < nCols; ++iCol) {
            if (selectSQL.length() == 0) {
                selectSQL.append("SELECT ");
            } else {
                selectSQL.append(", ");
            }
            YColumnDefinition columnDefinition0 = rowDefinition0.getColumnDefinition(iCol);
            if (columnDefinition0.isPrimaryKey()) {
                columnDefinition = this.addPkField(columnDefinition0.getName());
                selectSQL.append(tableName + "." + columnDefinition.getName());
            } else if (columnDefinition0.isForeignKey()) {
                YRowObject refRowObject = ((YRowFkColumnDefinition)columnDefinition0).getReferencedObject();
                String refTableName = refRowObject.getTableName();
                String refTableAlias = refRowObject.getName();
                columnDefinition = this.addDBField(columnDefinition0.getName(), columnDefinition0.getFieldType());
                selectSQL.append(tableName + "." + columnDefinition.getName());
                fromSQL.append(" LEFT JOIN " + refTableName + " " + refTableAlias + " ON (");
                fromSQL.append(tableName + "." + columnDefinition.getName() + "=");
                fromSQL.append(refTableAlias + "." + refRowObject.getPkFieldValue().getColumnDefinition().getName() + ")");
            } else if (columnDefinition0.isAlias()) {
                YColumnDefinition rootDefinition = columnDefinition0.getRootDefinition();
                for (int iRoObj = 0; iRoObj < nRoObj; ++iRoObj) {
                    int i;
                    YRowDefinition rowDefinition = rowObjects.get(iRoObj).getRowDefinition();
                    int n = rowDefinition.getNColumns();
                    for (i = 0; i < n; ++i) {
                        if (rootDefinition != rowDefinition.getColumnDefinition(i)) continue;
                        YRowObject rowObject0 = rowObjects.get(iRoObj);
                        columnDefinition = this.addDBField(columnDefinition0.getName(), columnDefinition0.getFieldType());
                        selectSQL.append(rowObject0.getName() + "." + rootDefinition.getName());
                        selectSQL.append(" AS " + columnDefinition0.getName());
                        iRoObj = nRoObj;
                        break;
                    }
                    if (i < n) continue;
                    columnDefinition = null;
                }
            } else {
                columnDefinition = this.addDBField(columnDefinition0.getName(), columnDefinition0.getFieldType());
                selectSQL.append(tableName + "." + columnDefinition.getName());
            }
            if (columnDefinition == null) continue;
            columnDefinition.setLabel(columnDefinition0.getLabel());
            columnDefinition.setNotNull(columnDefinition0.getNotNullCondition());
            if (!columnDefinition.isANum()) continue;
            columnDefinition.setNumFormat(columnDefinition0.getNumFormat());
        }
        this.setSQLSelect(selectSQL.toString() + fromSQL.toString());
        this.setTableName(tableName);
        this.postObject = rowObject;
        this.postValues = new YFieldValue[this.getColumnCount()];
        for (iCol = 0; iCol < this.getColumnCount(); ++iCol) {
            this.postValues[iCol] = this.postObject.getFieldValue(this.rowDefinition.columnDefinitions[iCol].getName());
        }
    }

    public YColumnDefinition addPkField(String fieldName) throws YException {
        if (this.rowPkDefinition != null) {
            throw new YProgramException(this, "Prim\u00e4rschl\u00fcssel ist bereits gesetzt.");
        }
        this.rowPkDefinition = this.rowDefinition.addColumnDefinition(fieldName, YColumnDefinition.FieldType.INT, true, false);
        return this.rowPkDefinition;
    }

    public YColumnDefinition getRowPkDefinition() {
        return this.rowPkDefinition;
    }

    public YColumnDefinition addDatabaseField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        return this.addDBField(fieldName, fieldType);
    }

    protected void addSubList(YSubRowListImplementation subList) {
        this.subListImplementations.add(subList);
    }

    protected void addSubRowList(YSubRowListImplementation subRowList) {
        this.subListImplementations.add(subRowList);
    }

    public YSubRowListImplementation getSubRowList(String name) throws YException {
        int nSubRowLists = this.subListImplementations.size();
        for (int iSubRowList = 0; iSubRowList < nSubRowLists; ++iSubRowList) {
            YSubRowListImplementation subRowList = this.subListImplementations.get(iSubRowList);
            if (!subRowList.getName().equals(name)) continue;
            return subRowList;
        }
        throw new YProgramException(this, name + " geh\u00f6rt nicht zu diesem Objekt.");
    }

    protected YListFkColumnDefinition addSubRowFkField(String fieldName, YSubRowList referencedList) throws YException {
        return this.rowDefinition.addFkColumnDefinition(fieldName, referencedList);
    }

    void checkFinalized() throws YProgramException {
        super.checkFinalized();
        if (this.rowPkDefinition == null) {
            throw new YProgramException(this, "Prim\u00e4rschl\u00fcssel nicht definiert.");
        }
    }

    protected void fireUpdate(int iRow) throws YException {
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, this.getRowValues(iRow)));
    }

    public YRowObjectList fetch() throws YException {
        String where = super.createWhereExpression();
        super.fetch();
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            this.subListImplementations.get(iSub).setMasterFilter(this.tableName, this.rowPkDefinition.getName(), where);
            this.subListImplementations.get(iSub).fetch();
        }
        return this;
    }

    public int getRowId(int iRow) throws YException {
        return this.getRowValues(iRow).getRowId();
    }

    public int setActiveRow(int iRow) throws YException {
        if (this.changeLevel > 0) {
            return this.activeRow;
        }
        if (this.activeRow != iRow) {
            if (this.activeRow >= 0 && iRow >= 0) {
                this.requestRowValues(this.getRowValues(this.activeRow));
            }
            if (iRow < 0) {
                for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                    this.subListImplementations.get(iSub).unsetSubWindow();
                }
                this.activeRow = -1;
                this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, -1, null));
            } else {
                for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                    this.subListImplementations.get(iSub).setSubWindow(this.getRowId(iRow));
                }
                this.activeRow = iRow;
                this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, iRow, this.getRowValues(this.activeRow)));
            }
        }
        return this.activeRow;
    }

    public int unsetActiveRow() throws YException {
        if (this.activeRow != -1) {
            this.requestRowValues(this.getRowValues(this.activeRow));
            for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                this.subListImplementations.get(iSub).unsetSubWindow();
            }
            this.activeRow = -1;
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, -1, null));
        }
        return -1;
    }

    public YRowValues append(YRowObject rowObject) throws YException {
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
        }
        this.unsetActiveRow();
        YRowValues rowValues = super.append(rowObject);
        this.setActiveRow(this.getRowCount() - 1);
        return rowValues;
    }

    public int appendRow() throws YException {
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
        }
        this.unsetActiveRow();
        int iRow = super.appendRow();
        this.setActiveRow(iRow);
        return iRow;
    }

    protected void clearRowValues() throws YException {
        this.unsetActiveRow();
        super.clearRowValues();
    }

    protected boolean hasValuesToStore(YRowValues rowValues) throws YException {
        YFieldValue fieldValue;
        int iCol;
        for (iCol = 0; iCol < this.dispColCount; ++iCol) {
            fieldValue = rowValues.getFieldValue(this.dispIndicees[iCol]);
            if (fieldValue.getColumnDefinition().isReadOnly() || fieldValue.getValue().length() <= 0) continue;
            return true;
        }
        for (iCol = 0; iCol < this.xdispColCount; ++iCol) {
            fieldValue = rowValues.getFieldValue(this.xdispIndicees[iCol]);
            if (fieldValue.getColumnDefinition().isReadOnly() || fieldValue.getValue().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public final boolean hasValuesToStore(int iRow) throws YException {
        try {
            YRowValues rowValues = this.getRowValues(iRow);
            return this.hasValuesToStore(rowValues);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Zeilenindex: " + Integer.toString(iRow));
        }
    }

    public boolean hasRowsToStore() throws YException {
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            if (!this.hasValuesToStore(iRow)) continue;
            return true;
        }
        return false;
    }

    public final int countRowsToStore() throws YException {
        int nRows = this.getRowCount();
        int nRowsToStore = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            if (!this.hasValuesToStore(iRow)) continue;
            ++nRowsToStore;
        }
        return nRowsToStore;
    }

    public final boolean hasAbsValuesToStore(int iAbsRow) throws YException {
        try {
            YRowValues rowValues = this.getAbsRowValues(iAbsRow);
            return this.hasValuesToStore(rowValues);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Zeilenindex: " + Integer.toString(iAbsRow));
        }
    }

    public boolean setDefaults() throws YException {
        boolean defaultsSet = false;
        int nCols = this.rowDefinition.getNColumns();
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            YRowValues rowValues = this.getAbsRowValues(iRow);
            YFieldValue pkFieldValue = rowValues.getPkFieldValue();
            if (!pkFieldValue.wasNull() || !this.hasValuesToStore(rowValues)) continue;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                defaultsSet |= rowValues.getFieldValue(iCol).setDefaultIfNull();
            }
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            this.subListImplementations.get(iSub).setDefaults();
        }
        return defaultsSet;
    }

    protected void checkNotNull() throws YNullValueException, YException {
        int nCols = this.rowDefinition.getNColumns();
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            YRowValues rowValues = this.getAbsRowValues(iRow);
            if (!this.hasValuesToStore(rowValues)) continue;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                YFieldValue fieldValue = rowValues.getFieldValue(iCol);
                YColumnDefinition columnDefinition = fieldValue.getColumnDefinition();
                if (columnDefinition.isPrimaryKey() || columnDefinition.isReadOnly() || !fieldValue.isNull() || !columnDefinition.isNotNull()) continue;
                throw new YNullValueException(this.getLabel(), columnDefinition.getLabel(), iRow + 1);
            }
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            YSubRowListImplementation subList = this.subListImplementations.get(iSub);
            subList.checkNotNull();
        }
    }

    protected void beforeBegin() throws YException {
    }

    protected void afterBegin() throws YException {
    }

    protected void beforeRow(int iRow, YRowValues rowValues) throws YException {
    }

    protected void afterRow(int iRow, YRowValues rowValues) throws YException {
    }

    protected void beforeCommit() throws YException {
    }

    void postThis() throws YException {
        YDatabase database = this.session.getDatabase();
        StringBuffer sql = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            YFieldValue fieldValue;
            int iCol;
            YRowValues rowValues = this.getAbsRowValues(iRow);
            if (rowValues.hasDeleteMark()) continue;
            this.beforeRow(iRow, rowValues);
            YFieldValue pkFieldValue = rowValues.getFieldValue(this.rowPkDefinition);
            sql.delete(0, sql.length());
            sql2.delete(0, sql2.length());
            int nSqlFields = 0;
            if (pkFieldValue.wasNull()) {
                if (this.hasValuesToStore(rowValues)) {
                    int detailId = database.nextId(this.tableName);
                    pkFieldValue.setAutoId(detailId);
                    sql.append("INSERT INTO " + this.tableName + "(");
                    sql2.append(" VALUES (");
                    for (iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
                        fieldValue = rowValues.getFieldValue(iCol);
                        if (fieldValue.isAlias() || fieldValue.getColumnDefinition().isReadOnly() || fieldValue.getColumnDefinition().isEmpty() || fieldValue.isNull()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                            sql2.append(", ");
                        }
                        sql.append(fieldValue.getColumnDefinition().getName());
                        sql2.append(this.sqlValue(fieldValue));
                        ++nSqlFields;
                    }
                    sql.append(")");
                    sql.append(sql2);
                    sql.append(")");
                    rowValues.setPostMark();
                } else {
                    rowValues.setDeleteMark();
                }
            } else {
                if (this.hasValuesToStore(rowValues)) {
                    sql.append("UPDATE " + this.tableName + " SET ");
                    for (iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
                        fieldValue = rowValues.getFieldValue(iCol);
                        if (fieldValue.isAlias() || fieldValue.getColumnDefinition().isReadOnly() || fieldValue.getColumnDefinition().isEmpty() || fieldValue.getColumnDefinition().isPrimaryKey() || !fieldValue.hasChanged()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                        }
                        sql.append(rowValues.getFieldValue(iCol).getColumnDefinition().getName() + "=");
                        sql.append(this.sqlValue(rowValues.getFieldValue(iCol)));
                        ++nSqlFields;
                    }
                    if (nSqlFields == 0) continue;
                    rowValues.setPostMark();
                } else {
                    sql.append("DELETE FROM " + this.tableName);
                    rowValues.setDeleteMark();
                }
                sql.append(" WHERE " + this.rowPkDefinition.getName() + "=" + pkFieldValue.getValue0());
            }
            if (sql.length() > 0) {
                if (!database.isInTransaction()) {
                    database.startTransaction();
                }
                this.sqlDml.execute(sql.toString());
            }
            this.afterRow(iRow, rowValues);
        }
    }

    void postThis(YRowObject postObject) throws YException {
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            int iCol;
            YRowValues rowValues = this.getAbsRowValues(iRow);
            if (rowValues.hasDeleteMark()) continue;
            this.beforeRow(iRow, rowValues);
            if (!this.hasValuesToStore(rowValues)) {
                rowValues.modifyToNull();
            }
            for (iCol = 0; iCol < this.getColumnCount(); ++iCol) {
                this.postValues[iCol].cloneFrom(rowValues.getFieldValue(iCol));
            }
            postObject.post();
            for (iCol = 0; iCol < this.getColumnCount(); ++iCol) {
                rowValues.getFieldValue(iCol).cloneFrom(this.postValues[iCol]);
            }
            if (postObject.getRowValues().hasPostMark()) {
                rowValues.setPostMark();
            }
            if (postObject.getRowValues().hasDeleteMark()) {
                rowValues.setDeleteMark();
            }
            this.afterRow(iRow, rowValues);
        }
    }

    boolean setPosted() throws YException {
        boolean hasChanged = super.setPosted();
        hasChanged |= this.defaultsSet;
        this.defaultsSet = false;
        if (this.postObject != null) {
            this.postObject.setPosted();
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            if (!this.subListImplementations.get(iSub).setPosted()) continue;
            this.subListImplementations.get(iSub).fireChanged(new YDBOChangeEvent());
        }
        return hasChanged;
    }

    void updateFkValues() throws YException {
        StringBuffer sql = new StringBuffer();
        int pkValueIndex = this.rowDefinition.getFieldValueIndex(this.rowPkDefinition.getName());
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            YRowValues rowValues = this.getAbsRowValues(iRow);
            if (rowValues.hasDeleteMark()) continue;
            sql.setLength(0);
            for (int iCol = 0; iCol < this.rowDefinition.nColumns; ++iCol) {
                YListFkFieldValue listFkFieldValue;
                int rowId;
                YFieldValue fieldValue = rowValues.getFieldValue(iCol);
                if (!fieldValue.getColumnDefinition().isListFk() || (rowId = (listFkFieldValue = (YListFkFieldValue)fieldValue).getReferencedRowId()) <= 0) continue;
                listFkFieldValue.setReferencedRowId(rowId);
                if (!listFkFieldValue.hasChanged()) continue;
                if (sql.length() > 0) {
                    sql.append(", ");
                }
                sql.append(listFkFieldValue.getFkColumnDefinition().getName() + "=" + listFkFieldValue.getValue());
            }
            if (sql.length() <= 0) continue;
            sql.insert(0, "UPDATE " + this.tableName + " SET ");
            sql.append(" WHERE " + this.rowPkDefinition.getName() + "=" + rowValues.getAsString(pkValueIndex));
            this.sqlDml.execute(sql.toString());
            rowValues.setPostMark();
        }
    }

    public void requestActiveRowValues() throws YException {
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
            if (this.getRowValues(this.activeRow).hasChanged()) {
                this.fireUpdate(this.activeRow);
            }
        }
    }

    public void post() throws YException {
        YSubRowListImplementation subList;
        int iSub;
        assert (this.finalized);
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        this.requestActiveRowValues();
        this.beforeBegin();
        if (!wasInTransaction) {
            this.defaultsSet = this.setDefaults();
            for (iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                subList = this.subListImplementations.get(iSub);
                subList.requestActiveRowValues();
                subList.setDefaults();
            }
            this.checkNotNull();
        }
        try {
            if (!database.isInTransaction()) {
                database.startTransaction();
            }
            this.afterBegin();
            if (this.postObject == null) {
                this.postThis();
            } else {
                this.postThis(this.postObject);
            }
            for (iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                subList = this.subListImplementations.get(iSub);
                for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                    YRowValues rowValues = this.getRowValues(iRow);
                    int rowId = rowValues.getRowId();
                    boolean setDeleteMark = rowValues.hasDeleteMark();
                    int objId = rowValues.getFieldValue(this.rowPkDefinition).getValueAsInt(0);
                    block5: for (int iSubRow = 0; iSubRow < subList.getAbsRowCount(); ++iSubRow) {
                        YRowValues subRowValues = subList.getAbsRowValues(iSubRow);
                        if (subRowValues.masterRowId != rowId) continue;
                        do {
                            if (objId <= 0 && subList.hasAbsValuesToStore(iSubRow)) {
                                throw new YUserException("Untereintr\u00e4ge zu einem leerem Listeneintrag k\u00f6nnen nicht gespeichert werden.");
                            }
                            if (setDeleteMark) {
                                subRowValues.setDeleteMark();
                            }
                            subRowValues.getFieldValue(subList.getMasterFkDefinition()).modifyValue(objId);
                            if (++iSubRow >= subList.getAbsRowCount()) continue block5;
                            subRowValues = subList.getAbsRowValues(iSubRow);
                        } while (subRowValues.masterRowId == rowId);
                    }
                }
                subList.post();
            }
            this.updateFkValues();
            this.beforeCommit();
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
                if (this.setPosted()) {
                    this.fireChanged(new YDBOChangeEvent());
                }
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
                this.resetMarks();
                for (iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                    this.subListImplementations.get(iSub).resetMarks();
                }
            }
            throw e;
        }
    }

    public void clearDispValues(int iRow) throws YException, YProgramException {
        super.clearDispValues(iRow);
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            this.subListImplementations.get(iSub).clearDispValues();
        }
    }

    public void clearActiveDispValues() throws YException, YProgramException {
        if (this.activeRow >= 0) {
            this.clearDispValues(this.activeRow);
        }
    }

    public void moveUpActiveRow() throws YException {
        if (this.activeRow > 0) {
            int iRow = this.moveUp(this.activeRow);
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INTERCHANGE, iRow, iRow + 1));
            this.setActiveRow(iRow);
        }
    }

    public void moveDownActiveRow() throws YException {
        if (this.activeRow >= 0 && this.activeRow + 1 < this.getRowCount()) {
            int iRow = this.moveDown(this.activeRow);
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INTERCHANGE, iRow, iRow + 1));
            this.setActiveRow(iRow);
        }
    }

    public void revert() throws YException {
        int nRows = this.getRowCount();
        this.setActiveRow(-1);
        ++this.changeLevel;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues rowValues = this.getRowValues(iRow);
            if (rowValues.getFieldValue(this.rowPkDefinition).wasNull()) {
                this.removeRowValues(iRow);
                --iRow;
                --nRows;
                continue;
            }
            rowValues.revert();
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            this.subListImplementations.get(iSub).revert();
        }
        --this.changeLevel;
        this.fireChanged(new YDBOChangeEvent());
    }

    public boolean hasChanged() throws YException {
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
        }
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            if (!this.getAbsRowValues(iRow).hasChanged()) continue;
            return true;
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            if (!this.subListImplementations.get(iSub).hasChanged()) continue;
            return true;
        }
        return false;
    }

    public String getObjId(int iRow) throws YException {
        return this.getRowValues(iRow).getFieldValue(this.rowPkDefinition).getValue();
    }

    public YFieldValue getPkValue(int iRow) throws YException {
        return this.getRowValues(iRow).getFieldValue(this.rowPkDefinition);
    }

    public int getPkAsInt(int iRow) throws YException {
        return this.getPkValue(iRow).getValueAsInt(0);
    }

    public int getObjIdAsInt(int iRow) throws YException {
        return this.getPkValue(iRow).getValueAsInt();
    }

    public int getIRow(String objId) {
        return this.findIRow(objId);
    }

    public int findIRow(String objId) {
        try {
            for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                if (!this.getRowValues(iRow).getFieldValue(this.rowPkDefinition).getValue().equals(objId)) continue;
                return iRow;
            }
            return -1;
        }
        catch (YException e) {
            return -1;
        }
    }
}

