/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDetailList;
import projektY.database.YNullValueException;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.YSubDetailListImplementation;
import projektY.database.YSubDetailListManager;

public class YSubDetailList
extends YDetailList
implements YSubDetailListImplementation {
    private YSubDetailListManager subDetailListManager;
    private String masterFilter;

    public YSubDetailList(YSession session, int maxColumns, YDetailList detailList) throws YException {
        super(session, maxColumns);
        this.subDetailListManager = new YSubDetailListManager(detailList, this);
    }

    public YSubDetailList(YSession session, int maxColumns, YDetailList detailList, YRowObject masterRowObject) throws YException {
        super(session, maxColumns, masterRowObject);
        this.subDetailListManager = new YSubDetailListManager(detailList, this);
    }

    public YSubDetailList(YSession session, int maxColumns, YDetailList detailList, int masterId) throws YException {
        super(session, maxColumns, masterId);
        this.subDetailListManager = new YSubDetailListManager(detailList, this);
    }

    public void addMasterFkField(String fieldName) throws YException {
        this.masterRowFkDefinition = this.addDBField(fieldName, YColumnDefinition.FieldType.INT);
    }

    public void setOrder(String[] order, boolean desc) throws YProgramException {
        this.subDetailListManager.checkOrder(order);
        super.setOrder(order, desc);
    }

    void checkFinalized() throws YProgramException {
        super.checkFinalized();
        if (this.masterRowFkDefinition == this.rowObjectFkDefinition) {
            throw new YProgramException(this, "Die Fremdschl\u00fcssel zum RowObjekt und zur Detailliste k\u00f6nnen nicht identisch sein.");
        }
        this.subDetailListManager.checkOrder(this.masterRowFkDefinition);
    }

    public void setMasterFilter(String tableName, String pkName, String filter) {
        this.masterFilter = this.subDetailListManager.createMasterFilter(tableName, this.tableAlias, pkName, filter, this.andWhere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YDetailList fetch() throws YException {
        String andWhere = this.andWhere;
        try {
            ++this.changeLevel;
            if (this.masterFilter != null) {
                this.setAndWhere(this.masterFilter);
            }
            super.fetch();
            this.subDetailListManager.linkRows();
            YSubDetailList ySubDetailList = this;
            return ySubDetailList;
        }
        finally {
            this.setAndWhere(andWhere);
            --this.changeLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YDetailList fetch(int rowObjectId) throws YException {
        String andWhere = this.andWhere;
        try {
            ++this.changeLevel;
            if (this.masterFilter != null) {
                this.setAndWhere(this.masterFilter);
            }
            super.fetch(rowObjectId);
            this.subDetailListManager.linkRows();
            YSubDetailList ySubDetailList = this;
            return ySubDetailList;
        }
        finally {
            this.setAndWhere(andWhere);
            --this.changeLevel;
        }
    }

    public void setSubWindow(int detailRowId) throws YException {
        this.subDetailListManager.setSubWindow(detailRowId);
    }

    public int unsetSubWindow() throws YException {
        return this.subDetailListManager.unsetSubWindow();
    }

    public YRowValues appendInSubWindow(YRowObject rowObject) throws YException {
        return this.append(rowObject);
    }

    public YRowValues append(YRowObject rowObject) throws YException {
        return this.subDetailListManager.append(rowObject);
    }

    public int appendRow() throws YException {
        YRowValues rowValues = this.createRowValues();
        return this.subDetailListManager.appendRowValues(rowValues);
    }

    public int getRowCount() throws YException {
        return this.subDetailListManager.getRowCount();
    }

    public YRowValues getRowValues(int iRow) throws YException {
        return this.subDetailListManager.getRowValues(iRow);
    }

    protected YRowValues removeRowValues(int iRow) throws YException {
        return this.subDetailListManager.removeRowValues(iRow);
    }

    int getMasterFkValueAsInt(YRowValues rowValues) throws YException {
        return rowValues.getFieldValue(this.masterRowFkDefinition).getValueAsInt();
    }

    protected YRowValues getRowValues4Set(int iRow) throws YException {
        return this.subDetailListManager.getRowValues4Set(iRow);
    }

    public boolean setPosted() throws YException {
        boolean hasChanged = super.setPosted();
        int detailRowId = this.unsetSubWindow();
        if (detailRowId > 0) {
            this.setSubWindow(detailRowId);
        }
        return hasChanged;
    }

    int getDetailRowId() {
        return this.subDetailListManager.getDetailRowId();
    }

    public boolean hasSubWindow() {
        return this.subDetailListManager.hasSubWindow();
    }

    public int moveUp(int iRow) throws YException {
        if (iRow == 0) {
            return 0;
        }
        return super.moveUp(this.subDetailListManager.subIndexToAbsolute(iRow)) - this.subDetailListManager.getIRow0();
    }

    public int moveDown(int iRow) throws YException {
        if (iRow >= this.getRowCount() - 1) {
            return iRow;
        }
        return super.moveDown(this.subDetailListManager.subIndexToAbsolute(iRow)) - this.subDetailListManager.getIRow0();
    }

    public void revert() throws YException {
        this.subDetailListManager.revertAll();
        int detailRowId = this.unsetSubWindow();
        if (detailRowId > 0) {
            this.setSubWindow(detailRowId);
        }
    }

    public void resetMarks() throws YException {
        super.resetMarks();
    }

    public YRowValues createRowValues() throws YException {
        return super.createRowValues();
    }

    public YRowValues addRowValues(int iAbsRow, YRowValues rowValues) throws YException {
        super.addRowValues(iAbsRow, rowValues);
        return rowValues;
    }

    public void checkNotNull() throws YNullValueException, YException {
        super.checkNotNull();
    }
}

