/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import popometer.graphics.Messpunkt;
import popometer.graphics.RectScaler;

public class Messpunkte {
    private RectScaler rectScaler;
    private Point imgPoint;
    private Dimension dragOffset;
    private Messpunkt aktiverMesspunkt;
    public Messpunkt kalibrierung1;
    public Messpunkt kalibrierung2;
    public Messpunkt sitz;
    public Messpunkt griff;
    public Messpunkt pedal;
    public Messpunkt knie;
    public Messpunkt schulter;
    public Messpunkt arm;
    public Vector<Messpunkt> messpunkte;
    private boolean messpunktZurueckgesetzt;
    private boolean messpunktBewegt;
    public boolean messpunktVerschoben;

    public Messpunkte(RectScaler rectScaler) {
        this.rectScaler = rectScaler;
        this.imgPoint = new Point();
        this.dragOffset = new Dimension();
        this.messpunkte = new Vector(8);
        for (int i = 0; i < 8; ++i) {
            this.messpunkte.add(new Messpunkt(rectScaler));
        }
        this.pedal = null;
        this.knie = null;
        this.sitz = null;
        this.schulter = null;
        this.arm = null;
        this.griff = null;
        this.messpunktZurueckgesetzt = false;
        this.messpunktBewegt = false;
    }

    public Vector<Messpunkt> get() {
        return this.messpunkte;
    }

    public Messpunkt get(int i) {
        return this.messpunkte.get(i);
    }

    public void init() {
        int i = 0;
        for (Messpunkt m : this.messpunkte) {
            m.move(50 + i * 25, 50 + i * 25);
            ++i;
        }
    }

    public void resetFlags() {
        for (Messpunkt m : this.messpunkte) {
            m.flag = false;
        }
    }

    public void resetAktiv() {
        if (this.aktiverMesspunkt != null) {
            this.aktiverMesspunkt.setZoomed(false);
            this.aktiverMesspunkt = null;
        }
    }

    public boolean benennen6(boolean blickrichtungRechts) {
        Messpunkt kandidat = null;
        Messpunkt[] knieUndArm = new Messpunkt[]{null, null};
        this.resetFlags();
        int max = 0;
        for (Messpunkt m : this.messpunkte) {
            if (m.x < 0 || m.y < 0) {
                return false;
            }
            if (m.y == max) {
                return false;
            }
            if (m.y <= max) continue;
            kandidat = m;
            max = m.y;
        }
        this.pedal = kandidat;
        this.pedal.flag = true;
        int min = this.messpunkte.get(0).getRectScaler().getWidth();
        for (Messpunkt m : this.messpunkte) {
            if (m.x == min) {
                return false;
            }
            if (m.x >= min) continue;
            kandidat = m;
            min = m.x;
        }
        if (kandidat.flag) {
            return false;
        }
        if (blickrichtungRechts) {
            this.sitz = kandidat;
            this.sitz.flag = true;
        } else {
            this.griff = kandidat;
            this.griff.flag = true;
        }
        max = 0;
        for (Messpunkt m : this.messpunkte) {
            if (m.x == max) {
                return false;
            }
            if (m.x <= max) continue;
            kandidat = m;
            max = m.x;
        }
        if (kandidat.flag) {
            return false;
        }
        if (blickrichtungRechts) {
            this.griff = kandidat;
            this.griff.flag = true;
        } else {
            this.sitz = kandidat;
            this.sitz.flag = true;
        }
        min = this.messpunkte.get(0).getRectScaler().getHeight();
        for (Messpunkt m : this.messpunkte) {
            if (m.y == min) {
                return false;
            }
            if (m.y >= min) continue;
            kandidat = m;
            min = m.y;
        }
        if (kandidat.flag) {
            return false;
        }
        this.schulter = kandidat;
        this.schulter.flag = true;
        int i = 0;
        for (Messpunkt m : this.messpunkte) {
            if (m.flag) continue;
            knieUndArm[i] = m;
            if (++i <= 1) continue;
            break;
        }
        if (knieUndArm[0].y > knieUndArm[1].y) {
            this.knie = knieUndArm[0];
            this.arm = knieUndArm[1];
        } else if (knieUndArm[1].y > knieUndArm[0].y) {
            this.knie = knieUndArm[1];
            this.arm = knieUndArm[0];
        } else {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean benennen8(boolean blickrichtungRechts) {
        int max;
        int min;
        Messpunkt kandidat = null;
        Messpunkt[] kandidatenDuo = new Messpunkt[]{null, null};
        this.resetFlags();
        if (blickrichtungRechts) {
            min = this.messpunkte.get(0).getRectScaler().getHeight();
            for (Messpunkt m : this.messpunkte) {
                if (m.x < 0 || m.y < 0) {
                    return false;
                }
                if (m.y == min) {
                    return false;
                }
                if (m.x >= min) continue;
                kandidat = m;
                min = m.x;
            }
        } else {
            max = 0;
            for (Messpunkt m : this.messpunkte) {
                if (m.x < 0 || m.y < 0) {
                    return false;
                }
                if (m.y == max) {
                    return false;
                }
                if (m.x <= max) continue;
                kandidat = m;
                max = m.x;
            }
        }
        this.kalibrierung1 = kandidat;
        this.kalibrierung1.flag = true;
        int i = 0;
        if (blickrichtungRechts) {
            for (Messpunkt m : this.messpunkte) {
                if (m.flag) continue;
                if (i < 2) {
                    kandidatenDuo[i++] = m;
                    continue;
                }
                if (kandidatenDuo[0].x > kandidatenDuo[1].x) {
                    kandidat = kandidatenDuo[0];
                    kandidatenDuo[0] = kandidatenDuo[1];
                    kandidatenDuo[1] = kandidat;
                }
                if (m.x <= kandidatenDuo[1].x) continue;
                kandidatenDuo[0] = m;
            }
        } else {
            for (Messpunkt m : this.messpunkte) {
                if (m.flag) continue;
                if (i < 2) {
                    kandidatenDuo[i++] = m;
                    continue;
                }
                if (kandidatenDuo[0].x < kandidatenDuo[1].x) {
                    kandidat = kandidatenDuo[0];
                    kandidatenDuo[0] = kandidatenDuo[1];
                    kandidatenDuo[1] = kandidat;
                }
                if (m.x >= kandidatenDuo[1].x) continue;
                kandidatenDuo[0] = m;
            }
        }
        if (kandidatenDuo[0].y < kandidatenDuo[1].y) {
            this.griff = kandidatenDuo[0];
            this.kalibrierung2 = kandidatenDuo[1];
        } else {
            if (kandidatenDuo[0].y <= kandidatenDuo[1].y) return false;
            this.griff = kandidatenDuo[1];
            this.kalibrierung2 = kandidatenDuo[0];
        }
        this.griff.flag = true;
        this.kalibrierung2.flag = true;
        min = this.messpunkte.get(0).getRectScaler().getHeight();
        for (Messpunkt m : this.messpunkte) {
            if (m.flag) continue;
            if (m.y == min) {
                return false;
            }
            if (m.y >= min) continue;
            kandidat = m;
            min = m.y;
        }
        this.schulter = kandidat;
        this.schulter.flag = true;
        max = 0;
        for (Messpunkt m : this.messpunkte) {
            if (m.flag) continue;
            if (m.y == max) {
                return false;
            }
            if (m.y <= max) continue;
            kandidat = m;
            max = m.y;
        }
        this.pedal = kandidat;
        this.pedal.flag = true;
        i = 0;
        for (Messpunkt m : this.messpunkte) {
            if (m.flag) continue;
            if (i < 2) {
                kandidatenDuo[i++] = m;
                continue;
            }
            if (kandidatenDuo[0].y > kandidatenDuo[1].y) {
                kandidat = kandidatenDuo[0];
                kandidatenDuo[0] = kandidatenDuo[1];
                kandidatenDuo[1] = kandidat;
            }
            if (m.y <= kandidatenDuo[0].y) continue;
            kandidatenDuo[0] = m;
        }
        if (blickrichtungRechts) {
            if (kandidatenDuo[0].x < kandidatenDuo[1].x) {
                this.sitz = kandidatenDuo[0];
                this.knie = kandidatenDuo[1];
            } else {
                if (kandidatenDuo[0].x <= kandidatenDuo[1].x) return false;
                this.sitz = kandidatenDuo[1];
                this.knie = kandidatenDuo[0];
            }
        } else if (kandidatenDuo[0].x > kandidatenDuo[1].x) {
            this.sitz = kandidatenDuo[0];
            this.knie = kandidatenDuo[1];
        } else {
            if (kandidatenDuo[0].x >= kandidatenDuo[1].x) return false;
            this.sitz = kandidatenDuo[1];
            this.knie = kandidatenDuo[0];
        }
        this.sitz.flag = true;
        this.knie.flag = true;
        for (Messpunkt m : this.messpunkte) {
            if (m.flag) continue;
            this.arm = m;
            this.arm.flag = true;
            return true;
        }
        return false;
    }

    public Messpunkt findeMesspunkt(Dimension offset, MouseEvent e) {
        for (int i = this.messpunkte.size() - 1; i >= 0; --i) {
            if (!this.messpunkte.get(i).coversScaled(e.getX(), e.getY())) continue;
            Messpunkt messpunkt = this.messpunkte.get(i);
            this.rectScaler.scaleTo(this.imgPoint, messpunkt);
            offset.width = e.getX() - this.imgPoint.x;
            offset.height = e.getY() - this.imgPoint.y;
            return messpunkt;
        }
        return null;
    }

    public boolean fotoMousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return false;
        }
        if (this.rectScaler.scaleFrom(this.imgPoint, e)) {
            Messpunkt letzterAktiverMesspunkt = this.aktiverMesspunkt;
            this.aktiverMesspunkt = this.findeMesspunkt(this.dragOffset, e);
            if (this.aktiverMesspunkt != letzterAktiverMesspunkt) {
                if (letzterAktiverMesspunkt != null) {
                    letzterAktiverMesspunkt.setZoomed(false);
                }
                if (this.aktiverMesspunkt != null) {
                    this.aktiverMesspunkt.setZoomed(true);
                    this.messpunkte.remove(this.aktiverMesspunkt);
                    this.messpunkte.add(this.aktiverMesspunkt);
                } else {
                    this.messpunktZurueckgesetzt = true;
                }
                return !this.messpunktBewegt;
            }
        }
        return false;
    }

    public boolean fotoMouseDragged(MouseEvent e) {
        if (this.aktiverMesspunkt != null && this.rectScaler.scaleFrom(this.imgPoint, e)) {
            this.aktiverMesspunkt.moveScaled(e.getX() - this.dragOffset.width, e.getY() - this.dragOffset.height);
            this.messpunktBewegt = true;
            return true;
        }
        return false;
    }

    public boolean fotoMouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return false;
        }
        if (this.aktiverMesspunkt == null) {
            this.messpunktVerschoben = this.messpunktBewegt && this.messpunktZurueckgesetzt;
            this.messpunktBewegt = false;
            this.messpunktZurueckgesetzt = false;
            return false;
        }
        if (!this.aktiverMesspunkt.isZoomed()) {
            return false;
        }
        this.messpunktBewegt |= this.aktiverMesspunkt.moveZoomed(e.getX(), e.getY());
        return true;
    }
}

