/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YCheckColumnDefinition;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YFieldValue;
import projektY.database.YLinkedDetailList;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.YSubRowListImplementation;

public class YCheckDetailList
extends YLinkedDetailList {
    YColumnDefinition checklistIdDefinition;
    int checklistId;
    private boolean fetched;

    public YCheckDetailList(YSession session, int maxColumns, YRowObject masterRowObject, int checklistId) throws YException {
        super(session, maxColumns, masterRowObject);
        this.checklistId = checklistId;
        this.fetched = false;
    }

    public YCheckDetailList(YSession session, int maxColumns, YRowObject masterRowObject) throws YException {
        this(session, maxColumns, masterRowObject, 0);
    }

    public YCheckDetailList(YSession session, int maxColumns, int masterId, int checklistId) throws YException {
        super(session, maxColumns, masterId);
        this.checklistId = checklistId;
        this.fetched = false;
    }

    public YCheckDetailList(YSession session, int maxColumns, int masterId) throws YException {
        this(session, maxColumns, masterId, 0);
    }

    protected YColumnDefinition addChecklistIdField(String fieldName) throws YException {
        this.checklistIdDefinition = super.addDetailDBField(fieldName, YColumnDefinition.FieldType.INT);
        return this.checklistIdDefinition;
    }

    protected YCheckColumnDefinition addCheckField(String fieldName) throws YException {
        return this.rowDefinition.addCheckColumnDefinition(fieldName);
    }

    String createSQLSelect() throws YProgramException {
        int iCol;
        StringBuffer sql = new StringBuffer(100);
        for (iCol = 0; iCol < this.linkDefinitions.size(); ++iCol) {
            YColumnDefinition columnDefinition = (YColumnDefinition)this.linkDefinitions.get(iCol);
            if (columnDefinition == this.detailFkDefinition) continue;
            if (sql.length() > 0) {
                sql.append(", ");
            }
            sql.append("l." + columnDefinition.getName());
        }
        sql.insert(0, "SELECT ");
        for (iCol = 0; iCol < this.detailDefinitions.size(); ++iCol) {
            sql.append(", d." + ((YColumnDefinition)this.detailDefinitions.get(iCol)).getName());
        }
        return sql.toString();
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        if (this.sqlSelect == null) {
            this.sqlSelect = this.createSQLSelect();
        }
        if (this.checklistId > 0 && this.checklistIdDefinition == null) {
            throw new YProgramException(this, "Benutzung von checklistId erfordert Aufruf von addChecklistIdField().");
        }
        super.checkFinalized();
    }

    @Override
    protected String createSelectWhere(int masterId) throws YException {
        StringBuffer sql = new StringBuffer(100);
        sql.append(this.sqlSelect);
        sql.append(" FROM " + this.tableName + " l RIGHT OUTER JOIN " + this.detailName + " d");
        sql.append(" ON (l." + this.detailFkDefinition.getName() + "=d." + this.rowPkDefinition.getName());
        sql.append(" AND l." + this.rowObjectFkDefinition.getName() + "=" + masterId + ")");
        String filter = super.createFilterExpression();
        if (filter.length() > 0 || this.checklistId > 0) {
            sql.append(" WHERE ");
            if (this.checklistId > 0) {
                sql.append(this.checklistIdDefinition.getName());
                sql.append('=');
                sql.append(this.checklistId);
            }
            if (filter.length() > 0) {
                if (this.checklistId > 0) {
                    sql.append(" AND ");
                }
                sql.append(filter);
            }
        }
        return sql.toString();
    }

    protected String createSQLSelectBlank() throws YException {
        int iCol;
        StringBuffer sql = new StringBuffer(100);
        sql.append("SELECT ");
        for (iCol = 0; iCol < this.detailDefinitions.size(); ++iCol) {
            if (iCol > 0) {
                sql.append(", ");
            }
            sql.append(((YColumnDefinition)this.detailDefinitions.get(iCol)).getName());
        }
        sql.append(" FROM ");
        sql.append(this.detailName);
        String filter = super.createFilterExpression();
        if (filter.length() > 0 || this.checklistId > 0) {
            sql.append(" WHERE ");
            if (this.checklistId > 0) {
                sql.append(this.checklistIdDefinition.getName());
                sql.append('=');
                sql.append(this.checklistId);
            }
            if (filter.length() > 0) {
                if (this.checklistId > 0) {
                    sql.append(" AND ");
                }
                sql.append(filter);
            }
        }
        if (this.order != null) {
            sql.append(" ORDER BY ");
            for (iCol = 0; iCol < this.order.length; ++iCol) {
                if (iCol > 0) {
                    sql.append(", ");
                }
                sql.append(this.order[iCol]);
            }
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchBlank() throws YException {
        try {
            assert (this.finalized);
            String sql = this.createSQLSelectBlank();
            this.sqlQuery.execute(sql.toString());
            ++this.changeLevel;
            this.clearRowValues();
            boolean hasMaxRows = this.maxRows > 0;
            this.moreRows = false;
            int iRow = 0;
            while (this.sqlQuery.next()) {
                YColumnDefinition columnDefinition;
                int iCol;
                if (hasMaxRows && iRow >= this.maxRows) {
                    this.moreRows = true;
                    break;
                }
                YRowValues rowValues = this.createRowValues();
                for (iCol = 0; iCol < this.linkDefinitions.size(); ++iCol) {
                    columnDefinition = (YColumnDefinition)this.linkDefinitions.get(iCol);
                    rowValues.getFieldValue(columnDefinition).gotValue("");
                }
                for (iCol = 0; iCol < this.detailDefinitions.size(); ++iCol) {
                    columnDefinition = (YColumnDefinition)this.detailDefinitions.get(iCol);
                    this.getQueryResult(rowValues.getFieldValue(columnDefinition));
                }
                rowValues.setChecked(false);
                this.addRowValues(rowValues);
                ++iRow;
            }
            for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                ((YSubRowListImplementation)this.subListImplementations.get(iSub)).fetch();
            }
            this.fetched = true;
        }
        finally {
            this.sqlQuery.close();
            --this.changeLevel;
            this.fireChanged(new YDBOChangeEvent());
        }
    }

    void setCheckedAfterFetch() throws YException {
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            YRowValues rowValues;
            rowValues.setChecked(!(rowValues = this.getAbsRowValues(iRow)).getFieldValue(this.rowObjectFkDefinition).isNull());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public YCheckDetailList fetch() throws YException {
        try {
            int masterId = this.masterRowObject == null ? this.rowObjectId : this.masterRowObject.getPkFieldValue().getValueAsInt(0);
            if (masterId == 0) {
                this.fetchBlank();
            } else {
                this.rowObjectId = masterId;
                ++this.changeLevel;
                super.fetch();
                for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                    YRowValues rowValues;
                    rowValues.setChecked(!(rowValues = this.getRowValues(iRow)).getFieldValue(this.rowObjectFkDefinition).isNull());
                }
                this.fireChanged(new YDBOChangeEvent());
            }
            this.fetched = true;
            YCheckDetailList yCheckDetailList = this;
            return yCheckDetailList;
        }
        finally {
            --this.changeLevel;
            this.fireChanged(new YDBOChangeEvent());
        }
    }

    public void setChecked(int iRow, boolean checked) throws YException {
        YRowValues rowValues = this.getRowValues(iRow);
        rowValues.setChecked(checked);
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, rowValues));
    }

    @Override
    public void clear() throws YException {
        if (this.fetched) {
            for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
                YRowValues rowValues = this.getAbsRowValues(iRow);
                for (int iCol = 0; iCol < this.linkDefinitions.size(); ++iCol) {
                    YColumnDefinition columnDefinition = (YColumnDefinition)this.linkDefinitions.get(iCol);
                    if (columnDefinition == this.rowPkDefinition || columnDefinition == this.detailFkDefinition) continue;
                    rowValues.getFieldValue(columnDefinition).gotValue("");
                    rowValues.setChecked(false);
                }
            }
            this.rowObjectId = 0;
            this.fireChanged(new YDBOChangeEvent());
        } else {
            this.fetchBlank();
        }
    }

    int getMasterPkValueAsInt(YRowValues rowValues) throws YException {
        if (this.masterRowObject == null) {
            return this.rowObjectId;
        }
        return this.masterRowObject.getPkFieldValue().getValueAsInt();
    }

    @Override
    public void post() throws YException {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues rowValues = this.getRowValues(iRow);
            YFieldValue fvMasterFk = rowValues.getFieldValue(this.masterRowFkDefinition);
            if (this.isChecked(iRow)) {
                fvMasterFk.modifyValue(this.getMasterPkValueAsInt(rowValues));
                continue;
            }
            for (int iCol = 0; iCol < this.linkDefinitions.size(); ++iCol) {
                YColumnDefinition columnDefinition = (YColumnDefinition)this.linkDefinitions.get(iCol);
                if (columnDefinition == this.detailFkDefinition || columnDefinition.getName().equals("checked_id__")) continue;
                rowValues.getFieldValue(columnDefinition).modifyToNull();
            }
        }
        super.post();
    }

    public boolean isChecked(int iRow) throws YException {
        int nCols;
        YRowValues rowValues = this.getRowValues(iRow);
        boolean checked = rowValues.isChecked();
        if (!checked && (nCols = this.linkDefinitions.size()) > 2) {
            for (int iCol = 0; iCol < nCols; ++iCol) {
                YColumnDefinition columnDefinition = (YColumnDefinition)this.linkDefinitions.get(iCol);
                if (columnDefinition.isCheck() || columnDefinition == this.masterRowFkDefinition || columnDefinition == this.detailFkDefinition || columnDefinition.getName().equals("checked_id__") || rowValues.getFieldValue(columnDefinition).isNull()) continue;
                return true;
            }
        }
        return checked;
    }

    @Override
    protected boolean hasValuesToStore(YRowValues rowValues) throws YException {
        YFieldValue fieldValue;
        int iCol;
        if (this.linkDefinitions.size() == 2) {
            if (rowValues.getFieldValue(this.rowObjectFkDefinition).isNull() || !rowValues.isChecked()) {
                return false;
            }
        } else {
            YColumnDefinition columnDefinition;
            for (iCol = 0; iCol < this.linkDefinitions.size() && ((columnDefinition = (YColumnDefinition)this.linkDefinitions.get(iCol)) == this.masterRowFkDefinition || columnDefinition == this.detailFkDefinition || columnDefinition.getName().equals("checked_id__") || (fieldValue = rowValues.getFieldValue(columnDefinition)).isNull()); ++iCol) {
            }
            if (iCol == this.linkDefinitions.size()) {
                rowValues.getFieldValue(this.masterRowFkDefinition).modifyValue("");
                return false;
            }
        }
        for (iCol = 0; iCol < this.dispColCount; ++iCol) {
            fieldValue = rowValues.getFieldValue(this.dispIndicees[iCol]);
            if (fieldValue.isNull()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean setPosted() throws YException {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues row = this.getRowValues(iRow);
            if (row.hasDeleteMark()) {
                for (int iCol = 0; iCol < this.linkDefinitions.size(); ++iCol) {
                    row.getFieldValue((YColumnDefinition)this.linkDefinitions.get(iCol)).setPosted();
                }
                boolean hadPostMark = row.hasPostMark();
                row.resetMarks();
                if (hadPostMark) {
                    row.setPostMark();
                }
            }
            row.setPosted();
        }
        return false;
    }

    @Override
    public void revert() throws YException {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues rowValues;
            rowValues.setChecked(!(rowValues = this.getRowValues(iRow)).getFieldValue(this.rowObjectFkDefinition).isNull());
        }
        for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
            ((YSubRowListImplementation)this.subListImplementations.get(iSub)).revert();
        }
        this.fireChanged(new YDBOChangeEvent());
    }
}

