/*
 * Decompiled with CFR 0.152.
 */
package projektY.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.database.YColumnDefinition;
import projektY.database.YDatabaseList;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.swing.YComboBoxModel;
import projektY.swing.YJTableManager;
import projektY.swing.YTableModel;

public final class Utils {
    public static final void centerWindow(Window window) {
        Dimension sz_screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension sz_form = window.getSize();
        if (sz_form.height > sz_screen.height) {
            sz_form.height = sz_screen.height;
        }
        if (sz_form.width > sz_screen.width) {
            sz_form.width = sz_screen.width;
        }
        window.setLocation((sz_screen.width - sz_form.width) / 2, (sz_screen.height - sz_form.height) / 2);
    }

    public static final void rightWindow(Window window) {
        Dimension sz_screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension sz_form = window.getSize();
        window.setLocation(sz_screen.width - sz_form.width, 0);
        window.setSize(sz_form.width, sz_screen.height - 25);
    }

    public static final void initJTable(JTable jTable, YDatabaseList databaseList) throws YException {
        YJTableManager.AlignRightCellRenderer alignRightCellRenderer = null;
        YTableModel tableModel = new YTableModel(databaseList);
        jTable.setModel(tableModel);
        for (int iCol = 0; iCol < databaseList.getDispColCount(); ++iCol) {
            YColumnDefinition columnDefinition = databaseList.getDispColumnDefinition(iCol);
            if (columnDefinition.isLookUp()) {
                YComboBoxModel comboBoxModel;
                if (columnDefinition.isDomain()) {
                    YLookUpDomain lookUpDomain = ((YLookUpDomainColumnDefinition)columnDefinition).getLookUpDomain();
                    comboBoxModel = new YComboBoxModel(lookUpDomain);
                } else {
                    YDatabaseList lookUpList = ((YLookUpDBColumnDefinition)columnDefinition).getLookUpList();
                    comboBoxModel = new YComboBoxModel(lookUpList, columnDefinition.isNotNull());
                }
                JComboBox comboBox = new JComboBox(comboBoxModel);
                jTable.getColumnModel().getColumn(iCol).setCellEditor(new DefaultCellEditor(comboBox));
                continue;
            }
            if (!columnDefinition.isANum()) continue;
            if (alignRightCellRenderer == null) {
                alignRightCellRenderer = new YJTableManager.AlignRightCellRenderer();
            }
            jTable.getColumnModel().getColumn(iCol).setCellRenderer(alignRightCellRenderer);
        }
    }
}

