/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.sqlab;

import com.sun.java.swing.plaf.sqlab.SQlabGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class FocusPainter
implements PropertyChangeListener {
    private static final Color FOCUS_COLOR = new Color(255, 133, 0);
    private static final int BLUR_SIZE = 9;
    private static final float BLUR_SPREAD = 0.15f;
    private static final double BLUR_OPACITY = 0.6;
    private KeyboardFocusManager focusManager;
    private Map<Window, FocusComponent> focusComponentMap = new HashMap<Window, FocusComponent>();

    public void propertyChange(PropertyChangeEvent evt) {
        Window activeWindow;
        FocusComponent focusComponent;
        System.out.println("evt.getPropertyName() = " + evt.getPropertyName() + " = " + evt.getNewValue());
        if (evt.getNewValue() != null && (focusComponent = this.getFocusComponent(activeWindow = this.focusManager.getActiveWindow())) != null) {
            focusComponent.setCurrentlyFocusedComponent(this.focusManager.getFocusOwner());
        }
    }

    private FocusComponent getFocusComponent(Window window) {
        FocusComponent focusComponent = this.focusComponentMap.get(window);
        if (focusComponent == null) {
            if (window instanceof JFrame) {
                JLayeredPane layeredPane = ((JFrame)window).getLayeredPane();
                focusComponent = new FocusComponent(layeredPane);
                layeredPane.add((Component)focusComponent, new Integer(250));
            } else if (window instanceof JDialog) {
                JLayeredPane layeredPane = ((JDialog)window).getLayeredPane();
                focusComponent = new FocusComponent(layeredPane);
                layeredPane.add((Component)focusComponent, new Integer(250));
            }
            this.focusComponentMap.put(window, focusComponent);
        }
        System.out.println("FocusPainter.getFocusComponent(" + window.hashCode() + ") => " + focusComponent.hashCode());
        return focusComponent;
    }

    private static class FocusComponent
    extends JComponent {
        private Component currentlyFocusedComponent = null;
        private WeakReference<JComponent> lastFocusedComponent = new WeakReference<Object>(null);
        private BufferedImage lastFocusImage = null;
        private Dimension lastSize = null;
        BufferedImage testImage;

        public FocusComponent(final JLayeredPane layeredPane) {
            this.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
            layeredPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    System.out.println("FocusPainter$FocusComponent.componentResized");
                    FocusComponent.this.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
                }
            });
        }

        public void setCurrentlyFocusedComponent(Component currentlyFocusedComponent) {
            this.currentlyFocusedComponent = currentlyFocusedComponent;
            this.repaint();
        }

        protected void paintComponent(Graphics g) {
            if (this.currentlyFocusedComponent != null && this.currentlyFocusedComponent instanceof JComponent) {
                BufferedImage focusImg;
                JComponent component = (JComponent)this.currentlyFocusedComponent;
                Rectangle bounds = new Rectangle(0, 0, component.getSize().width, component.getSize().height);
                Dimension size = component.getSize();
                if (component == this.lastFocusedComponent.get() && size.equals(this.lastSize)) {
                    focusImg = this.lastFocusImage;
                } else {
                    this.lastFocusImage = focusImg = this.createFocusGlow(bounds, component, g);
                    this.lastSize = size;
                    this.lastFocusedComponent = new WeakReference<JComponent>(component);
                }
                Rectangle rect = component.getVisibleRect();
                if (rect.width == bounds.width) {
                    rect.width += 9;
                }
                if (rect.height == bounds.height) {
                    rect.height += 9;
                }
                if (rect.x == bounds.x) {
                    rect.x -= 9;
                    rect.width += 9;
                }
                if (rect.y == bounds.y) {
                    rect.y -= 9;
                    rect.height += 9;
                }
                g = g.create();
                Rectangle clip = SwingUtilities.convertRectangle(component, rect, this);
                g.clipRect(clip.x, clip.y, clip.width, clip.height);
                bounds = SwingUtilities.convertRectangle(component, bounds, this);
                g.drawImage(focusImg, bounds.x - 9 - 9, bounds.y - 9 - 9, null);
                g.dispose();
            }
        }

        private BufferedImage createFocusGlow(Rectangle bounds, JComponent component, Graphics g) {
            BufferedImage img = SQlabGraphicsUtils.createCompatibleTranslucentImage(bounds.width + 9 + 9, bounds.height + 9 + 9);
            Graphics2D imgG = img.createGraphics();
            Graphics componentG = imgG.create(9, 9, bounds.width, bounds.height);
            componentG.setColor(Color.BLACK);
            if (component instanceof JRadioButton || component instanceof JCheckBox) {
                Color fg = component.getForeground();
                component.setForeground(new Color(0, 0, 0, 0));
                component.paint(componentG);
                component.setForeground(fg);
            } else if (component instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)component;
                BasicTabbedPaneUI tabbedPaneUI = (BasicTabbedPaneUI)tabbedPane.getUI();
                Rectangle tabRect = tabbedPaneUI.getTabBounds(tabbedPane, tabbedPane.getSelectedIndex());
                componentG.fillRoundRect(tabRect.x + 4, tabRect.y, tabRect.width - 7, tabRect.height, 5, 5);
            } else if (component instanceof JSlider) {
                JSlider slider = (JSlider)component;
                BasicSliderUI basicSliderUI = (BasicSliderUI)slider.getUI();
                try {
                    Field thumbRectField = BasicSliderUI.class.getDeclaredField("thumbRect");
                    thumbRectField.setAccessible(true);
                    Rectangle thumbRect = (Rectangle)thumbRectField.get(basicSliderUI);
                    componentG.fillOval(thumbRect.x, thumbRect.y, thumbRect.width, thumbRect.height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    g.fillRect(0, 0, bounds.width, bounds.height);
                }
            } else if (component instanceof JButton || component instanceof JToggleButton) {
                component.paint(componentG);
            } else {
                componentG.setColor(Color.BLACK);
                componentG.fillRect(0, 0, bounds.width, bounds.height);
            }
            componentG.dispose();
            imgG.dispose();
            BufferedImage focusImg = this.createFocusedImage(img);
            return focusImg;
        }

        private BufferedImage createFocusedImage(BufferedImage srcImg) {
            int w = srcImg.getWidth() + 18;
            int h = srcImg.getHeight() + 18;
            BufferedImage alpha = SQlabGraphicsUtils.getAlphaMask(srcImg, w, h);
            BufferedImage greyBuffer = new BufferedImage(w, h, 10);
            BufferedImage outline = new BufferedImage(w, h, 10);
            Kernel[] outlineKernels = SQlabGraphicsUtils.getSeparateGaussianKernel(1);
            new ConvolveOp(outlineKernels[0]).filter(alpha, greyBuffer);
            new ConvolveOp(outlineKernels[1]).filter(greyBuffer, outline);
            Kernel[] glowKernels = SQlabGraphicsUtils.getSeparateGaussianKernel(9);
            new ConvolveOp(glowKernels[0]).filter(alpha, greyBuffer);
            new ConvolveOp(glowKernels[1]).filter(greyBuffer, alpha);
            byte[] outlineData = ((DataBufferByte)outline.getRaster().getDataBuffer()).getData();
            byte[] glowData = ((DataBufferByte)alpha.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < glowData.length; ++i) {
                glowData[i] = outlineData[i] == 0 ? (byte)((double)glowData[i] * 0.6) : (byte)0;
            }
            RescaleOp rescaleOp = new RescaleOp(6.6666665f, 0.0f, null);
            rescaleOp.filter(alpha, alpha);
            BufferedImage dstImg = SQlabGraphicsUtils.createCompatibleTranslucentImage(w, h);
            Graphics2D g2 = dstImg.createGraphics();
            g2.drawImage((Image)SQlabGraphicsUtils.createColorMaskImage(alpha, FOCUS_COLOR), 0, 0, null);
            g2.dispose();
            return dstImg;
        }
    }
}

