/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import popometer.bikeandfit.Koerpermasse;
import popometer.bikeandfit.Parameter;
import popometer.math.Polygonzug;
import projektY.base.YException;

public class MagischesDreieck {
    private Parameter parameter;
    private float oben;
    private float hinten;
    private float vorn;
    private float neigungswinkel;
    private float rahmenwinkel;
    private Winkelsatz[] winkelsaetze;
    Polygonzug.Punkt K;
    Polygonzug.Punkt L;
    Polygonzug.Punkt S;

    public MagischesDreieck(Parameter parameter) {
        this.parameter = parameter;
        this.winkelsaetze = new Winkelsatz[]{new Winkelsatz(1, "aufrecht", 90.0f, 20.0f, 165.0f, 120.0f, 150.0f), new Winkelsatz(2, "leicht gebeugt", 115.0f, 60.0f, 165.0f, 120.0f, 150.0f), new Winkelsatz(3, "moderat", 124.0f, 90.0f, 174.0f, 120.0f, 140.0f), new Winkelsatz(4, "gestreckt", 158.0f, 100.0f, 165.0f, 120.0f, 150.0f), new Winkelsatz(5, "Triathlon", 168.0f, 110.0f, 165.0f, 120.0f, 150.0f)};
        this.K = new Polygonzug.Punkt();
        this.L = new Polygonzug.Punkt();
        this.S = new Polygonzug.Punkt();
        this.oben = 0.0f;
        this.hinten = 0.0f;
        this.vorn = 0.0f;
        this.neigungswinkel = 0.0f;
        this.rahmenwinkel = 0.0f;
    }

    public void berechnen(int winkelsatzId, Koerpermasse koerpermasse) throws YException {
        Winkelsatz winkelsatz = null;
        for (Winkelsatz ws : this.winkelsaetze) {
            if (ws.id != winkelsatzId) continue;
            winkelsatz = ws;
            break;
        }
        if (winkelsatz == null) {
            throw new YException("Ung\u00fcltige winkelsatzId: " + winkelsatzId);
        }
        Polygonzug pzOK = new Polygonzug();
        Polygonzug pzBein = new Polygonzug();
        pzOK.append(winkelsatz.rw, false, koerpermasse.ok);
        pzOK.append(winkelsatz.sw, true, koerpermasse.oa);
        pzOK.append(winkelsatz.ew, false, koerpermasse.ua);
        pzBein.append(winkelsatz.bw, true, koerpermasse.os);
        pzBein.append(winkelsatz.kw, true, koerpermasse.usf);
        pzBein.endPunkt(this.K);
        pzOK.endPunkt(this.L);
        this.S.x = 0.0f;
        this.S.y = -this.parameter.hueftabstand;
        float f = (this.K.a - this.parameter.kurbellaenge) / this.K.a;
        this.K.x *= f;
        this.K.y *= f;
        this.K.a -= this.parameter.kurbellaenge;
        this.oben = this.L.a;
        this.hinten = this.S.abstand(this.K);
        this.vorn = this.K.abstand(this.L);
        this.neigungswinkel = Polygonzug.VektorSumme.radToDeg((float)Math.asin((this.L.y - this.S.y) / this.L.abstand(this.S)));
        this.rahmenwinkel = 90.0f - Polygonzug.VektorSumme.radToDeg((float)Math.asin((this.K.x - this.S.x) / this.K.abstand(this.S)));
    }

    public float getOben() {
        return this.oben;
    }

    public float getHinten() {
        return this.hinten;
    }

    public float getVorn() {
        return this.vorn;
    }

    public float getNeigungswinkel() {
        return this.neigungswinkel;
    }

    public float getRahmenwinkel() {
        return this.rahmenwinkel;
    }

    public String toString() {
        return String.format("A%s B%s C%s: oben=%2.1f hinten=%2.1f vorn=%2.1f neigungswinkel=%2.1f rahmenwinkel=%2.1f", this.K.toString(), this.L.toString(), this.S.toString(), Float.valueOf(this.oben), Float.valueOf(this.hinten), Float.valueOf(this.vorn), Float.valueOf(this.neigungswinkel), Float.valueOf(this.rahmenwinkel));
    }

    public static class Winkelsatz {
        private int id;
        private String name;
        private float rw;
        private float sw;
        private float ew;
        private float bw;
        private float kw;

        public Winkelsatz(int id, String name, float rw, float sw, float ew, float bw, float kw) {
            this.id = id;
            this.name = name;
            this.rw = rw;
            this.sw = sw;
            this.ew = ew;
            this.bw = bw;
            this.kw = kw;
        }
    }
}

