/*
 * Decompiled with CFR 0.152.
 */
package popometer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MouseHoverTable
extends JFrame {
    int itsRow = 0;
    int itsColumn = 0;
    JTable itsTable = new JTable(5, 3);

    MouseHoverTable(String framename) {
        super(framename);
        this.itsTable.setOpaque(false);
        this.itsTable.setDefaultRenderer(Object.class, new AttributiveCellRenderer());
        MyMouseAdapter aMouseAda = new MyMouseAdapter();
        this.itsTable.addMouseMotionListener(aMouseAda);
        JScrollPane jsp = new JScrollPane(this.itsTable);
        this.getContentPane().add(this.itsTable);
    }

    public static void main(String[] args) {
        MouseHoverTable frame = new MouseHoverTable("Table Example");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Window w = e.getWindow();
                w.setVisible(false);
                w.dispose();
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }

    public class AttributiveCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public AttributiveCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == MouseHoverTable.this.itsRow && column == MouseHoverTable.this.itsColumn) {
                this.setBackground(Color.red);
                this.setForeground(Color.blue);
            } else {
                this.setBackground(Color.cyan);
                this.setForeground(Color.darkGray);
            }
            String aStr = "Row " + row + "Column" + column;
            this.setText(aStr);
            return this;
        }
    }

    public class MyMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent e) {
            JTable aTable = (JTable)e.getSource();
            MouseHoverTable.this.itsRow = aTable.rowAtPoint(e.getPoint());
            MouseHoverTable.this.itsColumn = aTable.columnAtPoint(e.getPoint());
            aTable.repaint();
        }
    }
}

