/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDatabaseData;

public class YParamSql {
    private Vector<SqlPart> sqlParts;

    private Vector<SqlPart> splitParamSql(String paramSql, Filter[] filter) throws YProgramException {
        boolean isString = false;
        int iSql = 0;
        int i0para = -1;
        Vector<SqlPart> sqlParts = new Vector<SqlPart>(10, 2);
        for (int i = 0; i < paramSql.length(); ++i) {
            String paramName;
            YColumnDefinition.FieldType paramType;
            char c = paramSql.charAt(i);
            if (c == '\'') {
                isString = !isString;
                continue;
            }
            if (c != ':' || isString) continue;
            if (i0para < 0 && i + 1 < paramSql.length() && paramSql.charAt(i + 1) == ':') {
                ++i;
                continue;
            }
            if (i0para < 0) {
                i0para = i;
                continue;
            }
            String param = paramSql.substring(i0para + 1, i);
            String sqlPartSql = paramSql.substring(iSql, i0para);
            int iAuf = param.indexOf(40);
            int iZu = param.indexOf(41);
            if (iAuf > 0 && iZu > 0 && iZu - iAuf >= 3) {
                String strParamType = param.substring(iAuf + 1, iZu);
                if (filter != null && strParamType.equals("FEXPR")) {
                    paramType = null;
                } else {
                    try {
                        paramType = YColumnDefinition.FieldType.valueOf(strParamType);
                    }
                    catch (IllegalArgumentException e) {
                        throw new YProgramException(this, e.getMessage());
                    }
                }
                paramName = param.substring(0, iAuf);
            } else if (iAuf < 0 && iZu < 0) {
                paramType = YColumnDefinition.FieldType.INT;
                paramName = param;
            } else {
                throw new YProgramException(this, "Fehlerhafter Abfrageparameter: ':" + param + ":'");
            }
            if (paramType == null) {
                int iFilter;
                for (iFilter = 0; iFilter < filter.length; ++iFilter) {
                    if (!filter[iFilter].fName.equals(paramName)) continue;
                    if (filter[iFilter].sqlParts != null) break;
                    filter[iFilter].sqlParts = this.splitParamSql(filter[iFilter].paramSql, null);
                    break;
                }
                if (iFilter >= filter.length) {
                    throw new YProgramException(this, "Filterausdruck nicht definiert: " + paramName);
                }
                sqlParts.add(new SqlPart(sqlPartSql, paramName, filter[iFilter]));
            } else {
                sqlParts.add(new SqlPart(sqlPartSql, paramName, paramType));
            }
            iSql = i + 1;
            i0para = -1;
        }
        if (iSql < paramSql.length()) {
            sqlParts.add(new SqlPart(paramSql.substring(iSql), null, (YColumnDefinition.FieldType)null));
        }
        return sqlParts;
    }

    public YParamSql(String paramSql, Filter[] filter) throws YProgramException {
        this.sqlParts = this.splitParamSql(paramSql, filter);
    }

    public YParamSql(String paramSql) throws YProgramException {
        this(paramSql, null);
    }

    public void clearParamValues() {
        for (int iPart = 0; iPart < this.sqlParts.size(); ++iPart) {
            SqlPart sqlPart = this.sqlParts.get(iPart);
            sqlPart.paramValue = null;
            if (sqlPart.filter == null) continue;
            for (int iFPart = 0; iFPart < sqlPart.filter.sqlParts.size(); ++iFPart) {
                sqlPart.filter.sqlParts.get((int)iFPart).paramValue = null;
            }
        }
    }

    public void setParamValue(String paramName, String paramValue) throws YProgramException {
        boolean paramFound = false;
        block0: for (int iPart = 0; iPart < this.sqlParts.size(); ++iPart) {
            SqlPart sqlPart = this.sqlParts.get(iPart);
            if (sqlPart.paramName == null) break;
            if (sqlPart.filter != null) {
                for (int iFPart = 0; iFPart < sqlPart.filter.sqlParts.size(); ++iFPart) {
                    SqlPart sqlFPart = sqlPart.filter.sqlParts.get(iFPart);
                    if (sqlFPart.paramName == null) continue block0;
                    if (!sqlFPart.paramName.equals(paramName)) continue;
                    sqlFPart.paramValue = paramValue;
                    paramFound = true;
                }
                continue;
            }
            if (!sqlPart.paramName.equals(paramName)) continue;
            sqlPart.paramValue = paramValue;
            paramFound = true;
        }
        if (!paramFound) {
            throw new YProgramException(this, "Unbekannter Parameter: '" + paramName + "'");
        }
    }

    public String createSQL(YDatabaseData databaseData) throws YProgramException {
        StringBuffer sqlBuffer = new StringBuffer(400);
        try {
            for (int iPart = 0; iPart < this.sqlParts.size(); ++iPart) {
                SqlPart sqlPart = this.sqlParts.get(iPart);
                sqlBuffer.append(sqlPart.sql);
                if (sqlPart.paramName == null) continue;
                if (sqlPart.filter != null) {
                    int iFPart;
                    StringBuffer sqlFBuffer = new StringBuffer(60);
                    for (iFPart = 0; iFPart < sqlPart.filter.sqlParts.size(); ++iFPart) {
                        SqlPart sqlFPart = sqlPart.filter.sqlParts.get(iFPart);
                        sqlFBuffer.append(sqlFPart.sql);
                        if (sqlFPart.paramName == null) continue;
                        if (sqlFPart.paramValue == null) break;
                        sqlFBuffer.append(databaseData.sqlValue(sqlFPart.paramValue, sqlFPart.paramType));
                    }
                    if (iFPart < sqlPart.filter.sqlParts.size()) continue;
                    sqlPart.paramValue = sqlFBuffer.toString();
                }
                if (sqlPart.paramValue == null) {
                    throw new YProgramException(this, "Kein Wert f\u00fcr Parameter: '" + sqlPart.paramName + "'");
                }
                if (sqlPart.filter != null) {
                    sqlBuffer.append(sqlPart.paramValue);
                    continue;
                }
                sqlBuffer.append(databaseData.sqlValue(sqlPart.paramValue, sqlPart.paramType));
            }
            return sqlBuffer.toString();
        }
        catch (YException e) {
            throw new YProgramException(this, e.toString());
        }
    }

    public static class Filter {
        String fName;
        String paramSql;
        Vector<SqlPart> sqlParts;

        public Filter(String fName, String paramSql) throws YProgramException {
            this.fName = fName;
            this.paramSql = paramSql;
            this.sqlParts = null;
        }
    }

    class SqlPart {
        public String sql;
        public String paramName;
        public YColumnDefinition.FieldType paramType;
        public Filter filter;
        public String paramValue;

        public SqlPart(String sql, String paramName, YColumnDefinition.FieldType paramType) {
            this.sql = sql;
            this.paramName = paramName;
            this.paramType = paramType;
            this.filter = null;
            this.paramValue = null;
        }

        public SqlPart(String sql, String paramName, Filter filter) {
            this.sql = sql;
            this.paramName = paramName;
            this.paramType = null;
            this.filter = filter;
            this.paramValue = null;
        }
    }
}

