/*
 * Decompiled with CFR 0.152.
 */
package popometer.graphics;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class RectScaler {
    private boolean center;
    private Dimension dimReal;
    private Rectangle rectInner;
    private float fX;
    private float fY;

    public RectScaler(boolean center) {
        this.center = center;
        this.dimReal = new Dimension();
        this.rectInner = new Rectangle();
        this.fX = 1.0f;
        this.fY = 1.0f;
    }

    public RectScaler() {
        this.center = true;
        this.dimReal = new Dimension();
        this.rectInner = new Rectangle();
        this.fX = 1.0f;
        this.fY = 1.0f;
    }

    public void scale(int wOuter, int hOuter, int wInner, int hInner) {
        float rOuter = (float)wOuter / (float)hOuter;
        float rInner = (float)wInner / (float)hInner;
        if (rOuter > rInner) {
            this.rectInner.height = hOuter;
            this.rectInner.width = (int)((float)wInner * (float)hOuter / (float)hInner);
            if (this.center) {
                this.rectInner.x = (wOuter - this.rectInner.width) / 2;
                this.rectInner.y = 0;
            }
        } else {
            this.rectInner.width = wOuter;
            this.rectInner.height = (int)((float)hInner * (float)wOuter / (float)wInner);
            if (this.center) {
                this.rectInner.x = 0;
                this.rectInner.y = (hOuter - this.rectInner.height) / 2;
            }
        }
        this.fX = (float)wInner / (float)this.rectInner.width;
        this.fY = (float)hInner / (float)this.rectInner.height;
        this.dimReal.width = wInner;
        this.dimReal.height = hInner;
    }

    public void scale(JPanel panel, BufferedImage image) {
        this.scale(panel.getWidth(), panel.getHeight(), image.getWidth(), image.getHeight());
    }

    public int getX() {
        return this.rectInner.x;
    }

    public int getY() {
        return this.rectInner.y;
    }

    public int getRealWidth() {
        return this.dimReal.width;
    }

    public int getRealHeight() {
        return this.dimReal.height;
    }

    public int getWidth() {
        return this.rectInner.width;
    }

    public int getHeight() {
        return this.rectInner.height;
    }

    public void scaleFrom(Point ps, Point p) {
        ps.x = Math.round((float)(p.x - this.rectInner.x) * this.fX);
        ps.y = Math.round((float)(p.y - this.rectInner.y) * this.fY);
    }

    public void scaleTo(Point ps, Point p) {
        ps.x = Math.round((float)p.x / this.fX) + this.rectInner.x;
        ps.y = Math.round((float)p.y / this.fY) + this.rectInner.y;
    }

    public int scaleTo(int l) {
        return Math.round((float)l / this.fX);
    }

    public int scaleFrom(int l) {
        return Math.round((float)l * this.fX);
    }

    public boolean scaleFrom(Point p, MouseEvent e) {
        int x = e.getX() - this.rectInner.x;
        int y = e.getY() - this.rectInner.y;
        if (x < 0 || y < 0) {
            return false;
        }
        if (x >= this.rectInner.width || y >= this.rectInner.height) {
            return false;
        }
        p.x = Math.round((float)x * this.fX);
        p.y = Math.round((float)y * this.fY);
        return true;
    }
}

