/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabaseList;
import projektY.database.YRowValues;
import projektY.database.YSession;

public abstract class YFilteredList
extends YDatabaseList {
    protected String andWhere;
    private YRowValues fetchedRow;
    protected boolean fetched;
    private Vector<Filter> filters;

    public YFilteredList(YSession session, int maxColumns, int maxRows) throws YProgramException {
        super(session, maxColumns, true);
        this.maxRows = maxRows;
        this.moreRows = false;
        this.fetched = false;
    }

    public YFilteredList(YSession session, int maxColumns, boolean readOnly) throws YProgramException {
        super(session, maxColumns, readOnly);
        this.fetched = false;
    }

    public YFilteredList(YSession session, int maxColumns) throws YProgramException {
        this(session, maxColumns, false);
    }

    protected void setAndWhere(String andWhere) throws YProgramException {
        assert (this.paramSelect == null) : "setAndWhere() kann nicht mit parametrisiertem SELECT verwendet werden.";
        this.andWhere = andWhere != null ? "(" + andWhere + ")" : null;
    }

    public boolean existsFilter(String filterName) {
        if (this.filters == null) {
            return false;
        }
        for (int iFilter = 0; iFilter < this.filters.size(); ++iFilter) {
            if (!this.filters.get((int)iFilter).filterName.equals(filterName)) continue;
            return true;
        }
        return false;
    }

    public void addFilter(String filterName, String filterExpression, YColumnDefinition.FieldType fieldType) throws YProgramException {
        try {
            assert (this.paramSelect == null) : "addFilter() kann nicht mit parametrisiertem SELECT verwendet werden.";
            if (this.existsFilter(filterName)) {
                throw new YProgramException(this, "Der Filter '" + filterName + "' wurde bereits hinzugef\u00fcgt.");
            }
            if (this.filters == null) {
                this.filters = new Vector();
            }
            this.filters.add(new Filter(this, filterName, filterExpression, fieldType));
        }
        catch (AssertionError e) {
            throw new YProgramException(this, ((Throwable)((Object)e)).toString());
        }
    }

    public void setFilterValue(String filterName, String value) throws YException, YProgramException {
        if (this.paramSelect != null) {
            this.paramSelect.setParamValue(filterName, value);
            return;
        }
        if (this.filters == null) {
            throw new YProgramException(this, "Keine Filter angelegt.");
        }
        for (int iFilter = 0; iFilter < this.filters.size(); ++iFilter) {
            Filter filter = this.filters.get(iFilter);
            if (!filter.filterName.equals(filterName)) continue;
            filter.value = this.sqlValue(value, filter.fieldType);
            return;
        }
        throw new YProgramException(this, "Filter nicht gefunden: '" + filterName + "'");
    }

    public void setFilterValues(String filterName, String[] values) throws YException, YProgramException {
        if (this.paramSelect != null) {
            throw new YProgramException(this, "setFilterValues(String, String[]) kann nicht bei paramSelect eingesetzt werden.");
        }
        if (this.filters == null) {
            throw new YProgramException(this, "Keine Filter angelegt.");
        }
        for (int iFilter = 0; iFilter < this.filters.size(); ++iFilter) {
            Filter filter = this.filters.get(iFilter);
            if (!filter.filterName.equals(filterName)) continue;
            StringBuffer vbuf = new StringBuffer(40);
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    vbuf.append(",");
                }
                vbuf.append(this.sqlValue(values[i], filter.fieldType));
            }
            filter.value = vbuf.toString();
            return;
        }
        throw new YProgramException(this, "Filter nicht gefunden: '" + filterName + "'");
    }

    public void setFilterValues(String filterName, Object[] values) throws YException, YProgramException {
        if (this.filters == null) {
            throw new YProgramException(this, "Keine Filter angelegt.");
        }
        for (int iFilter = 0; iFilter < this.filters.size(); ++iFilter) {
            Filter filter = this.filters.get(iFilter);
            if (!filter.filterName.equals(filterName)) continue;
            StringBuffer vbuf = new StringBuffer(40);
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    vbuf.append(",");
                }
                vbuf.append(this.sqlValue(values[i].toString(), filter.fieldType));
            }
            filter.value = vbuf.toString();
            return;
        }
        throw new YProgramException(this, "Filter nicht gefunden: '" + filterName + "'");
    }

    public void clearFilterValues() {
        if (this.paramSelect != null) {
            this.paramSelect.clearParamValues();
            return;
        }
        if (this.filters == null) {
            return;
        }
        for (int iFilter = 0; iFilter < this.filters.size(); ++iFilter) {
            this.filters.get((int)iFilter).value = null;
        }
    }

    protected String createFilterExpression() throws YException {
        StringBuffer expression = new StringBuffer();
        if (this.filters != null) {
            int n = 0;
            for (int iFilter = 0; iFilter < this.filters.size(); ++iFilter) {
                Filter filter = this.filters.get(iFilter);
                if (filter.value == null) continue;
                int l = expression.length();
                if (l > 0) {
                    expression.append(" AND ");
                    l += 5;
                }
                expression.append('(');
                expression.append(filter.filterExpression);
                expression.insert(1 + l + filter.iValue, filter.value);
                expression.append(')');
                ++n;
            }
            if (n > 1) {
                expression.insert(0, '(');
                expression.append(')');
            }
            return new String(expression);
        }
        return "";
    }

    protected String createWhereExpression() throws YException {
        StringBuffer where = new StringBuffer();
        where.append(this.createFilterExpression());
        if (this.andWhere != null) {
            if (where.length() > 0) {
                where.insert(0, '(');
                where.append(')');
                where.append(" AND ");
            }
            where.append(this.andWhere);
        }
        return where.toString();
    }

    protected String createSelectWhere() throws YException {
        if (this.paramSelect != null) {
            return this.paramSelect.createSQL(this);
        }
        StringBuffer sql = new StringBuffer(this.sqlSelect);
        String where = this.createWhereExpression();
        if (where.length() > 0) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        return new String(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YFilteredList fetch() throws YException {
        try {
            ++this.changeLevel;
            StringBuffer sql = new StringBuffer(this.createSelectWhere());
            int nFetched = 0;
            this.unsetActiveRow();
            if (this.order != null) {
                sql.append(" ORDER BY ");
                for (int i = 0; i < this.order.length; ++i) {
                    if (i > 0) {
                        sql.append(", ");
                    }
                    sql.append(this.order[i]);
                }
                if (this.orderDesc) {
                    sql.append(" DESC");
                }
            }
            this.sqlQuery.execute(sql.toString());
            this.clearRowValues();
            this.moreRows = false;
            while (this.sqlQuery.next()) {
                if (this.maxRows > 0 && ++nFetched > this.maxRows) {
                    this.moreRows = true;
                    break;
                }
                YRowValues rowValues = this.createRowValues();
                for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                    this.getQueryResult(rowValues.getFieldValue(i));
                }
                this.addRowValues(rowValues);
            }
            this.fetched = true;
            YFilteredList yFilteredList = this;
            return yFilteredList;
        }
        finally {
            this.sqlQuery.close();
            --this.changeLevel;
            this.fireChanged(new YDBOChangeEvent());
        }
    }

    protected YRowValues startFetchRows() throws YException {
        try {
            StringBuffer sql = new StringBuffer(this.createSelectWhere());
            if (this.order != null) {
                sql.append(" ORDER BY ");
                for (int i = 0; i < this.order.length; ++i) {
                    if (i > 0) {
                        sql.append(", ");
                    }
                    sql.append(this.order[i]);
                }
            }
            this.sqlQuery.execute(sql.toString());
            if (this.fetchedRow == null) {
                this.fetchedRow = this.rowDefinition.createRowValues(0);
            } else {
                this.fetchedRow.clear();
            }
            return this.fetchedRow;
        }
        catch (YException e) {
            this.sqlQuery.close();
            throw e;
        }
    }

    protected boolean fetchNextRow() throws YException {
        if (!this.sqlQuery.next()) {
            return false;
        }
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            this.getQueryResult(this.fetchedRow.getFieldValue(i));
        }
        return true;
    }

    protected void endFetchRows() throws YException {
        this.sqlQuery.close();
    }

    /*
     * Unable to fully structure code
     */
    public void fetchAsCSV(OutputStreamWriter osw, char fieldSeparator, char textSeparator, String lineSeparator, String charsetName) throws YException {
        try {
            rowValues = this.startFetchRows();
            nCols = this.rowDefinition.getNColumns();
            while (this.fetchNextRow()) {
                for (iCol = 0; iCol < nCols; ++iCol) {
                    if (iCol > 0) {
                        osw.write(fieldSeparator);
                    }
                    fieldValue = rowValues.getFieldValue(iCol);
                    this.getQueryResult(fieldValue);
                    fieldType = fieldValue.getColumnDefinition().getFieldType();
                    if (fieldType == YColumnDefinition.FieldType.STRING) ** GOTO lbl-1000
                    if (fieldType == YColumnDefinition.FieldType.EMPTYSTRING) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = isString = false;
                    }
                    if (isString && textSeparator != '\u0000') {
                        osw.write(textSeparator);
                    }
                    osw.write(fieldValue.getValue());
                    if (!isString || textSeparator == '\u0000') continue;
                    osw.write(textSeparator);
                }
                osw.write(lineSeparator);
            }
            this.endFetchRows();
        }
        catch (IOException e) {
            throw new YException("Fehler beim Schreiben der CSV-Datei: " + e.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void fetchAsCSV(OutputStreamWriter osw, char fieldSeparator, char textSeparator, String lineSeparator, boolean header) throws YException {
        try {
            rowValues = this.startFetchRows();
            nCols = this.rowDefinition.getNColumns();
            if (header) {
                for (iCol = 0; iCol < nCols; ++iCol) {
                    if (iCol > 0) {
                        osw.write(fieldSeparator);
                    }
                    osw.write(textSeparator);
                    osw.write(rowValues.getFieldValue(iCol).getColumnDefinition().getLabel());
                    osw.write(textSeparator);
                }
                osw.write(lineSeparator);
            }
            while (this.fetchNextRow()) {
                for (iCol = 0; iCol < nCols; ++iCol) {
                    if (iCol > 0) {
                        osw.write(fieldSeparator);
                    }
                    fieldValue = rowValues.getFieldValue(iCol);
                    this.getQueryResult(fieldValue);
                    fieldType = fieldValue.getColumnDefinition().getFieldType();
                    if (fieldType == YColumnDefinition.FieldType.STRING) ** GOTO lbl-1000
                    if (fieldType == YColumnDefinition.FieldType.EMPTYSTRING) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = isString = false;
                    }
                    if (isString && textSeparator != '\u0000') {
                        osw.write(textSeparator);
                    }
                    osw.write(fieldValue.getValue());
                    if (!isString || textSeparator == '\u0000') continue;
                    osw.write(textSeparator);
                }
                osw.write(lineSeparator);
            }
            this.endFetchRows();
        }
        catch (IOException e) {
            throw new YException("Fehler beim Schreiben der CSV-Datei: " + e.toString());
        }
    }

    public void fetchAsCSV(OutputStreamWriter osw, char fieldSeparator, char textSeparator, String lineSeparator) throws YException {
        this.fetchAsCSV(osw, fieldSeparator, textSeparator, lineSeparator, false);
    }

    private class Filter {
        String filterName;
        String filterExpression;
        int iValue;
        YColumnDefinition.FieldType fieldType;
        String value;

        Filter(Object obj, String filterName, String filterExpression, YColumnDefinition.FieldType fieldType) throws YProgramException {
            this.filterName = filterName;
            this.iValue = filterExpression.indexOf(":value:");
            if (this.iValue < 0) {
                throw new YProgramException(obj, "':value:' fehlt im Filerausdruck '" + filterExpression + "'");
            }
            StringBuffer sbExpression = new StringBuffer(filterExpression);
            sbExpression.delete(this.iValue, this.iValue + ":value:".length());
            this.filterExpression = new String(sbExpression);
            this.fieldType = fieldType;
        }
    }
}

