/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.base.YProgramException;
import projektY.base.YUnimplementedException;
import projektY.database.YCheckColumnDefinition;
import projektY.database.YColumnDefinition;
import projektY.database.YDatabaseData;
import projektY.database.YDatabaseList;
import projektY.database.YFieldValue;
import projektY.database.YListFkColumnDefinition;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YRowFkColumnDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;

public class YRowDefinition {
    Vector<YColumnDefinition> columnDefinitions;
    private YDatabaseData databaseData = null;
    YColumnDefinition[] toStringColumns;
    boolean concatToString;
    String concatString;
    private int nPkCols;
    private YColumnDefinition pkColumnDefinition;

    public YRowDefinition(YDatabaseData databaseData, int maxColumns) throws YProgramException {
        this.assignTo(databaseData);
        this.columnDefinitions = maxColumns > 0 ? new Vector(maxColumns, 10) : new Vector(30, 20);
        this.nPkCols = 0;
        this.pkColumnDefinition = null;
    }

    public YRowDefinition(YDatabaseData databaseData) throws YProgramException {
        this(databaseData, 0);
    }

    public YRowDefinition() throws YProgramException {
        this(null);
    }

    public YRowDefinition(YRowDefinition rowDefinition, int nMoreColumns) throws YProgramException {
        this.assignTo(this.databaseData);
        this.nPkCols = rowDefinition.nPkCols;
        this.pkColumnDefinition = rowDefinition.pkColumnDefinition;
        this.columnDefinitions = new Vector(rowDefinition.getNColumns() + nMoreColumns);
        for (int iCol = 0; iCol < rowDefinition.getNColumns(); ++iCol) {
            this.columnDefinitions.add(rowDefinition.columnDefinitions.get(iCol));
        }
    }

    public void assignTo(YDatabaseData databaseData) throws YProgramException {
        if (this.databaseData != null) {
            throw new YProgramException(this, "Jede Zeilendefinition kann nur f\u00fcr ein Objekt benutzt werden.");
        }
        this.databaseData = databaseData;
    }

    public void addColumnDefinition(YColumnDefinition columnDefinition) throws YProgramException {
        int i;
        String name = columnDefinition.getName();
        for (i = 0; i < this.getNColumns(); ++i) {
            int j = this.columnDefinitions.get(i).getName().compareTo(name);
            if (j == 0) {
                throw new YProgramException(this.databaseData == null ? this : this.databaseData, "Die Spalte '" + name + "' ist bereits definiert.");
            }
            if (j > 0) break;
        }
        this.columnDefinitions.add(i, columnDefinition);
        if (columnDefinition.isPrimaryKey()) {
            this.pkColumnDefinition = ++this.nPkCols == 1 ? columnDefinition : null;
        }
    }

    public YColumnDefinition addColumnDefinition(String name, YColumnDefinition.FieldType fieldType, boolean primaryKey, boolean readOnly) throws YProgramException {
        YColumnDefinition columnDefinition = new YColumnDefinition(this.getNColumns(), name, fieldType, primaryKey, readOnly);
        this.addColumnDefinition(columnDefinition);
        return columnDefinition;
    }

    public YColumnDefinition addColumnDefinition(String name, YColumnDefinition.FieldType fieldType) throws YProgramException {
        YColumnDefinition columnDefinition = new YColumnDefinition(this.getNColumns(), name, fieldType, false, false);
        this.addColumnDefinition(columnDefinition);
        return columnDefinition;
    }

    public YColumnDefinition addROColumnDefinition(String name, YColumnDefinition.FieldType fieldType) throws YException {
        YColumnDefinition columnDefinition = new YColumnDefinition(this.getNColumns(), name, fieldType, false, true);
        this.addColumnDefinition(columnDefinition);
        return columnDefinition;
    }

    public YColumnDefinition addAliasDefinition(String name, YColumnDefinition columnDefinition) throws YProgramException {
        YColumnDefinition aliasDefinition = new YColumnDefinition(this.getNColumns(), name, columnDefinition);
        this.addColumnDefinition(aliasDefinition);
        return aliasDefinition;
    }

    public YRowFkColumnDefinition addFkColumnDefinition(String name, YRowObject referencedObject) throws YProgramException {
        YRowFkColumnDefinition rowFkColumnDefinition = new YRowFkColumnDefinition(this.getNColumns(), name, referencedObject);
        this.addColumnDefinition(rowFkColumnDefinition);
        return rowFkColumnDefinition;
    }

    public YRowFkColumnDefinition addPkFkColumnDefinition(String name, YRowObject referencedObject) throws YProgramException {
        YRowFkColumnDefinition rowFkColumnDefinition = new YRowFkColumnDefinition(this.getNColumns(), name, referencedObject, true);
        this.addColumnDefinition(rowFkColumnDefinition);
        return rowFkColumnDefinition;
    }

    public YLookUpDBColumnDefinition addLookUpDBColumnDefinition(String name, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YProgramException {
        YLookUpDBColumnDefinition lookUpColumnDefinition = new YLookUpDBColumnDefinition(this.getNColumns(), name, lookUpList, valueFieldName, altFieldName);
        this.addColumnDefinition(lookUpColumnDefinition);
        return lookUpColumnDefinition;
    }

    public YLookUpDBColumnDefinition addLookUpDBColumnDefinition(String name, YDatabaseList lookUpList, String valueFieldName) throws YException {
        YLookUpDBColumnDefinition lookUpColumnDefinition = new YLookUpDBColumnDefinition(this.getNColumns(), name, lookUpList, valueFieldName);
        this.addColumnDefinition(lookUpColumnDefinition);
        return lookUpColumnDefinition;
    }

    public YLookUpDomainColumnDefinition addLookUpDomainDefinition(String name, YColumnDefinition.FieldType fieldType, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = new YLookUpDomainColumnDefinition(this.getNColumns(), name, fieldType, domain);
        this.addColumnDefinition(lookUpDomainColumnDefinition);
        return lookUpDomainColumnDefinition;
    }

    public YLookUpDomainColumnDefinition addLookUpDomainDefinition(String name, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = new YLookUpDomainColumnDefinition(this.getNColumns(), name, domain);
        this.addColumnDefinition(lookUpDomainColumnDefinition);
        return lookUpDomainColumnDefinition;
    }

    public YCheckColumnDefinition addCheckColumnDefinition(String name) throws YException {
        YCheckColumnDefinition checkColumnDefinition = new YCheckColumnDefinition(this.getNColumns(), name);
        this.addColumnDefinition(checkColumnDefinition);
        return checkColumnDefinition;
    }

    public YListFkColumnDefinition addFkColumnDefinition(String name, YRowObjectList referencedRowList) throws YException {
        YListFkColumnDefinition listFkColumnDefinition = new YListFkColumnDefinition(this.getNColumns(), name, referencedRowList);
        this.addColumnDefinition(listFkColumnDefinition);
        return listFkColumnDefinition;
    }

    void setToStringFields(String[] fieldNames, String concatWith) throws YException {
        if (concatWith == null) {
            this.concatToString = false;
            this.concatString = null;
        } else {
            this.concatToString = true;
            this.concatString = concatWith;
        }
        int nToStringColumns = fieldNames.length;
        this.toStringColumns = new YColumnDefinition[nToStringColumns];
        for (int i = 0; i < nToStringColumns; ++i) {
            this.toStringColumns[i] = this.getColumnDefinition(fieldNames[i]);
        }
    }

    void setToStringFields(String[] fieldNames) throws YException {
        this.setToStringFields(fieldNames, null);
    }

    void setToStringFields(String[] fieldNames, boolean concat) throws YException {
        if (concat) {
            this.setToStringFields(fieldNames, " ");
        } else {
            this.setToStringFields(fieldNames);
        }
    }

    void setToStringField(String fieldName) throws YException {
        this.setToStringFields(new String[]{fieldName}, false);
    }

    private int getArrayIndex(String columnName) {
        int l = 0;
        int r = this.getNColumns() - 1;
        while (l <= r) {
            int i = (l + r) / 2;
            int c = this.columnDefinitions.get(i).getName().compareTo(columnName);
            if (c > 0) {
                r = i - 1;
                continue;
            }
            if (c < 0) {
                l = i + 1;
                continue;
            }
            return i;
        }
        return -1;
    }

    public boolean isColumnDefined(String columnName) {
        return this.getArrayIndex(columnName) >= 0;
    }

    public int getFieldValueIndex(String columnName) throws YProgramException {
        int i = this.getArrayIndex(columnName);
        if (i < 0) {
            throw new YProgramException(this.databaseData == null ? this : this.databaseData, "Unbekannte Datenbankspalte: " + columnName);
        }
        return this.columnDefinitions.get(i).getFieldValueIndex();
    }

    public boolean columnExists(String columnName) {
        return this.getArrayIndex(columnName) >= 0;
    }

    public YColumnDefinition getPkColumnDefinition() throws YProgramException {
        if (this.pkColumnDefinition == null) {
            throw new YProgramException(this, "Es gibt kein eindeutiges Prim\u00e4rschl\u00fcsselfeld.");
        }
        return this.pkColumnDefinition;
    }

    public int getMaxColumns() {
        if (this.columnDefinitions == null) {
            return 0;
        }
        return this.columnDefinitions.capacity();
    }

    public int getNColumns() {
        return this.columnDefinitions.size();
    }

    public YColumnDefinition getColumnDefinition(int iCol) {
        return this.columnDefinitions.get(iCol);
    }

    public YColumnDefinition getColumnDefinition(String columnName) throws YProgramException {
        int i = this.getArrayIndex(columnName);
        if (i < 0) {
            throw new YProgramException(this.databaseData == null ? this : this.databaseData, "Unbekannte Datenbankspalte: " + columnName);
        }
        return this.columnDefinitions.get(i);
    }

    public YRowValues createRowValues(int rowId) throws YProgramException {
        int iCol;
        int nToStringColumns = this.toStringColumns == null ? 0 : this.toStringColumns.length;
        int nColumns = this.getNColumns();
        YRowValues rowValues = new YRowValues(this, rowId);
        for (iCol = 0; iCol < nColumns; ++iCol) {
            YColumnDefinition columnDefinition = this.columnDefinitions.get(iCol);
            if (columnDefinition.isRowFk()) {
                rowValues.createFkFieldValue((YRowFkColumnDefinition)columnDefinition);
                continue;
            }
            if (columnDefinition.isListFk()) {
                rowValues.createFkFieldValue((YListFkColumnDefinition)columnDefinition);
                continue;
            }
            if (columnDefinition.isLookUp()) {
                rowValues.createLookUpFieldValue((YLookUpColumnDefinition)columnDefinition);
                continue;
            }
            if (columnDefinition.isCheck()) {
                rowValues.createCheckFieldValue((YCheckColumnDefinition)columnDefinition);
                continue;
            }
            rowValues.createDBFieldValue(columnDefinition);
        }
        if (nToStringColumns > 0) {
            rowValues.toStringValues = new YFieldValue[nToStringColumns];
            for (iCol = 0; iCol < nToStringColumns; ++iCol) {
                rowValues.toStringValues[iCol] = rowValues.getFieldValue(this.toStringColumns[iCol]);
            }
        }
        return rowValues;
    }

    public void setVisible(boolean visible) {
        int nCols = this.getNColumns();
        for (int iCol = 0; iCol < nCols; ++iCol) {
            this.getColumnDefinition((int)iCol).visible = visible;
        }
    }

    public void setVisible(String[] visibleFields) throws YProgramException {
        throw new YUnimplementedException(this, "setVisible(String[] visibleFields)");
    }
}

