/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YDBFieldValue;
import projektY.database.YFieldValue;
import projektY.database.YRowFkColumnDefinition;
import projektY.database.YRowObject;

public class YRowFkFieldValue
extends YDBFieldValue {
    private YRowFkColumnDefinition rowFkColumnDefinition;
    private YRowObject detailRowObject;
    private YFieldValue detailPkValue;

    public YRowFkFieldValue(YRowFkColumnDefinition rowFkColumnDefinition) throws YProgramException {
        super(rowFkColumnDefinition);
        this.rowFkColumnDefinition = rowFkColumnDefinition;
        this.detailRowObject = rowFkColumnDefinition.getReferencedObject();
        this.detailPkValue = this.detailRowObject.getPkFieldValue();
    }

    public YRowFkColumnDefinition getRowFkColumnDefinition() {
        return this.rowFkColumnDefinition;
    }

    public void modifyValue(String value) throws YException {
        try {
            super.modifyValue(value);
            if (!value.equals(this.detailPkValue.getValue())) {
                if (value.length() == 0) {
                    this.detailRowObject.clear();
                } else {
                    this.detailRowObject.fetch(Integer.parseInt(value));
                }
            }
        }
        catch (NumberFormatException e) {
            throw new YException("Ung\u00fcltiger Wert f\u00fcr Fremdschl\u00fcssel: " + value);
        }
    }

    public void revert() throws YException {
        if (!this.hasChanged()) {
            return;
        }
        if (this.wasNull()) {
            super.revert();
            this.detailRowObject.clear();
        } else {
            super.revert();
            this.detailRowObject.fetch(this.getValueAsInt());
        }
    }
}

