/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabase;
import projektY.database.YFieldValue;
import projektY.database.YListFkColumnDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.YSubDetailList;
import projektY.database.YSubRowListImplementation;

public class YDetailList
extends YRowObjectList {
    protected YColumnDefinition rowObjectFkDefinition;
    protected String rowObjectFkAlias;
    protected YColumnDefinition masterRowFkDefinition;
    protected YRowObject masterRowObject;
    protected int rowObjectId = 0;
    protected boolean autoRowObjectId = false;
    protected OnRemove onRemove = OnRemove.DELETE;

    protected YDetailList(YSession session, int maxColumns, boolean readOnly) throws YProgramException {
        super(session, maxColumns, readOnly);
    }

    protected YDetailList(YSession session, int maxColumns) throws YProgramException {
        this(session, maxColumns, false);
    }

    protected YDetailList(YSession session, int maxColumns, YRowObject masterRowObject) throws YException {
        this(session, maxColumns);
        if (masterRowObject == null) {
            throw new YProgramException(this, "Das MasterRowObject einer DetailList kann nicht null sein.");
        }
        this.masterRowObject = masterRowObject;
    }

    protected YDetailList(YSession session, int maxColumns, int masterId, boolean readOnly) throws YException {
        this(session, maxColumns, readOnly);
        if (masterId <= 0) {
            throw new YException("Die masterId einer eigenst\u00e4ndigen Detailliste mu\u00df > 0 sein.");
        }
        this.rowObjectId = masterId;
    }

    protected YDetailList(YSession session, int maxColumns, int masterId) throws YException {
        this(session, maxColumns, masterId, false);
    }

    public YRowObject getMasterRowObject() throws YProgramException {
        if (this.masterRowObject == null) {
            throw new YProgramException(this, "Die Detailliste besitzt kein Master-Rowobjekt.");
        }
        return this.masterRowObject;
    }

    protected YListFkColumnDefinition addSubDetailFkField(String fieldName, YSubDetailList referencedList) throws YException {
        return this.rowDefinition.addFkColumnDefinition(fieldName, referencedList);
    }

    public YColumnDefinition addRowObjectFkField(String fieldName, boolean readOnly) throws YException {
        if (this.rowObjectFkDefinition != null) {
            throw new YProgramException(this, "rowObjectFkDefinition ist bereits gesetzt.");
        }
        if (this.masterRowFkDefinition != null) {
            throw new YProgramException(this, "masterRowFkDefinition darf erst nach rowObjectFkDefinition gesetzt werden.");
        }
        this.masterRowFkDefinition = this.rowObjectFkDefinition = this.rowDefinition.addColumnDefinition(fieldName, YColumnDefinition.FieldType.INT, false, readOnly);
        return this.rowObjectFkDefinition;
    }

    public YColumnDefinition addRowObjectFkField(String fieldName) throws YException {
        return this.addRowObjectFkField(fieldName, false);
    }

    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        assert (this.onRemove != OnRemove.UNDEFINED);
        if (this.rowObjectFkDefinition == null) {
            throw new YProgramException(this, "Fremdschl\u00fcssel zum Master-Zeilenobjekt nicht definiert.");
        }
        if (this.rowObjectFkAlias == null) {
            this.rowObjectFkAlias = "";
        } else {
            int l = this.rowObjectFkAlias.length();
            if (l > 0 && this.rowObjectFkAlias.charAt(l - 1) != '.') {
                this.rowObjectFkAlias = this.rowObjectFkAlias + ".";
            }
        }
    }

    public YRowValues append() throws YException {
        YRowValues rowValues = this.createRowValues();
        return this.addRowValues(rowValues);
    }

    public YRowValues append(YRowObject rowObject) throws YException {
        YRowValues rowValues = super.append(rowObject);
        rowValues.setAsString(this.masterRowFkDefinition.getFieldValueIndex(), rowObject.getPkFieldValue().getValue());
        return rowValues;
    }

    protected String createSelectWhere(int objId) throws YException {
        StringBuffer sql = new StringBuffer(this.sqlSelect);
        StringBuffer where = new StringBuffer();
        where.append(this.createFilterExpression());
        if (this.andWhere != null) {
            if (where.length() > 0) {
                where.insert(0, '(');
                where.append(')');
                where.append(" AND ");
            }
            where.append(this.andWhere);
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append(this.rowObjectFkAlias);
        where.append(this.rowObjectFkDefinition.getName());
        where.append('=');
        where.append(objId);
        sql.append(" WHERE (");
        sql.append(where);
        sql.append(')');
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YDetailList fetch() throws YProgramException, YException {
        try {
            int masterId;
            assert (this.finalized);
            if (this.masterRowObject == null) {
                if (this.rowObjectId == 0) {
                    throw new YProgramException(this, "Die Id des Master-Zeilenobjekts ist nicht bekannt.");
                }
                masterId = this.rowObjectId;
            } else {
                String idString = this.masterRowObject.getPkFieldValue().getValue0();
                if (idString.length() == 0) {
                    throw new YProgramException(this, "fetch() erfordert ein gef\u00fclltes Master-Objekt.");
                }
                masterId = new Integer(idString);
            }
            StringBuffer sql = new StringBuffer();
            sql.append(this.createSelectWhere(masterId));
            if (this.order != null) {
                sql.append(" ORDER BY ");
                for (int i = 0; i < this.order.length; ++i) {
                    if (i > 0) {
                        sql.append(", ");
                    }
                    sql.append(this.order[i]);
                }
            }
            this.sqlQuery.execute(sql.toString());
            ++this.changeLevel;
            this.clearRowValues();
            boolean hasMaxRows = this.maxRows > 0;
            this.moreRows = false;
            int iRow = 0;
            while (this.sqlQuery.next()) {
                if (hasMaxRows && iRow >= this.maxRows) {
                    this.moreRows = true;
                    break;
                }
                YRowValues rowValues = this.createRowValues();
                for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                    this.getQueryResult(rowValues.getFieldValue(i));
                }
                this.addRowValues(rowValues);
                ++iRow;
            }
            this.rowObjectId = masterId;
            for (int iSub = 0; iSub < this.subListImplementations.size(); ++iSub) {
                ((YSubRowListImplementation)this.subListImplementations.get(iSub)).fetch();
            }
            YDetailList yDetailList = this;
            return yDetailList;
        }
        finally {
            this.sqlQuery.close();
            --this.changeLevel;
            this.fireChanged(new YDBOChangeEvent());
            if (this.getAbsRowCount() > 0) {
                this.setActiveRow(0);
            }
        }
    }

    public YDetailList fetch(int rowObjectId) throws YException {
        assert (this.finalized);
        assert (this.masterRowObject == null);
        this.rowObjectId = rowObjectId;
        this.fetch();
        return this;
    }

    public void requery() throws YException {
        this.fetch();
    }

    public String getRowObjectFkAlias() {
        return this.rowObjectFkAlias;
    }

    public YColumnDefinition getMasterFkDefinition() {
        return this.masterRowFkDefinition;
    }

    int getMasterFkValueAsInt(YRowValues rowValues) throws YException {
        return this.rowObjectId;
    }

    protected void postThis() throws YException {
        YDatabase database = this.session.getDatabase();
        StringBuffer sql = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            YFieldValue fieldValue;
            int iCol;
            YRowValues rowValues = this.getAbsRowValues(iRow);
            if (rowValues.hasDeleteMark()) continue;
            this.beforeRow(iRow, rowValues);
            YFieldValue pkFieldValue = rowValues.getFieldValue(this.rowPkDefinition);
            YFieldValue fkFieldValue = rowValues.getFieldValue(this.masterRowFkDefinition);
            sql.delete(0, sql.length());
            sql2.delete(0, sql2.length());
            int nSqlFields = 0;
            if (pkFieldValue.wasNull()) {
                if (this.hasValuesToStore(rowValues)) {
                    int detailId = database.nextId(this.tableName);
                    pkFieldValue.setAutoId(detailId);
                    fkFieldValue.setAutoId(this.getMasterFkValueAsInt(rowValues));
                    sql.append("INSERT INTO " + this.tableName + "(");
                    sql2.append(" VALUES (");
                    for (iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
                        fieldValue = rowValues.getFieldValue(iCol);
                        if (fieldValue.isAlias() || fieldValue.getColumnDefinition().isReadOnly() || fieldValue.isNull()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                            sql2.append(", ");
                        }
                        sql.append(fieldValue.getColumnDefinition().getName());
                        sql2.append(this.sqlValue(fieldValue));
                        ++nSqlFields;
                    }
                    sql.append(")");
                    sql.append(sql2);
                    sql.append(")");
                    rowValues.setPostMark();
                } else {
                    rowValues.setDeleteMark();
                }
            } else {
                if (this.hasValuesToStore(rowValues)) {
                    sql.append("UPDATE " + this.tableName + " SET ");
                    for (iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
                        fieldValue = rowValues.getFieldValue(iCol);
                        if (fieldValue.isAlias() || fieldValue.getColumnDefinition().isReadOnly() || fieldValue.getColumnDefinition().isPrimaryKey() || !fieldValue.hasChanged()) continue;
                        if (nSqlFields > 0) {
                            sql.append(", ");
                        }
                        sql.append(rowValues.getFieldValue(iCol).getColumnDefinition().getName() + "=");
                        sql.append(this.sqlValue(rowValues.getFieldValue(iCol)));
                        ++nSqlFields;
                    }
                    if (nSqlFields == 0) continue;
                    rowValues.setPostMark();
                } else {
                    if (this.onRemove == OnRemove.UNLINK) {
                        sql.append("UPDATE " + this.tableName + " SET " + fkFieldValue.getColumnDefinition().getName() + "=null");
                    } else if (this.onRemove == OnRemove.DELETE) {
                        sql.append("DELETE FROM " + this.tableName);
                    }
                    rowValues.setDeleteMark();
                }
                sql.append(" WHERE " + this.rowPkDefinition.getName() + "=" + pkFieldValue.getValue0());
            }
            if (sql.length() > 0) {
                if (!database.isInTransaction()) {
                    database.startTransaction();
                }
                this.sqlDml.execute(sql.toString());
            }
            this.afterRow(iRow, rowValues);
        }
    }

    public void removeAll() throws YException {
        assert (this.finalized);
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        StringBuffer sql = new StringBuffer();
        if (this.getRowCount() == 0) {
            return;
        }
        try {
            if (this.onRemove == OnRemove.DELETE) {
                sql.append("DELETE FROM " + this.tableName);
            } else if (this.onRemove == OnRemove.UNLINK) {
                sql.append("UPDATE " + this.tableName + " SET " + this.masterRowFkDefinition.getName() + "=NULL");
            } else {
                return;
            }
            sql.append(" WHERE " + this.rowPkDefinition.getName() + " IN (");
            for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                YRowValues row = this.getRowValues(iRow);
                if (iRow > 0) {
                    sql.append(", ");
                }
                sql.append(row.getFieldValue(this.rowPkDefinition).getValue0());
            }
            sql.append(')');
            this.sqlDml.execute(sql.toString());
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
                this.setPosted();
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
            }
            throw e;
        }
    }

    public void clearRows() throws YException {
        this.clearRowValues();
    }

    public void clear() throws YException {
        this.rowObjectId = 0;
        this.clearRowValues();
    }

    public int getRowObjectId() {
        return this.rowObjectId;
    }

    protected void setRowObjectFkAlias(String rowObjectFkAlias) {
        this.rowObjectFkAlias = rowObjectFkAlias + ".";
    }

    void setAutoRowObjectId(int rowObjectId) throws YException {
        if (this.rowObjectId > 0) {
            throw new YProgramException(this, "rowObjectId einer Detailliste mehrfach gesetzt.");
        }
        this.rowObjectId = rowObjectId;
        this.autoRowObjectId = true;
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues rowValues = this.getRowValues(iRow);
            rowValues.getFieldValue(this.rowObjectFkDefinition).setAutoId(rowObjectId);
        }
    }

    protected void unsetPosted() throws YException {
        super.unsetPosted();
        if (this.autoRowObjectId) {
            this.autoRowObjectId = false;
            this.rowObjectId = 0;
        }
    }

    protected boolean setPosted() throws YException {
        this.autoRowObjectId = false;
        return super.setPosted();
    }

    public YFieldValue getPkValueByRowId(int rowId) throws YException {
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            YRowValues rowValues = this.getRowValues(iRow);
            if (rowValues.getRowId() != rowId) continue;
            return rowValues.getFieldValue(this.rowPkDefinition);
        }
        throw new YProgramException(this, "Ung\u00fcltige rowId: " + String.valueOf(rowId));
    }

    public int getPkAsIntByRowId(int rowId) throws YException {
        return this.getPkValueByRowId(rowId).getValueAsInt();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum OnRemove {
        UNDEFINED,
        DELETE,
        UNLINK;

    }
}

