/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YDBFieldValue;
import projektY.database.YListFkColumnDefinition;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;

public class YListFkFieldValue
extends YDBFieldValue {
    private YListFkColumnDefinition listFkColumnDefinition;
    private YRowObjectList detailListObject;
    private int rowId;

    public YListFkFieldValue(YListFkColumnDefinition listFkColumnDefinition) throws YProgramException {
        super(listFkColumnDefinition);
        this.listFkColumnDefinition = listFkColumnDefinition;
        this.detailListObject = listFkColumnDefinition.getReferencedObject();
        this.rowId = 0;
    }

    public YListFkColumnDefinition getFkColumnDefinition() {
        return this.listFkColumnDefinition;
    }

    public void revert() throws YException {
        super.revert();
        this.rowId = 0;
    }

    public void setReferencedRowId(int rowId) throws YException {
        int iRow;
        if (this.detailListObject == null) {
            throw new YProgramException(this, "Setzen mittels rowId nur bei referenzierter Liste m\u00f6glich.");
        }
        int nRows = this.detailListObject.getAbsRowCount();
        YRowValues rowValues = null;
        for (iRow = 0; iRow < nRows && (rowValues = this.detailListObject.getAbsRowValues(iRow)).getRowId() != rowId; ++iRow) {
        }
        if (iRow >= nRows) {
            throw new YProgramException(this, "Die rowId " + rowId + " existiert nicht.");
        }
        int fkValue = rowValues.getFieldValue(this.detailListObject.rowPkDefinition).getValueAsInt(0);
        if (fkValue == 0) {
            this.rowId = rowId;
        } else {
            this.modifyValue(fkValue);
        }
    }

    int getReferencedRowId() {
        return this.rowId;
    }

    public boolean setPosted() {
        this.rowId = 0;
        return super.setPosted();
    }
}

