/*
 * Decompiled with CFR 0.152.
 */
package projektY.database.jLibY;

import projektY.base.YException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabase;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.jLibY.YParamDBList;

public abstract class YStorableDBList
extends YParamDBList {
    protected YStorableDBList(YSession session, int maxColumns) throws YException {
        super(session, maxColumns);
    }

    protected YStorableDBList(YSession session) throws YException {
        super(session);
    }

    public void setDispFields(String[] insideTable, String[] outsideTable) throws YException {
        YColumnDefinition columnDefinition;
        this.dispIndicees = new int[insideTable.length];
        this.dispColCount = 0;
        while (this.dispColCount < insideTable.length) {
            columnDefinition = this.rowDefinition.getColumnDefinition(insideTable[this.dispColCount]);
            this.dispIndicees[this.dispColCount] = columnDefinition.getFieldValueIndex();
            columnDefinition.setVisible();
            ++this.dispColCount;
        }
        if (outsideTable != null) {
            this.xdispIndicees = new int[outsideTable.length];
            this.xdispColCount = 0;
            while (this.xdispColCount < outsideTable.length) {
                columnDefinition = this.rowDefinition.getColumnDefinition(outsideTable[this.xdispColCount]);
                this.xdispIndicees[this.xdispColCount] = columnDefinition.getFieldValueIndex();
                columnDefinition.setVisible();
                ++this.xdispColCount;
            }
        }
    }

    public boolean isRowEditable(int iRow) throws YException {
        return true;
    }

    public abstract YColumnDefinition getIdColumnDefinition() throws YException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert() throws YException {
        int nRows = this.getRowCount();
        this.setActiveRow(-1);
        try {
            this.startChangeBlock();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                YRowValues rowValues = this.getRowValues(iRow);
                if (rowValues.getFieldValue(this.getIdColumnDefinition()).wasNull()) {
                    this.removeRowValues(iRow);
                    --iRow;
                    --nRows;
                    continue;
                }
                rowValues.revert();
            }
        }
        finally {
            this.endChangeBlock();
        }
        this.fireChanged(new YDBOChangeEvent());
    }

    public boolean hasChanged() throws YException {
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
        }
        for (int iRow = 0; iRow < this.getAbsRowCount(); ++iRow) {
            if (!this.getAbsRowValues(iRow).hasChanged()) continue;
            return true;
        }
        return false;
    }

    protected void fireUpdate(int iRow) throws YException {
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, this.getRowValues(iRow)));
    }

    protected abstract void postThis() throws YException;

    protected abstract boolean prepareThis() throws YException;

    public int setActiveRow(int iRow) throws YException {
        if (this.isNestedChange()) {
            return this.activeRow;
        }
        if (this.activeRow != iRow) {
            if (this.activeRow >= 0) {
                this.requestRowValues(this.getRowValues(this.activeRow));
            }
            if (iRow < 0) {
                this.activeRow = -1;
                this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, -1, null));
            } else {
                this.activeRow = iRow;
                this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, iRow, this.getRowValues(this.activeRow)));
            }
        }
        return this.activeRow;
    }

    public void requestActiveRowValues() throws YException {
        if (this.activeRow >= 0) {
            this.requestRowValues(this.getRowValues(this.activeRow));
            if (this.getRowValues(this.activeRow).hasChanged()) {
                this.fireUpdate(this.activeRow);
            }
        }
    }

    public void post() throws YException {
        assert (this.isFinalized());
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        this.requestActiveRowValues();
        if (!wasInTransaction) {
            this.prepareThis();
        }
        try {
            if (!database.isInTransaction()) {
                database.startTransaction();
            }
            this.postThis();
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
                if (this.setPosted()) {
                    this.fireChanged(new YDBOChangeEvent());
                }
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
                this.unsetPosted();
            }
            throw e;
        }
    }
}

