/*
 * Decompiled with CFR 0.152.
 */
package projektY.swing;

import javax.swing.table.AbstractTableModel;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDatabaseList;
import projektY.database.YFieldValue;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpFieldValue;

public class YTableModel
extends AbstractTableModel
implements YDBOChangeEventListener {
    private YDatabaseList databaseList;
    private boolean readOnly;
    private int selectedRow;

    public YTableModel(YDatabaseList databaseList, boolean readOnly) throws YException {
        this.databaseList = databaseList;
        databaseList.addChangeEventListener(this);
        this.readOnly = readOnly;
        this.selectedRow = -1;
    }

    public YTableModel(YDatabaseList databaseList) throws YException {
        this(databaseList, false);
    }

    void setSelectedRow(int iRow) {
        this.selectedRow = iRow;
    }

    public Class getColumnClass(int iCol) {
        try {
            YColumnDefinition columnDefinition = this.databaseList.getDispColumnDefinition(iCol);
            if (columnDefinition.getFieldType() == YColumnDefinition.FieldType.BOOLEAN || columnDefinition.getFieldType() == YColumnDefinition.FieldType.EMPTYBOOLEAN) {
                return Boolean.class;
            }
            return String.class;
        }
        catch (YException e) {
            return String.class;
        }
    }

    public String getColumnName(int iCol) {
        try {
            return this.databaseList.getDispColumnDefinition(iCol).getLabel();
        }
        catch (YException e) {
            return "";
        }
    }

    public int getRowCount() {
        try {
            return this.databaseList.getRowCount();
        }
        catch (YException e) {
            return 0;
        }
    }

    public int getColumnCount() {
        try {
            return this.databaseList.getDispColCount();
        }
        catch (YException e) {
            return 0;
        }
    }

    public Object getValueAt(int iRow, int iCol) {
        try {
            String altFieldName;
            YColumnDefinition columnDefinition;
            YFieldValue fieldValue = this.databaseList.getDispValue(iRow, iCol);
            YColumnDefinition.FieldType fieldType = fieldValue.getColumnDefinition().getFieldType();
            String value = this.databaseList.getDispString(iRow, iCol);
            if (value.equals("") && (columnDefinition = this.databaseList.getDispColumnDefinition(iCol)).isLookUp() && !columnDefinition.isDomain() && (altFieldName = ((YLookUpDBColumnDefinition)columnDefinition).getAltFieldName()) != null) {
                value = this.databaseList.getAsString(iRow, altFieldName);
            }
            if (value.length() == 0) {
                return null;
            }
            if (fieldType == YColumnDefinition.FieldType.BOOLEAN || fieldType == YColumnDefinition.FieldType.EMPTYBOOLEAN) {
                return fieldValue.getValueAsBool() ? Boolean.TRUE : Boolean.FALSE;
            }
            return value;
        }
        catch (YException e) {
            return "";
        }
    }

    public boolean isCellEditable(int iRow, int iCol) {
        try {
            if (this.readOnly) {
                return false;
            }
            YColumnDefinition columnDefinition = this.databaseList.getDispColumnDefinition(iCol);
            if (columnDefinition.isReadOnly()) {
                return false;
            }
            if (!this.databaseList.isRowEditable(iRow)) {
                return false;
            }
            if (columnDefinition.isLookUp()) {
                return iRow == this.selectedRow;
            }
            return true;
        }
        catch (YException e) {
            return false;
        }
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        try {
            YColumnDefinition columnDefinition = this.databaseList.getDispColumnDefinition(iCol);
            if (columnDefinition.isLookUp() && iRow != this.selectedRow) {
                return;
            }
            if (value == null) {
                this.databaseList.setDispString(iRow, iCol, "");
            } else {
                YFieldValue fieldValue = this.databaseList.getDispValue(iRow, iCol);
                columnDefinition = fieldValue.getColumnDefinition();
                if (columnDefinition.isLookUp()) {
                    ((YLookUpFieldValue)fieldValue).modifyLookUpValue(value.toString());
                } else {
                    fieldValue.modifyValue(value.toString());
                }
                this.fireTableCellUpdated(iRow, iCol);
            }
        }
        catch (YException e) {
            // empty catch block
        }
    }

    public void DBObjectChanged(YDBOChangeEvent evt) {
        if (evt.getType().equals((Object)YDBOChangeEvent.ChangeEventType.INSERT)) {
            this.fireTableRowsInserted(evt.getIRow0(), evt.getIRowN());
            this.fireTableRowsUpdated(evt.getIRow0(), evt.getIRowN());
        } else if (evt.getType().equals((Object)YDBOChangeEvent.ChangeEventType.UPDATE)) {
            if (evt.getICol() >= 0) {
                this.fireTableCellUpdated(evt.getIRow0(), evt.getICol());
            } else {
                this.fireTableRowsUpdated(evt.getIRow0(), evt.getIRowN());
            }
        } else if (evt.getType().equals((Object)YDBOChangeEvent.ChangeEventType.DELETE)) {
            this.fireTableRowsDeleted(evt.getIRow0(), evt.getIRowN());
        } else if (evt.getType().equals((Object)YDBOChangeEvent.ChangeEventType.INTERCHANGE)) {
            this.fireTableRowsUpdated(evt.getIRow0(), evt.getIRowN());
        } else if (evt.getType().equals((Object)YDBOChangeEvent.ChangeEventType.REPLACE_ALL)) {
            this.fireTableDataChanged();
        }
    }

    public void exchangeData(YDatabaseList databaseList) throws YException {
        if (!databaseList.getClass().getName().equals(this.databaseList.getClass().getName())) {
            throw new YProgramException(this, this.databaseList.getClass().getName() + " kann nicht durch " + databaseList.getClass().getName() + " ersetzt werden.");
        }
        this.databaseList = databaseList;
        this.fireTableDataChanged();
    }
}

