/*
 * Decompiled with CFR 0.152.
 */
package popometer.math;

import java.util.Vector;

public class Polygonzug {
    private Vector<Vektor> vektoren = new Vector(20, 5);
    private Vector<VektorSumme> vektorsummen = new Vector(20, 5);

    public Polygonzug() {
        this.vektoren.add(new Vektor());
        this.vektorsummen.add(new VektorSumme());
    }

    public void print() {
        for (VektorSumme summe : this.vektorsummen) {
            System.out.println(summe.toString());
        }
    }

    public void append(double winkel, boolean seiteRechts, double laenge) {
        Vektor neuerVektor = new Vektor(winkel, seiteRechts, laenge);
        int iV = this.vektoren.size() - 1;
        this.vektoren.add(neuerVektor);
        this.vektorsummen.add(this.vektorsummen.get(iV).add(neuerVektor));
    }

    public void endPunkt(Punkt p) {
        int i = this.vektorsummen.size() - 1;
        p.x = this.vektorsummen.get(i).x;
        p.y = this.vektorsummen.get(i).y;
        p.a = this.vektorsummen.get(i).laenge;
    }

    public static class VektorSumme {
        private double winkel = 0.0;
        private double laenge = 0.0;
        private double x = 0.0;
        private double y = 0.0;

        public String toString() {
            return String.format("w=%2.1f l=%3.1f x=%3.1f y=%3.1f", this.winkel, this.laenge, this.x, this.y);
        }

        public static double degToRad(double deg) {
            return deg * Math.PI / 180.0;
        }

        public static double radToDeg(double rad) {
            return rad * 180.0 / Math.PI;
        }

        public VektorSumme clone() {
            VektorSumme neueSumme = new VektorSumme();
            neueSumme.winkel = this.winkel;
            neueSumme.laenge = this.laenge;
            neueSumme.x = this.x;
            neueSumme.y = this.y;
            return neueSumme;
        }

        public VektorSumme add(Vektor summand) {
            VektorSumme summe = this.clone();
            summe.winkel = summand.winkelRechts ? (summe.winkel += 180.0 + summand.winkel) : (summe.winkel += 180.0 - summand.winkel);
            if (summe.winkel > 360.0) {
                summe.winkel -= 360.0;
            }
            double radW = VektorSumme.degToRad(summe.winkel);
            summe.x += summand.laenge * Math.cos(radW);
            summe.y += summand.laenge * Math.sin(radW);
            summe.laenge = Math.sqrt(summe.x * summe.x + summe.y * summe.y);
            return summe;
        }
    }

    public static class Vektor {
        private double winkel;
        private boolean winkelRechts;
        private double laenge;

        public Vektor(double winkel, boolean seiteRechts, double laenge) {
            this.winkel = winkel;
            this.winkelRechts = seiteRechts;
            this.laenge = laenge;
        }

        public Vektor() {
            this.winkel = 0.0;
            this.winkelRechts = false;
            this.laenge = 0.0;
        }
    }

    public static class Punkt {
        public double x = 0.0;
        public double y = 0.0;
        public double a = 0.0;

        public double abstand(Punkt p) {
            double dx = this.x - p.x;
            double dy = this.y - p.y;
            return Math.sqrt(dx * dx + dy * dy);
        }

        public String toString() {
            return String.format("(%2.1f;%2.1f/%2.1f)", this.x, this.y, this.a);
        }
    }
}

